/*
 * Decompiled with CFR 0.152.
 */
package sanproject.syslog.communicator;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.syslog.communicator.CommitCertificateException;
import sanproject.syslog.communicator.CreateCertificateCommitterException;
import sanproject.syslog.communicator.SetCertificateException;
import sanproject.syslog.communicator.UploadCACertificateException;
import sanproject.syslog.communicator.UploadClientCertificateException;
import sanproject.syslog.enums.SyslogServerType;
import sanproject.syslog.enums.SyslogType;
import sanproject.syslog.sender.TLSSender;

public class SyslogCommunicator
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String DIR_TMP = "syslog\\tmp\\";
    static final String COPY_SYSLOG_CLIENT = "ClientCertfcate.syslog";
    static final String COPY_SIMSYSLOG_CLIENT = "ClientCertfcate.simsyslog";
    static final String COPY_SYSLOG_CA = "CACertfcate.syslog";
    static final String COPY_SIMSYSLOG_CA = "CACertfcate.simsyslog";
    static final String TMP_SYSLOG_KEY_STORE = "tmp_syslog.keyStore";
    static final String TMP_SYSLOG_TRUST_STORE = "tmp_syslog.trustStore";
    static final String TMP_SIMSYSLOG_KEY_STORE = "tmp_simsyslog.keyStore";
    static final String TMP_SIMSYSLOG_TRUST_STORE = "tmp_simsyslog.trustStore";
    static final String STORE_FILE_DIR = "san\\syslog\\";
    static final String SYSLOG_KEY_STORE = "syslog.keyStore";
    static final String SYSLOG_TRUST_STORE = "syslog.trustStore";
    static final String SIMSYSLOG_KEY_STORE = "simsyslog.keyStore";
    static final String SIMSYSLOG_TRUST_STORE = "simsyslog.trustStore";
    static final String TEST_SYSLOG_KEY_STORE = "test_syslog.keyStore";
    static final String TEST_SYSLOG_TRUST_STORE = "test_syslog.trustStore";
    static final String TEST_SIMSYSLOG_KEY_STORE = "test_simsyslog.keyStore";
    static final String TEST_SIMSYSLOG_TRUST_STORE = "test_simsyslog.trustStore";
    static final String SYSLOG_TEST_DATA_TLS = "<14>1 %s SVP Storage - - - CELFSS,1.1,,ConfigurationAccess,Success,uid=%s,R800:%s,%s,,,,,SVP,%s,,[AuditLog],Send Test Message,,Normal end";
    static final String SYSLOG_TEST_DATA_UDP = "'<14> 'MMM dd HH:mm:ss' SVP Storage: CELFSS,1.1,,,%s,Storage,SVP,ConfigurationAccess,Success,uid=%s,R800:%s,,%s,,,,,,,,,,,,SVP,%s,,[AuditLog],Send Test Message,,Normal end'";
    static final String SIMSYSLOG_TEST_DATA_TLS = "<13>1 %s SVP Storage - - - ,Test,RAID800(Serial:%s),%s,RefCode : 7FFFFF,This is Test Report.";
    static final String SIMSYSLOG_TEST_DATA_UDP = "'<13> 'MMM dd HH:mm:ss' SVP Storage: ,Test,RAID800(Serial:%s),%s,RefCode : 7FFFFF,This is Test Report.'";
    static final String TIME_FORMAT_YMDTHMSMS = "yyyy-MM-dd'T'HH:mm:ss.S";
    static final int TIME_FORMAT_YMDTHMSMS_SIZE = 21;
    static final int TIME_FORMAT_YMDTHMS_SIZE = 19;
    static final int UDP_DAY_CHANGE_DATA_SIZE = 11;
    static final String TIME_ZONE_Z = "Z";
    static final String TIME_ZONE_PLUS = "+%02d:%02d";
    static final String TIME_ZONE_MINUS = "-%02d:%02d";
    static final String FUNCTIONID = "007";
    static final String MODULEID = "26";
    static final String SEND_OK_MSGID = "205000";
    static final String CLIENT_UPLOAD_ERR_MSGID = "207001";
    static final String CA_UPLOAD_ERR_MSGID = "207002";
    static final String SET_KEYSTORE_ERR_MSGID = "205001";
    static final String SET_TRUSTSTORE_ERR_MSGID = "205002";
    static final String COMMIT_STORE_ERR_MSGID = "207003";
    static final String GET_CLIENT_STORE_ERR_MSGID = "207005";
    static final String GET_CA_STORE_ERR_MSGID = "207006";
    static final String TCP_ERR_MSGID = "205003";
    static final String HANDSHAKE_ERR_MSGID = "205004";
    static final String SUBJECT_ALT_NAME_ERR_MSGID = "205005";
    static final String TLS_SEND_ERR_MSGID = "205006";
    static final String MAKE_STORE_ERR_MSGID = "205007";
    static final String IPADD_ERR_MSGID = "205008";
    static final String ETC_ERR_MSGID = "207004";
    static final String KEY_STORE_PASSWORD = "hitachi2syslog1t0l0s2A3u1d0i0t2p";
    static final String TRUST_STORE_PASSWOR = "I2n1b0a0n2d3syslog1t0l0shitachip";
    static final String LOG_FILE = "SyslogCommunicator.log";
    static final String GUIDANCE_SERVER = "COMMON/%s_SERVER";
    static final String SET_COMMON_CERTFCATE_FILE = "set_Common.crt";
    static final String DIR_STORE = "syslog\\store\\";
    static final String DIR_RELATIVE_PATH = "..\\..\\";
    private static SJcLoggerInterface m_Logger = null;
    private SyslogType m_SyslogType;
    private boolean m_IsPriClientCertfile;
    private String m_PriPassword;
    private boolean m_IsSecClientCertfile;
    private String m_SecPassword;
    private boolean m_IsPriCaCertfile;
    private boolean m_IsSecCaCertfile;
    private byte[] m_PriClientCertByteData = null;
    private byte[] m_SecClientCertByteData = null;
    private byte[] m_PriCaCertByteData = null;
    private byte[] m_SecCaCertByteData = null;

    private SyslogCommunicator() {
    }

    public static void uploadClientCertificate(SyslogType syslogType, SyslogServerType serverType, String certfile) throws UploadClientCertificateException {
        SJcLoggerInterface logger = SyslogCommunicator.getLogger();
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "uploadClientCertificate", "start:" + syslogType.name() + " " + serverType.name());
        }
        String copyFile = "";
        switch (syslogType) {
            case Syslog: {
                copyFile = COPY_SYSLOG_CLIENT + serverType.ordinal();
                break;
            }
            case SimSyslog: {
                copyFile = COPY_SIMSYSLOG_CLIENT + serverType.ordinal();
            }
        }
        try {
            SJcFileUty.getUploadFile(certfile, DIR_TMP, copyFile);
        }
        catch (Exception exception) {
            if (null != logger) {
                logger.error("communicator", "SyslogCommunicator", "uploadClientCertificate", syslogType.name() + " " + serverType.name() + "=" + "Upload Error:" + CLIENT_UPLOAD_ERR_MSGID, exception);
            }
            throw new UploadClientCertificateException(exception, FUNCTIONID, MODULEID, CLIENT_UPLOAD_ERR_MSGID);
        }
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "uploadClientCertificate", "end:" + syslogType.name() + " " + serverType.name());
        }
    }

    public static void uploadCACertificate(SyslogType syslogType, SyslogServerType serverType, String certfile) throws UploadCACertificateException {
        SJcLoggerInterface logger = SyslogCommunicator.getLogger();
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "uploadCACertificate", "start:" + syslogType.name() + " " + serverType.name());
        }
        String copyFile = "";
        switch (syslogType) {
            case Syslog: {
                copyFile = COPY_SYSLOG_CA + serverType.ordinal();
                break;
            }
            case SimSyslog: {
                copyFile = COPY_SIMSYSLOG_CA + serverType.ordinal();
            }
        }
        try {
            SJcFileUty.getUploadFile(certfile, DIR_TMP, copyFile);
        }
        catch (Exception exception) {
            if (null != logger) {
                logger.error("communicator", "SyslogCommunicator", "uploadCACertificate", syslogType.name() + " " + serverType.name() + "=" + "Upload Error:" + CA_UPLOAD_ERR_MSGID, exception);
            }
            throw new UploadCACertificateException(exception, FUNCTIONID, MODULEID, CA_UPLOAD_ERR_MSGID);
        }
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "uploadCACertificate", "end:" + syslogType.name() + " " + serverType.name());
        }
    }

    public static SyslogCommunicator createCertificateCommitter(SyslogType syslogType, boolean isPriClientCertfile, String priPassword, boolean isSecClientCertfile, String secPassword, boolean isPriCaCertfile, boolean isSecCaCertfile) throws CreateCertificateCommitterException {
        SJcLoggerInterface logger = SyslogCommunicator.getLogger();
        SyslogCommunicator obj = new SyslogCommunicator();
        obj.m_SyslogType = syslogType;
        obj.m_IsPriClientCertfile = isPriClientCertfile;
        obj.m_PriPassword = priPassword;
        obj.m_IsSecClientCertfile = isSecClientCertfile;
        obj.m_SecPassword = secPassword;
        obj.m_IsPriCaCertfile = isPriCaCertfile;
        obj.m_IsSecCaCertfile = isSecCaCertfile;
        String upClientFile = "";
        String upCaFile = "";
        String msgID = "";
        switch (syslogType) {
            case Syslog: {
                upClientFile = COPY_SYSLOG_CLIENT;
                upCaFile = COPY_SYSLOG_CA;
                break;
            }
            case SimSyslog: {
                upClientFile = COPY_SIMSYSLOG_CLIENT;
                upCaFile = COPY_SIMSYSLOG_CA;
            }
        }
        SyslogServerType serverNo = SyslogServerType.Primary;
        try {
            if (isPriClientCertfile) {
                msgID = CLIENT_UPLOAD_ERR_MSGID;
                obj.m_PriClientCertByteData = SJcFileUty.loadBinary(DIR_TMP, upClientFile + serverNo.ordinal(), 0, -1);
            }
            if (isPriCaCertfile) {
                msgID = CA_UPLOAD_ERR_MSGID;
                obj.m_PriCaCertByteData = SJcFileUty.loadBinary(DIR_TMP, upCaFile + serverNo.ordinal(), 0, -1);
            }
            serverNo = SyslogServerType.Secondary;
            if (isSecClientCertfile) {
                msgID = CLIENT_UPLOAD_ERR_MSGID;
                obj.m_SecClientCertByteData = SJcFileUty.loadBinary(DIR_TMP, upClientFile + serverNo.ordinal(), 0, -1);
            }
            if (isSecCaCertfile) {
                msgID = CA_UPLOAD_ERR_MSGID;
                obj.m_SecCaCertByteData = SJcFileUty.loadBinary(DIR_TMP, upCaFile + serverNo.ordinal(), 0, -1);
            }
        }
        catch (Exception exception) {
            if (null != logger) {
                logger.error("communicator", "SyslogCommunicator", "createCertificateCommitter", syslogType.name() + " " + serverNo.name() + "=" + "Upload Error:" + msgID, exception);
            }
            throw new CreateCertificateCommitterException(exception, FUNCTIONID, MODULEID, msgID);
        }
        return obj;
    }

    public void setCertificate() throws SetCertificateException {
        SJcLoggerInterface logger = SyslogCommunicator.getLogger();
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "setCertificate", "start:" + this.m_SyslogType.name());
        }
        this.deleteTmpCertificate();
        String tmpKeyStore = "";
        String tmpTrustStore = "";
        switch (this.m_SyslogType) {
            case Syslog: {
                tmpKeyStore = TMP_SYSLOG_KEY_STORE;
                tmpTrustStore = TMP_SYSLOG_TRUST_STORE;
                break;
            }
            case SimSyslog: {
                tmpKeyStore = TMP_SIMSYSLOG_KEY_STORE;
                tmpTrustStore = TMP_SIMSYSLOG_TRUST_STORE;
            }
        }
        String msgID = "";
        SyslogServerType serverNo = SyslogServerType.Primary;
        try {
            if (this.m_IsPriClientCertfile) {
                msgID = SET_KEYSTORE_ERR_MSGID;
                SJcFileUty.saveBinary(DIR_TMP, SET_COMMON_CERTFCATE_FILE, this.m_PriClientCertByteData, 0);
                SyslogCommunicator.setKeyStore(SET_COMMON_CERTFCATE_FILE, this.m_PriPassword, tmpKeyStore + serverNo.ordinal());
            }
            if (this.m_IsPriCaCertfile) {
                msgID = SET_TRUSTSTORE_ERR_MSGID;
                SJcFileUty.saveBinary(DIR_TMP, SET_COMMON_CERTFCATE_FILE, this.m_PriCaCertByteData, 0);
                SyslogCommunicator.setTrustStore(SET_COMMON_CERTFCATE_FILE, tmpTrustStore + serverNo.ordinal());
            }
            serverNo = SyslogServerType.Secondary;
            if (this.m_IsSecClientCertfile) {
                msgID = SET_KEYSTORE_ERR_MSGID;
                SJcFileUty.saveBinary(DIR_TMP, SET_COMMON_CERTFCATE_FILE, this.m_SecClientCertByteData, 0);
                SyslogCommunicator.setKeyStore(SET_COMMON_CERTFCATE_FILE, this.m_SecPassword, tmpKeyStore + serverNo.ordinal());
            }
            if (this.m_IsSecCaCertfile) {
                msgID = SET_TRUSTSTORE_ERR_MSGID;
                SJcFileUty.saveBinary(DIR_TMP, SET_COMMON_CERTFCATE_FILE, this.m_SecCaCertByteData, 0);
                SyslogCommunicator.setTrustStore(SET_COMMON_CERTFCATE_FILE, tmpTrustStore + serverNo.ordinal());
            }
        }
        catch (Exception exception) {
            if (null != logger) {
                logger.error("communicator", "SyslogCommunicator", "setCertificate", this.m_SyslogType.name() + " " + serverNo.name() + "=" + "Set Error:" + msgID, exception);
            }
            this.deleteTmpCertificate();
            String[] argument = new String[]{String.format(GUIDANCE_SERVER, serverNo.name().toUpperCase())};
            throw new SetCertificateException(exception, FUNCTIONID, MODULEID, msgID, argument);
        }
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "setCertificate", "end:" + this.m_SyslogType.name());
        }
    }

    public void commitCertificate() throws CommitCertificateException {
        SJcLoggerInterface logger = SyslogCommunicator.getLogger();
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "commitCertificate", "start:" + this.m_SyslogType.name());
        }
        String srcKeyStoreName = "";
        String srcTrustStoreName = "";
        String destKeyStoreName = "";
        String destTrustStoreName = "";
        switch (this.m_SyslogType) {
            case Syslog: {
                srcKeyStoreName = TMP_SYSLOG_KEY_STORE;
                srcTrustStoreName = TMP_SYSLOG_TRUST_STORE;
                destKeyStoreName = SYSLOG_KEY_STORE;
                destTrustStoreName = SYSLOG_TRUST_STORE;
                break;
            }
            case SimSyslog: {
                srcKeyStoreName = TMP_SIMSYSLOG_KEY_STORE;
                srcTrustStoreName = TMP_SIMSYSLOG_TRUST_STORE;
                destKeyStoreName = SIMSYSLOG_KEY_STORE;
                destTrustStoreName = SIMSYSLOG_TRUST_STORE;
            }
        }
        try {
            SyslogServerType[] servers = SyslogServerType.values();
            boolean[] isCommitkeyStore = new boolean[]{this.m_IsPriClientCertfile, this.m_IsSecClientCertfile};
            boolean[] isCommitTrustStore = new boolean[]{this.m_IsPriCaCertfile, this.m_IsSecCaCertfile};
            for (SyslogServerType serverNo : servers) {
                String[] srcKeyStore = new String[]{srcKeyStoreName + serverNo.ordinal()};
                String[] srcTrustStore = new String[]{srcTrustStoreName + serverNo.ordinal()};
                String[] destKeyStore = new String[]{destKeyStoreName + serverNo.ordinal()};
                String[] destTrustStore = new String[]{destTrustStoreName + serverNo.ordinal()};
                if (isCommitkeyStore[serverNo.ordinal()]) {
                    SJcFileUty.copyInternalToExternal(DIR_STORE, srcKeyStore, SJcEnvUty.getSnBasePath() + STORE_FILE_DIR, destKeyStore);
                }
                if (!isCommitTrustStore[serverNo.ordinal()]) continue;
                SJcFileUty.copyInternalToExternal(DIR_STORE, srcTrustStore, SJcEnvUty.getSnBasePath() + STORE_FILE_DIR, destTrustStore);
            }
        }
        catch (Exception exception) {
            if (null != logger) {
                logger.error("communicator", "SyslogCommunicator", "commitCertificate", this.m_SyslogType.name() + "=" + "Commit Error:" + COMMIT_STORE_ERR_MSGID, exception);
            }
            throw new CommitCertificateException(exception, FUNCTIONID, MODULEID, COMMIT_STORE_ERR_MSGID);
        }
        finally {
            this.deleteTmpCertificate();
        }
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "commitCertificate", "end:" + this.m_SyslogType.name());
        }
    }

    public void deleteTmpCertificate() {
        SJcLoggerInterface logger = SyslogCommunicator.getLogger();
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "deleteTmpCertificate", "start:" + this.m_SyslogType.name());
        }
        String deleteKeyStoreName = "";
        String deleteTrustStoreName = "";
        switch (this.m_SyslogType) {
            case Syslog: {
                deleteKeyStoreName = TMP_SYSLOG_KEY_STORE;
                deleteTrustStoreName = TMP_SYSLOG_TRUST_STORE;
                break;
            }
            case SimSyslog: {
                deleteKeyStoreName = TMP_SIMSYSLOG_KEY_STORE;
                deleteTrustStoreName = TMP_SIMSYSLOG_TRUST_STORE;
            }
        }
        SyslogCommunicator.deleteCertificate(deleteKeyStoreName, deleteTrustStoreName);
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "deleteTmpCertificate", "end:" + this.m_SyslogType.name());
        }
    }

    public static SJcMessage sendTLS(SyslogType syslogType, SyslogServerType serverType, boolean isClientCertfile, String password, boolean isCaCertfile, String ipAddress, int iPort, byte ucTimeout, String serialNo, String userName, String location, String connectionID) {
        String testTrustStoreTopName;
        String testKeyStoreTopName;
        String msgid;
        SJcLoggerInterface logger;
        block20: {
            logger = SyslogCommunicator.getLogger();
            if (null != logger) {
                logger.info("communicator", "SyslogCommunicator", "sendTLS", "start:" + syslogType.name() + " " + serverType.name());
            }
            int serverNo = serverType.ordinal();
            msgid = ETC_ERR_MSGID;
            testKeyStoreTopName = "";
            testTrustStoreTopName = "";
            String upClientFile = "";
            String upCaFile = "";
            String keyStore = "";
            String trustStore = "";
            switch (syslogType) {
                case Syslog: {
                    testKeyStoreTopName = TEST_SYSLOG_KEY_STORE;
                    testTrustStoreTopName = TEST_SYSLOG_TRUST_STORE;
                    upClientFile = COPY_SYSLOG_CLIENT + serverNo;
                    upCaFile = COPY_SYSLOG_CA + serverNo;
                    keyStore = SYSLOG_KEY_STORE + serverNo;
                    trustStore = SYSLOG_TRUST_STORE + serverNo;
                    break;
                }
                case SimSyslog: {
                    testKeyStoreTopName = TEST_SIMSYSLOG_KEY_STORE;
                    testTrustStoreTopName = TEST_SIMSYSLOG_TRUST_STORE;
                    upClientFile = COPY_SIMSYSLOG_CLIENT + serverNo;
                    upCaFile = COPY_SIMSYSLOG_CA + serverNo;
                    keyStore = SIMSYSLOG_KEY_STORE + serverNo;
                    trustStore = SIMSYSLOG_TRUST_STORE + serverNo;
                }
            }
            String dataPath = SJcFileUty.setEndPathSeparator(System.getProperty("SN_DataPath")) + "data" + SJcConst.sjc_PathSeparator + DIR_STORE;
            dataPath = dataPath.toUpperCase().replace(SJcEnvUty.getSnBasePath(), DIR_RELATIVE_PATH);
            try {
                if (isClientCertfile) {
                    msgid = MAKE_STORE_ERR_MSGID;
                    keyStore = testKeyStoreTopName + serverNo;
                    SyslogCommunicator.setKeyStore(upClientFile, password, keyStore);
                    keyStore = dataPath + keyStore;
                }
                if (isCaCertfile) {
                    msgid = MAKE_STORE_ERR_MSGID;
                    trustStore = testTrustStoreTopName + serverNo;
                    SyslogCommunicator.setTrustStore(upCaFile, trustStore);
                    trustStore = dataPath + trustStore;
                }
                msgid = ETC_ERR_MSGID;
                TLSSender sender = new TLSSender(keyStore, trustStore, LOG_FILE);
                String data = SyslogCommunicator.getTLSTestData(syslogType, serialNo, userName, location, connectionID);
                msgid = IPADD_ERR_MSGID;
                byte[] ucIpAdd = InetAddress.getByName(ipAddress).getAddress();
                msgid = ETC_ERR_MSGID;
                int rtn = sender.Send(data.getBytes("UTF-8"), ucIpAdd, iPort, (byte)0, ucTimeout);
                switch (rtn) {
                    case 0: {
                        msgid = SEND_OK_MSGID;
                        break;
                    }
                    case 1: {
                        msgid = GET_CLIENT_STORE_ERR_MSGID;
                        break;
                    }
                    case 2: {
                        msgid = GET_CA_STORE_ERR_MSGID;
                        break;
                    }
                    case 3: {
                        msgid = TCP_ERR_MSGID;
                        break;
                    }
                    case 4: {
                        msgid = HANDSHAKE_ERR_MSGID;
                        break;
                    }
                    case 5: {
                        msgid = SUBJECT_ALT_NAME_ERR_MSGID;
                        break;
                    }
                    case 6: {
                        msgid = TLS_SEND_ERR_MSGID;
                        break;
                    }
                    case 7: {
                        msgid = ETC_ERR_MSGID;
                    }
                }
                sender.Shutdown();
            }
            catch (Exception exception) {
                if (null == logger) break block20;
                logger.error("communicator", "SyslogCommunicator", "sendTLS", syslogType.name() + " " + serverType.name() + "=" + "Send Error:" + msgid, exception);
            }
        }
        SyslogCommunicator.deleteCertificate(testKeyStoreTopName, testTrustStoreTopName);
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "sendTLS", "end:" + syslogType.name() + " " + serverType.name());
        }
        String[] argument = new String[]{String.format(GUIDANCE_SERVER, serverType.name().toUpperCase())};
        return new SJcMessage(FUNCTIONID, MODULEID, msgid, argument, argument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SJcMessage sendUDP(SyslogType syslogType, SyslogServerType serverType, String ipAddress, int iPort, String serialNo, String userName, String location, String connectionID) {
        SJcLoggerInterface logger = SyslogCommunicator.getLogger();
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "sendUDP", "start:" + syslogType.name() + " " + serverType.name());
        }
        String msgid = ETC_ERR_MSGID;
        DatagramSocket sender = null;
        try {
            String data = SyslogCommunicator.getUDPTestData(syslogType, serialNo, userName, location, connectionID);
            sender = new DatagramSocket();
            msgid = IPADD_ERR_MSGID;
            InetAddress inetAddress = InetAddress.getByName(ipAddress);
            msgid = ETC_ERR_MSGID;
            byte[] sendData = data.getBytes("UTF-8");
            DatagramPacket packet = new DatagramPacket(sendData, sendData.length, inetAddress, iPort);
            sender.send(packet);
            msgid = SEND_OK_MSGID;
        }
        catch (Exception exception) {
            if (null != logger) {
                logger.error("communicator", "SyslogCommunicator", "sendUDP", syslogType.name() + " " + serverType.name() + "=" + "Send Error:" + msgid, exception);
            }
        }
        finally {
            if (null != sender) {
                sender.close();
            }
        }
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "sendUDP", "end:" + syslogType.name() + " " + serverType.name());
        }
        String[] argument = new String[]{String.format(GUIDANCE_SERVER, serverType.name().toUpperCase())};
        return new SJcMessage(FUNCTIONID, MODULEID, msgid, argument, argument);
    }

    private static void setKeyStore(String clientCertfileName, String password, String keyStorefileName) throws Exception {
        SJcLoggerInterface logger = SyslogCommunicator.getLogger();
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "setKeyStore", "start:" + keyStorefileName);
        }
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            String dataPath = SJcFileUty.setEndPathSeparator(System.getProperty("SN_DataPath")) + "data" + SJcConst.sjc_PathSeparator;
            char[] clientPassword = password.toCharArray();
            inStream = SJcFileUty.getInStream(dataPath + DIR_TMP + clientCertfileName);
            KeyStore clientStore = KeyStore.getInstance("pkcs12");
            clientStore.load(inStream, clientPassword);
            inStream.close();
            inStream = null;
            String alias = clientStore.aliases().nextElement();
            Key key = clientStore.getKey(alias, clientPassword);
            Certificate[] cert = clientStore.getCertificateChain(alias);
            char[] keyStorePassword = KEY_STORE_PASSWORD.toCharArray();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, keyStorePassword);
            keyStore.setKeyEntry("syscomC", key, keyStorePassword, cert);
            if (!new File(dataPath + DIR_STORE).exists()) {
                SJcFileUty.makeDirectory(DIR_STORE);
            }
            outStream = SJcFileUty.getOutStream(dataPath + DIR_STORE + keyStorefileName);
            keyStore.store(outStream, keyStorePassword);
            outStream.close();
            outStream = null;
        }
        catch (Exception exception) {
            block13: {
                block12: {
                    if (null != logger) {
                        logger.error("communicator", "SyslogCommunicator", "setKeyStore", keyStorefileName + "=" + "Store Error", exception);
                    }
                    if (null != inStream) {
                        try {
                            inStream.close();
                        }
                        catch (Exception closeError) {
                            if (null == logger) break block12;
                            logger.error("communicator", "SyslogCommunicator", "setKeyStore", keyStorefileName + "=" + "inStream.close Error", closeError);
                        }
                    }
                }
                if (null != outStream) {
                    try {
                        outStream.close();
                    }
                    catch (Exception closeError) {
                        if (null == logger) break block13;
                        logger.error("communicator", "SyslogCommunicator", "setKeyStore", keyStorefileName + "=" + "outStream.close Error", closeError);
                    }
                }
            }
            throw exception;
        }
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "setKeyStore", "end:" + keyStorefileName);
        }
    }

    private static void setTrustStore(String caCertfileName, String trustStorefileName) throws Exception {
        SJcLoggerInterface logger = SyslogCommunicator.getLogger();
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "setTrustStore", "start:" + trustStorefileName);
        }
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            String dataPath = SJcFileUty.setEndPathSeparator(System.getProperty("SN_DataPath")) + "data" + SJcConst.sjc_PathSeparator;
            inStream = SJcFileUty.getInStream(dataPath + DIR_TMP + caCertfileName);
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            Certificate cert = certFactory.generateCertificate(inStream);
            inStream.close();
            inStream = null;
            char[] trustStorePassword = TRUST_STORE_PASSWOR.toCharArray();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, trustStorePassword);
            keyStore.setCertificateEntry("syscomR", cert);
            if (!new File(dataPath + DIR_STORE).exists()) {
                SJcFileUty.makeDirectory(DIR_STORE);
            }
            outStream = SJcFileUty.getOutStream(dataPath + DIR_STORE + trustStorefileName);
            keyStore.store(outStream, trustStorePassword);
            outStream.close();
            outStream = null;
        }
        catch (Exception exception) {
            block13: {
                block12: {
                    if (null != logger) {
                        logger.error("communicator", "SyslogCommunicator", "setTrustStore", trustStorefileName + "=" + "Store Error", exception);
                    }
                    if (null != inStream) {
                        try {
                            inStream.close();
                        }
                        catch (Exception closeError) {
                            if (null == logger) break block12;
                            logger.error("communicator", "SyslogCommunicator", "setTrustStore", trustStorefileName + "=" + "inStream.close Error", closeError);
                        }
                    }
                }
                if (null != outStream) {
                    try {
                        outStream.close();
                    }
                    catch (Exception closeError) {
                        if (null == logger) break block13;
                        logger.error("communicator", "SyslogCommunicator", "setTrustStore", trustStorefileName + "=" + "outStream.close Error", closeError);
                    }
                }
            }
            throw exception;
        }
        if (null != logger) {
            logger.info("communicator", "SyslogCommunicator", "setTrustStore", "end:" + trustStorefileName);
        }
    }

    private static String getTLSTestData(SyslogType syslogType, String serialNo, String userName, String location, String connectionID) throws Exception {
        String testDataFormat = "";
        int timeFormatSize = 0;
        switch (syslogType) {
            case Syslog: {
                testDataFormat = SYSLOG_TEST_DATA_TLS;
                timeFormatSize = 21;
                break;
            }
            case SimSyslog: {
                testDataFormat = SIMSYSLOG_TEST_DATA_TLS;
                timeFormatSize = 19;
            }
        }
        SimpleDateFormat nowformat = new SimpleDateFormat(TIME_FORMAT_YMDTHMSMS, Locale.US);
        Calendar now = Calendar.getInstance();
        String nowDate = nowformat.format(now.getTime()).substring(0, timeFormatSize);
        int timeZone = now.getTimeZone().getRawOffset();
        nowDate = syslogType == SyslogType.SimSyslog || 0 == timeZone ? nowDate + TIME_ZONE_Z : (0 < timeZone ? nowDate + String.format(TIME_ZONE_PLUS, Math.abs(timeZone) / 1000 / 60 / 60, Math.abs(timeZone) / 1000 / 60 % 60) : nowDate + String.format(TIME_ZONE_MINUS, Math.abs(timeZone) / 1000 / 60 / 60, Math.abs(timeZone) / 1000 / 60 % 60));
        String data = "";
        switch (syslogType) {
            case Syslog: {
                data = String.format(testDataFormat, nowDate, userName, serialNo, location, connectionID);
                break;
            }
            case SimSyslog: {
                data = String.format(testDataFormat, nowDate, serialNo, location);
            }
        }
        return String.valueOf(data.length()) + " " + data;
    }

    private static String getUDPTestData(SyslogType syslogType, String serialNo, String userName, String location, String connectionID) throws Exception {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat testDataFormat = null;
        String data = "";
        switch (syslogType) {
            case Syslog: {
                testDataFormat = new SimpleDateFormat(SYSLOG_TEST_DATA_UDP, Locale.US);
                SimpleDateFormat nowformat = new SimpleDateFormat(TIME_FORMAT_YMDTHMSMS, Locale.US);
                String nowDate = nowformat.format(now.getTime()).substring(0, 21);
                int timeZone = now.getTimeZone().getRawOffset();
                nowDate = 0 == timeZone ? nowDate + TIME_ZONE_Z : (0 < timeZone ? nowDate + String.format(TIME_ZONE_PLUS, Math.abs(timeZone) / 1000 / 60 / 60, Math.abs(timeZone) / 1000 / 60 % 60) : nowDate + String.format(TIME_ZONE_MINUS, Math.abs(timeZone) / 1000 / 60 / 60, Math.abs(timeZone) / 1000 / 60 % 60));
                data = String.format(testDataFormat.format(now.getTime()), nowDate, userName, serialNo, location, connectionID);
                break;
            }
            case SimSyslog: {
                testDataFormat = new SimpleDateFormat(SIMSYSLOG_TEST_DATA_UDP, Locale.US);
                data = String.format(testDataFormat.format(now.getTime()), serialNo, location);
            }
        }
        String changeData = data.substring(0, 11);
        data = data.replace(changeData, changeData.replace(" 0", "  "));
        return data;
    }

    private static void deleteCertificate(String keyStoreTopName, String trustStoreTopName) {
        block4: {
            try {
                SyslogServerType[] servers = SyslogServerType.values();
                String dataPath = SJcFileUty.setEndPathSeparator(System.getProperty("SN_DataPath")) + "data" + SJcConst.sjc_PathSeparator + DIR_STORE;
                for (SyslogServerType serverNo : servers) {
                    String deleteKeyStore = keyStoreTopName + serverNo.ordinal();
                    String deleteTrustStore = trustStoreTopName + serverNo.ordinal();
                    if (new File(dataPath + deleteKeyStore).exists()) {
                        SJcFileUty.deleteFile(DIR_STORE, deleteKeyStore);
                    }
                    if (!new File(dataPath + deleteTrustStore).exists()) continue;
                    SJcFileUty.deleteFile(DIR_STORE, deleteTrustStore);
                }
            }
            catch (Exception exception) {
                SJcLoggerInterface logger = SyslogCommunicator.getLogger();
                if (null == logger) break block4;
                logger.error("communicator", "SyslogCommunicator", "deleteCertificate", keyStoreTopName + " " + trustStoreTopName + "=" + "delete Error", exception);
            }
        }
    }

    private static SJcLoggerInterface getLogger() {
        if (null == m_Logger) {
            System.setProperty("SN_LogPath", "syslog");
            m_Logger = SJcLogUty.getLogger(LOG_FILE);
        }
        return m_Logger;
    }
}

