/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

class JServerTraceFormatter
extends Formatter {
    private final SimpleDateFormat mDateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String mStrLineSeparator = System.getProperty("line.separator");

    private void addException(StringBuilder builder, Throwable t) {
        if (null != t) {
            String msg = t.getLocalizedMessage();
            if (null == msg) {
                msg = t.getMessage();
            }
            if (null != msg) {
                builder.append(msg);
                builder.append(mStrLineSeparator);
            }
            StringWriter result = new StringWriter();
            PrintWriter printWriter = new PrintWriter(result);
            t.printStackTrace(printWriter);
            builder.append(((Object)result).toString());
            builder.append(mStrLineSeparator);
        }
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder builder = new StringBuilder();
        Date recordTime = new Date(record.getMillis());
        builder.append(this.mDateformat.format(recordTime));
        builder.append(" [");
        builder.append(record.getThreadID());
        builder.append("]");
        String srcClz = record.getSourceClassName();
        if (null != srcClz) {
            builder.append(srcClz);
        }
        builder.append(mStrLineSeparator);
        builder.append(record.getLevel().toString());
        builder.append(": ");
        Object[] params = record.getParameters();
        String recordMessage = params != null ? MessageFormat.format(record.getMessage(), params) : record.getMessage();
        builder.append(recordMessage);
        builder.append(mStrLineSeparator);
        this.addException(builder, record.getThrown());
        return builder.toString();
    }
}

