/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import com.ws.utilities.WSIStandardMessages;
import com.ws.wbem.jserver.CIMRepository;
import com.ws.wbem.jserver.ProviderAdapter;
import com.ws.wbem.jserver.services.ObjectManagerAdapterService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMClass;
import javax.cim.CIMObjectPath;
import javax.cim.CIMQualifier;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.provider.IndicationProvider;
import javax.wbem.provider.ProviderHandle;
import javax.wbem.provider.PullAssociatorProvider;
import javax.wbem.provider.PullInstanceProvider;
import org.wbemservices.wbem.repository.PSRlogImpl;

class ProviderAdapterFactory {
    private static final String PROVIDER = "provider";
    private static final String ERROR_INVALID_PROVIDER_QUALIFIER_NO_VALUE_FOUND = "Invalid provider qualifier, no value found!";
    private static final String ERROR_INVALID_QUALIFIER_CAN_NOT_BE_NULL = "Invalid qualifier, can not be null!";
    private Map<String, ProviderAdapter> mAdapters;
    private ProviderHandle mCimom = null;
    private boolean mShouldReturnNull = false;
    private static final Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");
    private final Map<String, providerInfo> pomaCache;

    public ProviderAdapterFactory(ProviderHandle pch) throws WBEMException {
        this.mCimom = pch;
        this.pomaCache = new ConcurrentHashMap<String, providerInfo>();
        String passAllProvCheck = System.getProperty("passAllProviderCheck", "false");
        if ("true".equalsIgnoreCase(passAllProvCheck)) {
            this.mShouldReturnNull = true;
            mLogger.finer("'passAllProviderCheck' is true");
        } else {
            this.mShouldReturnNull = false;
            this.mAdapters = Collections.synchronizedMap(new HashMap(5));
            mLogger.finer("Provider factory created and ready");
        }
    }

    private String generatePOMAKey(CIMObjectPath pOP) {
        StringBuilder temp = null;
        if (null != pOP) {
            temp = new StringBuilder(pOP.getNamespace());
            temp.append('/');
            temp.append(pOP.getObjectName());
        }
        return null != temp ? temp.toString() : null;
    }

    private ProviderAdapter getAdapter(String pName) {
        ProviderAdapter adapter = this.mAdapters.get(pName);
        if (adapter == null && (adapter = ObjectManagerAdapterService.getPPAHandle(pName)) != null) {
            this.mAdapters.put(pName, adapter);
        }
        return adapter;
    }

    public IndicationProvider getCIMIndicationProvider(CIMClass pCIMClass) throws WBEMException {
        if (this.mShouldReturnNull) {
            return null;
        }
        CIMQualifier qual = pCIMClass.getQualifier(PROVIDER);
        if (qual == null) {
            mLogger.finer("No 'provider' qualifier found for class: " + pCIMClass.getName());
            return null;
        }
        String provider = this.getProviderString(qual);
        providerInfo pInfo = this.parseProviderQualifier(provider);
        ProviderAdapter prov = null;
        try {
            prov = this.getPOMA(pInfo.protocol);
        }
        catch (ClassNotFoundException cnfe) {
            mLogger.log(Level.SEVERE, "Provider class not found: " + provider, cnfe);
            Object[] o = new Object[]{provider, pCIMClass.getName()};
            throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_POMA_NOT_FOUND", (Object[])o));
        }
        return prov.getIndicationProvider(pInfo.provider, pCIMClass.getName(), pInfo.params);
    }

    private ProviderAdapter getPOMA(String protocol) throws WBEMException, ClassNotFoundException {
        ProviderAdapter adapter = null;
        try {
            mLogger.finer("Need to get provider object manager adapter for protocol: " + protocol);
            adapter = this.getAdapter(protocol);
            if (adapter == null) {
                Object[] o = new Object[]{protocol};
                mLogger.severe(WSIStandardMessages.getMessage((String)"ERROR_POMA_NOT_FOUND", (Object[])o));
                throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_POMA_NOT_FOUND", (Object[])o));
            }
            return adapter;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString());
        }
    }

    private providerInfo getProviderInfo(CIMObjectPath pOP, CIMClass pCIMClass) throws WBEMException {
        providerInfo info = null;
        String key2Lookup = this.generatePOMAKey(pOP);
        if (null != key2Lookup) {
            info = this.pomaCache.get(key2Lookup);
        }
        if (null == info) {
            CIMClass clz = pCIMClass;
            if (null == clz) {
                try {
                    clz = this.mCimom.getClass(pOP, false, true);
                }
                catch (WBEMException e) {
                    if (e.getID() == 3) {
                        throw WBEMOperationErrors.getNamespaceNotFoundException((CIMObjectPath)pOP, (WBEMOperation)WBEMOperation.GETCLASS, (String)(this.getClass().getSimpleName() + "." + "getProviderInfo"));
                    }
                    if (e.getID() == 6) {
                        throw WBEMOperationErrors.getClassNotFoundException((CIMObjectPath)pOP, (WBEMOperation)WBEMOperation.GETCLASS, (String)(this.getClass().getSimpleName() + "." + "getProviderInfo"));
                    }
                    throw e;
                }
            }
            if ((info = this.getProviderInfoFromCIMClass(clz)) != null) {
                this.pomaCache.put(key2Lookup, info);
            }
        }
        return info;
    }

    private providerInfo getProviderInfoFromCIMClass(CIMClass pCIMClass) throws WBEMException {
        CIMQualifier qual = pCIMClass.getQualifier(PROVIDER);
        if (qual == null) {
            mLogger.finer("'Provider' qualifier not found for class: " + pCIMClass.getName());
            return null;
        }
        String provider = this.getProviderString(qual);
        providerInfo pInfo = this.parseProviderQualifier(provider);
        pInfo.setClassName(pCIMClass.getName());
        return pInfo;
    }

    private String getProviderString(CIMQualifier<?> pQual) throws WBEMException {
        if (pQual == null) {
            throw new WBEMException(1, ERROR_INVALID_QUALIFIER_CAN_NOT_BE_NULL);
        }
        String qual = (String)pQual.getValue();
        if (qual == null) {
            throw new WBEMException(1, ERROR_INVALID_PROVIDER_QUALIFIER_NO_VALUE_FOUND);
        }
        return qual;
    }

    public PullAssociatorProvider getPullAssociatorProvider(CIMObjectPath pOP, CIMClass pCIMClass) throws WBEMException {
        if (this.mShouldReturnNull) {
            return PSRlogImpl.getRepository();
        }
        PullAssociatorProvider ret = null;
        providerInfo info = this.getProviderInfo(pOP, pCIMClass);
        if (null != info) {
            try {
                ProviderAdapter poma = this.getPOMA(info.protocol);
                ret = poma.getPullAssociatorProvider(info.provider, info.className, info.params);
            }
            catch (ClassNotFoundException e) {
                Throwable t = e.getCause();
                if (null == t) {
                    t = e;
                }
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)pOP, (String)t.getLocalizedMessage(), (WBEMOperation)WBEMOperation.GETCLASS, null);
            }
        }
        return ret;
    }

    public PullInstanceProvider getPullInstanceProvider(CIMObjectPath pOP, CIMClass pCIMClass) throws WBEMException {
        if (this.mShouldReturnNull) {
            return PSRlogImpl.getRepository();
        }
        CIMRepository ret = null;
        providerInfo info = this.getProviderInfo(pOP, pCIMClass);
        if (null != info) {
            try {
                if (info.protocol.equals("repository")) {
                    ret = PSRlogImpl.getRepository();
                } else {
                    ProviderAdapter poma = this.getPOMA(info.protocol);
                    ret = poma.getPullInstanceProvider(info.provider, info.className, info.params);
                }
            }
            catch (ClassNotFoundException e) {
                Throwable t = e.getCause();
                if (null == t) {
                    t = e;
                }
                mLogger.log(Level.SEVERE, "Exception getting class, ", t);
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)pOP, (String)t.getLocalizedMessage(), (WBEMOperation)WBEMOperation.GETCLASS, null);
            }
        }
        return ret;
    }

    private providerInfo parseProviderQualifier(String pValue) throws WBEMException {
        if (pValue.equalsIgnoreCase("repository")) {
            providerInfo pInfo = new providerInfo();
            pInfo.protocol = "repository";
            return pInfo;
        }
        int colon = 58;
        providerInfo pInfo = new providerInfo();
        int index = pValue.indexOf(58);
        if (index > 0) {
            String protocol = pValue.substring(0, index);
            pInfo.protocol = protocol.trim();
            int index2 = pValue.indexOf(58, index + 1);
            if (index2 < 0) {
                index2 = pValue.length();
                pInfo.params = new String[0];
            } else {
                String params = pValue.substring(index2 + 1);
                StringTokenizer tok = new StringTokenizer(params, ",");
                String[] paramsArray = new String[tok.countTokens()];
                while (tok.hasMoreTokens()) {
                    paramsArray[index] = tok.nextToken();
                    ++index;
                }
                pInfo.params = paramsArray;
            }
            pInfo.provider = pValue.substring(index + 1, index2);
            return pInfo;
        }
        Object[] o = new Object[]{pValue};
        throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_PROVIDER_QUALIFIER_INVALID", (Object[])o));
    }

    void RegisterProtocolProvider(String pAdapterType, ProviderAdapter pAdapter, boolean isAuto) throws WBEMException {
        this.UnRegisterProtocolProvider(pAdapterType);
        pAdapter.initialize(this.mCimom);
        if (isAuto) {
            pAdapter.start(null);
        }
        mLogger.fine("adding an adapter for protocol: " + pAdapterType);
        this.mAdapters.put(pAdapterType, pAdapter);
    }

    protected void shutdown() {
        if (this.mAdapters == null || this.mAdapters.values() == null) {
            return;
        }
        for (ProviderAdapter pIF : this.mAdapters.values()) {
            try {
                pIF.stop();
                pIF.shutdown();
            }
            catch (Exception e) {
                mLogger.log(Level.WARNING, "received exception when calling close on provider", e);
            }
        }
    }

    void UnRegisterProtocolProvider(String pAdapterType) {
        mLogger.fine("Unregister PPA:" + pAdapterType);
        ProviderAdapter adapter = this.getAdapter(pAdapterType);
        if (adapter != null) {
            this.mAdapters.remove(pAdapterType);
            adapter.stop();
            adapter.shutdown();
        }
    }

    class providerInfo {
        public String protocol;
        public String provider;
        public String[] params;
        public String className;

        providerInfo() {
        }

        public void setClassName(String className) {
            this.className = className;
        }
    }
}

