/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver.profiles.dmtf.simpleidentity;

import com.ws.wbem.jserver.AuthService;
import com.ws.wbem.jserver.AuthServiceType;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSecurityAdapterFactory;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.profiles.common.BaseSingletonInstanceProvider;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.client.EnumerateResponse;
import javax.wbem.provider.ProviderHandle;

public class AccountManagementServiceProvider
extends BaseSingletonInstanceProvider {
    private static final String CPV_NAME = JServerProperties.getSchemaName() + " Account Management Service";
    private static final String CPV_SYSTEMCREATIONCLASSNAME = JServerSettings.replaceSchemaClassName("WS_WBEMServerSystem");
    private AuthService mAuthService;

    @Override
    public void initialize(ProviderHandle handle) throws WBEMException {
        super.initialize(handle);
        this.mClassName = JServerSettings.replaceSchemaClassName("WS_AccountManagementService");
        this.mAuthService = JServerSecurityAdapterFactory.getAdapter();
    }

    @Override
    public Object invokeMethod(CIMObjectPath target, String methodName, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        boolean account;
        UnsignedInteger32 ret = null;
        boolean thirdParty = this.mAuthService.getType() == AuthServiceType.THIRDPARTY;
        boolean bl = account = this.mAuthService.getType() == AuthServiceType.ACCOUNTS;
        if ("CreateAccount".equalsIgnoreCase(methodName) && account) {
            ret = this.createAccount(target, inArgs, outArgs);
        } else if ("GetAccounts".equalsIgnoreCase(methodName) && account) {
            ret = this.getAccount(target, inArgs, outArgs);
        } else if ("CreateUserContact".equalsIgnoreCase(methodName) && thirdParty) {
            ret = this.createUserContact(target, inArgs, outArgs);
        } else if ("GetUserContacts".equalsIgnoreCase(methodName) && thirdParty) {
            ret = this.getUserContact(target, inArgs, outArgs);
        } else {
            if ("StartService".equalsIgnoreCase(methodName)) {
                throw WBEMOperationErrors.getMethodNotSupportedException((CIMObjectPath)target, (String)methodName, (WBEMOperation)WBEMOperation.INVOKEMETHOD);
            }
            if ("StopService".equalsIgnoreCase(methodName)) {
                throw WBEMOperationErrors.getMethodNotSupportedException((CIMObjectPath)target, (String)methodName, (WBEMOperation)WBEMOperation.INVOKEMETHOD);
            }
            if ("RequestStateChange".equalsIgnoreCase(methodName)) {
                WBEMOperationErrors.getMethodNotSupportedException((CIMObjectPath)target, (String)methodName, (WBEMOperation)WBEMOperation.INVOKEMETHOD);
            } else {
                throw WBEMOperationErrors.getMethodNotSupportedException((CIMObjectPath)target, (String)methodName, (WBEMOperation)WBEMOperation.INVOKEMETHOD);
            }
        }
        return ret;
    }

    private UnsignedInteger32 getAccount(CIMObjectPath target, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) {
        String userID = null;
        UnsignedInteger32 ret = null;
        if (null != inArgs && inArgs.length == 1) {
            for (CIMArgument<?> a : inArgs) {
                if (null == a || !"UserID".equalsIgnoreCase(a.getName())) continue;
                userID = (String)a.getValue();
            }
        }
        ret = this.getAccounts(target, userID, outArgs);
        return ret;
    }

    private UnsignedInteger32 getUserContact(CIMObjectPath target, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) {
        String userID = null;
        UnsignedInteger32 ret = null;
        if (null != inArgs && inArgs.length == 1) {
            for (CIMArgument<?> a : inArgs) {
                if (null == a || !"UserID".equalsIgnoreCase(a.getName())) continue;
                userID = (String)a.getValue();
            }
        }
        ret = this.getUserContacts(target, userID, outArgs);
        return ret;
    }

    private UnsignedInteger32 getUserContacts(CIMObjectPath target, String userID, CIMArgument<?>[] outArgs) {
        UnsignedInteger32 ret = new UnsignedInteger32(2L);
        if (null != userID) {
            CIMObjectPath accountOP = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), JServerProperties.getInteropNamespace(), JServerSettings.replaceSchemaClassName("WS_UserContact"), null);
            try {
                CIMInstance ci;
                UnsignedInteger32 maxObjects = new UnsignedInteger32(100L);
                EnumerateResponse resp = mHandle.enumerateInstances(accountOP, null, null, null, null, false, maxObjects);
                CloseableIterator instances = resp.getResponses();
                while (instances.hasNext()) {
                    ci = (CIMInstance)instances.next();
                    String accountID = (String)ci.getPropertyValue("UserID");
                    if (!userID.equals(accountID)) continue;
                    if (!resp.isEnd()) {
                        mHandle.closeEnumeration(accountOP, resp.getContext());
                    }
                    ret = new UnsignedInteger32(0L);
                    outArgs[0] = new CIMArgument("UserContacts", new CIMDataType("WS_UserContact", 0), (Object)new CIMObjectPath[]{ci.getObjectPath()});
                }
                while (!resp.isEnd()) {
                    resp = mHandle.getInstancesWithPath(accountOP, resp.getContext(), maxObjects);
                    while (instances.hasNext()) {
                        ci = (CIMInstance)instances.next();
                        if (!userID.equals(ci.getPropertyValue("UserID"))) continue;
                        if (!resp.isEnd()) {
                            mHandle.closeEnumeration(accountOP, resp.getContext());
                        }
                        ret = new UnsignedInteger32(0L);
                        outArgs[0] = new CIMArgument("UserContacts", new CIMDataType("WS_UserContact", 0), (Object)new CIMObjectPath[]{ci.getObjectPath()});
                    }
                }
            }
            catch (Exception e) {
                mLogger.log(Level.SEVERE, "Received Exception for AccountManagementService.GetAccount() trying to enumerate accounts.", e);
            }
        }
        return ret;
    }

    private UnsignedInteger32 getAccounts(CIMObjectPath target, String userID, CIMArgument<?>[] outArgs) {
        UnsignedInteger32 ret = new UnsignedInteger32(2L);
        if (null != userID) {
            CIMObjectPath accountOP = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), JServerProperties.getInteropNamespace(), JServerSettings.replaceSchemaClassName("WS_Account"), null);
            try {
                CIMInstance ci;
                UnsignedInteger32 maxObjects = new UnsignedInteger32(100L);
                EnumerateResponse resp = mHandle.enumerateInstances(accountOP, null, null, null, null, false, maxObjects);
                CloseableIterator instances = resp.getResponses();
                while (instances.hasNext()) {
                    ci = (CIMInstance)instances.next();
                    String accountID = (String)ci.getPropertyValue("UserID");
                    if (!userID.equals(accountID)) continue;
                    if (!resp.isEnd()) {
                        mHandle.closeEnumeration(accountOP, resp.getContext());
                    }
                    ret = new UnsignedInteger32(0L);
                    outArgs[0] = new CIMArgument("Accounts", new CIMDataType("CIM_Account", 0), (Object)new CIMObjectPath[]{ci.getObjectPath()});
                }
                while (!resp.isEnd()) {
                    resp = mHandle.getInstancesWithPath(accountOP, resp.getContext(), maxObjects);
                    while (instances.hasNext()) {
                        ci = (CIMInstance)instances.next();
                        if (!userID.equals(ci.getPropertyValue("UserID"))) continue;
                        if (!resp.isEnd()) {
                            mHandle.closeEnumeration(accountOP, resp.getContext());
                        }
                        ret = new UnsignedInteger32(0L);
                        outArgs[0] = new CIMArgument("Accounts", new CIMDataType("CIM_Account", 0), (Object)new CIMObjectPath[]{ci.getObjectPath()});
                    }
                }
            }
            catch (Exception e) {
                mLogger.log(Level.SEVERE, "Received Exception for AccountManagementService.GetAccount() trying to enumerate accounts.", e);
            }
        }
        return ret;
    }

    @Override
    protected CIMInstance generateInstance(CIMObjectPath target) {
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("Name", CIMDataType.STRING_T, (Object)CPV_NAME, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)CPV_SYSTEMCREATIONCLASSNAME, true), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)this.mClassName, true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)this.getHostName(), true)};
        CIMProperty[] props = new CIMProperty[]{keyProps[0], keyProps[1], keyProps[2], keyProps[3], new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)CPV_NAME, false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(2), false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(12), false)};
        CIMObjectPath op = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), JServerProperties.getInteropNamespace(), this.mClassName, keyProps);
        return new CIMInstance(op, props);
    }

    private UnsignedInteger32 createAccount(CIMObjectPath target, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) {
        CIMObjectPath system = null;
        CIMInstance accountTemplate = null;
        UnsignedInteger32 ret = null;
        if (null != inArgs && inArgs.length == 2) {
            for (CIMArgument<?> a : inArgs) {
                if (null != a && "System".equalsIgnoreCase(a.getName())) {
                    system = (CIMObjectPath)a.getValue();
                }
                if (null == a || !"AccountTemplate".equalsIgnoreCase(a.getName())) continue;
                accountTemplate = (CIMInstance)a.getValue();
            }
        }
        ret = this.createAccount(target, system, accountTemplate, outArgs);
        return ret;
    }

    private UnsignedInteger32 createAccount(CIMObjectPath target, CIMObjectPath system, CIMInstance accountTemplate, CIMArgument<?>[] outArgs) {
        UnsignedInteger32 ret = new UnsignedInteger32(2L);
        if (null == system || null == accountTemplate) {
            mLogger.severe("createAccount: system or accountTemplate was null - returning failed!");
            return ret;
        }
        String id = null;
        try {
            id = (String)accountTemplate.getPropertyValue("UserID");
        }
        catch (Exception e) {
            mLogger.log(Level.SEVERE, "CreateAccount failed when getting the value of the UserID property from the account--Template", e);
            return ret;
        }
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)(JServerProperties.getSchemaName() + ":" + id), true)};
        CIMObjectPath opIdentity = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), JServerProperties.getInteropNamespace(), JServerSettings.replaceSchemaClassName("WS_Identity"), keyProps);
        CIMInstance instIdentity = null;
        try {
            instIdentity = mHandle.getInstance(opIdentity, null);
        }
        catch (WBEMException e) {
            if (6 == e.getID()) {
                try {
                    opIdentity = mInternalProvider.createInstance(this.generateIdentityInstance(opIdentity));
                }
                catch (Exception ee) {
                    mLogger.log(Level.SEVERE, "CreateAccount failed when gettig the Instance of " + opIdentity, e);
                    return ret;
                }
            }
            mLogger.log(Level.SEVERE, "CreateAccount failed when gettig the Instance of " + opIdentity, e);
            return ret;
        }
        try {
            CIMObjectPath accountOP = mInternalProvider.createInstance(this.generateAccountInstance(target, accountTemplate));
            CIMObjectPath p = this.fixSystemName(accountOP);
            outArgs[0] = new CIMArgument("Account", new CIMDataType("CIM_Account"), (Object)p);
            if (null == instIdentity) {
                outArgs[1] = new CIMArgument("Identities", new CIMDataType("CIM_Identity", 0), (Object)new CIMObjectPath[]{opIdentity});
            }
            ret = new UnsignedInteger32(0L);
        }
        catch (Exception e) {
            ret = new UnsignedInteger32(2L);
        }
        return ret;
    }

    private UnsignedInteger32 createUserContact(CIMObjectPath target, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) {
        UnsignedInteger32 ret = new UnsignedInteger32(2L);
        CIMObjectPath system = null;
        CIMInstance userContactTemplate = null;
        if (null != inArgs && inArgs.length == 2) {
            for (CIMArgument<?> a : inArgs) {
                if (null != a && "System".equalsIgnoreCase(a.getName())) {
                    system = (CIMObjectPath)a.getValue();
                }
                if (null == a || !"AccountTemplate".equalsIgnoreCase(a.getName())) continue;
                userContactTemplate = (CIMInstance)a.getValue();
            }
        }
        if (null == system || null == userContactTemplate) {
            mLogger.severe("createAccount: system or userContactTemplate was null - returning failed!");
            return ret;
        }
        String id = null;
        try {
            id = (String)userContactTemplate.getPropertyValue("UserID");
        }
        catch (Exception e) {
            mLogger.log(Level.SEVERE, "CreateUserContact failed when getting the value of the UserID property from the usercontact Template", e);
            return ret;
        }
        if (null == id) {
            mLogger.log(Level.SEVERE, "UserID can not be null - CreateUserContact returning failed!");
            return ret;
        }
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)(JServerProperties.getSchemaName() + ":" + id), true)};
        CIMObjectPath opIdentity = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), JServerProperties.getInteropNamespace(), JServerSettings.replaceSchemaClassName("WS_Identity"), keyProps);
        CIMInstance instIdentity = null;
        try {
            instIdentity = mHandle.getInstance(opIdentity, null);
        }
        catch (WBEMException e) {
            if (6 == e.getID()) {
                try {
                    opIdentity = mInternalProvider.createInstance(this.generateIdentityInstance(opIdentity));
                }
                catch (Exception ee) {
                    mLogger.log(Level.SEVERE, "CreateAccount failed when gettig the Instance of " + opIdentity, e);
                    return ret;
                }
            }
            mLogger.log(Level.SEVERE, "CreateAccount failed when gettig the Instance of " + opIdentity, e);
            return ret;
        }
        try {
            CIMObjectPath userContactOP = mInternalProvider.createInstance(this.generateUserContactInstance(target, userContactTemplate));
            outArgs[0] = new CIMArgument("Account", new CIMDataType("CIM_Account"), (Object)userContactOP);
            if (null == instIdentity) {
                outArgs[1] = new CIMArgument("Identities", new CIMDataType("CIM_Identity", 0), (Object)new CIMObjectPath[]{opIdentity});
            }
            ret = new UnsignedInteger32(0L);
        }
        catch (Exception e) {
            ret = new UnsignedInteger32(2L);
        }
        return ret;
    }

    private CIMInstance generateIdentityInstance(CIMObjectPath opIdentity) {
        CIMProperty[] props = new CIMProperty[]{opIdentity.getKey("InstanceID"), new CIMProperty("CurrentlyAuthenticated", CIMDataType.BOOLEAN_T, (Object)false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)((String)opIdentity.getKeyValue("InstanceID"))), new CIMProperty("Roles", CIMDataType.STRING_ARRAY_T, (Object)new String[0])};
        return new CIMInstance(opIdentity, props);
    }

    private CIMInstance generateUserContactInstance(CIMObjectPath target, CIMInstance userContactTemplate) {
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)JServerSettings.replaceSchemaClassName("WS_UserContact"), true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)(JServerProperties.getSchemaName() + ":" + userContactTemplate.getPropertyValue("UserID")), true)};
        CIMObjectPath ucOP = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), JServerProperties.getInteropNamespace(), JServerSettings.replaceSchemaClassName("WS_UserContact"), keyProps);
        CIMInstance retInstance = userContactTemplate.deriveInstance(ucOP);
        retInstance = userContactTemplate.deriveInstance(keyProps);
        return retInstance;
    }

    private CIMInstance generateAccountInstance(CIMObjectPath target, CIMInstance accountTemplate) {
        String[] organizationName;
        CIMProperty[] keyProps = new CIMProperty[]{new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)"unknown", true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)JServerSettings.replaceSchemaClassName("WS_WBEMServerSystem"), true), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)JServerSettings.replaceSchemaClassName("WS_Account"), true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)(JServerProperties.getSchemaName() + ":" + (String)accountTemplate.getPropertyValue("UserID")), true)};
        String elementName = (String)accountTemplate.getPropertyValue("ElementName");
        if (null == elementName) {
            elementName = JServerProperties.getSchemaName() + ":" + (String)accountTemplate.getPropertyValue("UserID");
        }
        if (null == (organizationName = (String[])accountTemplate.getPropertyValue("OrganizationName"))) {
            organizationName = new String[]{JServerProperties.getSchemaName()};
        }
        CIMProperty[] props = new CIMProperty[]{keyProps[0], keyProps[1], keyProps[2], keyProps[3], accountTemplate.getProperty("UserID"), accountTemplate.getProperty("UserPassword"), new CIMProperty("OrganizationName", CIMDataType.STRING_ARRAY_T, (Object)organizationName), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)elementName), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(12)), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(2))};
        CIMObjectPath opAccount = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), JServerProperties.getInteropNamespace(), JServerSettings.replaceSchemaClassName("WS_Account"), keyProps);
        return new CIMInstance(opAccount, props);
    }
}

