/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.profiles.dmtf.indications;

import com.ws.wbem.jserver.CIMRepository;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.profiles.common.CommonProviderUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;
import org.wbemservices.wbem.repository.PSRlogImpl;

public class IndicationsBackupStore {
    private static final String CN_FILTER = "CIM_IndicationFilter";
    private static final String CN_SUBSCRIPTION = "CIM_IndicationSubscription";
    private static final String CN_HANDLER = "CIM_ListenerDestination";
    private static final String NS_INTEROP = JServerProperties.getInteropNamespace();
    private static final CIMObjectPath opFilter = new CIMObjectPath(null, null, null, NS_INTEROP, "CIM_IndicationFilter", null);
    private static final CIMObjectPath opHandler = new CIMObjectPath(null, null, null, NS_INTEROP, "CIM_ListenerDestination", null);
    private static final CIMObjectPath opSubscription = new CIMObjectPath(null, null, null, NS_INTEROP, "CIM_IndicationSubscription", null);
    private static final String backupDir = JServerProperties.getIndicationBackupDir();
    private static final String FILENAME = "indicationsBackup.ser";
    private static final String backupFile = backupDir + File.separatorChar + "indicationsBackup.ser";
    public static final String CN_STATICFILTER = JServerSettings.replaceSchemaClassName((String)"WS_StaticIndicationFilter");
    private static final ReentrantReadWriteLock mRRWLock = new ReentrantReadWriteLock();
    private static final Lock mReadLock = mRRWLock.readLock();
    private static final Lock mWriteLock = mRRWLock.writeLock();
    protected static Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");
    public static final int INDEX_FILTER_LIST = 0;
    public static final int INDEX_HANDLER_LIST = 1;
    public static final int INDEX_SUBSCRIPTION_LIST = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<CIMInstance> readData() {
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        if (null == backupDir || backupDir.isEmpty()) {
            return arrayList.iterator();
        }
        try {
            mReadLock.lock();
            try (FileInputStream fileInputStream = new FileInputStream(backupFile);
                 ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);){
                List list = (List)objectInputStream.readObject();
                if (null != list) {
                    if (list.size() == 3) {
                        CIMRepository cIMRepository = PSRlogImpl.getRepository();
                        List list2 = (List)list.get(0);
                        List list3 = (List)list.get(1);
                        List list4 = (List)list.get(2);
                        if (null != list2) {
                            for (CIMInstance cIMInstance : list2) {
                                try {
                                    cIMRepository.createInstance(cIMInstance);
                                    arrayList.add(CommonProviderUtils.fixSystemName((CIMInstance)cIMInstance));
                                }
                                catch (WBEMException wBEMException) {
                                    mLogger.log(Level.FINEST, "couldn't create filter from backup");
                                }
                            }
                        }
                        if (null != list3) {
                            for (CIMInstance cIMInstance : list3) {
                                try {
                                    cIMRepository.createInstance(cIMInstance);
                                }
                                catch (WBEMException wBEMException) {}
                            }
                        }
                        if (null != list4) {
                            for (CIMInstance cIMInstance : list4) {
                                try {
                                    cIMRepository.createInstance(cIMInstance);
                                }
                                catch (WBEMException wBEMException) {}
                            }
                        }
                    } else {
                        mLogger.log(Level.WARNING, "IndicationsBackup.restoreData(): wrong number of lists in backup.  Should have been 3 but there were only {0}", new Object[]{list.size()});
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                mLogger.log(Level.FINE, "Cannot read indications backup information from file. File cannot be found:" + backupFile, fileNotFoundException);
            }
            catch (Throwable throwable) {
                mLogger.log(Level.SEVERE, "ERROR: Reading indications backup information failed from file: " + backupFile, throwable);
            }
            finally {
                mReadLock.unlock();
            }
        }
        catch (Throwable throwable) {
            mLogger.log(Level.WARNING, "Caught exception reading indications backup information from file {0}:\n{1}", new Object[]{backupFile, throwable});
        }
        return arrayList.iterator();
    }

    public static synchronized void restoreData() {
        if (null == backupDir || backupDir.isEmpty()) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                IndicationsBackupStore.readData();
            }
        }, "IndicationRestore");
        thread.setDaemon(true);
        thread.start();
    }

    public static void storeData(final ProviderHandle providerHandle) {
        if (null == backupDir || backupDir.isEmpty()) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                IndicationsBackupStore.writeData(providerHandle);
            }
        }, "IndicationStoreData");
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void writeData(ProviderHandle providerHandle) {
        try {
            Object object;
            ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
            ArrayList<CIMInstance> arrayList2 = new ArrayList<CIMInstance>();
            ArrayList<CIMInstance> arrayList3 = new ArrayList<CIMInstance>();
            CloseableIterator closeableIterator = providerHandle.enumerateInstances(opFilter, null);
            CloseableIterator closeableIterator2 = providerHandle.enumerateInstances(opHandler, null);
            CloseableIterator closeableIterator3 = providerHandle.enumerateInstances(opSubscription, null);
            while (closeableIterator.hasNext()) {
                object = (CIMInstance)closeableIterator.next();
                if (CN_STATICFILTER.equals(object.getClassName())) continue;
                arrayList.add(CommonProviderUtils.cleanSystemName((CIMInstance)object));
            }
            while (closeableIterator2.hasNext()) {
                object = (CIMInstance)closeableIterator2.next();
                arrayList2.add(CommonProviderUtils.cleanSystemName((CIMInstance)object));
            }
            while (closeableIterator3.hasNext()) {
                object = (CIMInstance)closeableIterator3.next();
                arrayList3.add(CommonProviderUtils.cleanAssociationSystemName((CIMInstance)object));
            }
            object = new ArrayList(3);
            object.add(0, arrayList);
            object.add(1, arrayList2);
            object.add(2, arrayList3);
            try {
                mWriteLock.lock();
                try (FileOutputStream fileOutputStream = new FileOutputStream(backupFile);
                     ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);){
                    objectOutputStream.writeObject(object);
                }
            }
            catch (Exception exception) {
                mLogger.severe("ERROR: Could not write to file: " + backupFile);
            }
            finally {
                mWriteLock.unlock();
            }
        }
        catch (WBEMException wBEMException) {
            mLogger.log(Level.SEVERE, "Caught exception trying to read indication information for backup: {0}", new Object[]{wBEMException});
        }
    }
}

