/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.profiles.dmtf.recordlog;

import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.profiles.common.BaseProviderImpl;
import com.ws.wbem.profiles.common.InvalidCommonObject;
import com.ws.wbem.profiles.common.ReferenceInfo;
import com.ws.wbem.profiles.dmtf.recordlog.Record;
import com.ws.wbem.profiles.dmtf.recordlog.RecordConsumerIF;
import com.ws.wbem.profiles.dmtf.recordlog.RecordLogProfileUtils;
import com.ws.wbem.query.fql.FQLParser;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;

public class JLogEntryImpl<T extends InvalidCommonObject, V extends InvalidCommonObject>
extends BaseProviderImpl<T, V> {
    private final String ERR_GENERATE_OBJECTPATH_FAILED = "Failed to generate ObjectPath";
    private final String ERR_INVALID_KEY = "Invalid key.";
    private static final String RECORD_FORMAT = "\tuint64 LogID\tstring Severity\tuint64 ThreadID\tcimdatetime DateCreated\tstring ClassName\tstring FunctionName\tstring Message\tstring StackTrace";
    public static final String CLASSNAME = "JLogEntry";
    private final String PREFIXED_CLASSNAME = RecordLogProfileUtils.getSchemaName() + "_" + "JLogEntry";
    private static JLogEntryImpl<InvalidCommonObject, InvalidCommonObject> singleton = null;

    public static synchronized BaseProviderImpl<InvalidCommonObject, InvalidCommonObject> getInstrumentationInstance() throws Exception {
        if (singleton == null) {
            singleton = new JLogEntryImpl();
        }
        return singleton;
    }

    private JLogEntryImpl() {
    }

    @Override
    public void enumerate(CloseableAddableIterator<CIMInstance> closeableAddableIterator, CIMObjectPath cIMObjectPath, String[] stringArray, String string, String string2, boolean bl, boolean bl2, Hashtable<String, Object> hashtable, ReferenceInfo referenceInfo) throws WBEMException {
        if (bl) {
            throw WBEMOperationErrors.getContinuationOnErrorNotSupportedException((CIMObjectPath)cIMObjectPath, (WBEMOperation)WBEMOperation.OPENENUMERATEINSTANCES, null);
        }
        try {
            FQLParser fQLParser = FQLParser.getFQLParser((String)string, (String)string2, (CIMObjectPath)cIMObjectPath, (WBEMOperation)WBEMOperation.ENUMERATEINSTANCES);
            EnumerateThread enumerateThread = new EnumerateThread(!bl2, closeableAddableIterator, cIMObjectPath, stringArray, bl, fQLParser);
            Thread thread = new Thread(enumerateThread);
            thread.setDaemon(true);
            thread.start();
        }
        catch (Throwable throwable) {
            throw new WBEMException(1, "Exception starting to enumerate instances", null, throwable);
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath cIMObjectPath, String[] stringArray, T t, V v, Object ... objectArray) throws WBEMException {
        if (null != objectArray && objectArray.length > 0) {
            String string = objectArray[0].toString();
            Record record = (Record)objectArray[1];
            try {
                CIMObjectPath cIMObjectPath2 = this.generateObjectPath(cIMObjectPath, null, null, string + ":" + record.getSequence());
                CIMProperty[] cIMPropertyArray = cIMObjectPath2.getKeys();
                CIMProperty[] cIMPropertyArray2 = new CIMProperty[]{cIMPropertyArray[0], new CIMProperty("RecordID", CIMDataType.STRING_T, (Object)cIMPropertyArray[0].getValue().toString(), false), new CIMProperty("CreationTimeStamp", CIMDataType.DATETIME_T, (Object)this.getDateTimeAbsolute(record), false), new CIMProperty("RecordFormat", CIMDataType.STRING_T, (Object)RECORD_FORMAT, false), new CIMProperty("RecordData", CIMDataType.STRING_T, (Object)this.getFormattedData(record), false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)string, false)};
                return new CIMInstance(cIMObjectPath2, cIMPropertyArray2).filterProperties(stringArray);
            }
            catch (Throwable throwable) {
                throw new WBEMException(1, throwable.getMessage());
            }
        }
        throw new WBEMException(1, "Failed to generate ObjectPath\nInvalid key.");
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath cIMObjectPath, T t, V v, Object ... objectArray) throws WBEMException {
        if (null != objectArray && objectArray.length > 0) {
            CIMProperty[] cIMPropertyArray = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)objectArray[0].toString(), true)};
            return new CIMObjectPath(cIMObjectPath.getScheme(), cIMObjectPath.getHost(), cIMObjectPath.getPort(), cIMObjectPath.getNamespace(), this.PREFIXED_CLASSNAME, cIMPropertyArray, cIMObjectPath.getXmlSchemaName());
        }
        throw new WBEMException(1, "Failed to generate ObjectPath\nInvalid key.");
    }

    private CIMDateTimeAbsolute getDateTimeAbsolute(Record record) {
        String string;
        String string2 = record.getDate();
        String[] stringArray = string2.split("-");
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = stringArray[2];
        String string6 = record.getTime();
        String[] stringArray2 = string6.split(":");
        String string7 = stringArray2[0];
        String string8 = stringArray2[1];
        String string9 = stringArray2[2];
        String string10 = string = record.getMilli();
        int n = 0;
        if (string.length() < 6) {
            n = 6 - string.length();
            for (int i = 0; i < n; ++i) {
                string10 = string10 + "0";
            }
        }
        return new CIMDateTimeAbsolute(string3 + string4 + string5 + string7 + string8 + string9 + "." + string10.substring(0, 6) + "+000");
    }

    private String getFormattedData(Record record) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != record) {
            String string = record.getSequence();
            stringBuilder.append("\t" + (string == null ? "" : string));
            string = record.getLevel();
            stringBuilder.append("\t" + (string == null ? "" : string));
            string = record.getThread();
            stringBuilder.append("\t" + (string == null ? "" : string));
            string = record.getDate();
            stringBuilder.append("\t" + (string == null ? "" : string));
            string = record.getRecordClass();
            stringBuilder.append("\t" + (string == null ? "" : string));
            string = record.getMethod();
            stringBuilder.append("\t" + (string == null ? "" : string));
            string = record.getMessage();
            stringBuilder.append("\t" + (string == null ? "" : string.replaceAll("\\t", " ")));
            string = record.getException();
            if (string != null) {
                string = record.getException().replaceAll("\\t", " ");
                string = string.replaceAll("<frame>", "");
                string = string.replaceAll("</frame>", "");
                stringBuilder.append("\t" + string);
            } else {
                stringBuilder.append("\t");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, String[] stringArray) throws WBEMException {
        if (!cIMObjectPath.getObjectName().equals(this.PREFIXED_CLASSNAME)) {
            throw new WBEMException(5);
        }
        Object object = null;
        try {
            Object[] objectArray = new Object[1];
            GetInstanceThread getInstanceThread = new GetInstanceThread(objectArray, cIMObjectPath, stringArray);
            Thread thread = new Thread(getInstanceThread);
            thread.setDaemon(true);
            thread.start();
            while (thread.isAlive()) {
                Thread.sleep(1000L);
            }
            object = objectArray[0];
        }
        catch (Exception exception) {
            throw new WBEMException(1, exception.getMessage());
        }
        if (null == object) {
            throw new WBEMException(6);
        }
        if (object instanceof WBEMException) {
            throw (WBEMException)((Object)object);
        }
        if (object instanceof CIMInstance) {
            return (CIMInstance)object;
        }
        throw new WBEMException(6);
    }

    public class GetInstanceThread
    implements Runnable,
    RecordConsumerIF {
        Object[] mOutputContainer;
        private final CIMObjectPath mOP;
        private final String[] mPropertyList;

        public GetInstanceThread(Object[] objectArray, CIMObjectPath cIMObjectPath, String[] stringArray) {
            this.mOutputContainer = objectArray;
            this.mOP = cIMObjectPath;
            this.mPropertyList = stringArray;
        }

        @Override
        public boolean consumeRecord(String string, Record record) throws WBEMException {
            boolean bl = true;
            String string2 = this.mOP.getKey("InstanceID").getValue().toString();
            if (string2.equals(string + ":" + record.getSequence())) {
                this.mOutputContainer[0] = JLogEntryImpl.this.generateInstance(this.mOP, this.mPropertyList, null, null, string, record);
                bl = false;
            }
            return bl;
        }

        @Override
        public void run() {
            try {
                String string = RecordLogProfileUtils.getLogFileDirectory();
                List<String> list = RecordLogProfileUtils.getLogFiles(string);
                for (String string2 : list) {
                    if (!RecordLogProfileUtils.getLogs(string2, this)) break;
                }
            }
            catch (Throwable throwable) {
                this.mOutputContainer[0] = throwable instanceof WBEMException ? throwable : new WBEMException(1, "Exception while getting instance\n\n" + throwable.getMessage(), null, throwable);
            }
        }
    }

    public class EnumerateThread
    implements Runnable,
    RecordConsumerIF {
        boolean isInstanceOp;
        CloseableAddableIterator<CIMInstance> iter;
        private CIMObjectPath mOP;
        private final String[] mPropertyList;
        final FQLParser mFQLParser;

        public EnumerateThread(boolean bl, CloseableAddableIterator<CIMInstance> closeableAddableIterator, CIMObjectPath cIMObjectPath, boolean bl2, FQLParser fQLParser) {
            this(bl, closeableAddableIterator, cIMObjectPath, null, bl2, fQLParser);
        }

        public EnumerateThread(boolean bl, CloseableAddableIterator<CIMInstance> closeableAddableIterator, CIMObjectPath cIMObjectPath, String[] stringArray, boolean bl2, FQLParser fQLParser) {
            this.isInstanceOp = bl;
            this.iter = closeableAddableIterator;
            this.mOP = cIMObjectPath;
            this.mPropertyList = stringArray;
            this.mFQLParser = fQLParser;
        }

        @Override
        public boolean consumeRecord(String string, Record record) throws WBEMException {
            if (!this.iter.isClosed()) {
                CIMInstance cIMInstance = JLogEntryImpl.this.generateInstance(this.mOP, this.mPropertyList, null, null, string, record);
                if (null == this.mFQLParser || this.mFQLParser.evaluate(cIMInstance)) {
                    this.iter.add((Object)cIMInstance);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String string = RecordLogProfileUtils.getLogFileDirectory();
                List<String> list = RecordLogProfileUtils.getLogFiles(string);
                for (String string2 : list) {
                    RecordLogProfileUtils.getLogs(string2, this);
                }
            }
            catch (Throwable throwable) {
                WBEMException wBEMException = throwable instanceof WBEMException ? (WBEMException)throwable : new WBEMException(1, "Exception while enumerating instances\n\n", null, throwable);
                this.iter.setException(wBEMException);
            }
            finally {
                if (this.iter != null && !this.iter.isDone()) {
                    this.iter.done();
                }
            }
        }
    }
}

