/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;
import org.wbemservices.wbem.repository.LogException;
import org.wbemservices.wbem.repository.LogHandler;
import org.wbemservices.wbem.repository.LogInputStream;
import org.wbemservices.wbem.repository.LogOutputStream;

class ReliableLog {
    private static final String snapshotPrefix = "Snapshot.";
    private static final String logfilePrefix = "Logfile.";
    private static final String versionFile = "Version_Number";
    private static final String newVersionFile = "New_Version_Number";
    private static final int intBytes = 4;
    private final File dir;
    private int version = 0;
    private String logName = null;
    private RandomAccessFile log = null;
    private FileDescriptor logFD;
    private long snapshotBytes = 0L;
    private long logBytes = 0L;
    private int logEntries = 0;
    private final LogHandler handler;

    public ReliableLog(String dirPath, LogHandler handler) throws IOException, LogException {
        this.dir = new File(dirPath);
        if (!(this.dir.exists() && this.dir.isDirectory() || this.dir.mkdir())) {
            throw new LogException("could not create directory for log: " + dirPath);
        }
        this.handler = handler;
        this.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.log == null) {
            return;
        }
        try {
            this.log.close();
        }
        finally {
            this.log = null;
        }
    }

    private void commitToNewVersion() throws IOException {
        this.writeVersionFile(false);
        this.deleteNewVersionFile();
    }

    private void createFirstVersion() throws IOException {
        this.version = 0;
        this.writeVersionFile(false);
    }

    private void deleteFile(String name) throws LogException {
        File f = new File(name);
        if (!f.delete()) {
            throw new LogException("couldn't remove file: " + name);
        }
    }

    private void deleteLogFile(int ver) throws IOException {
        if (ver == 0) {
            return;
        }
        this.deleteFile(this.versionName(logfilePrefix, ver));
    }

    private void deleteNewVersionFile() throws IOException {
        this.deleteFile(this.fName(newVersionFile));
    }

    public void deletePersistentStore() {
        try {
            this.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.deleteLogFile(this.version);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.deleteSnapshot(this.version);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.deleteFile(this.fName(versionFile));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.deleteNewVersionFile();
        }
        catch (LogException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.dir.delete();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private void deleteSnapshot(int ver) throws IOException {
        if (ver == 0) {
            return;
        }
        this.deleteFile(this.versionName(snapshotPrefix, ver));
    }

    private String fName(String name) {
        return this.dir.getPath() + File.separator + name;
    }

    private void getVersion() throws IOException {
        try {
            this.version = this.readVersion(this.fName(newVersionFile));
            this.commitToNewVersion();
        }
        catch (IOException e) {
            try {
                this.deleteNewVersionFile();
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                this.version = this.readVersion(this.fName(versionFile));
            }
            catch (IOException ex) {
                this.createFirstVersion();
            }
        }
    }

    private void incrVersion() {
        do {
            ++this.version;
        } while (this.version == 0);
    }

    public long logSize() {
        return this.logBytes;
    }

    private void openLogFile(boolean truncate) throws IOException {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logName = this.versionName(logfilePrefix);
        this.log = new RandomAccessFile(this.logName, "rw");
        this.logFD = this.log.getFD();
        if (truncate) {
            this.log.setLength(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readVersion(String name) throws IOException {
        try (DataInputStream in = new DataInputStream(new FileInputStream(name));){
            int n = in.readInt();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws IOException, LogException {
        if (this.version == 0) {
            return;
        }
        String fname = this.versionName(snapshotPrefix);
        File snapshotFile = new File(fname);
        FileInputStream in = new FileInputStream(snapshotFile);
        BufferedInputStream bufIn = new BufferedInputStream(in);
        try {
            try {
                this.handler.recover(bufIn);
            }
            catch (Exception e) {
                throw new LogException("recovery failed", e);
            }
            this.snapshotBytes = snapshotFile.length();
        }
        finally {
            in.close();
        }
        this.recoverUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverUpdates() throws IOException, LogException {
        if (this.version == 0) {
            return;
        }
        String fname = this.versionName(logfilePrefix);
        FileInputStream in = new FileInputStream(fname);
        BufferedInputStream bufIn = new BufferedInputStream(in);
        DataInputStream dataIn = new DataInputStream(bufIn);
        try {
            while (true) {
                int updateLen = 0;
                try {
                    updateLen = dataIn.readInt();
                }
                catch (EOFException e) {
                    break;
                }
                if (updateLen == 0) {
                    break;
                }
                if (updateLen < 0) {
                    throw new LogException("corrupted log: bad update length");
                }
                if (bufIn.available() < updateLen) {
                    break;
                }
                try {
                    this.handler.readUpdate(new LogInputStream(bufIn, updateLen));
                }
                catch (Exception e) {
                    throw new LogException("read update failed", e);
                }
                this.logBytes += (long)(4 + updateLen);
                ++this.logEntries;
            }
        }
        finally {
            in.close();
        }
        this.openLogFile(false);
        this.log.seek(this.logBytes);
        this.log.setLength(this.logBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshot() throws IOException, LogException {
        int oldVersion = this.version;
        this.incrVersion();
        String fname = this.versionName(snapshotPrefix);
        File snapshotFile = new File(fname);
        try (FileOutputStream out = new FileOutputStream(snapshotFile);){
            try {
                this.handler.snapshot(out);
            }
            catch (Exception e) {
                throw new LogException("snapshot failed", e);
            }
            this.snapshotBytes = snapshotFile.length();
        }
        this.openLogFile(true);
        this.logBytes = 0L;
        this.logEntries = 0;
        this.writeVersionFile(true);
        this.commitToNewVersion();
        this.deleteSnapshot(oldVersion);
        this.deleteLogFile(oldVersion);
    }

    public long snapshotSize() {
        return this.snapshotBytes;
    }

    public void update(Object value) throws IOException, LogException {
        this.update(value, false);
    }

    public void update(Object value, boolean forceToDisk) throws IOException, LogException {
        long entryStart;
        block7: {
            entryStart = this.log.getFilePointer();
            this.log.writeInt(0);
            try {
                this.handler.writeUpdate(new LogOutputStream(this.log), value);
                if (!forceToDisk) break block7;
                try {
                    this.logFD.sync();
                }
                catch (SyncFailedException sfe) {
                    throw new LogException("sync log failed", sfe);
                }
            }
            catch (Exception e) {
                throw new LogException("write update failed", e);
            }
        }
        long entryEnd = this.log.getFilePointer();
        long updateLen = entryEnd - entryStart - 4L;
        this.log.seek(entryStart);
        this.log.writeInt((int)updateLen);
        this.log.seek(entryEnd);
        this.logBytes = entryEnd;
        if (forceToDisk) {
            try {
                this.logFD.sync();
            }
            catch (SyncFailedException sfe) {
                throw new LogException("sync log failed", sfe);
            }
        }
        ++this.logEntries;
    }

    private String versionName(String name) {
        return this.versionName(name, 0);
    }

    private String versionName(String prefix, int ver) {
        ver = ver == 0 ? this.version : ver;
        return this.fName(prefix) + String.valueOf(ver);
    }

    private void writeVersionFile(boolean newVersion) throws IOException {
        String name = newVersion ? newVersionFile : versionFile;
        DataOutputStream out = new DataOutputStream(new FileOutputStream(this.fName(name)));
        out.writeInt(this.version);
        out.close();
    }
}

