/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.kerberos;

import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalAccountInfo;
import sanproject.sn2.base.authentication.module.external.common.SJbaseLoginModule;
import sanproject.sn2.base.authentication.module.external.common.SJbaseParamater;
import sanproject.sn2.base.authentication.module.external.common.SJbaseSrvRecord;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExAuthenticationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.base.authentication.module.external.kerberos.SJbaseKerberosConfiguration;
import sanproject.sn2.base.authentication.module.external.kerberos.SJbaseKerberosConfigurationFactory;
import sanproject.sn2.base.authentication.module.external.kerberos.SJbaseKerberosGetInitialTicket;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseKerberosLoginModule
implements SJbaseLoginModule {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseKerberosLoginModule";
    private SJbaseKerberosConfiguration[] kerberosConfAry = null;
    private String userId;
    private String password;
    private Properties properties;

    public SJbaseKerberosLoginModule(String userId, String password, Properties properties) {
        String method = "constructor";
        logger.info(module, method, "", "start");
        this.userId = userId;
        this.password = password;
        this.properties = properties;
        logger.info(module, method, "", "end");
    }

    @Override
    public SJbaseParamater authenticate() throws SJbaseExAuthenticationException, SJbaseExCommunicationException {
        String method = "authenticate";
        logger.info(module, method, "", "srart");
        if (this.userId == null || this.userId.length() == 0) {
            logger.error(module, method, "check the user id", "invalid");
            throw new SJbaseExAuthenticationException();
        }
        if (this.password == null) {
            logger.error(module, method, "check the password", "invalid");
            throw new SJbaseExAuthenticationException();
        }
        this.kerberosConfAry = new SJbaseKerberosConfigurationFactory(this.properties).getConfigurations();
        if (this.kerberosConfAry == null) {
            logger.error(module, method, "check the configuration objectes", "invalid");
            SJbaseExAuthenticationException et = new SJbaseExAuthenticationException();
            et.setErrCode(9999);
            throw et;
        }
        String[] kdcList = null;
        for (int i = 0; i < this.kerberosConfAry.length; ++i) {
            SJbaseKerberosConfiguration tmpConf = this.kerberosConfAry[i];
            logger.info(module, method, "start the authentication process", "server :[" + i + "]");
            try {
                if (tmpConf.getDns_Lookup_Kdc().equalsIgnoreCase("true")) {
                    kdcList = tmpConf.getRealm() == null || tmpConf.getRealm().length() == 0 ? new SJbaseSrvRecord("kerberos", tmpConf.getDefaul_Realm()).getServerList() : new SJbaseSrvRecord("kerberos", tmpConf.getRealm()).getServerList();
                    for (int j = 0; j < kdcList.length; ++j) {
                        String[] tmpList = kdcList[j].split(",");
                        tmpConf.setKdc(tmpList[3].substring(0, tmpList[3].length() - 1));
                        tmpConf.setRealm(tmpConf.getDefaul_Realm());
                        try {
                            SJbaseParamater paramater = this.authenticate(tmpConf);
                            logger.info(module, method, "authenticate the user", "succeeded, KDC get from DNS :[" + tmpConf.getKdc() + "]");
                            logger.info(module, method, "", "end");
                            return paramater;
                        }
                        catch (SJbaseExCommunicationException e) {
                            logger.error(module, method, "authenticate the user", "failed, KDC get from DNS :[" + tmpConf.getKdc() + "]");
                            continue;
                        }
                    }
                    continue;
                }
                try {
                    SJbaseParamater paramater = this.authenticate(tmpConf);
                    logger.info(module, method, "authenticate the user", "succeeded, server :[" + i + "]");
                    logger.info(module, method, "", "end");
                    return paramater;
                }
                catch (SJbaseExCommunicationException e) {
                    logger.error(module, method, "authenticate the user", "failed, KDC :[" + i + "]", e);
                    continue;
                }
            }
            catch (SJbaseExAuthenticationException e) {
                logger.error(module, method, "authenticate the user", "failed, KDC :[" + i + "]", e);
                throw e;
            }
        }
        logger.error(module, method, "authentication the user", "failed at all servers");
        throw new SJbaseExCommunicationException();
    }

    public SJbaseParamater authenticate(SJbaseKerberosConfiguration kerberosConf) throws SJbaseExAuthenticationException, SJbaseExCommunicationException {
        String method = "authenticate";
        logger.info(module, method, "", "start");
        if (kerberosConf.getServerErrCode() == 10) {
            logger.error(module, method, "check the configuration object", "invalid");
            SJbaseExAuthenticationException et = new SJbaseExAuthenticationException();
            et.setErrCode(9999);
            throw et;
        }
        SJbaseExternalAccountInfo account = new SJbaseKerberosGetInitialTicket().execute(kerberosConf, this.userId, this.password);
        SJbaseParamater paramater = new SJbaseParamater(account);
        paramater.setKerberosConf(kerberosConf);
        logger.info(module, method, "", "end");
        return paramater;
    }
}

