/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.ldapcheckgroup;

import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalConst;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfiguration;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseLdapCheckGroupConfigurationFactory
implements SJbaseExternalConst {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseLdapCheckGroupConfigurationFactory";
    public static final String GROUP_BASE = "auth.group";
    private Properties checkGroupProperties;

    public SJbaseLdapCheckGroupConfigurationFactory(Properties checkGroupProperties) {
        this.checkGroupProperties = checkGroupProperties;
    }

    public SJbaseLdapGroupConfiguration[] getGroupConfigurations() {
        SJbaseLdapGroupConfiguration[] configs;
        String method = "getGroupConfigurations";
        logger.info(module, method, "", "start");
        String authServerType = this.checkGroupProperties.getProperty("auth.server.type");
        if (authServerType.equalsIgnoreCase("ldap")) {
            String serverList = this.checkGroupProperties.getProperty("auth.server.name");
            if (serverList == null || serverList.length() == 0) {
                logger.info(module, method, "check the server name", "invlaid");
                configs = new SJbaseLdapGroupConfiguration[]{};
            } else {
                String[] serverListArry = serverList.split(",");
                configs = new SJbaseLdapGroupConfiguration[serverListArry.length];
                for (int i = 0; i < serverListArry.length; ++i) {
                    String tmpServerName = serverListArry[i];
                    logger.info(module, method, "start to construct the configuration object", tmpServerName + ":[" + i + "]");
                    SJbaseLdapGroupConfiguration tmpConf = new SJbaseLdapGroupConfiguration();
                    String index = "auth.ldap." + tmpServerName + ".";
                    this.setDnsLookup(authServerType, tmpConf, index);
                    this.setDomainName(authServerType, tmpConf, index);
                    this.setLdapProtocol(authServerType, tmpConf, index);
                    this.setHost(authServerType, tmpConf, index);
                    this.setPort(tmpConf, index);
                    this.setTimeout(tmpConf, index);
                    this.setRetryTimes(tmpConf, index);
                    this.setRetryInterval(tmpConf, index);
                    this.setSearchUserPassword(tmpConf, index);
                    this.setSearchUserDN(tmpConf, index);
                    this.setBaseDN(tmpConf, index);
                    logger.info(module, method, "finish constructing the configuration object", tmpServerName + ":[" + i + "]");
                    configs[i] = tmpConf;
                }
            }
        } else if (authServerType.equalsIgnoreCase("radius")) {
            String serverList = this.checkGroupProperties.getProperty("auth.server.name");
            if (serverList == null || serverList.length() == 0) {
                logger.info(module, method, "check the server name", "invlaid");
                configs = new SJbaseLdapGroupConfiguration[]{};
            } else {
                String[] serverListArry = serverList.split(",");
                configs = new SJbaseLdapGroupConfiguration[serverListArry.length];
                for (int i = 0; i < serverListArry.length; ++i) {
                    String tmpServerName = serverListArry[i];
                    logger.info(module, method, "start to construct the configuration object", tmpServerName + ":[" + i + "]");
                    SJbaseLdapGroupConfiguration tmpConf = new SJbaseLdapGroupConfiguration();
                    String index = "auth.radius." + tmpServerName + ".";
                    this.setDomainName(authServerType, tmpConf, index);
                    this.setDnsLookup(authServerType, tmpConf, index);
                    index = "auth.group." + tmpConf.getDomainName() + ".";
                    this.setLdapProtocol(authServerType, tmpConf, index);
                    this.setHost(authServerType, tmpConf, index);
                    this.setPort(tmpConf, index);
                    this.setTimeout(tmpConf, index);
                    this.setRetryTimes(tmpConf, index);
                    this.setRetryInterval(tmpConf, index);
                    this.setSearchUserPassword(tmpConf, index);
                    this.setSearchUserDN(tmpConf, index);
                    this.setBaseDN(tmpConf, index);
                    logger.info(module, method, "finish constructing the configuration object", tmpServerName + ":[" + i + "]");
                    configs[i] = tmpConf;
                }
            }
        } else if (authServerType.equalsIgnoreCase("kerberos")) {
            String realmNameList = this.checkGroupProperties.getProperty("auth.kerberos.realm_name");
            if (realmNameList == null || realmNameList.length() == 0) {
                logger.info(module, method, "check the server name", "invlaid");
                configs = new SJbaseLdapGroupConfiguration[]{};
            } else {
                String[] realmNameListArry = realmNameList.split(",");
                configs = new SJbaseLdapGroupConfiguration[realmNameListArry.length];
                for (int i = 0; i < realmNameListArry.length; ++i) {
                    String tmpRealmName = realmNameListArry[i];
                    logger.info(module, method, "start to construct the configuration object", tmpRealmName + ":[" + i + "]");
                    SJbaseLdapGroupConfiguration tmpConf = new SJbaseLdapGroupConfiguration();
                    String index = "auth.kerberos." + tmpRealmName + ".";
                    this.setDnsLookup(authServerType, tmpConf, index);
                    this.setDomainName(authServerType, tmpConf, index);
                    this.setHost(authServerType, tmpConf, index);
                    index = "auth.group." + tmpRealmName + ".";
                    this.setLdapProtocol(authServerType, tmpConf, index);
                    this.setPort(tmpConf, index);
                    this.setTimeout(tmpConf, index);
                    this.setRetryTimes(tmpConf, index);
                    this.setRetryInterval(tmpConf, index);
                    this.setSearchUserPassword(tmpConf, index);
                    this.setSearchUserDN(tmpConf, index);
                    this.setBaseDN(tmpConf, index);
                    logger.info(module, method, "finish constructing the configuration object", tmpRealmName + ":[" + i + "]");
                    configs[i] = tmpConf;
                }
            }
        } else {
            configs = new SJbaseLdapGroupConfiguration[]{};
        }
        return configs;
    }

    public void setDnsLookup(String serverType, SJbaseLdapGroupConfiguration conf, String index) {
        String tmpDnsLookup;
        String method = "setDnsLookup";
        logger.info(module, method, "", "start");
        String prm1 = null;
        String prm2 = null;
        if (serverType.equalsIgnoreCase("kerberos")) {
            tmpDnsLookup = this.checkGroupProperties.getProperty("auth.kerberos.dns_lookup_kdc");
            prm1 = this.checkGroupProperties.getProperty(index + "kdc");
            prm2 = this.checkGroupProperties.getProperty(index + "realm");
        } else if (serverType.equalsIgnoreCase("radius")) {
            tmpDnsLookup = this.checkGroupProperties.getProperty(index + "dns_lookup");
            prm1 = this.checkGroupProperties.getProperty("auth.group." + conf.getDomainName() + "." + "host");
            prm2 = this.checkGroupProperties.getProperty("auth.group." + conf.getDomainName() + "." + "port");
        } else {
            tmpDnsLookup = this.checkGroupProperties.getProperty(index + "dns_lookup");
            prm1 = this.checkGroupProperties.getProperty(index + "host");
            prm2 = this.checkGroupProperties.getProperty(index + "port");
        }
        if (prm1 == null || prm1.length() == 0 || prm2 == null || prm2.length() == 0) {
            if (tmpDnsLookup == null || tmpDnsLookup.length() == 0) {
                logger.info(module, method, "the value is invalid", "dns lookup");
                conf.setDnsLookup("false");
            } else if (tmpDnsLookup.equalsIgnoreCase("true") || tmpDnsLookup.equalsIgnoreCase("false")) {
                conf.setDnsLookup(tmpDnsLookup);
            } else {
                logger.info(module, method, "the value is invalid", "dns lookup");
                conf.setDnsLookup("false");
            }
        } else {
            conf.setDnsLookup("false");
        }
        logger.info(module, method, "", "end");
    }

    public void setDomainName(String serverType, SJbaseLdapGroupConfiguration conf, String index) {
        String tmpDomainName;
        String method = "setDomainName";
        logger.info(module, method, "", "start");
        if (serverType.equalsIgnoreCase("kerberos")) {
            tmpDomainName = this.checkGroupProperties.getProperty(index + "realm");
            if (tmpDomainName == null || tmpDomainName.length() == 0) {
                tmpDomainName = this.checkGroupProperties.getProperty("auth.kerberos.default_realm");
            }
        } else {
            tmpDomainName = this.checkGroupProperties.getProperty(index + "domain.name");
        }
        if (tmpDomainName == null || tmpDomainName.length() == 0) {
            logger.info(module, method, "the value is invalid", "domain name");
            conf.setServerErrCode(10);
        } else {
            conf.setDomainName(tmpDomainName);
        }
        logger.info(module, method, "", "end");
    }

    public void setLdapProtocol(String serverType, SJbaseLdapGroupConfiguration conf, String index) {
        String method = "setLdapProtocol";
        logger.info(module, method, "", "start");
        String tmpProtocol = this.checkGroupProperties.getProperty(index + "protocol");
        if (tmpProtocol == null || tmpProtocol.length() == 0) {
            if (serverType.equalsIgnoreCase("ldap")) {
                logger.info(module, method, "the value is invalid", "protocol");
                conf.setServerErrCode(10);
            } else {
                conf.setProtocol("ldap");
            }
        } else if (tmpProtocol.equalsIgnoreCase("ldap")) {
            conf.setProtocol("ldap");
        } else if (tmpProtocol.equalsIgnoreCase("ldaps") && conf.getDnsLookup().equalsIgnoreCase("false")) {
            conf.setProtocol("ldaps");
        } else if (tmpProtocol.equalsIgnoreCase("starttls")) {
            conf.setProtocol("starttls");
        } else {
            logger.info(module, method, "the value is invalid", "protocol");
            conf.setServerErrCode(10);
        }
        logger.info(module, method, "", "end");
    }

    public void setHost(String serverType, SJbaseLdapGroupConfiguration conf, String index) {
        String host;
        String method = "setHost";
        logger.info(module, method, "", "start");
        if (serverType.equalsIgnoreCase("kerberos")) {
            int trimHost;
            host = this.checkGroupProperties.getProperty(index + "kdc");
            if (host != null && (trimHost = host.indexOf(":")) > 0) {
                host = host.substring(0, trimHost);
            }
        } else {
            host = this.checkGroupProperties.getProperty(index + "host");
        }
        conf.setHost(host);
        logger.info(module, method, "", "end");
    }

    public void setPort(SJbaseLdapGroupConfiguration conf, String index) {
        String method = "setPort";
        logger.info(module, method, "", "start");
        int tmpPort = 389;
        try {
            tmpPort = Integer.parseInt(this.checkGroupProperties.getProperty(index + "port"));
            if (tmpPort < 1 || tmpPort > 65535) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", "port number");
            tmpPort = 389;
        }
        conf.setPort(tmpPort);
        logger.info(module, method, "", "end");
    }

    public void setTimeout(SJbaseLdapGroupConfiguration conf, String index) {
        String method = "setTimeout";
        logger.info(module, method, "", "start");
        int tmpTimeout = 10;
        try {
            tmpTimeout = Integer.parseInt(this.checkGroupProperties.getProperty(index + "timeout"));
            if (tmpTimeout < 1 || tmpTimeout > 120) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", "timeout");
            tmpTimeout = 10;
        }
        conf.setTimeout(tmpTimeout);
        logger.info(module, method, "", "end");
    }

    public void setRetryTimes(SJbaseLdapGroupConfiguration conf, String index) {
        String method = "setRetryTimes";
        logger.info(module, method, "", "start");
        int tmpRetryTimes = 3;
        try {
            tmpRetryTimes = Integer.parseInt(this.checkGroupProperties.getProperty(index + "retry.times"));
            if (tmpRetryTimes < 0 || tmpRetryTimes > 50) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", "retry times");
            tmpRetryTimes = 3;
        }
        conf.setRetryTimes(tmpRetryTimes);
        logger.info(module, method, "", "end");
    }

    public void setRetryInterval(SJbaseLdapGroupConfiguration conf, String index) {
        String method = "setRetryInterval";
        logger.info(module, method, "", "start");
        int tmpRetryInterval = 1;
        try {
            tmpRetryInterval = Integer.parseInt(this.checkGroupProperties.getProperty(index + "retry.interval"));
            if (tmpRetryInterval < 1 || tmpRetryInterval > 60) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", "retry interval");
            tmpRetryInterval = 1;
        }
        conf.setRetryInterval(tmpRetryInterval);
        logger.info(module, method, "", "end");
    }

    public void setSearchUserPassword(SJbaseLdapGroupConfiguration conf, String index) {
        String method = "setSearchUserPassword";
        logger.info(module, method, "", "start");
        String tmpSearchPW = this.checkGroupProperties.getProperty(index + "searchpw");
        if (tmpSearchPW == null || tmpSearchPW.length() == 0) {
            logger.info(module, method, "", "search user password is not registered");
            conf.setServerErrCode(10);
        } else {
            conf.setSearchUserPassword(tmpSearchPW);
        }
        logger.info(module, method, "", "end");
    }

    public void setSearchUserDN(SJbaseLdapGroupConfiguration conf, String index) {
        String method = "setSearchUserDN";
        logger.info(module, method, "", "start");
        String tmpSearchDN = this.checkGroupProperties.getProperty(index + "searchdn");
        if (tmpSearchDN == null || tmpSearchDN.length() == 0) {
            logger.info(module, method, "", "search user is not registered");
            conf.setServerErrCode(10);
        } else {
            conf.setSearchUserDN(tmpSearchDN);
        }
        logger.info(module, method, "", "end");
    }

    public void setBaseDN(SJbaseLdapGroupConfiguration conf, String index) {
        String method = "setBaseDN";
        logger.info(module, method, "", "start");
        String tmpbaseDN = this.checkGroupProperties.getProperty(index + "basedn");
        if (tmpbaseDN == null || tmpbaseDN.length() == 0) {
            logger.info(module, method, "", "basedn is not registered");
            conf.setServerErrCode(10);
        } else {
            conf.setSearchDN(tmpbaseDN);
        }
        logger.info(module, method, "", "end");
    }
}

