/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.radius;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusFormatException;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusPacket;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusPacketParser;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusPacketValidator;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseRadiusPacketHandler {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseRadiusPacketHandler";
    protected String protocol = "PAP";
    protected String host = "localhost";
    protected int port = 1812;
    protected int timeout = 1000;
    protected int retry = 3;
    protected SJbaseRadiusPacketValidator validator;

    public SJbaseRadiusPacketHandler(String protocol, String host, int port, int timeout, int retry) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.retry = retry;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getRetry() {
        return this.retry;
    }

    public void setRetry(int retry) {
        this.retry = retry;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public SJbaseRadiusPacketValidator getValidator() {
        return this.validator;
    }

    public void setValidator(SJbaseRadiusPacketValidator validator) {
        this.validator = validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SJbaseRadiusPacket send(SJbaseRadiusPacket request) throws SJbaseExCommunicationException {
        int times;
        String method = "send";
        logger.info(module, method, "", "start");
        SJbaseRadiusPacket response = null;
        SJbaseRadiusPacketParser resParser = new SJbaseRadiusPacketParser();
        byte[] reqBytes = request.toBytes();
        for (times = -1; times < this.retry; ++times) {
            logger.info(module, method, "start the authentication process", "retry times :" + Integer.toString(times + 1));
            DatagramSocket socket = null;
            try {
                InetSocketAddress remoteAddr = new InetSocketAddress(this.host, this.port);
                if (remoteAddr.isUnresolved()) {
                    logger.error(module, method, "resolve the host name", "failed");
                    SJbaseExCommunicationException et = new SJbaseExCommunicationException();
                    et.setErrCode(1);
                    throw et;
                }
                DatagramPacket reqPacket = new DatagramPacket(reqBytes, reqBytes.length, remoteAddr);
                byte[] resbuf = new byte[4096];
                DatagramPacket resPacket = new DatagramPacket(resbuf, resbuf.length);
                socket = new DatagramSocket();
                socket.send(reqPacket);
                socket.setSoTimeout(this.timeout * 1000);
                socket.receive(resPacket);
                byte[] resBytes = new byte[resPacket.getLength()];
                System.arraycopy(resbuf, 0, resBytes, 0, resBytes.length);
                response = resParser.parse(resBytes);
                if (this.validator == null) break;
                this.validator.validate(response);
                break;
            }
            catch (SocketTimeoutException e) {
                logger.error(module, method, "", "", e);
                continue;
            }
            catch (SJbaseRadiusFormatException e) {
                logger.error(module, method, "", "", e);
                continue;
            }
            catch (IOException e) {
                logger.error(module, method, "", "", e);
                continue;
            }
            finally {
                if (socket != null) {
                    socket.close();
                }
            }
        }
        if (times == this.retry) {
            logger.error(module, method, "authenticate the user", "failed scheduled times");
            SJbaseExCommunicationException et = new SJbaseExCommunicationException();
            et.setErrCode(2);
            throw et;
        }
        logger.info(module, method, "", "end");
        return response;
    }
}

