/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.session;

import java.util.HashMap;

public class SJbaseUserSessionLockManager {
    private static HashMap<String, SJbaseUserSessionLock> lockTree = new HashMap();

    private SJbaseUserSessionLockManager() {
    }

    public static synchronized Object acquire(String userID) {
        SJbaseUserSessionLock lock;
        boolean exist = lockTree.containsKey(userID);
        if (!exist) {
            SJbaseUserSessionLockManager sJbaseUserSessionLockManager = new SJbaseUserSessionLockManager();
            sJbaseUserSessionLockManager.getClass();
            lock = sJbaseUserSessionLockManager.new SJbaseUserSessionLock();
            lock.setUserID(userID);
            lockTree.put(userID, lock);
        } else {
            lock = lockTree.get(userID);
        }
        lock.acquire();
        return lock;
    }

    public static synchronized void release(Object obj) {
        if (!(obj instanceof SJbaseUserSessionLock)) {
            return;
        }
        SJbaseUserSessionLock lock = (SJbaseUserSessionLock)obj;
        lock.release();
        if (lock.getCounter() <= 0) {
            String userID = lock.getUserID();
            lockTree.remove(userID);
        }
    }

    private class SJbaseUserSessionLock {
        private int lockCounter = 0;
        private String userID;

        private SJbaseUserSessionLock() {
        }

        public void acquire() {
            ++this.lockCounter;
        }

        public void release() {
            --this.lockCounter;
        }

        public int getCounter() {
            return this.lockCounter;
        }

        public String getUserID() {
            return this.userID;
        }

        public void setUserID(String userID) {
            this.userID = userID;
        }
    }
}

