/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.tomcat;

import java.io.IOException;
import java.io.OutputStream;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;

public class SJcTomcatOutputStream
extends OutputStream {
    SJcLoggerInterface logger = null;
    private static final String ENCODE = "UTF-8";
    private static final String LOG_FUNCTION = "SN2";
    private static final String LOG_TITLE = "Tomcat";
    private static final String LOG_SUBTITLE = "Stdout";

    public SJcTomcatOutputStream(SJcLoggerInterface logger) {
        this.logger = logger;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkParameter(b, off, len);
        if (len == 0) {
            return;
        }
        try {
            StackTraceElement[] elements;
            Throwable th = new Throwable();
            for (StackTraceElement element : elements = th.getStackTrace()) {
                String className = element.getClassName();
                if (!className.contains("SJcLogger")) continue;
                return;
            }
            String logString = new String(b, off, len, ENCODE);
            if ((logString = this.stripCRLF(logString)).length() != 0) {
                this.logger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, logString);
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
    }

    private void checkParameter(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    private String stripCRLF(String logString) {
        int endIndex;
        if (logString.endsWith("\n")) {
            endIndex = logString.length() - 1;
            logString = logString.substring(0, endIndex);
        }
        if (logString.endsWith("\r")) {
            endIndex = logString.length() - 1;
            logString = logString.substring(0, endIndex);
        }
        return logString;
    }

    @Override
    public void write(int b) throws IOException {
    }
}

