/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet.extauth.hic;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.BitSet;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sanproject.sn2.base.authentication.plugin.SJbaseHICAuthentication;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.SJcAuditLogSSOElemCon;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLoggerInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.security.exception.SJcSecureUtyParameterException;

public class SJsvlLauncherServlet
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private final String LOG_FUNCTION = "HIC Authentication";
    private final String LOG_TITLE = ((Object)((Object)this)).getClass().getSimpleName();
    private static final String FORWARD_URL = "/index.do";
    public static final String HIC_KEY_USER_ID = "USER_ID";
    public static final String HIC_KEY_LOCALIZATION_MODE = "LOCALIZATION_MODE";
    private static final String ENCODE = "UTF-8";
    public static final String HIC_KEY_DIRECT_LAUNCH_MODE = "DIRECT_LAUNCH_MODE";
    public static final String HIC_KEY_CALLBACK_URL_BACK = "CALLBACK_URL_BACK";
    public static final String HIC_KEY_CALLBACK_URL_APPLY = "CALLBACK_URL_APPLY";
    public static final String HIC_KEY_CALLBACK_PARAMS = "CALLBACK_PARAMS";
    public static final String HIC_KEY_SUB_MENU_DISABLE = "SUB_MENU_DISABLE";
    public static final String HIC_KEY_HELP_URL = "HELP_URL";
    public static final int VALID_SIZE_SUB_MENU_DISABLE = 32;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doGet";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info("HIC Authentication", this.LOG_TITLE, "doGet", "Start. - request:" + request + ", response:" + response);
        this.doPost(request, response);
        STD_LOGGER.info("HIC Authentication", this.LOG_TITLE, "doGet", "End.");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doPost";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info("HIC Authentication", this.LOG_TITLE, "doPost", "Start. - request:" + request + ", response:" + response);
        String onetimeKey = this.getOnetimeKey(request);
        if (null == onetimeKey) {
            response.sendError(404);
            STD_LOGGER.error("HIC Authentication", this.LOG_TITLE, "doPost", "onetimeKey read error.");
            SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger();
            SJcAuditLogSSOElemCon ec = SJcAuditLogSSOElemCon.createSSOElemCon("HCSSO Authentication", "", "", request.getRemoteAddr(), "Error", new SJcSecureUtyParameterException("107000").getMsg());
            adtLogger.putLog(ec);
            return;
        }
        HashMap<String, Object> userInfoMap = null;
        try {
            userInfoMap = SJbaseHICAuthentication.getUserInfo(onetimeKey);
        }
        catch (SJcException e) {
            STD_LOGGER.error("HIC Authentication", this.LOG_TITLE, "doPost", "Failed to get userInfoMap.", e);
            response.sendError(404);
            SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger();
            SJcAuditLogSSOElemCon ec = SJcAuditLogSSOElemCon.createSSOElemCon("HCSSO Authentication", "", "", request.getRemoteAddr(), "Error", e.getMsg());
            adtLogger.putLog(ec);
            return;
        }
        SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger();
        String userName = (String)userInfoMap.get(HIC_KEY_USER_ID);
        SJcAuditLogSSOElemCon ec = SJcAuditLogSSOElemCon.createSSOElemCon("HCSSO Authentication", "", userName, request.getRemoteAddr(), "Success", null);
        adtLogger.putLog(ec);
        String lang = "AUTO";
        String userInfoLang = (String)userInfoMap.get(HIC_KEY_LOCALIZATION_MODE);
        if (userInfoLang.equals("1")) {
            lang = "EN";
        } else if (userInfoLang.equals("2")) {
            lang = "JA";
        }
        String loginType = "HIC";
        String username = (String)userInfoMap.get(HIC_KEY_USER_ID);
        String launchMode = this.getDirectLaunchMode(userInfoMap);
        String callbackUrlBack = (String)userInfoMap.get(HIC_KEY_CALLBACK_URL_BACK);
        String callbackUrlApply = (String)userInfoMap.get(HIC_KEY_CALLBACK_URL_APPLY);
        String callbackParam = (String)userInfoMap.get(HIC_KEY_CALLBACK_PARAMS);
        String subMenuDisable = this.getSubMenuDisable(userInfoMap);
        String helpURL = this.getHelpURL(userInfoMap);
        request.setAttribute("SN_Language", (Object)lang);
        request.setAttribute("SN_View_LoginType", (Object)loginType);
        request.setAttribute("SN_View_UserName", (Object)username);
        request.setAttribute("SN_View_Password", (Object)onetimeKey);
        request.setAttribute("SN_View_DirectLaunch", (Object)launchMode);
        request.setAttribute("SN_View_CallbackUrlBack", (Object)callbackUrlBack);
        request.setAttribute("SN_View_CallbackUrlApply", (Object)callbackUrlApply);
        request.setAttribute("SN_View_CallbackParam", (Object)callbackParam);
        request.setAttribute("SN_SubMenu_Disable", (Object)subMenuDisable);
        request.setAttribute("SN_View_HelpURL", (Object)helpURL);
        STD_LOGGER.info("HIC Authentication", this.LOG_TITLE, "doPost", "lang:" + lang + ", PARAM_LOGINTYPE:" + loginType + ", PARAM_USERNAME:" + username + ", onetimeKey:" + onetimeKey + ", launchMode:" + launchMode + ", subMenuDisable:" + subMenuDisable + ", helpURL:" + helpURL + ", callbackUrlBack: " + callbackUrlBack + ", callbackUrlApply: " + callbackUrlApply + ", callbackParam: " + callbackParam);
        ServletContext sc = this.getServletContext();
        RequestDispatcher rd = sc.getRequestDispatcher(FORWARD_URL);
        rd.forward((ServletRequest)request, (ServletResponse)response);
        STD_LOGGER.info("HIC Authentication", this.LOG_TITLE, "doPost", "End.");
    }

    private String getDirectLaunchMode(HashMap<String, Object> userInfoMap) {
        String LOG_SUBTITLE = "getDirectLaunchMode";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        String result = "0";
        String launchMode = (String)userInfoMap.get(HIC_KEY_DIRECT_LAUNCH_MODE);
        if (launchMode == null) {
            STD_LOGGER.info("HIC Authentication", this.LOG_TITLE, "getDirectLaunchMode", "DIRECT_LAUNCH_MODE is null. result:" + result);
            return result;
        }
        result = launchMode;
        STD_LOGGER.info("HIC Authentication", this.LOG_TITLE, "getDirectLaunchMode", "result:" + result);
        return result;
    }

    private String getSubMenuDisable(HashMap<String, Object> userInfoMap) {
        String LOG_SUBTITLE = "getSubMenuDisable";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        String result = "0";
        BitSet bs = (BitSet)userInfoMap.get(HIC_KEY_SUB_MENU_DISABLE);
        if (bs == null) {
            STD_LOGGER.info("HIC Authentication", this.LOG_TITLE, "getSubMenuDisable", "SUB_MENU_DISABLE is null.");
            return result;
        }
        int bsint = 0;
        for (int i = 31; i >= 0; --i) {
            if (bs.get(i)) {
                bsint |= 1;
            }
            if (i == 0) continue;
            bsint <<= 1;
        }
        result = new Integer(bsint).toString();
        STD_LOGGER.info("HIC Authentication", this.LOG_TITLE, "getSubMenuDisable", "result:" + result);
        return result;
    }

    private String getHelpURL(HashMap<String, Object> userInfoMap) {
        String LOG_SUBTITLE = "getHelpURL";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        String result = "";
        String helpURL = (String)userInfoMap.get(HIC_KEY_HELP_URL);
        if (helpURL == null) {
            STD_LOGGER.info("HIC Authentication", this.LOG_TITLE, "getHelpURL", "HELP_URL is null. result:" + result);
            return result;
        }
        result = helpURL;
        STD_LOGGER.info("HIC Authentication", this.LOG_TITLE, "getHelpURL", "result:" + result);
        return result;
    }

    String getOnetimeKey(HttpServletRequest request) {
        String LOG_SUBTITLE = "getOnetimeKey";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info("HIC Authentication", this.LOG_TITLE, "getOnetimeKey", "Start.");
        String result = null;
        request.setAttribute("SN_View_PathInfo_Flag", (Object)false);
        String expantionPath = request.getPathInfo();
        if (null != expantionPath) {
            result = !expantionPath.equals("/") ? expantionPath.substring(1) : "";
            request.setAttribute("SN_View_PathInfo_Flag", (Object)true);
        } else {
            result = this.readOnetimeKeyFromRequest(request);
            if (null == result || "".equals(result)) {
                STD_LOGGER.error("HIC Authentication", this.LOG_TITLE, "getOnetimeKey", "onetimeKey from parameter is null or empty.");
            }
        }
        STD_LOGGER.info("HIC Authentication", this.LOG_TITLE, "getOnetimeKey", "End. - result:" + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readOnetimeKeyFromRequest(HttpServletRequest request) {
        String LOG_SUBTITLE = "readOnetimeKeyFromRequest";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace("HIC Authentication", this.LOG_TITLE, "readOnetimeKeyFromRequest", "Start. - request:" + request);
        String ret = null;
        ServletInputStream inStream = null;
        InputStreamReader reader = null;
        try {
            int ch;
            inStream = request.getInputStream();
            reader = new InputStreamReader((InputStream)inStream, ENCODE);
            StringBuffer buf = new StringBuffer();
            while ((ch = reader.read()) != -1) {
                buf.append((char)ch);
            }
            ret = buf.toString();
            this.closeStream((Closeable)inStream);
            this.closeStream(reader);
        }
        catch (Exception e) {
            try {
                STD_LOGGER.error("HIC Authentication", this.LOG_TITLE, "readOnetimeKeyFromRequest", "Failed to read onetime key.", e.getCause());
                this.closeStream((Closeable)inStream);
                this.closeStream(reader);
            }
            catch (Throwable throwable) {
                this.closeStream((Closeable)inStream);
                this.closeStream(reader);
                throw throwable;
            }
        }
        STD_LOGGER.trace("HIC Authentication", this.LOG_TITLE, "readOnetimeKeyFromRequest", "End. - ret:" + ret);
        return ret;
    }

    private void closeStream(Closeable s) {
        String LOG_SUBTITLE = "closeStream";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace("HIC Authentication", this.LOG_TITLE, "closeStream", "Start. - s:" + s);
        if (null != s) {
            try {
                s.close();
            }
            catch (IOException e) {
                STD_LOGGER.error("HIC Authentication", this.LOG_TITLE, "closeStream", "Failed to close stream.", e);
            }
        }
        STD_LOGGER.trace("HIC Authentication", this.LOG_TITLE, "closeStream", "End.");
    }
}

