/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.data;

import com.hitachi.sanproject.data.SanClass;
import com.hitachi.sanproject.data.SanClassImpl;
import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataErrorCode;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanInterface;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SanDataUtility {
    public static final int STRING_BUFFER_SIZE = 128;
    protected static final Pattern p1 = Pattern.compile("\\s*\"([\\S&&[^\"]]+)\"\\s*:\\s*\\{\\s*\"@\"\\s*:\\s*\\{\\s*\"type\"\\s*:\\s*\"([\\S&&[^\"]]+)\"\\s*,*");
    protected static final Pattern p2 = Pattern.compile("\\s*\"([\\S&&[^\"]]+)\"\\s*:\\s*\"\\s*([\\S&&[^\"]]|[\\S&&[^\"]][ \\S&&[^\"]]*[\\S&&[^\"]])\\s*\"\\s*,*");

    public static SanData readDataFromJSON(File file) throws SanDataException {
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        SanData sanData = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader(fileInputStream);
            sanData = SanDataUtility.readDataFromJSONCmn(inputStreamReader, file.getName());
        }
        catch (IOException iOException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)iOException);
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                } else if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return sanData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SanData readDataFromJSON(InputStream inputStream, String string) throws SanDataException {
        InputStreamReader inputStreamReader = null;
        SanData sanData = null;
        inputStreamReader = new InputStreamReader(inputStream);
        try {
            sanData = SanDataUtility.readDataFromJSONCmn(inputStreamReader, string);
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return sanData;
    }

    /*
     * Unable to fully structure code
     */
    public static SanData readDataFromJSONCmn(InputStreamReader var0, String var1_1) throws SanDataException {
        block28: {
            var2_2 = null;
            var3_3 = null;
            var4_4 = null;
            try {
                var4_4 = new BufferedReader(var0);
                var5_5 = 0;
                var6_10 = null;
                var7_11 = null;
                block15: while ((var5_5 = var4_4.read()) != -1) {
                    var8_12 = (char)var5_5;
                    switch (var8_12) {
                        case ',': 
                        case '{': {
                            if (var6_10 == null) {
                                var6_10 = new StringBuilder(128);
                                continue block15;
                            }
                            var6_10.append(var8_12);
                            continue block15;
                        }
                        case '}': {
                            if (var6_10 == null) ** GOTO lbl59
                            var7_11 = var6_10.toString();
                            var6_10 = null;
                            System.out.println(var7_11);
                            var9_13 = SanDataUtility.p1.matcher(var7_11);
                            if (!var9_13.find()) ** GOTO lbl58
                            var10_14 = var9_13.group(1);
                            var11_15 = var9_13.group(2);
                            System.out.println("key=" + var10_14);
                            System.out.println("type=" + var11_15);
                            if (var2_2 != null) ** GOTO lbl38
                            if (!var1_1.toLowerCase().contains(var10_14.toLowerCase() + ".json")) {
                                throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s, id=%s", new Object[]{var1_1, var10_14}));
                            }
                            if (var11_15.equals("Data")) {
                                var2_2 = new SanData(var10_14);
                                var3_3 = var2_2.clazz;
                            } else {
                                throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s, id=%s, type=%s", new Object[]{var1_1, var10_14, var11_15}));
lbl38:
                                // 1 sources

                                ((SanClassImpl)var3_3).newMemberClass(var10_14, var11_15);
                                var3_3 = (SanClassImpl)var3_3.memberClass(var10_14);
                            }
                            if (var3_3 == null) ** GOTO lbl66
                            var12_16 = var3_3.attrs();
                            var13_17 = var7_11.substring(var9_13.end());
                            var14_18 = null;
                            while (var13_17 != null) {
                                var14_18 = SanDataUtility.p2.matcher(var13_17);
                                if (var14_18.find()) {
                                    var15_19 = var14_18.group(1);
                                    var16_20 = var14_18.group(2);
                                    System.out.println("attrKey=" + var15_19);
                                    System.out.println("attrValue=" + var16_20);
                                    var12_16.put(var15_19, var16_20);
                                    var13_17 = var13_17.substring(var14_18.end());
                                    continue;
                                }
                                var13_17 = null;
                            }
                            ** GOTO lbl66
lbl58:
                            // 1 sources

                            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s, str=%s", new Object[]{var1_1, var7_11}));
lbl59:
                            // 1 sources

                            if (var3_3 != null) {
                                var3_3 = var3_3.parentClass();
                                System.out.println("parentClass=" + var3_3.path());
                                if (var3_3 instanceof SanData) {
                                    System.out.println("JSON End");
                                    ** break;
lbl65:
                                    // 1 sources

                                    break block28;
                                }
                            }
lbl66:
                            // 6 sources

                            var7_11 = null;
                            continue block15;
                        }
                        default: {
                            if (var6_10 == null) continue block15;
                            var6_10.append(var8_12);
                            continue block15;
                        }
                    }
                }
            }
            catch (IOException var5_7) {
                throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", new Object[]{var5_7}));
            }
            catch (NullPointerException var5_8) {
                if (var3_3 == null) {
                    throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", new Object[]{var1_1}), (Throwable)var5_8);
                }
                throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s, analyzeingKey=%s", new Object[]{var1_1, var3_3.path()}), (Throwable)var5_8);
            }
            catch (ClassCastException var5_9) {
                if (var3_3 == null) {
                    throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", new Object[]{var1_1}), (Throwable)var5_9);
                }
                throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s, analyzeingKey=%s", new Object[]{var1_1, var3_3.path()}), (Throwable)var5_9);
            }
            finally {
                try {
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                }
                catch (IOException var18_22) {
                    var18_22.printStackTrace();
                }
            }
        }
        if (var2_2 != null) {
            var2_2.initialize();
            return var2_2;
        }
        return null;
    }

    public static SanInterface readInterfaceFromJSON(File file) throws SanDataException {
        SanInterface sanInterface = null;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader(fileInputStream);
            sanInterface = SanDataUtility.readInterfaceFromJSONCmn(inputStreamReader, file.getName());
        }
        catch (IOException iOException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)iOException);
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                } else if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return sanInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SanInterface readInterfaceFromJSON(InputStream inputStream, String string) throws SanDataException {
        SanInterface sanInterface = null;
        InputStreamReader inputStreamReader = null;
        inputStreamReader = new InputStreamReader(inputStream);
        try {
            sanInterface = SanDataUtility.readInterfaceFromJSONCmn(inputStreamReader, string);
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return sanInterface;
    }

    /*
     * Unable to fully structure code
     */
    public static SanInterface readInterfaceFromJSONCmn(InputStreamReader var0, String var1_1) throws SanDataException {
        block32: {
            var2_2 = null;
            var3_3 = null;
            var4_4 = null;
            var5_5 = null;
            var6_6 = null;
            try {
                var6_6 = new BufferedReader(var0);
                var7_7 = 0;
                var8_12 = null;
                var9_13 = null;
                block15: while ((var7_7 = var6_6.read()) != -1) {
                    var10_14 = (char)var7_7;
                    switch (var10_14) {
                        case ',': 
                        case '{': {
                            if (var8_12 == null) {
                                var8_12 = new StringBuilder(128);
                                continue block15;
                            }
                            var8_12.append(var10_14);
                            continue block15;
                        }
                        case '}': {
                            if (var8_12 == null) ** GOTO lbl86
                            var9_13 = var8_12.toString();
                            var8_12 = null;
                            System.out.println(var9_13);
                            var11_15 = SanDataUtility.p1.matcher(var9_13);
                            if (!var11_15.find()) ** GOTO lbl85
                            var12_16 = var11_15.group(1);
                            var13_17 = var11_15.group(2);
                            System.out.println("key=" + var12_16);
                            System.out.println("type=" + var13_17);
                            if (var2_2 != null) ** GOTO lbl53
                            if (!var1_1.toLowerCase().contains(var12_16.toLowerCase() + ".json")) {
                                throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s, id=%s", new Object[]{var1_1, var12_16}));
                            }
                            if (!var13_17.equals("Interface")) ** GOTO lbl52
                            var2_2 = new SanInterface(var12_16);
                            var14_18 = var9_13.substring(var11_15.end());
                            var15_19 = null;
                            while (var14_18 != null) {
                                var15_19 = SanDataUtility.p2.matcher((CharSequence)var14_18);
                                if (var15_19.find()) {
                                    var16_20 = var15_19.group(1);
                                    var17_21 = var15_19.group(2);
                                    System.out.println("attrKey=" + (String)var16_20);
                                    System.out.println("attrValue=" + var17_21);
                                    var2_2.putAttr((String)var16_20, var17_21);
                                    var14_18 = var14_18.substring(var15_19.end());
                                    continue;
                                }
                                var14_18 = null;
                            }
                            ** GOTO lbl68
lbl52:
                            // 1 sources

                            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s, id=%s, type=%s", new Object[]{var1_1, var12_16, var13_17}));
lbl53:
                            // 1 sources

                            if (var3_3 != null || var4_4 != null) ** GOTO lbl59
                            if (!var12_16.equals("RequestData") || !var13_17.equals("Data")) ** GOTO lbl58
                            var4_4 = var2_2.newRequest();
                            var3_3 = var4_4.clazz;
                            ** GOTO lbl68
lbl58:
                            // 1 sources

                            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("id=%s.RequestData, key=%s, type=%s", new Object[]{var2_2.id(), var12_16, var13_17}));
lbl59:
                            // 1 sources

                            if (var3_3 != null || var4_4 == null) ** GOTO lbl65
                            if (var12_16.equals("ResponseData") && var13_17.equals("Data")) {
                                var5_5 = var2_2.newResponse();
                                var3_3 = var5_5.clazz;
                            } else {
                                throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("id=%s.ResponseData, key=%s, type=%s", new Object[]{var2_2.id(), var12_16, var13_17}));
lbl65:
                                // 1 sources

                                ((SanClassImpl)var3_3).newMemberClass(var12_16, var13_17);
                                var3_3 = (SanClassImpl)var3_3.memberClass(var12_16);
                            }
lbl68:
                            // 4 sources

                            if (var3_3 != null) {
                                var14_18 = var3_3.attrs();
                                var15_19 = var9_13.substring(var11_15.end());
                                var16_20 = null;
                                while (var15_19 != null) {
                                    var16_20 = SanDataUtility.p2.matcher((CharSequence)var15_19);
                                    if (var16_20.find()) {
                                        var17_21 = var16_20.group(1);
                                        var18_22 = var16_20.group(2);
                                        System.out.println("attrKey=" + var17_21);
                                        System.out.println("attrValue=" + var18_22);
                                        var14_18.put(var17_21, var18_22);
                                        var15_19 = var15_19.substring(var16_20.end());
                                        continue;
                                    }
                                    var15_19 = null;
                                }
                            }
                            ** GOTO lbl96
lbl85:
                            // 1 sources

                            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s, str=%s", new Object[]{var1_1, var9_13}));
lbl86:
                            // 1 sources

                            if (var3_3 != null) {
                                var3_3 = var3_3.parentClass();
                                System.out.println("parentClass=" + var3_3.path());
                                if (var3_3 instanceof SanData) {
                                    if (var5_5 != null) {
                                        System.out.println("JSON End");
                                        ** break;
lbl93:
                                        // 1 sources

                                        break block32;
                                    }
                                    System.out.println("RequestData End");
                                    var3_3 = null;
                                }
                            }
lbl96:
                            // 6 sources

                            var9_13 = null;
                            continue block15;
                        }
                        default: {
                            if (var8_12 == null) continue block15;
                            var8_12.append(var10_14);
                            continue block15;
                        }
                    }
                }
            }
            catch (IOException var7_9) {
                throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", new Object[]{var1_1}), (Throwable)var7_9);
            }
            catch (NullPointerException var7_10) {
                if (var3_3 == null) {
                    throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", new Object[]{var1_1}), (Throwable)var7_10);
                }
                throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s, analyzeingKey=%s", new Object[]{var1_1, var3_3.path()}), (Throwable)var7_10);
            }
            catch (ClassCastException var7_11) {
                if (var3_3 == null) {
                    throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", new Object[]{var1_1}), (Throwable)var7_11);
                }
                throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s, analyzeingKey=%s", new Object[]{var1_1, var3_3.path()}), (Throwable)var7_11);
            }
            finally {
                try {
                    if (var6_6 != null) {
                        var6_6.close();
                    }
                }
                catch (IOException var20_24) {
                    var20_24.printStackTrace();
                }
            }
        }
        if (var2_2 != null) {
            var4_4.initialize();
            var5_5.initialize();
            return var2_2;
        }
        return null;
    }

    public static SanData readValueFromJSON(File file, SanData sanData) throws SanDataException {
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            SanDataUtility.readData(file, bufferedReader, sanData);
        }
        catch (IOException iOException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)iOException);
        }
        catch (NullPointerException nullPointerException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)nullPointerException);
        }
        catch (ClassCastException classCastException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)classCastException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                } else if (inputStreamReader != null) {
                    inputStreamReader.close();
                } else if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return sanData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void readData(File file, BufferedReader bufferedReader, SanData sanData) throws SanDataException {
        StringBuilder stringBuilder = null;
        int n = 0;
        try {
            block6: while ((n = bufferedReader.read()) != -1) {
                char c = (char)n;
                switch (c) {
                    case '{': {
                        if (stringBuilder == null) {
                            stringBuilder = new StringBuilder(128);
                            continue block6;
                        }
                        String string = stringBuilder.toString();
                        Pattern pattern = Pattern.compile(String.format("\\s*\"%s\"\\s*:\\s*", sanData.key()));
                        Matcher matcher = pattern.matcher(string);
                        if (!matcher.find()) {
                            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s, str=%s", file.getName(), string));
                        }
                        while (true) {
                            SanClass sanClass;
                            if ((sanClass = SanDataUtility.readMemberKey(file, bufferedReader, (SanObject)sanData)) == null) {
                                stringBuilder = null;
                                continue block6;
                            }
                            if (sanClass.type().equals("Object")) {
                                SanDataUtility.readObj(file, bufferedReader, sanData.newObj(sanClass.key()));
                                continue;
                            }
                            if (sanClass.type().equals("List")) {
                                SanDataUtility.readList(file, bufferedReader, sanData.newList(sanClass.key()));
                                continue;
                            }
                            SanDataUtility.readMemberValue(file, bufferedReader, (SanObject)sanData, sanClass.key());
                        }
                    }
                    case '}': {
                        return;
                    }
                }
                if (stringBuilder == null) continue;
                stringBuilder.append(c);
            }
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()));
        }
        catch (IOException iOException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static SanClass readMemberKey(File file, BufferedReader bufferedReader, SanObject sanObject) throws SanDataException {
        StringBuilder stringBuilder = null;
        int n = 0;
        try {
            block7: while ((n = bufferedReader.read()) != -1) {
                char c = (char)n;
                switch (c) {
                    case '\"': {
                        if (stringBuilder == null) {
                            stringBuilder = new StringBuilder(128);
                        }
                        stringBuilder.append(c);
                        continue block7;
                    }
                    case ':': {
                        String string = stringBuilder.toString();
                        Pattern pattern = Pattern.compile("\"(\\S+)\"\\s*");
                        Matcher matcher = pattern.matcher(string);
                        if (!matcher.find()) throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s, str=%s", file.getName(), string));
                        String string2 = matcher.group(1);
                        return sanObject.memberClass(string2);
                    }
                    case '}': {
                        return null;
                    }
                }
                if (stringBuilder == null) continue;
                stringBuilder.append(c);
            }
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()));
        }
        catch (IOException iOException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void readMemberValue(File file, BufferedReader bufferedReader, SanObject sanObject, String string) throws SanDataException {
        StringBuilder stringBuilder = null;
        int n = 0;
        try {
            block6: while ((n = bufferedReader.read()) != -1) {
                char c = (char)n;
                switch (c) {
                    case '\"': {
                        if (stringBuilder != null) {
                            String string2 = stringBuilder.toString();
                            System.out.println(String.format("objPath=%s, key=%s, value=%s", sanObject.objPath(), string, string2));
                            sanObject.parseAndPutMember(string, string2);
                            return;
                        }
                        stringBuilder = new StringBuilder(128);
                        continue block6;
                    }
                }
                if (stringBuilder == null) continue;
                stringBuilder.append(c);
            }
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()));
        }
        catch (IOException iOException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)iOException);
        }
        catch (SanDataException sanDataException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)sanDataException);
        }
    }

    protected static void readObj(File file, BufferedReader bufferedReader, SanObject sanObject) throws SanDataException {
        int n = 0;
        try {
            while ((n = bufferedReader.read()) != -1) {
                char c = (char)n;
                switch (c) {
                    case '{': {
                        SanClass sanClass;
                        while ((sanClass = SanDataUtility.readMemberKey(file, bufferedReader, sanObject)) != null) {
                            if (sanClass.type().equals("Object")) {
                                SanDataUtility.readObj(file, bufferedReader, sanObject.newObj(sanClass.key()));
                                continue;
                            }
                            if (sanClass.type().equals("List")) {
                                SanDataUtility.readList(file, bufferedReader, sanObject.newList(sanClass.key()));
                                continue;
                            }
                            SanDataUtility.readMemberValue(file, bufferedReader, sanObject, sanClass.key());
                        }
                        return;
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)iOException);
        }
        throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()));
    }

    protected static void readList(File file, BufferedReader bufferedReader, SanList sanList) throws SanDataException {
        int n = 0;
        try {
            while ((n = bufferedReader.read()) != -1) {
                char c = (char)n;
                switch (c) {
                    case '{': {
                        SanObject sanObject;
                        while ((sanObject = SanDataUtility.readElementObj(file, bufferedReader, sanList)) != null) {
                            SanDataUtility.readObj(file, bufferedReader, sanObject);
                        }
                        return;
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)iOException);
        }
        throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static SanObject readElementObj(File file, BufferedReader bufferedReader, SanList sanList) throws SanDataException {
        StringBuilder stringBuilder = null;
        int n = 0;
        try {
            block7: while ((n = bufferedReader.read()) != -1) {
                char c = (char)n;
                switch (c) {
                    case '\"': {
                        if (stringBuilder == null) {
                            stringBuilder = new StringBuilder(128);
                        }
                        stringBuilder.append(c);
                        continue block7;
                    }
                    case ':': {
                        String string = stringBuilder.toString();
                        Pattern pattern = Pattern.compile("\"\\s*\\[\\s*\\d+\\s*\\]\\s*\"\\s*");
                        Matcher matcher = pattern.matcher(string);
                        if (!matcher.find()) throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s, str=%s", file.getName(), string));
                        return sanList.addObj();
                    }
                    case '}': {
                        return null;
                    }
                }
                if (stringBuilder == null) continue;
                stringBuilder.append(c);
            }
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()));
        }
        catch (IOException iOException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)iOException);
        }
    }

    public static void writeValueToJSON(File file, SanData sanData) throws SanDataException {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        if (sanData == null) {
            return;
        }
        try {
            fileOutputStream = new FileOutputStream(file);
            outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            StringBuilder stringBuilder = new StringBuilder(16);
            bufferedWriter.write("{");
            bufferedWriter.newLine();
            stringBuilder.append('\t');
            SanDataUtility.writeDataValue(file, bufferedWriter, sanData, stringBuilder);
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            bufferedWriter.newLine();
            bufferedWriter.write("}");
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)iOException);
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                } else if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                } else if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected static void writeDataValue(File file, BufferedWriter bufferedWriter, SanData sanData, StringBuilder stringBuilder) throws SanDataException {
        try {
            bufferedWriter.write(String.format("%s\"%s\":{", stringBuilder.toString(), sanData.key()));
            stringBuilder.append('\t');
            boolean bl = true;
            for (SanClass sanClass : sanData.memberClassList()) {
                Object object;
                if (sanClass.type().equals("Object")) {
                    object = sanData.getObj(sanClass.key());
                    if (object == null) continue;
                    if (!bl) {
                        bufferedWriter.write(",");
                    }
                    bufferedWriter.newLine();
                    SanDataUtility.writeObjValue(file, bufferedWriter, object, stringBuilder);
                    bl = false;
                    continue;
                }
                if (sanClass.type().equals("List")) {
                    object = sanData.getList(sanClass.key());
                    if (object == null) continue;
                    if (!bl) {
                        bufferedWriter.write(",");
                    }
                    bufferedWriter.newLine();
                    SanDataUtility.writeListValue(file, bufferedWriter, (SanList)object, stringBuilder);
                    bl = false;
                    continue;
                }
                if (!bl) {
                    bufferedWriter.write(",");
                }
                bufferedWriter.newLine();
                object = sanClass.key();
                if (sanData.getMember((String)object) == null) continue;
                String string = sanData.getMemberToString((String)object);
                bufferedWriter.write(String.format("%s\"%s\":\"%s\"", stringBuilder.toString(), object, string));
                bl = false;
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            bufferedWriter.newLine();
            bufferedWriter.write(String.format("%s}", stringBuilder.toString()));
        }
        catch (IOException iOException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)iOException);
        }
    }

    protected static void writeObjValue(File file, BufferedWriter bufferedWriter, SanObject sanObject, StringBuilder stringBuilder) throws SanDataException {
        try {
            bufferedWriter.write(String.format("%s\"%s\":{", stringBuilder.toString(), sanObject.key()));
            stringBuilder.append('\t');
            boolean bl = true;
            for (SanClass sanClass : sanObject.memberClassList()) {
                Object object;
                if (sanClass.type().equals("Object")) {
                    object = sanObject.getObj(sanClass.key());
                    if (object == null) continue;
                    if (!bl) {
                        bufferedWriter.write(",");
                    }
                    bufferedWriter.newLine();
                    SanDataUtility.writeObjValue(file, bufferedWriter, object, stringBuilder);
                    bl = false;
                    continue;
                }
                if (sanClass.type().equals("List")) {
                    object = sanObject.getList(sanClass.key());
                    if (object == null) continue;
                    if (!bl) {
                        bufferedWriter.write(",");
                    }
                    bufferedWriter.newLine();
                    SanDataUtility.writeListValue(file, bufferedWriter, (SanList)object, stringBuilder);
                    bl = false;
                    continue;
                }
                if (!bl) {
                    bufferedWriter.write(",");
                }
                bufferedWriter.newLine();
                object = sanClass.key();
                if (sanObject.getMember((String)object) == null) continue;
                String string = sanObject.getMemberToString((String)object);
                bufferedWriter.write(String.format("%s\"%s\":\"%s\"", stringBuilder.toString(), object, string));
                bl = false;
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            bufferedWriter.newLine();
            bufferedWriter.write(String.format("%s}", stringBuilder.toString()));
        }
        catch (IOException iOException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)iOException);
        }
    }

    protected static void writeListValue(File file, BufferedWriter bufferedWriter, SanList sanList, StringBuilder stringBuilder) throws SanDataException {
        try {
            bufferedWriter.write(String.format("%s\"%s\":{", stringBuilder.toString(), sanList.key()));
            stringBuilder.append('\t');
            boolean bl = true;
            for (int i = 0; i < sanList.size(); ++i) {
                SanObject sanObject = sanList.getObj(i);
                if (sanObject == null) continue;
                if (!bl) {
                    bufferedWriter.write(",");
                }
                bufferedWriter.newLine();
                bufferedWriter.write(String.format("%s\"[%d]\":{", stringBuilder.toString(), i));
                SanDataUtility.writeElementObjValue(file, bufferedWriter, sanList.getObj(i), stringBuilder);
                bufferedWriter.newLine();
                bufferedWriter.write(String.format("%s}", stringBuilder.toString()));
                bl = false;
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            bufferedWriter.newLine();
            bufferedWriter.write(String.format("%s}", stringBuilder.toString()));
        }
        catch (IOException iOException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)iOException);
        }
    }

    protected static void writeElementObjValue(File file, BufferedWriter bufferedWriter, SanObject sanObject, StringBuilder stringBuilder) throws SanDataException {
        try {
            stringBuilder.append('\t');
            boolean bl = true;
            for (SanClass sanClass : sanObject.memberClassList()) {
                Object object;
                if (sanClass.type().equals("Object")) {
                    object = sanObject.getObj(sanClass.key());
                    if (object == null) continue;
                    if (!bl) {
                        bufferedWriter.write(",");
                    }
                    bufferedWriter.newLine();
                    SanDataUtility.writeObjValue(file, bufferedWriter, object, stringBuilder);
                    bl = false;
                    continue;
                }
                if (sanClass.type().equals("List")) {
                    object = sanObject.getList(sanClass.key());
                    if (object == null) continue;
                    if (!bl) {
                        bufferedWriter.write(",");
                    }
                    bufferedWriter.newLine();
                    SanDataUtility.writeListValue(file, bufferedWriter, (SanList)object, stringBuilder);
                    bl = false;
                    continue;
                }
                if (!bl) {
                    bufferedWriter.write(",");
                }
                bufferedWriter.newLine();
                object = sanClass.key();
                if (sanObject.getMember((String)object) == null) continue;
                String string = sanObject.getMemberToString((String)object);
                bufferedWriter.write(String.format("%s\"%s\":\"%s\"", stringBuilder.toString(), object, string));
                bl = false;
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        catch (IOException iOException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", file.getName()), (Throwable)iOException);
        }
    }

    public static String convertToMeaning(int n, int[] nArray, String[] stringArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return stringArray[i];
        }
        return null;
    }

    public static Integer convertToValue(String string, int[] nArray, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return nArray[i];
        }
        return null;
    }

    public static SanData readDataAndValue(String string) throws SanDataException {
        SanData sanData = null;
        try {
            sanData = SanDataUtility.readDataFromJSON(new File(String.format("%s.json", string)));
            SanDataUtility.readValueFromJSON(new File(String.format("%s_value.json", string)), sanData);
        }
        catch (SanDataException sanDataException) {
            throw SanDataErrorCode.newException((SanDataErrorCode)SanDataErrorCode.INVALID_DATA_FILE, (String)String.format("file=%s", string), (Throwable)sanDataException);
        }
        return sanData;
    }
}

