/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.util;

import com.hitachi.sanproject.util.SanProcessUtility;
import java.io.File;
import java.util.logging.Logger;

public enum SanTRLog {
    SUPERVISOR_START(0, 2, "RMI-API Forward Server", "TRRMIS002001", "Initializing", ""),
    SUPERVISOR_START_READY(0, 2, "RMI-API Forward Server", "TRRMIS002002", "Ready", ""),
    SUPERVISOR_START_WARN(0, 1, "RMI-API Forward Server", "TRRMIS002003", "Warning", ""),
    SUPERVISOR_START_FAILED(0, 0, "RMI-API Forward Server", "TRRMIS002004", "Failed", ""),
    SUPERVISOR_FAILED_READ_SETTINGPRO(0, 0, "RMI-API Forward Server", "TRRMIS002005", "Failed : Environment is invalid.", ""),
    SUPERVISOR_FAILED_READ_ENVPRO(0, 0, "RMI-API Forward Server", "TRRMIS002006", "Failed : Environment is invalid.", ""),
    SUPERVISOR_USED_DEFAULT_PUBLIC_PORT(0, 1, "RMI-API Forward Server", "TRRMIS002007", "Warning : Used the default settings. Port=%s", ""),
    SUPERVISOR_PUBLIC_REGISTRY_NULL(0, 1, "RMI-API Forward Server", "TRRMIS002008", "Warning : Port is already in use. Port=%s", ""),
    SUPERVISOR_PRIVATE_REGISTRY_NULL(0, 1, "RMI-API Forward Server", "TRRMIS002009", "Warning : Port is already in use. Port=%s", ""),
    SUPERVISOR_PUBLIC_ROBJ_NULL(0, 1, "RMI-API Forward Server", "TRRMIS002010", "Warning : Port is already in use. Port=%s", ""),
    SUPERVISOR_PRIVATE_ROBJ_NULL(0, 1, "RMI-API Forward Server", "TRRMIS002011", "Warning : Port is already in use. Port=%s", ""),
    SUPERVISOR_STOPPING(0, 2, "RMI-API Forward Server", "TRRMIS002012", "Stopping", ""),
    SUPERVISOR_STOPPED(0, 2, "RMI-API Forward Server", "TRRMIS002013", "Stopped", ""),
    SUPERVISOR_PUBLIC_REGISTRY_SSLERR(0, 1, "RMI-API Forward Server", "TRRMIS002014", "Warning : SSL settings are invalid.", ""),
    SUPERVISOR_PUBLIC_ROBJ_SSLERR(0, 1, "RMI-API Forward Server", "TRRMIS002015", "Warning : SSL settings are invalid.", ""),
    DKC_START(1, 2, "RMI-API Server", "TRRMIS002501", "Initializing", "rmiserver"),
    DKC_START_READY(1, 2, "RMI-API Server", "TRRMIS002502", "Ready", "rmiserver"),
    DKC_START_WARN(1, 1, "RMI-API Server", "TRRMIS002503", "Warning", ""),
    DKC_START_FAILED(1, 0, "RMI-API Server", "TRRMIS002504", "Failed", ""),
    DKC_FAILED_READ_DKCPRO(1, 0, "RMI-API Server", "TRRMIS002505", "Failed : Environment is invalid.", "rmiserver"),
    DKC_FAILED_READ_SETTINGPRO(1, 0, "RMI-API Server", "TRRMIS002506", "Failed : Environment is invalid.", "rmiserver"),
    DKC_FAILED_READ_ENVPRO(1, 0, "RMI-API Server", "TRRMIS002507", "Failed : Environment is invalid.", "rmiserver"),
    DKC_PRIVATE_REGISTRY_NULL(1, 0, "RMI-API Server", "TRRMIS002508", "Failed : Port is already in use. Port=%s", "rmiserver"),
    DKC_PRIVATE_ROBJ_NULL(1, 0, "RMI-API Server", "TRRMIS002509", "Failed : Port is already in use. Port=%s", "rmiserver"),
    DKC_STOPPING(1, 2, "RMI-API Server", "TRRMIS002510", "Stopping", "rmiserver"),
    DKC_STOPPED(1, 2, "RMI-API Server", "TRRMIS002511", "Stopped", "rmiserver"),
    SUPERVISOR_DKC_PROCESS_DOWN(1, 0, "RMI-API Server", "TRRMIS002512", "Failed : Failed to connect to RMI.", ""),
    DKC_FAILED_PROCESS_DOWN(1, 0, "RMI-API Server", "TRRMIS002513", "Failed : The service has been terminated forcibly.", "rmiserver"),
    DKC_FAILED_RMICONNECT_ERROR(1, 0, "RMI-API Server", "TRRMIS002514", "Failed : Failed to connect to RMI.", "rmiserver"),
    DKC_STOPPED_ERROR(1, 0, "RMI-API Server", "TRRMIS002515", "Stopped : The service has been terminated abnormally.", "rmiserver");

    public static final int LOGLEVEL_ERROR = 0;
    public static final int LOGLEVEL_WARN = 1;
    public static final int LOGLEVEL_INFO = 2;
    public static final int MODE_SUPERVISOR = 0;
    public static final int MODE_DKC = 1;
    public static final String TRLOGOPEBAT_PATH_SUPERVISOR;
    public static final String TRLOGOPEBAT_PATH_DKC;
    public static final String TRLOGOPEBAT_PATH_SUPERVISOR_TO_DKC;
    public static final String TRLOGOPEBAT_FILENAME = "TroubleshootLogOperation.bat";
    private int mode;
    private int logLevel;
    private String appname;
    private String code;
    private String message;
    private String moduleId;

    private SanTRLog(int n2, int n3, String string2, String string3, String string4, String string5) {
        this.mode = n2;
        this.logLevel = n3;
        this.appname = string2;
        this.code = string3;
        this.message = string4;
        this.moduleId = string5;
    }

    public static void write(Logger logger, SanTRLog sanTRLog, Object ... objectArray) {
        String string = "";
        string = sanTRLog.mode == 0 ? TRLOGOPEBAT_PATH_SUPERVISOR + TRLOGOPEBAT_FILENAME : TRLOGOPEBAT_PATH_DKC + TRLOGOPEBAT_FILENAME;
        SanProcessUtility.execCmd(logger, string, Integer.toString(sanTRLog.logLevel), sanTRLog.appname, sanTRLog.code, "\"" + String.format(sanTRLog.message, objectArray) + "\"", sanTRLog.moduleId);
    }

    public static void writeDKC(Logger logger, SanTRLog sanTRLog, String string, Object ... objectArray) {
        String string2 = "";
        string2 = sanTRLog.mode == 0 ? TRLOGOPEBAT_PATH_SUPERVISOR + TRLOGOPEBAT_FILENAME : (string != "" ? String.format(TRLOGOPEBAT_PATH_SUPERVISOR_TO_DKC, string) + TRLOGOPEBAT_FILENAME : TRLOGOPEBAT_PATH_DKC + TRLOGOPEBAT_FILENAME);
        SanProcessUtility.execCmd(logger, string2, Integer.toString(sanTRLog.logLevel), sanTRLog.appname, sanTRLog.code, "\"" + String.format(sanTRLog.message, objectArray) + "\"", sanTRLog.moduleId);
    }

    static {
        TRLOGOPEBAT_PATH_SUPERVISOR = ".." + File.separator + "TRLog" + File.separator + "bat" + File.separator;
        TRLOGOPEBAT_PATH_DKC = ".." + File.separator + "DKC200" + File.separator + "mp" + File.separator + "pc" + File.separator;
        TRLOGOPEBAT_PATH_SUPERVISOR_TO_DKC = ".." + File.separator + ".." + File.separator + "%s" + File.separator + "DKC200" + File.separator + "mp" + File.separator + "pc" + File.separator;
    }
}

