/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.data;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeMap;
import sanproject.common.Robj_interface_CVAEInfo;
import sanproject.common.Robj_interface_DelCVAEInfo;
import sanproject.serverux.data.AClassWithNativeMethods;
import sanproject.serverux.data.JNIException;
import sanproject.serverux.data.RmiObjImpl;
import sanproject.serverux.data.RmiReturnObject;
import sanproject.serverux.data.StringControl;
import sanproject.serverux.data.common_FileAccessor;
import sanproject.serverux.dataimpl.CVAEInfo;

public class CVAEFileAccess
extends common_FileAccessor {
    public static final Object LOCK = new Object();
    static final String FILE_DIR = "..\\..\\config\\";
    static final String FILE = "Ctrack_CVAEInfo.txt";
    public static final String FILENAME = "..\\..\\config\\Ctrack_CVAEInfo.txt";
    public static final String CVAE_DELIMITER = "\t";
    public static final String CVAE_LICENSE_DELIMITER = ",";
    public static final String MODE_ALL = "";
    private static final int LINE_ELEMENT_MIN = 10;
    private static final int POSITION_ID = 0;
    private static final int POSITION_PRODUCT = 1;
    private static final int POSITION_VERSION = 2;
    private static final int POSITION_IPADDRES = 3;
    private static final int POSITION_LICENSE = 4;
    private static final int POSITION_REGISTRY_TIME = 5;
    private static final int POSITION_REGISTRY_STRING = 6;
    private static final int POSITION_LAST_TIME = 7;
    private static final int POSITION_LAST_STRING = 8;
    private static final int POSITION_MEMO = 9;
    public static final int ENTRY_MAX = 1024;
    public static final int CHAR_MAX_ID = 256;
    public static final int CHAR_MAX_PRODUCT = 256;
    public static final int CHAR_MAX_VERSION = 256;
    public static final int CHAR_MAX_IPADDRES = 1024;
    public static final int CHAR_MAX_LICENSE = 1024;
    public static final int CHAR_MAX_MEMO = 4096;
    private static final int ARRAY_LICENSE = 32;
    protected static final int ON_DELETE = 1;
    protected static final int OFF_DELETE = 0;
    private static final int KIND_CHG = 1;
    private static final int KIND_DEL = 2;
    static final String ADT_FC_OK = "Normal end";
    static final String ADT_FC_ERR = "Error";
    RmiObjImpl rmiobj;

    public CVAEFileAccess(RmiObjImpl rmiObjImpl) {
        this.rmiobj = rmiObjImpl;
    }

    public CVAEFileAccess(Object object) throws JNIException {
        super(object, FILENAME);
    }

    public Object accessFileStart(Object object) throws JNIException {
        return this.accessFileRetryer(object, FILENAME);
    }

    protected Object manage(Object object, String string) throws JNIException, IOException {
        System.out.println("manage Start" + object);
        Object object2 = null;
        String string2 = MODE_ALL;
        if (object == null) {
            throw this.newException("CVAEInfo NoData.", 65734);
        }
        if (object instanceof String) {
            object2 = this.getCVAEInfoList();
        } else {
            if (object instanceof Robj_interface_CVAEInfo) {
                try {
                    System.out.println("Set CVAEInfo Start");
                    object2 = this.entryCVAEInfo((Robj_interface_CVAEInfo)object);
                    this.AdtCVAEInfo(this.rmiobj.strUserName, 1, "Normal end/" + this.rmiobj.info.IPAddress, object);
                    System.out.println("Set CVAEInfo Start Normal End");
                }
                catch (JNIException jNIException) {
                    string2 = "Error(" + jNIException.nErrCode + "-" + jNIException.nErrData + ")";
                    System.out.println("Set CVAEInfo Err End:" + string2);
                    this.AdtCVAEInfo(this.rmiobj.strRegBindName, 1, string2, object);
                    throw this.newException(jNIException.getMessage(), jNIException.nErrData);
                }
            }
            if (object instanceof Robj_interface_DelCVAEInfo) {
                try {
                    System.out.println("Del CVAEInfo Start");
                    object2 = this.delCVAEInfo((Robj_interface_DelCVAEInfo)object);
                    this.AdtCVAEInfo(this.rmiobj.strUserName, 2, "Normal end/" + this.rmiobj.info.IPAddress, object);
                    System.out.println("Del CVAEInfo Start Normal End");
                }
                catch (JNIException jNIException) {
                    string2 = "Error(" + jNIException.nErrCode + "-" + jNIException.nErrData + ")";
                    System.out.println("Del CVAEInfo Err End:" + string2);
                    this.AdtCVAEInfo(this.rmiobj.strRegBindName, 2, string2, object);
                    throw this.newException(jNIException.getMessage(), jNIException.nErrData);
                }
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getCVAEInfoList() throws JNIException {
        Object object = LOCK;
        synchronized (object) {
            Robj_interface_CVAEInfo[] robj_interface_CVAEInfoArray = null;
            String[] stringArray = this.getLineArrayWithoutClose();
            ArrayList<CVAEInfo> arrayList = new ArrayList<CVAEInfo>();
            while (stringArray != null) {
                if (stringArray.length < 10) {
                    throw this.newException("File fomat error", 5560);
                }
                CVAEInfo cVAEInfo = this.changeLineToCVAEInfo(stringArray);
                arrayList.add(cVAEInfo);
                stringArray = this.getLineArrayWithoutClose();
            }
            int n = arrayList.size();
            Robj_interface_CVAEInfo[] robj_interface_CVAEInfoArray2 = new Robj_interface_CVAEInfo[n];
            for (int i = 0; i < n; ++i) {
                robj_interface_CVAEInfoArray2[i] = (CVAEInfo)arrayList.get(i);
            }
            robj_interface_CVAEInfoArray = robj_interface_CVAEInfoArray2;
            return robj_interface_CVAEInfoArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object entryCVAEInfo(Robj_interface_CVAEInfo robj_interface_CVAEInfo) throws JNIException, IOException {
        Object object = LOCK;
        synchronized (object) {
            boolean bl = false;
            TreeMap treeMap = this.makeHash(this.getCVAEInfoList());
            super.closeFile();
            treeMap = this.checkID(robj_interface_CVAEInfo.getID(), treeMap) ? this.updateTarget(treeMap, robj_interface_CVAEInfo) : this.addTarget(treeMap, robj_interface_CVAEInfo);
            this.makeFile(treeMap);
        }
        return new RmiReturnObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object delCVAEInfo(Robj_interface_DelCVAEInfo robj_interface_DelCVAEInfo) throws JNIException, IOException {
        Object object = LOCK;
        synchronized (object) {
            boolean bl = false;
            TreeMap treeMap = this.makeHash(this.getCVAEInfoList());
            super.closeFile();
            String[] stringArray = robj_interface_DelCVAEInfo.getID();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.checkID(stringArray[i], treeMap)) {
                    throw this.newException("delCVAEInfo No ID:" + stringArray[i], 65734);
                }
                treeMap.remove(stringArray[i]);
            }
            this.makeFile(treeMap);
        }
        return new RmiReturnObject();
    }

    private boolean checkID(String string, TreeMap treeMap) throws JNIException {
        boolean bl = false;
        if (string == null) {
            throw this.newException("strID null", 65734);
        }
        if (string.equals(MODE_ALL)) {
            throw this.newException("strID empty", 65734);
        }
        bl = treeMap.containsKey(string);
        return bl;
    }

    protected CVAEInfo changeLineToCVAEInfo(String[] stringArray) {
        CVAEInfo cVAEInfo = new CVAEInfo();
        cVAEInfo.setID(stringArray[0]);
        cVAEInfo.setProductName(stringArray[1]);
        cVAEInfo.setVersionInfo(stringArray[2]);
        cVAEInfo.setIPAddress(stringArray[3]);
        String[] stringArray2 = StringControl.getStringArrayFromLine(stringArray[4], CVAE_LICENSE_DELIMITER);
        int n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].length() <= 0) continue;
            ++n;
        }
        String[] stringArray3 = new String[n];
        int n2 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].length() <= 0) continue;
            stringArray3[n2++] = stringArray2[i];
        }
        cVAEInfo.setLicenseInfo(stringArray3);
        cVAEInfo.setRegistryDate(Integer.parseInt(stringArray[5]));
        cVAEInfo.setLastAccessDate(Integer.parseInt(stringArray[7]));
        cVAEInfo.setMemoRandom(stringArray[9]);
        return cVAEInfo;
    }

    protected String changeCVAEInfoToLine(CVAEInfo cVAEInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.cutMaxString(cVAEInfo.getID(), 256) + CVAE_DELIMITER);
        stringBuffer.append(this.cutMaxString(cVAEInfo.getProductName(), 256) + CVAE_DELIMITER);
        stringBuffer.append(this.cutMaxString(cVAEInfo.getVersionInfo(), 256) + CVAE_DELIMITER);
        stringBuffer.append(this.cutMaxString(cVAEInfo.getIPAddress(), 1024) + CVAE_DELIMITER);
        String[] stringArray = cVAEInfo.getLicenseInfo();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < 32; ++i) {
            if (i > 0) {
                stringBuffer.append(CVAE_LICENSE_DELIMITER);
            }
            if (i >= stringArray.length) continue;
            stringBuffer.append(this.cutMaxString(stringArray[i], 1024));
        }
        stringBuffer.append(CVAE_DELIMITER);
        stringBuffer.append(cVAEInfo.getRegistryTimeStamp() + CVAE_DELIMITER);
        stringBuffer.append(cVAEInfo.getRegistryDate() + CVAE_DELIMITER);
        stringBuffer.append(cVAEInfo.getLastAccessTimeStamp() + CVAE_DELIMITER);
        stringBuffer.append(cVAEInfo.getLastAccessDate() + CVAE_DELIMITER);
        stringBuffer.append(this.cutMaxString(cVAEInfo.getMemoRandom(), 4096) + StringControl.LN_SEP);
        return stringBuffer.toString();
    }

    private TreeMap updateTarget(TreeMap treeMap, Robj_interface_CVAEInfo robj_interface_CVAEInfo) {
        CVAEInfo cVAEInfo = (CVAEInfo)treeMap.get(robj_interface_CVAEInfo.getID());
        cVAEInfo.setID(this.cutMaxString(robj_interface_CVAEInfo.getID(), 256));
        cVAEInfo.setProductName(this.cutMaxString(robj_interface_CVAEInfo.getProductName(), 256));
        cVAEInfo.setVersionInfo(this.cutMaxString(robj_interface_CVAEInfo.getVersionInfo(), 256));
        cVAEInfo.setIPAddress(this.cutMaxString(robj_interface_CVAEInfo.getIPAddress(), 1024));
        cVAEInfo.setLicenseInfo(robj_interface_CVAEInfo.getLicenseInfo());
        cVAEInfo.setRegistryDate(robj_interface_CVAEInfo.getRegistryTimeStamp());
        cVAEInfo.setLastAccessDate(robj_interface_CVAEInfo.getLastAccessTimeStamp());
        cVAEInfo.setMemoRandom(this.cutMaxString(robj_interface_CVAEInfo.getMemoRandom(), 4096));
        return treeMap;
    }

    private TreeMap addTarget(TreeMap treeMap, Robj_interface_CVAEInfo robj_interface_CVAEInfo) throws JNIException {
        if (treeMap.size() >= 1024) {
            throw this.newException("Entry count Max", 66802);
        }
        treeMap.put(robj_interface_CVAEInfo.getID(), robj_interface_CVAEInfo);
        return treeMap;
    }

    private TreeMap makeHash(Object object) throws JNIException {
        TreeMap<String, Robj_interface_CVAEInfo> treeMap = new TreeMap<String, Robj_interface_CVAEInfo>();
        Robj_interface_CVAEInfo[] robj_interface_CVAEInfoArray = null;
        if (object instanceof Robj_interface_CVAEInfo[]) {
            robj_interface_CVAEInfoArray = (Robj_interface_CVAEInfo[])object;
            for (int i = robj_interface_CVAEInfoArray.length - 1; i >= 0; --i) {
                treeMap.put(robj_interface_CVAEInfoArray[i].getID(), robj_interface_CVAEInfoArray[i]);
            }
        } else {
            throw this.newException("makeHash() unexpected class:" + object.getClass(), 2005);
        }
        return treeMap;
    }

    protected void createFile(int n, String string) throws JNIException {
        boolean bl = false;
        int n2 = 4;
        for (int i = 0; i < n2; ++i) {
            try {
                File file = new File(string);
                if (n == 1) {
                    file.delete();
                }
                if (!file.createNewFile()) continue;
                bl = true;
                break;
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
                if (i < 3) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                throw this.newException("createFile() FileAccessError", 4001);
            }
        }
        if (!bl) {
            throw this.newException("createFile() FileAccessError", 4001);
        }
    }

    private void makeFile(TreeMap treeMap) throws JNIException, IOException {
        this.createFile(1, FILENAME);
        super.openFile(FILENAME);
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = treeMap.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof CVAEInfo)) continue;
            stringBuffer.append(this.changeCVAEInfoToLine((CVAEInfo)objectArray[i]));
        }
        this.putOneLineWithoutClose(stringBuffer.toString());
    }

    private void AdtCVAEInfo(String string, int n, String string2, Object object) throws JNIException {
        AClassWithNativeMethods aClassWithNativeMethods = new AClassWithNativeMethods();
        System.out.println("AdtCVAEInfo(" + string + CVAE_LICENSE_DELIMITER + n + CVAE_LICENSE_DELIMITER + string2 + ")");
        try {
            int n2 = aClassWithNativeMethods.adtCVAEInfo(string, n, string2, object);
            if (n2 != 1) {
                System.out.println("CVAEInfo AuditLog=False," + n2);
                throw this.newException("CVAEInfo AuditLog=False," + n2, 4011);
            }
            System.out.println("CVAEInfo AuditLog=True");
        }
        catch (JNIException jNIException) {
            int n3 = jNIException.getErrCode();
            int n4 = jNIException.getErrData();
            System.out.println("AuditLog=False," + n3 + CVAE_LICENSE_DELIMITER + n4);
            throw this.newException("AuditLog=False," + n3, n4);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            throw this.newException("AuditLog=False,", 4011);
        }
    }

    private String cutMaxString(String string, int n) {
        if (string == null) {
            return MODE_ALL;
        }
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public String[] getLineArrayWithoutClose() throws JNIException {
        return CVAEFileAccess.getStringArrayFromLine(this.getLineWithoutClose(), CVAE_DELIMITER);
    }

    public static String[] getStringArrayFromLine(String string, String string2) {
        String[] stringArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
            String string3 = MODE_ALL;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string3.equals(string2) && string4.equals(string2)) {
                    arrayList.add(new String(MODE_ALL));
                } else if (!string4.equals(string2)) {
                    arrayList.add(string4);
                }
                string3 = string4;
            }
            if (string3.equals(string2)) {
                arrayList.add(new String(MODE_ALL));
            }
            stringArray = new String[arrayList.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
        }
        return stringArray;
    }

    public void putOneLineWithoutClose(String string) throws JNIException {
        try {
            if (this.getFile() != null) {
                this.getFile().write(string.getBytes("SJIS"));
            }
        }
        catch (IOException iOException) {
            throw this.newException("putOneLineWithoutClose() Failed ", 6023);
        }
    }

    public String getLineWithoutClose() throws JNIException {
        String string = null;
        try {
            if (this.getFile() != null) {
                byte by;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((by = this.getFile().readByte()) != 10) {
                    if (by == 13) continue;
                    byteArrayOutputStream.write(by);
                }
                string = new String(byteArrayOutputStream.toByteArray());
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            throw this.newException("getLine() Failed ", 6023);
        }
        return string;
    }
}

