/*
 * Decompiled with CFR 0.152.
 */
package com.ws.logging;

import com.ws.wbem.jserver.JServerTraceProperties;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Calendar;

public final class FailSafeLog {
    static final String newLine = System.getProperty("line.separator", "\r\n");
    static String fileName;

    public static void failSafe(String message, Object ... args) {
        FailSafeLog.failSafe(message, null, args);
    }

    public static synchronized void failSafe(String message, Throwable t, Object ... args) {
        try (FileOutputStream f = FailSafeLog.getFileStream();
             PrintStream ps = new PrintStream(f);){
            FailSafeLog.printTimeStamp(ps);
            if (null == message && null == t) {
                Exception e = new Exception("failSafe(Throwable) called with no data!");
                e.printStackTrace(ps);
            } else {
                if (null != message) {
                    ps.format(message, args);
                    ps.print(newLine);
                }
                if (null != t) {
                    t.printStackTrace(ps);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void failSafe(Throwable e) {
        FailSafeLog.failSafe(null, e, new Object[0]);
    }

    private static final FileOutputStream getFileStream() throws FileNotFoundException {
        return new FileOutputStream(fileName, false);
    }

    private static void printTimeStamp(PrintStream ps) {
        if (null == ps) {
            throw new NullPointerException("PrintStream can not be null");
        }
        Calendar rightNow = Calendar.getInstance();
        ps.format("%1$tm/%1$te/%1$tY %1$tH:%1$tM:%1$tS.%1$tL", rightNow);
        ps.print(newLine);
    }

    private FailSafeLog() {
    }

    static {
        StringBuilder file = new StringBuilder(JServerTraceProperties.getLogFileDirectory());
        file.append(System.getProperty("file.separator"));
        file.append(FailSafeLog.class.getSimpleName());
        file.append(".err");
        fileName = file.toString();
    }
}

