/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import com.ws.cim.mof.MOFStyle;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.cim.CIMDateTime;
import javax.cim.Messages;

public class CIMDateTimeAbsolute
extends CIMDateTime
implements Serializable {
    private static final String STAR4 = "****";
    private static final String _01 = "01";
    private static final String STAR2 = "**";
    private static final long serialVersionUID = 7556792806296945178L;
    private int mMicrosecond;
    private int mSecond;
    private int mMinute;
    private int mHour;
    private int mDay;
    private int mMonth;
    private int mYear;
    private String mDateTimeString = null;

    public CIMDateTimeAbsolute() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        this.mDateTimeString = this.getCalendarString(cal);
        try {
            this.setIntFieldValues(this.mDateTimeString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public CIMDateTimeAbsolute(Calendar calendar) throws IllegalArgumentException {
        if (calendar == null) {
            throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.4"));
        }
        this.mDateTimeString = this.getCalendarString(calendar);
        try {
            this.setIntFieldValues(this.mDateTimeString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public CIMDateTimeAbsolute(String dateTime) throws IllegalArgumentException {
        if (null == dateTime) {
            throw new IllegalArgumentException("dateTime can not be null");
        }
        if (dateTime.startsWith("\"") && dateTime.endsWith("\"")) {
            dateTime = dateTime.substring(1, dateTime.length() - 1);
        }
        if (dateTime.length() != 25 || dateTime.charAt(14) != '.' || dateTime.charAt(21) != '+' && dateTime.charAt(21) != '-') {
            throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.1") + dateTime);
        }
        if (this.getUTCOffsetString(dateTime).indexOf(42) >= 0) {
            throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.5") + dateTime);
        }
        this.mDateTimeString = dateTime;
        StringBuilder dateTimeBuffer = new StringBuilder(dateTime);
        boolean insignificant = false;
        String msString = this.getMicrosecondString(dateTime);
        if (msString.equals("******")) {
            this.mMicrosecond = -1;
            insignificant = true;
        } else {
            if (msString.indexOf(42) >= 0) {
                while (msString.endsWith("*")) {
                    msString = msString.substring(0, msString.length() - 1);
                }
                msString = this.padLeadingZeros(msString, 6);
            }
            try {
                this.mMicrosecond = Integer.parseInt(msString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.6") + dateTime);
            }
        }
        String secString = this.getSecondString(dateTime);
        if (secString.equals(STAR2)) {
            this.mSecond = -1;
            if (!insignificant) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.13"));
            }
            dateTimeBuffer.replace(12, 14, _01);
        } else {
            insignificant = false;
            try {
                this.mSecond = Integer.parseInt(secString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.7") + dateTime);
            }
        }
        String minString = this.getMinuteString(dateTime);
        if (minString.equals(STAR2)) {
            this.mMinute = -1;
            if (!insignificant) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.15"));
            }
            dateTimeBuffer.replace(10, 12, _01);
        } else {
            insignificant = false;
            try {
                this.mMinute = Integer.parseInt(minString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.8") + dateTime);
            }
        }
        String hourString = this.getHourString(dateTime);
        if (hourString.equals(STAR2)) {
            this.mHour = -1;
            if (!insignificant) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.17"));
            }
            dateTimeBuffer.replace(8, 10, _01);
        } else {
            insignificant = false;
            try {
                this.mHour = Integer.parseInt(hourString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.9") + dateTime);
            }
        }
        String dayString = this.getDayString(dateTime);
        if (dayString.equals(STAR2)) {
            this.mDay = -1;
            if (!insignificant) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.19"));
            }
            dateTimeBuffer.replace(6, 8, _01);
        } else {
            insignificant = false;
            try {
                this.mDay = Integer.parseInt(dayString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.10") + dateTime);
            }
        }
        String monthString = this.getMonthString(dateTime);
        if (monthString.equals(STAR2)) {
            this.mMonth = -1;
            if (!insignificant) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.21"));
            }
            dateTimeBuffer.replace(4, 6, _01);
        } else {
            insignificant = false;
            try {
                this.mMonth = Integer.parseInt(monthString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.11") + dateTime);
            }
        }
        String yearString = this.getYearString(dateTime);
        if (yearString.equals(STAR4)) {
            this.mYear = -1;
            if (!insignificant) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.23"));
            }
            dateTimeBuffer.replace(0, 4, "2000");
        } else {
            try {
                this.mYear = Integer.parseInt(yearString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.12") + dateTime);
            }
        }
        this.getCalendar(dateTimeBuffer.toString());
    }

    @Override
    public int compareTo(CIMDateTime dateTime) throws IllegalArgumentException {
        int ret = 0;
        if (!(dateTime instanceof CIMDateTimeAbsolute)) {
            throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.0"));
        }
        CIMDateTimeAbsolute when = (CIMDateTimeAbsolute)dateTime;
        Calendar thisCalendar = this.getCalendar();
        Calendar whenCalendar = when.getCalendar();
        if (when.getDateTimeString().indexOf(42) >= 0 || this.mDateTimeString.indexOf(42) >= 0) {
            if (this.getMicrosecond() == -1 || when.getMicrosecond() == -1) {
                thisCalendar.clear(14);
                whenCalendar.clear(14);
            } else {
                String thisMilliseconds = this.mDateTimeString.substring(15, 18);
                String whenMilliseconds = when.getDateTimeString().substring(15, 18);
                int thisIndex = thisMilliseconds.indexOf(42);
                int whenIndex = whenMilliseconds.indexOf(42);
                if (thisIndex > 0 || whenIndex > 0) {
                    int minIndex = thisIndex < whenIndex ? thisIndex : whenIndex;
                    thisMilliseconds = this.padTrailingZeros(thisMilliseconds.substring(0, minIndex), 3);
                    whenMilliseconds = this.padTrailingZeros(whenMilliseconds.substring(0, minIndex), 3);
                    thisCalendar.set(14, Integer.parseInt(thisMilliseconds));
                    whenCalendar.set(14, Integer.parseInt(whenMilliseconds));
                }
            }
            if (this.getSecond() == -1 || when.getSecond() == -1) {
                thisCalendar.clear(13);
                whenCalendar.clear(13);
                if (this.getMinute() == -1 || when.getMinute() == -1) {
                    thisCalendar.clear(12);
                    whenCalendar.clear(12);
                    if (this.getHour() == -1 || when.getHour() == -1) {
                        thisCalendar.clear(10);
                        whenCalendar.clear(10);
                        if (this.getDay() == -1 || when.getDay() == -1) {
                            thisCalendar.clear(5);
                            whenCalendar.clear(5);
                            if (this.getMonth() == -1 || when.getMonth() == -1) {
                                thisCalendar.clear(2);
                                whenCalendar.clear(2);
                                if (this.getYear() == -1 || when.getYear() == -1) {
                                    thisCalendar.clear(1);
                                    whenCalendar.clear(1);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (thisCalendar.after(whenCalendar)) {
            ret = 1;
        } else if (thisCalendar.before(when.getCalendar())) {
            ret = -1;
        } else if (this.getMicrosecond() > when.getMicrosecond()) {
            ret = 1;
        } else if (this.getMicrosecond() < when.getMicrosecond()) {
            ret = -1;
        }
        return ret;
    }

    @Override
    public boolean equals(Object dateTime) {
        if (dateTime instanceof CIMDateTimeAbsolute) {
            return super.equals(dateTime);
        }
        return false;
    }

    protected Calendar getCalendar() throws IllegalArgumentException {
        return this.getCalendar(this.mDateTimeString);
    }

    private Calendar getCalendar(String dateString) throws IllegalArgumentException {
        Calendar retCal = null;
        if (dateString == null) {
            return null;
        }
        int STAR1 = 42;
        int asteriskIndex = dateString.indexOf(42);
        if (asteriskIndex > 0 && asteriskIndex < 19 || this.getUTCOffsetString(dateString).indexOf(42) >= 0) {
            throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.2") + Messages.getString("CIMDateTimeAbsolute.3"));
        }
        try {
            Integer.parseInt(dateString.substring(15, 21));
            retCal = Calendar.getInstance();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
            formatter.setLenient(false);
            Date date = formatter.parse(dateString.substring(0, 18));
            retCal.setTime(date);
            int offset = Integer.parseInt(dateString.substring(22)) * 60000;
            if (dateString.charAt(21) == '-') {
                offset *= -1;
            }
            retCal.set(15, offset);
            retCal.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(dateString + " " + e);
        }
        return retCal;
    }

    private String getCalendarString(Calendar c) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.padLeadingZeros(c.get(1), 4));
        buf.append(this.padLeadingZeros(c.get(2) + 1, 2));
        buf.append(this.padLeadingZeros(c.get(5), 2));
        buf.append(this.padLeadingZeros(c.get(11), 2));
        buf.append(this.padLeadingZeros(c.get(12), 2));
        buf.append(this.padLeadingZeros(c.get(13), 2));
        buf.append(".");
        buf.append(this.padTrailingZeros(this.padLeadingZeros(c.get(14), 3), 6));
        int offset = c.get(15);
        if (offset < 0) {
            buf.append("-");
        } else {
            buf.append("+");
        }
        buf.append(this.padLeadingZeros(Math.abs(offset / 60000), 3));
        String calString = buf.toString();
        return calString;
    }

    @Override
    public String getDateTimeString() {
        return this.mDateTimeString;
    }

    public int getDay() {
        return this.mDay;
    }

    private String getDayString(String dateTime) {
        return dateTime.substring(6, 8);
    }

    public int getHour() {
        return this.mHour;
    }

    private String getHourString(String dateTime) {
        return dateTime.substring(8, 10);
    }

    public int getMicrosecond() {
        return this.mMicrosecond;
    }

    private String getMicrosecondString(String dateTime) {
        return dateTime.substring(15, 21);
    }

    public int getMinute() {
        return this.mMinute;
    }

    private String getMinuteString(String dateTime) {
        return dateTime.substring(10, 12);
    }

    public int getMonth() {
        return this.mMonth;
    }

    private String getMonthString(String dateTime) {
        return dateTime.substring(4, 6);
    }

    public int getSecond() {
        return this.mSecond;
    }

    private String getSecondString(String dateTime) {
        return dateTime.substring(12, 14);
    }

    public int getUTCOffset() {
        try {
            return Integer.parseInt(this.mDateTimeString.substring(22));
        }
        catch (Exception e) {
            return -1;
        }
    }

    private String getUTCOffsetString(String dateTime) {
        return dateTime.substring(22);
    }

    public int getYear() {
        return this.mYear;
    }

    private String getYearString(String dateTime) {
        return dateTime.substring(0, 4);
    }

    @Override
    public int hashCode() {
        return this.mDateTimeString.hashCode();
    }

    private void setIntFieldValues(String dateTime) throws IllegalArgumentException {
        try {
            this.mYear = Integer.parseInt(this.getYearString(dateTime));
            this.mMonth = Integer.parseInt(this.getMonthString(dateTime));
            this.mDay = Integer.parseInt(this.getDayString(dateTime));
            this.mHour = Integer.parseInt(this.getHourString(dateTime));
            this.mMinute = Integer.parseInt(this.getMinuteString(dateTime));
            this.mSecond = Integer.parseInt(this.getSecondString(dateTime));
            this.mMicrosecond = Integer.parseInt(this.getMicrosecondString(dateTime));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(Messages.getString("CIMDateTimeAbsolute.1"));
        }
    }

    public String toString() {
        MOFStyle mf = new MOFStyle();
        return mf.generateMOF(this);
    }
}

