/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import com.ws.cim.mof.MOFStyle;
import java.io.Serializable;
import java.util.Arrays;
import javax.cim.CIMDataType;
import javax.cim.CIMQualifiedElementInterface;
import javax.cim.CIMQualifier;
import javax.cim.CIMTypedElement;
import javax.cim.SharedMethods;

public class CIMParameter<E>
extends CIMTypedElement<E>
implements CIMQualifiedElementInterface,
Serializable {
    private static final long serialVersionUID = -599745518235491344L;
    private final CIMQualifier<?>[] mQualifiers;

    public CIMParameter(String name, CIMDataType type, CIMQualifier<?>[] qualifiers) {
        super(name, type);
        this.mQualifiers = qualifiers != null ? qualifiers : new CIMQualifier[]{};
    }

    @Override
    public boolean equals(Object object) {
        try {
            if (object instanceof CIMParameter && super.equals(object)) {
                CIMParameter p = (CIMParameter)object;
                Object[] quals = (CIMQualifier[])this.mQualifiers.clone();
                Object[] pquals = (CIMQualifier[])p.mQualifiers.clone();
                Arrays.sort(quals);
                Arrays.sort(pquals);
                if (Arrays.equals(quals, pquals)) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public CIMParameter<E> filter(boolean includeQualifiers, boolean localOnly) {
        if (includeQualifiers && !localOnly) {
            return this;
        }
        return new CIMParameter<E>(this.getName(), this.getDataType(), includeQualifiers ? SharedMethods.getFilteredQualifiers(localOnly, this.mQualifiers) : null);
    }

    @Override
    public CIMQualifier<?> getQualifier(int index) throws ArrayIndexOutOfBoundsException {
        return this.mQualifiers[index];
    }

    @Override
    public CIMQualifier<?> getQualifier(String name) {
        if (name != null) {
            for (CIMQualifier<?> mQualifier : this.mQualifiers) {
                if (!mQualifier.getName().equalsIgnoreCase(name)) continue;
                return mQualifier;
            }
        }
        return null;
    }

    @Override
    public int getQualifierCount() {
        return this.mQualifiers.length;
    }

    @Override
    public CIMQualifier<?>[] getQualifiers() {
        return this.mQualifiers;
    }

    @Override
    public Object getQualifierValue(String name) {
        CIMQualifier<?> q = this.getQualifier(name);
        if (q != null) {
            return q.getValue();
        }
        return null;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        for (CIMQualifier<?> q : this.mQualifiers) {
            hash ^= q.hashCode();
        }
        return hash;
    }

    @Override
    public boolean hasQualifier(String name) {
        return this.getQualifier(name) != null;
    }

    @Override
    public boolean hasQualifierValue(String name, Object value) {
        CIMQualifier<?> q = this.getQualifier(name);
        return q != null && q.getValue() != null && q.getValue().equals(value);
    }

    @Override
    public String toString() {
        MOFStyle mf = new MOFStyle();
        return mf.generateMOF(this);
    }
}

