/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.dataimpl;

import sanproject.serverux.data.SANRmiException;
import sanproject.serverux.dataimpl.PGNoExGPID;
import sanproject.serverux.dataimpl.PGNoFB4PG;

public class PGNoConverter {
    private static final int FB4_BORDER_LINE = 100;
    private static final int MIN_FB4 = 1;
    private static final int MAX_FB4 = 18;
    private static final int E_MIN_FB4 = 101;
    private static final int E_MAX_FB4 = 16484;
    private static final int MIN_PG = 1;
    private static final int MAX_PG = 256;
    private static final int MIN_EXG = 1;
    private static final int MAX_EXG = 16384;
    private static final int MIN_PID = 1;
    private static final int MAX_PID = 256;
    private static final int MIN_VVOL = 65;
    private static final int MAX_VVOL = 96;
    private static final int CAL_VVOL_1 = 65;
    private static final int CAL_VVOL_2 = 256;
    private static final int VIEW_VVOL_PG = 1;
    public static final int FLAG_COM = 0;
    public static final int FLAG_EXD = 1;
    public static final int FLAG_VVOL = 2;
    static final int JAVA_ERROR_CODE = 1;
    static final int INVALID_PARAMETER = 6039;

    public static PGNoExGPID toExGPID(int n, int n2) throws SANRmiException {
        PGNoExGPID pGNoExGPID = PGNoConverter.toEP(n, n2);
        return pGNoExGPID;
    }

    public static PGNoExGPID toExGPID(PGNoFB4PG pGNoFB4PG) throws SANRmiException {
        PGNoExGPID pGNoExGPID = PGNoConverter.toEP(pGNoFB4PG.nFB4, pGNoFB4PG.nPG);
        return pGNoExGPID;
    }

    public static PGNoFB4PG toFB4PG(int n, int n2, int n3) throws SANRmiException {
        PGNoFB4PG pGNoFB4PG = PGNoConverter.toFP(n, n2, n3);
        return pGNoFB4PG;
    }

    public static PGNoFB4PG toFB4PG(PGNoExGPID pGNoExGPID) throws SANRmiException {
        PGNoFB4PG pGNoFB4PG = PGNoConverter.toFP(pGNoExGPID.IsExternal, pGNoExGPID.nExG, pGNoExGPID.nPID);
        return pGNoFB4PG;
    }

    private static PGNoExGPID toEP(int n, int n2) throws SANRmiException {
        boolean bl = false;
        int n3 = 0;
        if (n2 < 1 || n2 > 256) {
            System.out.println("toExGPID : PG Range Err -> " + n2);
            bl = true;
        }
        if (!bl) {
            if (n >= 1 && n <= 18) {
                n3 = 0;
            } else if (n >= 101 && n <= 16484) {
                n3 = 1;
                n -= 100;
            } else if (n >= 65 && n <= 96) {
                n3 = 2;
                n = (n - 65) * 256 + n2;
                n2 = 1;
            } else {
                System.out.println("toExGPID : FB4 Range Err -> " + n);
                bl = true;
            }
        }
        if (bl) {
            throw PGNoConverter._makeExp_SANRmi(1, 6039);
        }
        PGNoExGPID pGNoExGPID = new PGNoExGPID();
        pGNoExGPID.IsExternal = n3;
        pGNoExGPID.nExG = n;
        pGNoExGPID.nPID = n2;
        return pGNoExGPID;
    }

    private static PGNoFB4PG toFP(int n, int n2, int n3) throws SANRmiException {
        boolean bl = false;
        if (n2 < 1 || n2 > 16384) {
            System.out.println("toFB4PG : ExG Range Err -> " + n2);
            bl = true;
        }
        if (!(bl || n3 >= 1 && n3 <= 256)) {
            System.out.println("toFB4PG : PID Range Err -> " + n3);
            bl = true;
        }
        if (!bl && n != 0) {
            if (n == 1) {
                n2 += 100;
            } else if (n == 2) {
                n2 = (n2 - n3) / 256 + 65;
            } else {
                System.out.println("toFB4PG : IsExternal Err -> " + n);
                bl = true;
            }
        }
        if (bl) {
            throw PGNoConverter._makeExp_SANRmi(1, 6039);
        }
        PGNoFB4PG pGNoFB4PG = new PGNoFB4PG();
        pGNoFB4PG.nFB4 = n2;
        pGNoFB4PG.nPG = n3;
        return pGNoFB4PG;
    }

    private static SANRmiException _makeExp_SANRmi(int n, int n2) {
        SANRmiException sANRmiException = new SANRmiException();
        sANRmiException.nErrCode = n;
        sANRmiException.nErrData = n2;
        return sANRmiException;
    }
}

