/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.jserver.soma;

import com.hitachi.jserver.soma.SMISUserContextData;
import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRemote;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.smi.common.ProviderProperties;
import com.hitachi.smi.common.RMIObjectMapping;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.BitSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperationErrors;

public class SMISSecurityLib {
    private static final String STORAGE_ADMINISTRATOR_SYSTEM_RESOURCE_MANAGEMENT = "Storage Administrator (System Resource Management)";
    private static final String STORAGE_ADMINISTRATOR_REMOTE_COPY = "Storage Administrator (Remote Copy)";
    private static final String STORAGE_ADMINISTRATOR_PROVISIONING = "Storage Administrator (Provisioning)";
    private static final String STORAGE_ADMINISTRATOR_PERFORMANCE_MANAGEMENT = "Storage Administrator (Performance Management)";
    private static final String STORAGE_ADMINISTRATOR_LOCAL_COPY = "Storage Administrator (Local Copy)";
    private static final String STORAGE_ADMINISTRATOR_INITIAL_CONFIGURATION = "Storage Administrator (Initial Configuration)";
    private static final String STORAGE_ADMINISTRATOR_VIEW_ONLY = "Storage Administrator (View Only)";
    private static BitSet roleOfViewOnly;
    private static BitSet roleOfViewAndModify;
    private static final int MAX_LOGIN_RETRIES = 2;
    protected static Logger mLogger;
    private static ConcurrentHashMap<String, SMISUserContextData> mSecurityMap;

    public static boolean authenticate(String username, String password, String clientIP) {
        boolean ret = false;
        for (int i = 0; i < 2 && !ret; ++i) {
            mLogger.log(Level.INFO, "'authenticate' called for {0}, calling RMI API for the {1}{2} of {3} times.", new Object[]{username, i + 1, i == 0 ? "st" : "nd", 2});
            ret = SMISSecurityLib.authenticateUser(username, password, clientIP);
            String msg = "User " + username + (ret ? " " : " not ") + "athenticated";
            if (!ret && i + 1 < 2) {
                msg = msg + ", will retry";
            }
            mLogger.info(msg);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean authenticateUser(String username, String password, String clientIP) {
        block9: {
            SanResponse sanresponse;
            block10: {
                try {
                    if (roleOfViewAndModify.isEmpty()) {
                        SMISSecurityLib.setUserRoleValues();
                    }
                }
                catch (Throwable t) {
                    mLogger.log(Level.SEVERE, "Failed to get user roles from backend", t);
                    return false;
                }
                RMIObjectMapping device = RMIObjectMapping.getEmbeddedRMIObjectMapping();
                if (null == device) break block9;
                SanRemote sanRemote = device.getRMIObject().keyValueAPI_GetSanRemote();
                SanData generalParam = device.getRMIObject().keyValueAPI_GetStorageInfoParam(sanRemote, clientIP);
                SanRequest sanrequest = sanRemote.newRequest(generalParam, "SANauthenticateStorageUser");
                sanrequest.putString("UserName", username);
                sanrequest.putString("Password", password);
                sanresponse = device.getRMIObject().keyValueAPI_Invoke("SANauthenticateStorageUser", sanRemote, generalParam, sanrequest, false);
                mLogger.log(Level.FINE, "SANauthenticateStorageUser returned {0}", sanresponse.errorCode());
                if (sanresponse.errorCode() == 0) break block10;
                boolean bl = false;
                return bl;
            }
            try {
                SanObject accountInf = sanresponse.getObj("AccountInfo");
                BitSet thisRole = accountInf.getBitSet("AuthBitmap");
                BitSet modify = (BitSet)thisRole.clone();
                modify.and(roleOfViewAndModify);
                BitSet read = (BitSet)thisRole.clone();
                read.and(roleOfViewOnly);
                int rights = modify.equals(roleOfViewAndModify) ? 2 : (read.equals(roleOfViewOnly) ? 1 : 0);
                mSecurityMap.put(username, new SMISUserContextData(username, rights));
                boolean bl = true;
                return bl;
            }
            catch (Throwable ex) {
                Throwable t = ex;
                while (null != t.getCause()) {
                    t = t.getCause();
                }
                mLogger.log(Level.SEVERE, "Lib authenticate unexpected EXCEPTION: " + ex, ex);
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static void authorizeRead(String username) throws WBEMException {
        SMISUserContextData data;
        mLogger.finest("authorizeRead called for: " + username);
        if (ProviderProperties.isEmbedded() && (null == (data = mSecurityMap.get(username)) || !data.canRead())) {
            mLogger.log(Level.FINE, "Lib authenticate authorizeRead failed for {0}", username);
            throw WBEMOperationErrors.getAccessDeniedException();
        }
        mLogger.finest("authorizeRead completed");
    }

    public static void authorizeWrite(String username) throws WBEMException {
        SMISUserContextData data;
        mLogger.log(Level.FINEST, "authorizeWrite called for user {0}", username);
        if (ProviderProperties.isEmbedded() && (null == (data = mSecurityMap.get(username)) || !data.canWrite())) {
            mLogger.log(Level.FINE, "Lib authenticate authorizeWrite failed for {0}", username);
            throw WBEMOperationErrors.getAccessDeniedException();
        }
        mLogger.finest("authorizeWrite completed for user " + username);
    }

    public static void close() {
    }

    private static void getRoleInfo(SanResponse responseData) throws SanDataException {
        mLogger.info("Parsing role data from back end");
        SanList roles = responseData.getList("Roles");
        for (SanObject role : roles) {
            String name = role.getString("Name");
            boolean builtIn = role.getBoolean("Builtin");
            BitSet authMap = role.getBitSet("AuthBitmap");
            mLogger.log(Level.FINE, "Mapping group, {0}, to role. ");
            if (name.equals(STORAGE_ADMINISTRATOR_VIEW_ONLY) && builtIn) {
                roleOfViewOnly.or(authMap);
            }
            if (name.equals(STORAGE_ADMINISTRATOR_INITIAL_CONFIGURATION) && builtIn) {
                roleOfViewAndModify.or(authMap);
            }
            if (name.equals(STORAGE_ADMINISTRATOR_LOCAL_COPY) && builtIn) {
                roleOfViewAndModify.or(authMap);
            }
            if (name.equals(STORAGE_ADMINISTRATOR_PERFORMANCE_MANAGEMENT) && builtIn) {
                roleOfViewAndModify.or(authMap);
            }
            if (name.equals(STORAGE_ADMINISTRATOR_PROVISIONING) && builtIn) {
                roleOfViewAndModify.or(authMap);
            }
            if (name.equals(STORAGE_ADMINISTRATOR_REMOTE_COPY) && builtIn) {
                roleOfViewAndModify.or(authMap);
            }
            if (!name.equals(STORAGE_ADMINISTRATOR_SYSTEM_RESOURCE_MANAGEMENT) || !builtIn) continue;
            roleOfViewAndModify.or(authMap);
        }
        mLogger.info("Done parsing role data.");
    }

    public static void init() {
        roleOfViewOnly = new BitSet();
        roleOfViewAndModify = new BitSet();
        mLogger.info("SMI-S Security Library initialization completed");
    }

    private static void setUserRoleValues() throws RemoteException, WBEMException, SanDataException, SanRmiException, NotBoundException {
        mLogger.info("Getting role data from device");
        RMIObjectMapping device = RMIObjectMapping.getEmbeddedRMIObjectMapping();
        device.getRMIObject().keyValueAPI_GetRegistry();
        SanRemote remote = device.getRMIObject().keyValueAPI_GetSanRemote();
        SanData generalParameter = device.getRMIObject().keyValueAPI_GetStorageInfoParam(remote, "127.0.0.1");
        device.getRMIObject().addAccountInfo(generalParameter);
        SanRequest requestData = remote.newRequest(generalParameter, "ACCreadAllRoles");
        SanResponse responseData = device.getRMIObject().keyValueAPI_Invoke("ACCreadAllRoles", remote, generalParameter, requestData, true);
        SMISSecurityLib.getRoleInfo(responseData);
    }

    static {
        mLogger = Logger.getLogger("com.ws.wbem.jserver");
        mSecurityMap = new ConcurrentHashMap();
    }
}

