/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.HitachiCache;
import com.hitachi.smi.common.ProviderStatusUtils;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.paralleltasker.TaskStop;
import com.ws.wbem.jserver.DaemonThreadFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;

public class CacheStarter
implements Runnable {
    private static final String[] mPreCache = new String[]{"com.hitachi.smi.common.ResourceGroupInfo"};
    private static final String[] mASyncClasses = new String[]{"com.hitachi.smi.common.SnapshotInfo2", "com.hitachi.smi.common.PairInfo", "com.hitachi.smi.common.RmcpPairInfo", "com.hitachi.smi.common.FCoE", "com.hitachi.smi.common.CHAInfo", "com.hitachi.smi.common.PortandHostGroupInfo", "com.hitachi.smi.common.ISCSIreadAlliScsiInitiator", "com.hitachi.smi.common.ISCSIreadAllPortInfo"};
    private static final String[] reqBySyncClasses = new String[]{"com.hitachi.smi.common.ThinPool", "com.hitachi.smi.common.LUPathObject", "com.hitachi.smi.common.PDEVInfo", "com.hitachi.smi.common.PGInfo", "com.hitachi.smi.common.FCPort"};
    private static final String[] mSynchronusClasses = new String[]{"com.hitachi.smi.common.ISCSITargetPort", "com.hitachi.smi.common.DeviceNumber", "com.hitachi.smi.common.ChassisArrayGroup", "com.hitachi.smi.common.VirtualLDEV", "com.hitachi.smi.common.LDevNickname", "com.hitachi.smi.common.PDEVInfoEntry", "com.hitachi.smi.common.ExternalChassisArrayGroup", "com.hitachi.smi.common.PoolNickname"};
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.cache");
    private boolean mProcessingErrorOccurred;
    private boolean mProcessing;
    private boolean mReAddedToThreadPool;
    private final TaskStop mShouldStop = new TaskStop();
    private final RMIObjectMapping managedDevice;

    public CacheStarter(RMIObjectMapping dev) {
        if (null == dev) {
            throw new NullPointerException("RMIObjectMapping must be supplied");
        }
        this.mReAddedToThreadPool = false;
        this.mProcessingErrorOccurred = false;
        this.mProcessing = true;
        this.managedDevice = dev;
    }

    public synchronized void CacheStarterReAddedToThreadPool() {
        this.mReAddedToThreadPool = true;
    }

    private void callCacheMethod(String clzName) {
        try {
            Class<?> dynClz = Class.forName(clzName);
            Method mthd = dynClz.getMethod("cache", RMIObjectMapping.class);
            long startItem = System.currentTimeMillis();
            mLogger.log(Level.INFO, "Starting to process {0} for {1}", new Object[]{dynClz.getSimpleName(), this.managedDevice});
            mthd.invoke(null, this.managedDevice);
            mLogger.log(Level.INFO, "Processing {0} on {1} took {2} milliseconds", new Object[]{dynClz.getSimpleName(), this.managedDevice, System.currentTimeMillis() - startItem});
        }
        catch (NoSuchMethodException nsme) {
            mLogger.log(Level.SEVERE, "class is not 'Cachable' - " + clzName + " device " + this.managedDevice, nsme);
        }
        catch (Throwable t) {
            while (null != t.getCause()) {
                t = t.getCause();
            }
            mLogger.log(Level.SEVERE, "Unable to load class to cache: " + clzName + " device " + this.managedDevice, t);
            this.setProcessingError(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommonObjects() throws InterruptedException {
        cacheASyncClassThread task;
        ExecutorService exec = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() < 2 ? 2 : Runtime.getRuntime().availableProcessors(), (ThreadFactory)new DaemonThreadFactory());
        ExecutorCompletionService<cacheASyncClassThread> cs = new ExecutorCompletionService<cacheASyncClassThread>(exec);
        for (String clz : mPreCache) {
            this.callCacheMethod(clz);
        }
        ArrayList<Future<cacheASyncClassThread>> reqClasses = new ArrayList<Future<cacheASyncClassThread>>(reqBySyncClasses.length);
        for (String reqBySynClass : reqBySyncClasses) {
            task = new cacheASyncClassThread(reqBySynClass);
            Future<cacheASyncClassThread> future = cs.submit(task, task);
            reqClasses.add(future);
        }
        for (String aSync : mASyncClasses) {
            task = new cacheASyncClassThread(aSync);
            cs.submit(task, task);
        }
        exec.shutdown();
        int counter = 0;
        while (!this.isProcessingError() && counter < reqClasses.size()) {
            cs.take();
            mLogger.log(Level.FINER, "Completed processing {0} prerequsite classes", ++counter);
        }
        reqClasses = null;
        mLogger.log(Level.INFO, "Prerequisite classes cached for {0}, caching other classes", new Object[]{this.managedDevice});
        for (String syncClass : mSynchronusClasses) {
            if (this.isProcessingError()) break;
            this.callCacheMethod(syncClass);
        }
        try {
            counter = 0;
            while (!exec.awaitTermination(30L, TimeUnit.SECONDS)) {
                if (counter % 1000 != 0) continue;
                mLogger.log(Level.INFO, "Waiting for asynchronous classes to complete...");
            }
        }
        catch (InterruptedException e) {
        }
        finally {
            mLogger.log(Level.INFO, "Asynchronous classes completed");
        }
    }

    public synchronized boolean getProcessingError() {
        return this.mProcessingErrorOccurred;
    }

    public synchronized boolean isCacheStarterReAddedToThreadPool() {
        return this.mReAddedToThreadPool;
    }

    public synchronized boolean isProcessing() {
        return this.mProcessing;
    }

    public synchronized boolean isProcessingError() {
        return this.mProcessingErrorOccurred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startProcessing = -1L;
        String serialNum = null;
        CacheUpdater updater = null;
        if (this.isCacheStarterReAddedToThreadPool()) {
            mLogger.log(Level.INFO, "{0} population failed, will restart in {1} seconds", new Object[]{this.managedDevice, 60});
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            this.setProcessing(true);
            this.setProcessingError(false);
            this.mReAddedToThreadPool = false;
        }
        ProviderStatusUtils.setProviderStatus(ProviderStatusUtils.ProviderStatus.Initializing, ProviderStatusUtils.ProviderStatusDetailCode.NONE);
        try {
            serialNum = this.managedDevice.getSerialNumber();
            Thread temp = Thread.currentThread();
            temp.setName("Cache Processor for " + serialNum);
            startProcessing = System.currentTimeMillis();
            updater = new CacheUpdater(serialNum);
            mLogger.log(Level.INFO, "Starting cache population for {0}", serialNum);
            this.doCommonObjects();
        }
        catch (Throwable thrown) {
            mLogger.log(Level.SEVERE, "unexpected error processing cache for " + serialNum, thrown);
            this.setProcessingError(true);
        }
        finally {
            long runTime = System.currentTimeMillis() - startProcessing;
            if (!this.isProcessingError()) {
                mLogger.info("Processing cache for " + serialNum + " was successful and took " + runTime + " milliseconds");
                ProviderStatusUtils.setProviderStatus(ProviderStatusUtils.ProviderStatus.Ready, ProviderStatusUtils.ProviderStatusDetailCode.NONE);
                if (null != updater) {
                    updater.start();
                } else {
                    mLogger.severe("No cache updater object for " + this.managedDevice);
                }
            } else {
                if (startProcessing != -1L) {
                    mLogger.info("Processing cache failed for " + serialNum + ", runtime " + runTime + " milliseconds!");
                } else {
                    mLogger.info("Processing cache failed for " + serialNum);
                }
                ProviderStatusUtils.setProviderStatus(ProviderStatusUtils.ProviderStatus.Warning, ProviderStatusUtils.ProviderStatusDetailCode.CACHEFAILED);
                this.stop();
            }
            this.setProcessing(false);
        }
    }

    private synchronized void setProcessing(boolean value) {
        this.mProcessing = value;
    }

    private synchronized void setProcessingError(boolean processingError) {
        if (processingError) {
            this.setProcessing(false);
        }
        this.mProcessingErrorOccurred = processingError;
    }

    protected boolean stop() {
        boolean ret = true;
        if (this.isProcessing()) {
            this.mShouldStop.setStop(true);
        }
        try {
            ret = HitachiCache.getHitachiCache(this.managedDevice.getSerialNumber()).stop();
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Exception trying to stop cache for " + this.managedDevice, e);
        }
        return ret;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CacheStarter [managedDevice=");
        builder.append(this.managedDevice);
        builder.append(", mProcessing=");
        builder.append(this.mProcessing);
        builder.append(", mProcessingErrorOccurred=");
        builder.append(this.mProcessingErrorOccurred);
        builder.append(", mShouldStop=");
        builder.append(this.mShouldStop.shouldStop());
        builder.append("]");
        return builder.toString();
    }

    private class cacheASyncClassThread
    implements Runnable {
        private final String mClassName;

        protected cacheASyncClassThread(String clzName) {
            this.mClassName = clzName;
        }

        @Override
        public void run() {
            try {
                if (!CacheStarter.this.isProcessingError()) {
                    CacheStarter.this.callCacheMethod(this.mClassName);
                }
            }
            catch (Throwable e) {
                mLogger.log(Level.SEVERE, "Unable to load class to cache " + this.mClassName + " for " + CacheStarter.this.managedDevice, e);
                CacheStarter.this.setProcessingError(true);
            }
        }
    }
}

