/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.AbstractVersionChecker;
import com.hitachi.smi.cache.CacheUpdateType;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.LDEVBranchChecker;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.LUSEInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import sanproject.common.Robj_interface_BASICVerAllLUSE;
import sanproject.common.Robj_interface_VerLeaf;

public class LUSEBranchChecker
extends AbstractVersionChecker {
    protected LUSEBranchChecker(String serialNum) {
        super(serialNum);
        CacheUpdater.registerVersionChecker(CacheUpdater.ConfVerID.BASIC, this);
    }

    @Override
    public void checkVersionDetails(Robj_interface_VerLeaf[] currentChildren, Robj_interface_VerLeaf[] prevChildren) {
        this.CompareAllLUSEBranch((Robj_interface_BASICVerAllLUSE)currentChildren[4], (Robj_interface_BASICVerAllLUSE)prevChildren[4]);
    }

    private void CompareAllLUSEBranch(Robj_interface_BASICVerAllLUSE current, Robj_interface_BASICVerAllLUSE prior) {
        try {
            ArrayList<LUSEInfo> added = new ArrayList<LUSEInfo>();
            ArrayList<LUSEInfo> removed = new ArrayList<LUSEInfo>();
            if (!(current == null && prior == null || null != current && null != prior && current.getNVer() == prior.getNVer())) {
                mLogger.log(Level.INFO, "Detected change in ALL LUSE version on {0}", this.getSerialNumber());
                LUSEInfo.modifyCachedLUSE(added, removed, this.getSerialNumber());
                this.updateDNs(added, removed);
                CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.LUSE, (Serializable[])added.toArray(new LUSEInfo[added.size()]));
                CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.LUSE, (Serializable[])removed.toArray(new LUSEInfo[removed.size()]));
            }
        }
        catch (Throwable e) {
            mLogger.log(Level.SEVERE, "Exception occurred trying modify DNs in cache.", e);
        }
    }

    private void updateDNs(List<LUSEInfo> added, List<LUSEInfo> removed) {
        short[] CUandLDEV;
        Long componentVal;
        Long[] componentVals;
        int index = 0;
        LinkedList<Short[]> addedDNs = new LinkedList<Short[]>();
        LinkedList<Short[]> modifiedDNs = new LinkedList<Short[]>();
        LinkedList<Short[]> removedDNs = new LinkedList<Short[]>();
        for (LUSEInfo luse : added) {
            componentVals = luse.getComponents();
            for (index = 0; index < componentVals.length; ++index) {
                componentVal = componentVals[index];
                CUandLDEV = BaseDeviceNumber.getDevIdStringValues(componentVal.toString());
                if (0 == index) {
                    LDEVBranchChecker.addModifiedDN2List(CUandLDEV[1], CUandLDEV[2], modifiedDNs);
                    continue;
                }
                LDEVBranchChecker.addRemovedDN2List(CUandLDEV[1], CUandLDEV[2], removedDNs);
                LDEVBranchChecker.addAddedDN2List(CUandLDEV[1], CUandLDEV[2], addedDNs);
            }
        }
        for (LUSEInfo luse : removed) {
            componentVals = luse.getComponents();
            for (index = 0; index < componentVals.length; ++index) {
                componentVal = componentVals[index];
                CUandLDEV = BaseDeviceNumber.getDevIdStringValues(componentVal.toString());
                if (0 == index) {
                    LDEVBranchChecker.addModifiedDN2List(CUandLDEV[1], CUandLDEV[2], modifiedDNs);
                    continue;
                }
                LDEVBranchChecker.addAddedDN2List(CUandLDEV[1], CUandLDEV[2], addedDNs);
                LDEVBranchChecker.addRemovedDN2List(CUandLDEV[1], CUandLDEV[2], removedDNs);
            }
        }
        LDEVBranchChecker.processAffectedDNs(addedDNs, modifiedDNs, removedDNs, this.getSerialNumber());
    }
}

