/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.AbstractVersionChecker;
import com.hitachi.smi.cache.CacheUpdateType;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.ResourceGroupInfoVersionChecker;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.ISCSIreadAllPortInfo;
import com.hitachi.smi.common.ISCSIreadAlliScsiInitiator;
import com.hitachi.smi.common.ResourceGroupInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_BASICVerAllPort;
import sanproject.common.Robj_interface_BASICVerPort;
import sanproject.common.Robj_interface_VerLeaf;

public class PortBranchChecker
extends AbstractVersionChecker
implements ResourceGroupInfoVersionChecker.RSGUpdateCallback {
    protected PortBranchChecker(String serialNum) {
        super(serialNum);
        CacheUpdater.registerVersionChecker(CacheUpdater.ConfVerID.BASIC, this);
        ResourceGroupInfoVersionChecker.registerForRSGUpdates(ResourceGroupInfo.SearchType.PORT, this);
    }

    private Thread checkiSCSIInitiators() {
        Runnable checker = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AbstractVersionChecker.mLogger.log(Level.INFO, "{0} starting", Thread.currentThread().getName());
                    ArrayList<ISCSIreadAlliScsiInitiator> added = new ArrayList<ISCSIreadAlliScsiInitiator>();
                    ArrayList<ISCSIreadAlliScsiInitiator> modified = new ArrayList<ISCSIreadAlliScsiInitiator>();
                    ArrayList<ISCSIreadAlliScsiInitiator> removed = new ArrayList<ISCSIreadAlliScsiInitiator>();
                    ISCSIreadAlliScsiInitiator.update(PortBranchChecker.this.getSerialNumber(), added, modified, removed);
                    AbstractVersionChecker.mLogger.log(Level.INFO, "ISCSIreadAlliScsiInitiator added: {0}, modified {1}, removed {2}", new Object[]{added.size(), modified.size(), removed.size()});
                    if (!modified.isEmpty()) {
                        CacheUpdater.doCallback((String)PortBranchChecker.this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PORT, (Serializable[])modified.toArray(new ISCSIreadAlliScsiInitiator[modified.size()]));
                    }
                    if (!added.isEmpty()) {
                        CacheUpdater.doCallback((String)PortBranchChecker.this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PORT, (Serializable[])added.toArray(new ISCSIreadAlliScsiInitiator[added.size()]));
                    }
                    if (!removed.isEmpty()) {
                        CacheUpdater.doCallback((String)PortBranchChecker.this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PORT, (Serializable[])removed.toArray(new ISCSIreadAlliScsiInitiator[removed.size()]));
                    }
                }
                catch (Throwable t) {
                    AbstractVersionChecker.mLogger.log(Level.SEVERE, "Error updating ISCSIreadAlliScsiInitiator!", t);
                }
                finally {
                    AbstractVersionChecker.mLogger.log(Level.INFO, "{0} exiting", Thread.currentThread().getName());
                }
            }
        };
        Thread t = new Thread(checker);
        t.setDaemon(true);
        t.setName("ISCSIreadAlliScsiInitiator Checker");
        t.start();
        return t;
    }

    private Thread checkiSCSIPorts() {
        Runnable checker = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AbstractVersionChecker.mLogger.log(Level.INFO, "{0} starting", Thread.currentThread().getName());
                    ArrayList<ISCSIreadAllPortInfo> added = new ArrayList<ISCSIreadAllPortInfo>();
                    ArrayList<ISCSIreadAllPortInfo> modified = new ArrayList<ISCSIreadAllPortInfo>();
                    ArrayList<ISCSIreadAllPortInfo> removed = new ArrayList<ISCSIreadAllPortInfo>();
                    ISCSIreadAllPortInfo.update(PortBranchChecker.this.getSerialNumber(), added, modified, removed);
                    AbstractVersionChecker.mLogger.log(Level.INFO, "ISCSITargISCSIreadAllPortInfo added: {0}, modified {1}, removed {2}", new Object[]{added.size(), modified.size(), removed.size()});
                    if (!modified.isEmpty()) {
                        CacheUpdater.doCallback((String)PortBranchChecker.this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PORT, (Serializable[])modified.toArray(new ISCSITargetPort[modified.size()]));
                    }
                    if (!added.isEmpty()) {
                        CacheUpdater.doCallback((String)PortBranchChecker.this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PORT, (Serializable[])added.toArray(new ISCSITargetPort[added.size()]));
                    }
                    if (!removed.isEmpty()) {
                        CacheUpdater.doCallback((String)PortBranchChecker.this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PORT, (Serializable[])removed.toArray(new ISCSITargetPort[removed.size()]));
                    }
                }
                catch (Throwable t) {
                    AbstractVersionChecker.mLogger.log(Level.SEVERE, "Error updating ISCSIreadAllPortInfo!", t);
                }
                finally {
                    AbstractVersionChecker.mLogger.log(Level.INFO, "{0} exiting", Thread.currentThread().getName());
                }
            }
        };
        Thread t = new Thread(checker);
        t.setDaemon(true);
        t.setName("ISCSIreadAllPortInfo Checker");
        t.start();
        return t;
    }

    @Override
    public void checkVersionDetails(Robj_interface_VerLeaf[] currentChildren, Robj_interface_VerLeaf[] prevChildren) {
        this.CompareAllPortBranch((Robj_interface_BASICVerAllPort)currentChildren[2], (Robj_interface_BASICVerAllPort)prevChildren[2]);
    }

    private void CompareAllPortBranch(Robj_interface_BASICVerAllPort current, Robj_interface_BASICVerAllPort prior) {
        if (current == null || prior == null) {
            mLogger.log(Level.FINER, "Version info null, {0} {1}", new Object[]{null != current ? "" : "current null", null != prior ? "" : "prior null"});
        } else if (current.getNVer() != prior.getNVer() || current.getNSummaryVer() != prior.getNSummaryVer()) {
            mLogger.info("Detected change in ALL Port version");
            this.ComparePorts((Robj_interface_BASICVerPort[])current.getObjChildren(), (Robj_interface_BASICVerPort[])prior.getObjChildren());
        }
    }

    private void ComparePorts(Robj_interface_BASICVerPort[] current, Robj_interface_BASICVerPort[] prior) {
        ArrayList<Thread> wait4Threads = new ArrayList<Thread>();
        wait4Threads.add(this.checkiSCSIPorts());
        wait4Threads.add(this.checkiSCSIInitiators());
        ArrayList<Short> added = new ArrayList<Short>();
        ArrayList<Short> modified = new ArrayList<Short>();
        ArrayList<Short> removed = new ArrayList<Short>();
        for (short index = 0; index < current.length; index = (short)((short)(index + 1))) {
            if (current[index] == null && prior[index] == null) continue;
            if (current[index] == null && prior[index] != null) {
                removed.add(index);
                continue;
            }
            if (current[index] != null && prior[index] == null) {
                added.add(index);
                continue;
            }
            if (current[index].getNVer() == prior[index].getNVer()) continue;
            modified.add(index);
        }
        if (!modified.isEmpty()) {
            this.processModifiedPort(modified, removed, added);
        }
        if (!removed.isEmpty()) {
            this.processRemovedPort(removed);
        }
        if (!added.isEmpty()) {
            this.processAddedPort(added);
        }
        for (Thread t : wait4Threads) {
            if (null == t || !t.isAlive()) continue;
            try {
                mLogger.log(Level.INFO, "Waiting for {0} to complete", t.getName());
                t.join();
            }
            catch (InterruptedException e) {
                mLogger.log(Level.FINE, t.getName() + " interuptted.", e);
            }
        }
    }

    private void processAddedPort(List<Short> added) {
        try {
            Serializable[] dns = FCPort.addFCPortToCache(added, this.getSerialNumber());
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PORT, (Serializable[])dns);
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "Exception occurred trying to add FCPort to cache.", t);
        }
    }

    private void processModifiedPort(List<Short> modified, List<Short> removed, List<Short> added) {
        try {
            Serializable[] ports = FCPort.modifyFCportInCache(this.getSerialNumber(), modified, removed, added);
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PORT, (Serializable[])ports);
        }
        catch (Throwable e) {
            mLogger.log(Level.SEVERE, "Exception occurred trying modify FCPort in cache.", e);
        }
    }

    private void processRemovedPort(List<Short> removed) {
        try {
            Serializable[] ports = FCPort.removeFCPortFromCache(removed, this.getSerialNumber());
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PORT, (Serializable[])ports);
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Exception occurred trying remove FCPort from cache.", e);
        }
    }

    @Override
    public void RSGUpdated(ResourceGroupInfo.SearchType type, TreeSet<String> addedElements, TreeSet<String> removedElements) {
        if (!removedElements.isEmpty()) {
            ArrayList<Short> removed = new ArrayList<Short>(removedElements.size());
            for (String val : removedElements) {
                removed.add(Short.parseShort(val));
            }
            this.processRemovedPort(removed);
        }
        if (!addedElements.isEmpty()) {
            ArrayList<Short> added = new ArrayList<Short>(addedElements.size());
            for (String val : addedElements) {
                added.add(Short.parseShort(val));
            }
            this.processAddedPort(added);
        }
    }
}

