/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache.comparator;

import com.hitachi.smi.cache.comparator.HitachiCacheComparator;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.DeviceNumber;
import java.util.logging.Level;

public class DNComparator<E extends DeviceNumber>
implements HitachiCacheComparator<E> {
    final boolean aou;
    final boolean qs;
    final boolean composite;
    final int fb4;
    final int pg;
    final int vdev;
    final short dkc;
    final short cu;
    final short ldev;
    final short poolID;
    private boolean returnAll;
    private short clpr;

    public DNComparator() {
        this(false);
    }

    public DNComparator(boolean compositeOnly) {
        this(false, false, -1, -1, -1, -1, -1, -1, -1, -1, compositeOnly);
    }

    public DNComparator(boolean aouOnly, boolean qsOnly) {
        this(aouOnly, qsOnly, -1, -1, -1, -1, -1, -1, -1, -1, false);
    }

    public DNComparator(boolean aouOnly, boolean qsOnly, short poolID) {
        this(aouOnly, qsOnly, poolID, -1, -1, -1, -1, -1, -1, -1, false);
    }

    public DNComparator(boolean aouOnly, boolean qsOnly, short poolID, int fb4, int pg, int vdev, short dkc, short cu, short ldev, short clpr, boolean composite) {
        this.composite = composite;
        this.poolID = poolID;
        this.fb4 = fb4;
        this.pg = pg;
        this.vdev = vdev;
        this.dkc = dkc;
        this.cu = cu;
        this.ldev = ldev;
        this.clpr = clpr;
        if (-1 != clpr && !aouOnly && !qsOnly) {
            mLogger.log(Level.SEVERE, "DNComparator looking for CLPR but aou or qs was false", new Exception());
            this.aou = true;
            this.qs = true;
        } else {
            this.aou = aouOnly;
            this.qs = qsOnly;
        }
        this.returnAll = this.shouldReturnAll();
    }

    public DNComparator(int fb4) {
        this(false, false, -1, fb4, -1, -1, -1, -1, -1, -1, false);
    }

    public DNComparator(int fb4, int pg) {
        this(false, false, -1, fb4, pg, -1, -1, -1, -1, -1, false);
    }

    public DNComparator(int fb4, int pg, int vdev) {
        this(false, false, -1, fb4, pg, vdev, -1, -1, -1, -1, false);
    }

    public DNComparator(short cu) {
        this(false, false, -1, -1, -1, -1, -1, cu, -1, -1, false);
    }

    public DNComparator(short dkc, short cu, short ldev) {
        this(false, false, -1, -1, -1, -1, dkc, cu, ldev, -1, false);
    }

    @Override
    public boolean isMatch(E compared) {
        boolean ret = true;
        if (!this.returnAll) {
            if (this.aou && !((DeviceNumber)compared).isAOUVol()) {
                ret = false;
            }
            if (ret && this.qs && !((DeviceNumber)compared).isQSVvol()) {
                ret = false;
            }
            if (ret && -1 != this.clpr && ((DeviceNumber)compared).getSCLPR() != this.clpr) {
                ret = false;
            }
            if (ret && -1 != this.poolID && ((DeviceNumber)compared).getThinPoolID() != this.poolID) {
                ret = false;
            }
            if (ret && -1 != this.fb4 && ((DeviceNumber)compared).getFb4() != this.fb4) {
                ret = false;
            }
            if (ret && -1 != this.pg && ((DeviceNumber)compared).getPg() != this.pg) {
                ret = false;
            }
            if (ret && -1 != this.vdev && ((DeviceNumber)compared).getVdev() != this.vdev) {
                ret = false;
            }
            if (ret && -1 != this.dkc && ((BaseDeviceNumber)compared).getLdkc() != this.dkc) {
                ret = false;
            }
            if (ret && -1 != this.cu && ((BaseDeviceNumber)compared).getCu() != this.cu) {
                ret = false;
            }
            if (ret && -1 != this.ldev && ((BaseDeviceNumber)compared).getLdev() != this.ldev) {
                ret = false;
            }
        }
        mLogger.log(ret ? Level.FINEST : Level.FINE, "DNComparator returning {0} for DN {1}", new Object[]{ret, ret ? Long.valueOf(((BaseDeviceNumber)compared).getDn()) : compared});
        return ret;
    }

    private boolean shouldReturnAll() {
        boolean ret = false;
        if (!this.aou && !this.qs && -1 == this.dkc && -1 == this.cu && -1 == this.ldev && -1 == this.fb4 && -1 == this.pg && -1 == this.poolID && -1 == this.vdev && -1 == this.clpr) {
            ret = true;
        }
        return ret;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DNComparator [returnAll=");
        builder.append(this.returnAll);
        if (-1 != this.dkc) {
            builder.append(", dkc=");
            builder.append(this.dkc);
        }
        if (-1 != this.cu) {
            builder.append(", cu=");
            builder.append(this.cu);
        }
        if (-1 != this.ldev) {
            builder.append(", ldev=");
            builder.append(this.ldev);
        }
        if (-1 != this.fb4) {
            builder.append(", fb4=");
            builder.append(this.fb4);
        }
        if (-1 != this.pg) {
            builder.append(", pg=");
            builder.append(this.pg);
        }
        if (-1 != this.vdev) {
            builder.append(", vdev=");
            builder.append(this.vdev);
        }
        if (-1 != this.poolID) {
            builder.append(", poolID=");
            builder.append(this.poolID);
        }
        if (this.aou) {
            builder.append(", aou=");
            builder.append(this.aou);
        }
        if (this.qs) {
            builder.append(", qs=");
            builder.append(this.qs);
        }
        if (-1 != this.clpr) {
            builder.append(", clpr=");
            builder.append(this.clpr);
        }
        builder.append("]");
        return builder.toString();
    }
}

