/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.wbem.WBEMException;

public class CommonClassAsList<E extends AbstractBaseCommonObject>
extends IteratorCallbackIMPL<E> {
    private WBEMException theException = null;
    private final LinkedList<E> theList = new LinkedList();
    private boolean done = false;

    public CommonClassAsList() {
        super(null, false, null, null, null);
    }

    @Override
    public synchronized void done() {
        this.done = true;
        this.notifyAll();
    }

    @Override
    public void exceptionOccurred(WBEMException thrown) {
        this.theException = thrown;
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<E> getReturnValue() throws WBEMException {
        int count = 0;
        while (!this.isDone()) {
            try {
                CommonClassAsList commonClassAsList = this;
                synchronized (commonClassAsList) {
                    this.wait(30000L);
                }
            }
            catch (InterruptedException e) {
                this.theException = new WBEMException(1, e.toString(), null, (Throwable)e);
            }
            if (count++ <= 60) continue;
            throw new WBEMException(1, "CommonClassAsList waited 30 minutes, failing request");
        }
        if (this.theException != null) {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            logger.severe("throwing " + this.theException.toString() + " from CommonClassAsArray.getReturnValue");
            throw this.theException;
        }
        return this.theList;
    }

    private final synchronized boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean returnItem(E item) {
        boolean ret = false;
        if (!this.isDone() && item != null) {
            ret = true;
            LinkedList<E> linkedList = this.theList;
            synchronized (linkedList) {
                if (!this.theList.offer(item)) {
                    Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                    logger.severe("failed to add item to array: " + item);
                    ret = false;
                    this.theList.clear();
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnItems(E[] items) {
        if (!this.isDone()) {
            if (items != null && items.length > 0) {
                LinkedList<E> linkedList = this.theList;
                synchronized (linkedList) {
                    if (!this.theList.addAll(Arrays.asList(items))) {
                        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                        logger.severe("failed to add items to array.");
                    }
                }
            }
            this.done();
        }
    }
}

