/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.cache.comparator.DNComparator;
import com.hitachi.smi.cache.comparator.HitachiCacheComparator;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.DeviceNumberAOUProcessor;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.LUPathObject;
import com.hitachi.smi.common.LUSEInfo;
import com.hitachi.smi.common.PairInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ResourceRestriction;
import com.hitachi.smi.common.RmcpPairInfo;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.paralleltasker.ProcessTask;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import com.hitachi.smi.paralleltasker.TaskStop;
import com.hitachi.smi.paralleltasker.Wait4ProcessTasks;
import com.ws.wbem.CloseableAddableIterator;
import java.io.Serializable;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_LUNMgetLDEVStatus;
import sanproject.common.Robj_interface_RJSetGettingParamDevice;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail2;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail3;
import sanproject.common.Robj_interface_RJiLDKCIndex;
import sanproject.common.Robj_interface_RJiVDEVIndex;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.SANRmiException;

public class DeviceNumber
extends BaseDeviceNumber {
    private static final long serialVersionUID = 1L;
    private static final String clzName = DeviceNumber[].class.getName();
    private static final Class<DeviceNumber[]> clz = DeviceNumber[].class;
    private static Hashtable<String, Short> volAtrbHash = null;
    private static final String VOL_TYPE_DYNAMIC = "Dynamic Provisioning";
    private static final String VOL_TYPE_COW_SNAPSHOT = "COW Snapshot";
    private static final String VOL_TYPE_EXTERNAL = "External";
    private static final String VOL_TYPE_BASIC = "Basic";
    private boolean need2CalcKBytes;
    private byte healthState;
    private UnsignedInteger64 blockSize;
    private boolean BLUPathCmdDev;
    private boolean BSystemLU;
    private ArrayList<Long> compositeComponents;
    private UnsignedInteger16 consistsOf;
    private UnsignedInteger16 dataOrganization;
    private boolean external;
    private int fb4;
    private UnsignedInteger16[] guardMode;
    private boolean migrationServices;
    private long numOfKBytes;
    private long numOfCylinders;
    private int pg;
    private String raidLevel;
    private short SLUSEElmCount;
    private boolean systemDisk;
    private int vdev;
    private byte volType;
    private byte volumeFlag;
    private boolean volumeIsPool;
    private boolean mProtected;
    private int mVolumeAccess;
    private boolean mLUNMaskingAllowed;
    private boolean AOUVol;
    private boolean BJNLVolume;
    private boolean externalMFVolume;
    private boolean blockVolume;
    private short mFirstLUNPortID;
    private short SSLPR;
    private short SCLPR;
    private boolean MFVolume;
    private boolean middleVolume;
    private boolean internalVolume;
    private boolean QSVvol;
    private byte byDriveType;
    private boolean normalDrive;
    private boolean SATADrive;
    private boolean SSDDrive;
    private boolean BCacheMode;
    private boolean BRmtCmdDev;
    private boolean BCvsVolume;
    private boolean BEncrypt;
    private byte ByEncryptKey;
    private byte ByProtectionLevel;
    private byte ByCurrentMPBladeID;
    private byte ByUserMPBladeID;
    private int ILUPathNumber;
    private boolean BLUPathCmdDevSec;
    private boolean BCmdDevAuth;
    private boolean BDevGrpDefine;
    private short SPoolID;
    private byte ByExtDriveType;
    private byte[] extWWN;
    private boolean ExtNormalDrive;
    private boolean ExtSATADrive;
    private boolean ExtSSDDrive;
    private boolean mReserved;
    private boolean mVVol;
    private String mAttribute;

    public static DeviceNumber[] add2CachedDNs(LinkedList<Short[]> pList, String serialNum) throws RemoteException, SANRmiException, WBEMException, GetRmiException {
        DeviceNumber[] ret = null;
        cacheLogger.log(Level.INFO, "Processing {0} added DNs on {1}", new Object[]{pList.size(), serialNum});
        LinkedList<DeviceNumber> dns = DeviceNumber.getDNsBasedOnCUnLDEV(serialNum, pList);
        HashMap dnMap = new HashMap();
        cacheLogger.log(Level.INFO, "Adding {0} DNs to cache from {1}", new Object[]{dns.size(), serialNum});
        CacheLib.addDataToCache(dnMap, dns, clz, serialNum);
        ret = dns.toArray(new DeviceNumber[dns.size()]);
        cacheLogger.log(Level.INFO, "Done adding DNs to cache from {0}", serialNum);
        return ret;
    }

    public static void addDN2Map(DeviceNumber dn, AbstractMap<String, List<DeviceNumber>> dnMap) {
        boolean isComposite = dn.getSLUSEElmCount() != 0;
        String dnKeyStr = clzName;
        CacheLib.addToMap(dnMap, dnKeyStr, dn);
        if (isComposite) {
            CacheLib.addToMap(dnMap, dnKeyStr + "composite", dn);
        }
        if (dn.isAOUVol() || dn.isQSVvol()) {
            String combinedKey = CacheLib.getDevNumAOUQSString();
            CacheLib.addToMap(dnMap, combinedKey, dn);
            String key = CacheLib.getDevNumAOUString(dn.isAOUVol());
            CacheLib.addToMap(dnMap, key, dn);
            String key2 = CacheLib.getDevNumThinPoolIDString(dn.getThinPoolID(), dn.isAOUVol());
            CacheLib.addToMap(dnMap, key2, dn);
            String combinedKey2 = CacheLib.getDevNumAOUQSThinPoolIDString(dn.getThinPoolID());
            CacheLib.addToMap(dnMap, combinedKey2, dn);
            if (isComposite) {
                CacheLib.addToMap(dnMap, combinedKey + "composite", dn);
                CacheLib.addToMap(dnMap, combinedKey2 + "composite", dn);
                CacheLib.addToMap(dnMap, key + "composite", dn);
                key2 = CacheLib.getDevNumThinPoolIDCompositeString(dn.getThinPoolID(), dn.isAOUVol());
                CacheLib.addToMap(dnMap, key2, dn);
            }
        }
        String fb4Str = CacheLib.getDevNumFB4String(dn.getFb4());
        CacheLib.addToMap(dnMap, fb4Str, dn);
        if (isComposite) {
            CacheLib.addToMap(dnMap, fb4Str + "composite", dn);
        }
        String dnPGStr = CacheLib.getDevNumPGString(dn.getPg());
        String dnFB4PgStr = fb4Str + dnPGStr;
        CacheLib.addToMap(dnMap, dnFB4PgStr, dn);
        if (isComposite) {
            CacheLib.addToMap(dnMap, dnFB4PgStr + "composite", dn);
        }
        String dnVDEVStr = CacheLib.getDevNumVDEVString(dn.getVdev());
        String dnFB4PgVdevStr = fb4Str + dnPGStr + dnVDEVStr;
        CacheLib.addToMap(dnMap, dnFB4PgVdevStr, dn);
        if (isComposite) {
            CacheLib.addToMap(dnMap, dnFB4PgVdevStr + "composite", dn);
        }
        short[] vals = BaseDeviceNumber.getDevIdStringValues(dn.getDNAsString());
        String dkcStr = CacheLib.getDKCString(vals[0]);
        String cuStr = CacheLib.getCUString(vals[1]);
        String ldevStr = CacheLib.getLDEVIndexLDEVString(vals[2]);
        String dkcCULDevStr = "DN:" + dkcStr + cuStr + ldevStr;
        CacheLib.addToMap(dnMap, dkcCULDevStr, dn);
        if (isComposite) {
            CacheLib.addToMap(dnMap, dkcCULDevStr + "composite", dn);
        }
        String tCUStr = "DN:" + cuStr;
        CacheLib.addToMap(dnMap, tCUStr, dn);
        String cuLDevStr = tCUStr + ldevStr;
        CacheLib.addToMap(dnMap, cuLDevStr, dn);
        if (dn.volType == 2 || dn.volType == 3) {
            String clprKey = CacheLib.getDevNumAOUCLPR(dn.getSCLPR());
            CacheLib.addToMap(dnMap, clprKey, dn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void cache(RMIObjectMapping rmiMapping) throws WBEMException, RemoteException, GetRmiException, SANRmiException {
        RMIObjectCache rmiObj = rmiMapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) return;
        Class<DeviceNumber> clazz = DeviceNumber.class;
        synchronized (DeviceNumber.class) {
            if (!cache.isCached(clz)) {
                DeviceNumberAOUProcessor.cache(rmiMapping);
                ConcurrentHashMap dnMap = new ConcurrentHashMap();
                ClosableAddableIteratorCB<DeviceNumber> callback = new ClosableAddableIteratorCB<DeviceNumber>();
                DeviceNumber.getUncachedDNs(rmiObj, callback, false, true, null, -1, -1, -1, false, (short)-1);
                CloseableAddableIterator<DeviceNumber> iter = callback.getWrappedCloseableAddableIter();
                ArrayList<DeviceNumber> dns = new ArrayList<DeviceNumber>();
                while (iter.hasNext()) {
                    DeviceNumber dn = (DeviceNumber)iter.next();
                    int idx = Collections.binarySearch(dns, dn);
                    dns.add(idx < 0 ? Math.abs(idx) - 1 : idx, dn);
                }
                CacheLib.addDataToCache(dnMap, dns, clz, rmiMapping.getSerialNumber());
            } else {
                cacheLogger.log(Level.WARNING, "DeviceNumber is already in the cache {0}", rmiMapping);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static DeviceNumber createDeviceNumberFromInfoDetail(String serialNum, Robj_interface_RJiLDEVInfoDetail3 infoDetail, Robj_interface_LUNMgetLDEVStatus statusDetail, Hashtable<Integer, String> raidLevels) throws RemoteException, GetRmiException, SANRmiException, WBEMException {
        DeviceNumber dn = null;
        dn = new DeviceNumber(serialNum, infoDetail.getSLDKC(), infoDetail.getSCU(), infoDetail.getSLDEV(), infoDetail.getLLDEVLBASize(), infoDetail.getIEmulationType());
        dn.healthState = null != statusDetail ? statusDetail.getByLDEVStatus() : (byte)0;
        dn.fb4 = infoDetail.getIFB4();
        dn.pg = infoDetail.getIPG();
        dn.vdev = infoDetail.getIVDEV();
        String rl = raidLevels.get(infoDetail.getIRaidLevel());
        dn.raidLevel = rl == null ? "UNKNOWN" : rl;
        dn.BLUPathCmdDev = infoDetail.isBLUPathCmdDev();
        dn.BSystemLU = infoDetail.isBSystemLU();
        dn.volumeFlag = infoDetail.getByVolumeFlag();
        dn.blockSize = ProviderConstants.UINT64_512;
        dn.volType = infoDetail.getByVolumeType();
        dn.ILUPathNumber = infoDetail.getILUPathNumber();
        dn.mFirstLUNPortID = dn.ILUPathNumber > 0 ? DeviceNumber.getLUPaths(dn) : (short)-1;
        dn.AOUVol = infoDetail.isAOUVvol();
        dn.BJNLVolume = infoDetail.isBJNLVolume();
        dn.externalMFVolume = infoDetail.isExternalMFVolume();
        dn.blockVolume = infoDetail.isBLockVolume();
        dn.SSLPR = infoDetail.getSSLPR();
        dn.SCLPR = infoDetail.getSCLPR();
        dn.MFVolume = infoDetail.isMFVolume();
        dn.middleVolume = infoDetail.isMiddleVolume();
        dn.internalVolume = infoDetail.isInternalVolume();
        dn.QSVvol = infoDetail.isQSVvol();
        dn.byDriveType = infoDetail.getByDriveType();
        dn.normalDrive = infoDetail.isNormalDrive();
        dn.SATADrive = infoDetail.isSATADrive();
        dn.SSDDrive = infoDetail.isSSDDrive();
        dn.BCacheMode = infoDetail.isBCacheMode();
        dn.BRmtCmdDev = infoDetail.isBRmtCmdDev();
        dn.BCvsVolume = infoDetail.isBCvsVolume();
        dn.BEncrypt = infoDetail.isBEncrypt();
        dn.ByEncryptKey = infoDetail.getByEncryptKey();
        dn.ByProtectionLevel = infoDetail.getByProtectionLevel();
        dn.ByCurrentMPBladeID = infoDetail.getByCurrentMPBladeID();
        dn.ByUserMPBladeID = infoDetail.getByUserMPBladeID();
        dn.BLUPathCmdDevSec = infoDetail.isBLUPathCmdDevSec();
        dn.BCmdDevAuth = infoDetail.isBCmdDevAuth();
        dn.BDevGrpDefine = infoDetail.isBDevGrpDefine();
        dn.SPoolID = infoDetail.getSPoolID();
        dn.ByExtDriveType = infoDetail.getByExtDriveType();
        dn.extWWN = infoDetail.getByExtWWN();
        dn.ExtNormalDrive = infoDetail.isExtNormalDrive();
        dn.ExtSATADrive = infoDetail.isExtSATADrive();
        dn.ExtSSDDrive = infoDetail.isExtSSDDrive();
        dn.systemDisk = infoDetail.isBSystemDisk();
        dn.migrationServices = infoDetail.isBHIHSMReserve();
        dn.volumeIsPool = infoDetail.isBPoolVol();
        dn.mVVol = infoDetail.isVvol();
        dn.external = infoDetail.isExternalVolume();
        if (dn.isOpenVolume()) {
            dn.numOfKBytes = infoDetail.getLLDEVSize();
        } else {
            long ldevSize = infoDetail.getLLDEVLBASize();
            dn.numOfKBytes = ProviderLibs.toKBytes(ldevSize);
            dn.numOfCylinders = infoDetail.getLLDEVSize();
        }
        dn.SLUSEElmCount = 1;
        if (dn.SLUSEElmCount > 1) {
            try {
                RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(serialNum);
                RMIObjectCache rmiObj = mapping.getRMIObject();
                CommonClassAsList<LUSEInfo> callback = new CommonClassAsList<LUSEInfo>();
                LUSEInfo.getLUSEInfo(rmiObj, callback, infoDetail.getSLDKC(), infoDetail.getSCU(), infoDetail.getSLDEV());
                LinkedList<LUSEInfo> elements = callback.getReturnValue();
                callback = null;
                LUSEInfo index = elements.poll();
                while (index != null) {
                    List<Long> theComponents = Arrays.asList(index.getComponents());
                    dn.compositeComponents.addAll(theComponents);
                    index = elements.poll();
                }
            }
            catch (WBEMException we) {
                providerLogger.log(Level.SEVERE, "Error creating DeviceNumber for " + serialNum, we);
            }
        }
        dn.consistsOf = ProviderLibs.consistsOf(serialNum, dn.fb4, dn.pg);
        DeviceNumber.setGuardMode(dn, infoDetail.getByLDEVGuardStatus());
        DeviceNumber.setDataOrganization(dn, infoDetail.getByVolumeFlag());
        boolean bl = dn.mReserved = dn.isBlockVolume() || dn.isMigrationServices() || dn.isBJNLVolume() || dn.isSystemDisk();
        dn.mAttribute = dn.isBLUPathCmdDev() || dn.isBRmtCmdDev() ? "CMDDEV" : (dn.isSystemDisk() ? "System Disk" : (dn.isMigrationServices() ? "Reserve" : (dn.isBJNLVolume() ? "Journal" : (dn.isBlockVolume() ? "Quorum Disk" : (dn.isVolumeIsPool() ? "Pool Volume" : "Regular")))));
        return dn;
    }

    private static boolean deviceIDMatchesInfo(Robj_interface_RJiLDEVInfoDetail2 infoDetail, String deviceIDKeyVal) {
        boolean ret = false;
        long devNum = BaseDeviceNumber.makeUniqueDN(infoDetail.getSLDKC(), infoDetail.getSCU(), infoDetail.getSLDEV());
        if (Long.parseLong(deviceIDKeyVal) == devNum) {
            ret = true;
        }
        return ret;
    }

    public static final DeviceNumber find(Robj_interface_RJiLDEVIndex lDevIndex, RMIObjectCache rmiObject) throws WBEMException {
        DeviceNumber ret = null;
        if (null != lDevIndex && null != rmiObject) {
            long dn = BaseDeviceNumber.makeUniqueDN(lDevIndex.getSLDKC(), lDevIndex.getSCU(), lDevIndex.getSLDEV());
            ret = DeviceNumber.find(String.valueOf(dn), false, rmiObject);
        }
        return ret;
    }

    public static final DeviceNumber find(String deviceIDKeyVal, boolean compositeOnly, RMIObjectCache rmiObject) throws WBEMException {
        if (null == rmiObject) {
            throw new WBEMException(6, "Cache object must be passed to 'find' functions");
        }
        DeviceNumber ret = null;
        if (deviceIDKeyVal != null && deviceIDKeyVal.length() > 0) {
            FindDNCallback callback = new FindDNCallback(rmiObject.getSMISMappingContainer().getSerialNumber(), deviceIDKeyVal);
            HitachiCacheInterface cache = rmiObject.smisGetHitachiCacheIF();
            if (cache.isCached(clz)) {
                DeviceNumber.getDNs(rmiObject, callback, false, true, deviceIDKeyVal, -1, -1, -1, compositeOnly);
                ret = (DeviceNumber)callback.getReturnValue();
            } else {
                try {
                    DeviceNumber.getUncachedDNs(rmiObject, callback, false, true, deviceIDKeyVal, -1, -1, -1, compositeOnly, (short)-1);
                    ret = (DeviceNumber)callback.getReturnValue();
                }
                catch (WBEMException we) {
                    throw we;
                }
                catch (Throwable e) {
                    throw new WBEMException(1, e.toString(), null, e);
                }
            }
        }
        return ret;
    }

    public static final DeviceNumber find(String deviceIDKeyVal, RMIObjectCache rmiObject) throws WBEMException {
        return DeviceNumber.find(deviceIDKeyVal, false, rmiObject);
    }

    public static DeviceNumber findHeadLUSE(String deviceIDKeyVal, RMIObjectCache rmiObj) throws WBEMException {
        try {
            DeviceNumber dn;
            if (null != deviceIDKeyVal && null != rmiObj && null != (dn = DeviceNumber.find(deviceIDKeyVal, rmiObj))) {
                if (dn.getSLUSEElmCount() != 0) {
                    return dn;
                }
                CommonClassAsList<LUSEInfo> callback = new CommonClassAsList<LUSEInfo>();
                LUSEInfo.getLUSEInfo(rmiObj, callback);
                LinkedList<LUSEInfo> luseInfos = callback.getReturnValue();
                callback = null;
                LUSEInfo luseInfo = luseInfos.poll();
                while (luseInfo != null) {
                    Long headDN = luseInfo.findHeadLuse(deviceIDKeyVal);
                    if (-1L != headDN) {
                        luseInfos.clear();
                        return DeviceNumber.find(headDN.toString(), rmiObj);
                    }
                    luseInfo = luseInfos.poll();
                }
            }
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
        return null;
    }

    public static String getCacheKeyName() {
        return clzName;
    }

    private static final void getDNs(IteratorCallback<DeviceNumber> callback, boolean isObjectPath, boolean hasProperties, String deviceIDKeyVal, int pFB4, int pPG, int pVdev, boolean pCompositeOnly) throws WBEMException {
        Collection<RMIObjectMapping> maps = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping map : maps) {
            if (null != map) {
                DeviceNumber.getDNs(map.getRMIObject(), callback, isObjectPath, hasProperties, deviceIDKeyVal, pFB4, pPG, pVdev, pCompositeOnly);
                continue;
            }
            providerLogger.severe("One of the mappings is null.");
        }
    }

    private static void getDNs(IteratorCallback<DeviceNumber> callback, short pCLPRNum) throws WBEMException {
        Collection<RMIObjectMapping> maps = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping map : maps) {
            if (null != map) {
                DeviceNumber.getDNs(map.getRMIObject(), callback, pCLPRNum);
                continue;
            }
            providerLogger.severe("One of the mappings is null.");
        }
    }

    private static final void getDNs(IteratorCallback<DeviceNumber> callback, short pPoolID, boolean compositeOnly, VolumeTypeEnum volType) throws WBEMException {
        Collection<RMIObjectMapping> maps = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping map : maps) {
            if (null != map) {
                DeviceNumber.getDNs(map.getRMIObject(), callback, pPoolID, compositeOnly, volType);
                continue;
            }
            providerLogger.severe("One of the mappings is null.");
        }
    }

    public static final void getDNs(RMIObjectCache rmiObj, IteratorCallback<DeviceNumber> callback, boolean isObjectPath, boolean hasProperties, String deviceIDKeyVal) throws WBEMException {
        DeviceNumber.getDNs(rmiObj, callback, isObjectPath, hasProperties, deviceIDKeyVal, -1, -1, -1, false);
    }

    public static final void getDNs(RMIObjectCache rmiObj, IteratorCallback<DeviceNumber> callback, boolean isObjectPath, boolean hasProperties, String deviceIDKeyVal, boolean compositeOnly) throws WBEMException {
        DeviceNumber.getDNs(rmiObj, callback, isObjectPath, hasProperties, deviceIDKeyVal, -1, -1, -1, compositeOnly);
    }

    public static final void getDNs(RMIObjectCache rmiObj, IteratorCallback<DeviceNumber> callback, boolean isObjectPath, boolean hasProperties, String deviceIDKeyVal, int pFB4, int pPG, int pVdev) throws WBEMException {
        DeviceNumber.getDNs(rmiObj, callback, isObjectPath, hasProperties, deviceIDKeyVal, pFB4, pPG, pVdev, false);
    }

    public static final void getDNs(RMIObjectCache rmiObj, IteratorCallback<DeviceNumber> callback, boolean isObjectPath, boolean hasProperties, String deviceIDKeyVal, int pFB4, int pPG, int pVdev, boolean pCompositeOnly) throws WBEMException {
        if (null == rmiObj) {
            DeviceNumber.getDNs(callback, isObjectPath, hasProperties, deviceIDKeyVal, pFB4, pPG, pVdev, pCompositeOnly);
            return;
        }
        try {
            HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
            if (cache.isCached(clz)) {
                AbstractBaseCommonObject[] devNums = (DeviceNumber[])cache.getCachedObject(clz);
                if (devNums != null) {
                    short[] vals = BaseDeviceNumber.getDevIdStringValues(deviceIDKeyVal);
                    DNComparator comparator = new DNComparator(false, false, -1, pFB4, pPG, pVdev, vals[0], vals[1], vals[2], -1, true);
                    callback.returnItems(devNums, comparator);
                } else {
                    callback.done();
                }
            } else {
                providerLogger.log(Level.WARNING, "DeviceNumber not cached on {0}, performance issue", rmiObj.getSMISMappingContainer());
                DeviceNumber.getUncachedDNs(rmiObj, callback, isObjectPath, hasProperties, deviceIDKeyVal, pFB4, pPG, pVdev, pCompositeOnly, (short)-1);
            }
        }
        catch (Throwable e) {
            providerLogger.log(Level.SEVERE, "WBEMException caught from " + rmiObj.getSMISMappingContainer() + " looking for ThinPool with DeviceID:" + deviceIDKeyVal + ", FB4 #:" + pFB4 + ", PG #: " + pPG + ", VDEV #: " + pVdev + ", Composite: " + pCompositeOnly, e);
            WBEMException we = new WBEMException(1, e.toString(), null, e);
            callback.exceptionOccurred(we);
            callback.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void getDNs(RMIObjectCache rmiObj, IteratorCallback<DeviceNumber> callback, short pCLPRNum) throws WBEMException {
        if (null == rmiObj) {
            DeviceNumber.getDNs(callback, pCLPRNum);
            return;
        }
        try {
            HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
            if (cache.isCached(clz)) {
                AbstractBaseCommonObject[] dns = (DeviceNumber[])cache.getCachedObject(clz);
                if (dns != null) {
                    boolean aouqs = -1 != pCLPRNum;
                    DNComparator comparator = new DNComparator(aouqs, aouqs, -1, -1, -1, -1, -1, -1, -1, pCLPRNum, true);
                    callback.returnItems(dns, comparator);
                    dns = null;
                } else {
                    providerLogger.log(Level.INFO, "No DeviceNumbers in cache for {0}", new Object[]{rmiObj.getSMISMappingContainer()});
                }
            } else {
                providerLogger.log(Level.WARNING, "getDNs: DeviceNumber is not cached for {0}, this is a serious performance issue", rmiObj.getSMISMappingContainer());
                DeviceNumber.getUncachedDNs(rmiObj, callback, false, true, null, -1, -1, -1, false, pCLPRNum);
            }
        }
        catch (Throwable e) {
            WBEMException we = new WBEMException(1, e.toString(), null, e);
            callback.exceptionOccurred(we);
        }
        finally {
            callback.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void getDNs(RMIObjectCache rmiObj, IteratorCallback<DeviceNumber> callback, short pPoolID, boolean compositeOnly, VolumeTypeEnum volType) throws WBEMException {
        if (null == rmiObj) {
            DeviceNumber.getDNs(callback, pPoolID, compositeOnly, volType);
            return;
        }
        try {
            boolean qsOnly;
            boolean aouOnly;
            HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
            if (volType == VolumeTypeEnum.AOUVOL || volType == VolumeTypeEnum.NON_QSVVOL) {
                aouOnly = true;
                qsOnly = false;
            } else if (volType == VolumeTypeEnum.QSVVOL || volType == VolumeTypeEnum.NON_AOUVOL) {
                aouOnly = false;
                qsOnly = true;
            } else if (volType == VolumeTypeEnum.AOUVOL_OR_QSVVOL) {
                qsOnly = true;
                aouOnly = true;
            } else {
                providerLogger.log(Level.INFO, "Type of AOU/QS volume must be specified, {0} is an invalid option. Device: {1}", new Object[]{volType, rmiObj.getSMISMappingContainer()});
                throw new WBEMException("Invalid VolumeType");
            }
            DNComparator<DeviceNumber> comparator = new DNComparator<DeviceNumber>(aouOnly, qsOnly, pPoolID);
            if (cache.isCached(clz)) {
                AbstractBaseCommonObject[] dns = (DeviceNumber[])cache.getCachedObject(clz);
                if (dns != null) {
                    callback.returnItems(dns, comparator);
                } else {
                    providerLogger.log(Level.FINE, "No DeviceNumbers (LDEVs) found in cache for {0}", rmiObj.getSMISMappingContainer());
                    callback.done();
                }
            } else {
                LogRecord record = new LogRecord(Level.WARNING, "DeviceNumber not cached on {0}, performance issue");
                record.setParameters(new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber()});
                record.setThrown(new Exception(record.getMessage()));
                cacheLogger.log(record);
                ClosableAddableIteratorCB<DeviceNumber> allDNs = new ClosableAddableIteratorCB<DeviceNumber>();
                DeviceNumber.getUncachedDNs(rmiObj, allDNs, false, true, null, -1, -1, -1, false, (short)-1);
                CloseableAddableIterator<DeviceNumber> iter = allDNs.getWrappedCloseableAddableIter();
                while (iter.hasNext()) {
                    DeviceNumber dn = (DeviceNumber)iter.next();
                    if (null != comparator && !comparator.isMatch(dn)) continue;
                    callback.returnItem(dn);
                }
            }
        }
        catch (Throwable e) {
            WBEMException we = new WBEMException(1, e.toString(), null, e);
            callback.exceptionOccurred(we);
        }
        finally {
            callback.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getDNsBasedOnCUnLDEV(RMIObjectCache rmiObj, IteratorCallback<DeviceNumber> callback, LinkedList<Short[]> pList) throws WBEMException, RemoteException, SANRmiException, GetRmiException {
        block14: {
            boolean needToCloseCallback = true;
            try {
                LinkedList<Robj_interface_RJiCUIndex> addedCU = null;
                LinkedList<Object> addedLDEV = new LinkedList<Object>();
                cacheLogger.log(Level.INFO, "Getting DNs based on CU and LDEV for {0}", rmiObj.getSMISMappingContainer());
                Short[] cuLdevVals = pList.poll();
                while (cuLdevVals != null) {
                    Robj_interface_RJiCUIndex index;
                    short cuIndex = cuLdevVals[0];
                    short ldevIndex = cuLdevVals[1];
                    if (-1 == ldevIndex) {
                        if (addedCU == null) {
                            addedCU = new LinkedList<Robj_interface_RJiCUIndex>();
                        }
                        cacheLogger.log(Level.FINE, "Creating RJiCUIndex: {0} on {1} ", new Object[]{rmiObj.getSMISMappingContainer(), cuIndex});
                        index = (Robj_interface_RJiCUIndex)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJICUINDEX);
                        index.setSLDKC((short)0);
                        index.setSCU(cuIndex);
                        addedCU.offer(index);
                    } else {
                        cacheLogger.log(Level.FINE, "Creating RJiLDEVindex({0}, {1}) on {2}", new Object[]{cuIndex, ldevIndex, rmiObj.getSMISMappingContainer()});
                        index = (Robj_interface_RJiLDEVIndex)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJILDEVINDEX);
                        index.setSLDKC((short)0);
                        index.setSLDEV(ldevIndex);
                        index.setSCU(cuIndex);
                        addedLDEV.offer(index);
                    }
                    cuLdevVals = pList.poll();
                }
                if (addedCU != null && !addedCU.isEmpty()) {
                    cacheLogger.log(Level.INFO, "Looking up {0} RJiCUIndexes on {1}", new Object[]{addedCU.size(), rmiObj.getSMISMappingContainer()});
                    Robj_interface_RJiLDEVIndex[] indexes = rmiObj.getLDEVIndex(addedCU.toArray(new Robj_interface_RJiCUIndex[addedCU.size()]));
                    addedLDEV.addAll(Arrays.asList(indexes));
                }
                if (!addedLDEV.isEmpty()) {
                    Robj_interface_RJiLDEVIndex[] indexes = addedLDEV.toArray(new Robj_interface_RJiLDEVIndex[addedLDEV.size()]);
                    Robj_interface_LUNMgetLDEVStatus[] status = rmiObj.getLDEVStatus(indexes);
                    Robj_interface_RJiLDEVInfoDetail3[] infoDetails = rmiObj.smisGetLDEVInfoDetail3(indexes);
                    Hashtable<Integer, String> raidLevels = ProviderLibs.getSupportedRaidLevels();
                    TaskStop task = null;
                    if (infoDetails.length > 3) {
                        task = new TaskProcessor("DevNum-update - " + rmiObj.getSMISMappingContainer(), infoDetails.length);
                    }
                    for (int idx = 0; idx < infoDetails.length; ++idx) {
                        if (task != null) {
                            if (task.shouldStop()) {
                                callback.done();
                                break block14;
                            }
                            WorkerThread worker = new WorkerThread(callback, rmiObj.getSMISMappingContainer().getSerialNumber(), infoDetails[idx], status, raidLevels, false, null, -1, true, false, (TaskProcessor)task);
                            ProcessTask.addTask(worker);
                            needToCloseCallback = false;
                            continue;
                        }
                        callback.returnItem(DeviceNumber.createDeviceNumberFromInfoDetail(rmiObj.getSMISMappingContainer().getSerialNumber(), infoDetails[idx], status[idx], raidLevels));
                    }
                    break block14;
                }
                cacheLogger.log(Level.INFO, "Did not find any changed CU and LDEVs on {0}", rmiObj.getSMISMappingContainer());
            }
            finally {
                cacheLogger.log(Level.INFO, "Done getting DNs based on CU and LDEV on {0}", rmiObj.getSMISMappingContainer());
                if (needToCloseCallback) {
                    callback.done();
                }
            }
        }
    }

    private static LinkedList<DeviceNumber> getDNsBasedOnCUnLDEV(String serialNum, LinkedList<Short[]> pList) throws WBEMException, RemoteException, SANRmiException, GetRmiException {
        CommonClassAsList<DeviceNumber> callback = new CommonClassAsList<DeviceNumber>();
        DeviceNumber.getDNsBasedOnCUnLDEV(RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject(), callback, pList);
        return callback.getReturnValue();
    }

    private static Robj_interface_RJiLDEVIndex[] getLDEVIndexesByCU(String deviceIDKeyVal, RMIObjectCache rmiObj) throws RemoteException, SANRmiException {
        Robj_interface_RJiCUIndex[] cus;
        short[] vals = BaseDeviceNumber.getDevIdStringValues(deviceIDKeyVal);
        ArrayList<Robj_interface_RJiCUIndex> cuIndexes = new ArrayList<Robj_interface_RJiCUIndex>();
        Robj_interface_RJiLDKCIndex[] dkcs = rmiObj.getLDKCIndex();
        for (Robj_interface_RJiCUIndex cu : cus = rmiObj.getCUIndex(dkcs)) {
            if (cu.getSLDKC() == vals[0] && cu.getSCU() == vals[1]) {
                cuIndexes.add(cu);
                continue;
            }
            if (cu.getSLDKC() > vals[0] || cu.getSCU() > vals[1]) break;
        }
        return rmiObj.getLDEVIndex(cuIndexes.toArray(new Robj_interface_RJiCUIndex[cuIndexes.size()]));
    }

    private static Robj_interface_RJiLDEVIndex[] getLDEVIndexesByVDEV(int pFB4, int pPG, int pVdev, RMIObjectCache rmiObj) throws RemoteException, SANRmiException {
        Robj_interface_RJSetGettingParamDevice param = (Robj_interface_RJSetGettingParamDevice)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.SetGettingParam);
        param.setBAllDevice(true);
        Robj_interface_RJiVDEVIndex[] vdevs = rmiObj.getVDEVIndex(param);
        ArrayList<Robj_interface_RJiVDEVIndex> vDevIndexes = new ArrayList<Robj_interface_RJiVDEVIndex>();
        for (Robj_interface_RJiVDEVIndex vdev : vdevs) {
            if (!(vdev.getIFB4() != pFB4 || pPG != -1 && vdev.getIPG() != pPG || pVdev != -1 && vdev.getIVDEV() != pVdev)) {
                vDevIndexes.add(vdev);
                continue;
            }
            if (vdev.getIFB4() > pFB4 && pPG != -1 && vdev.getIPG() > pPG) break;
        }
        return rmiObj.getLDEVIndex(vDevIndexes.toArray(new Robj_interface_RJiVDEVIndex[vDevIndexes.size()]));
    }

    protected static short getLUPaths(DeviceNumber dn) throws WBEMException {
        short ret = -1;
        RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber());
        RMIObjectCache rmiObj = mapping.getRMIObject();
        CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
        try {
            LUPathObject.getLUPaths(rmiObj, callback, dn.getDn());
            LinkedList<LUPathObject> paths = callback.getReturnValue();
            callback = null;
            ret = paths.size() > 0 ? (short)((LUPathObject)paths.get(0)).getSPort() : (short)-1;
            paths.clear();
        }
        catch (WBEMException e) {
            ret = -1;
            providerLogger.log(Level.SEVERE, "Error occured trying to determine if DN(" + dn + ") has LU Paths", e);
        }
        return ret;
    }

    private static void getUncachedDNs(RMIObjectCache rmiObj, IteratorCallback<DeviceNumber> callback, boolean isObjectPath, boolean hasProperties, String deviceIDKeyVal, int pFB4, int pPG, int pVdev, boolean pCompositeOnly, short pCLPRNum) throws RemoteException, GetRmiException, SANRmiException, WBEMException {
        Thread t = new Thread(new ThreadedGetUnCachedDNs(rmiObj, callback, isObjectPath, hasProperties, deviceIDKeyVal, pFB4, pPG, pVdev, pCompositeOnly, pCLPRNum));
        t.setDaemon(true);
        t.setName("getUncachedDNs");
        t.start();
    }

    public static String getVolTypeAsString(byte volType) {
        String ret = null;
        switch (volType) {
            case 0: {
                ret = VOL_TYPE_BASIC;
                break;
            }
            case 1: {
                ret = VOL_TYPE_EXTERNAL;
                break;
            }
            case 2: {
                ret = VOL_TYPE_COW_SNAPSHOT;
                break;
            }
            case 3: {
                ret = VOL_TYPE_DYNAMIC;
                break;
            }
            default: {
                ret = "";
            }
        }
        return ret;
    }

    public static DeviceNumber[] modifyCachedDN(LinkedList<Short[]> pList, String serialNum) throws WBEMException {
        LinkedList<DeviceNumber> newDNs;
        ArrayList<DeviceNumber> ret = new ArrayList<DeviceNumber>(pList.size());
        cacheLogger.log(Level.INFO, "Processing {0} Modified DNs on {1}", new Object[]{pList.size(), serialNum});
        try {
            RMIObjectMapping rmiMapping = RMIObjectMapping.getRMIObjectMapping(serialNum);
            DeviceNumberAOUProcessor.cache(rmiMapping);
            newDNs = DeviceNumber.getDNsBasedOnCUnLDEV(serialNum, pList);
        }
        catch (RemoteException e) {
            throw new WBEMException(1, "RemoteException getting LDEV info from " + serialNum, null, (Throwable)e);
        }
        catch (SANRmiException e) {
            throw new WBEMException(1, "SANRmiException getting LDEV info from " + serialNum, null, (Throwable)e);
        }
        catch (GetRmiException e) {
            throw new WBEMException(1, "GetRmiException getting LDEV info from " + serialNum, null, (Throwable)e);
        }
        Wait4ProcessTasks task = new Wait4ProcessTasks(newDNs.size());
        DeviceNumber newDN = newDNs.poll();
        while (newDN != null) {
            ModifyCacheThread worker = new ModifyCacheThread(newDN, ret, task, cacheLogger);
            ProcessTask.addTask(worker);
            newDN = newDNs.poll();
        }
        task.processingDone();
        cacheLogger.log(Level.INFO, "Done processing modified DNs on {0}", serialNum);
        return ret.toArray(new DeviceNumber[ret.size()]);
    }

    public static void modifyCachedDNs(HashSet<Short[]> changeIndicated, List<DeviceNumber> added, List<DeviceNumber> modified, List<DeviceNumber> removed, String serialNum) {
        try {
            DeviceNumber dnFrmBackEnd;
            RMIObjectMapping rmiMapping = RMIObjectMapping.getRMIObjectMapping(serialNum);
            RMIObjectCache rmiObj = rmiMapping.getRMIObject();
            DeviceNumberAOUProcessor.cache(rmiMapping);
            CommonClassAsList<DeviceNumber> callbackBE = new CommonClassAsList<DeviceNumber>();
            CommonClassAsList<DeviceNumber> cacheCB = new CommonClassAsList<DeviceNumber>();
            cacheLogger.log(Level.INFO, "Processing {0} Modified CUs for {1}", new Object[]{changeIndicated.size(), serialNum});
            DeviceNumber.getDNsBasedOnCUnLDEV(rmiObj, callbackBE, new LinkedList<Short[]>(changeIndicated));
            cacheLogger.log(Level.INFO, "Get all DeviceNumbers from cache {0}", serialNum);
            DeviceNumber.getDNs(rmiObj, cacheCB, (short)-1);
            LinkedList<DeviceNumber> cached = cacheCB.getReturnValue();
            cacheCB = null;
            cacheLogger.log(Level.INFO, "Got {0} DNs from cache {1}", new Object[]{cached.size(), serialNum});
            Collections.sort(cached);
            LinkedList<DeviceNumber> actual = callbackBE.getReturnValue();
            cacheLogger.log(Level.INFO, "Got {0} DNs from the backend {1}", new Object[]{actual.size(), serialNum});
            Collections.sort(actual);
            HashMap map = new HashMap();
            Wait4ProcessTasks task = new Wait4ProcessTasks(actual.size());
            while ((dnFrmBackEnd = actual.poll()) != null) {
                ModifyCacheThread worker = new ModifyCacheThread(dnFrmBackEnd, cached, modified, added, map, task, cacheLogger);
                ProcessTask.addTask(worker);
            }
            cacheLogger.log(Level.FINE, "waiting for comparison of  backend, {0} to cached DNs", serialNum);
            task.processingDone();
            cacheLogger.log(Level.FINE, "threads completed comparison of DNs for {0}", serialNum);
            ArrayList<Short> changedCUs = new ArrayList<Short>(changeIndicated.size());
            for (Short[] cuLDEV : changeIndicated) {
                changedCUs.add(cuLDEV[0]);
            }
            Collections.sort(changedCUs);
            for (DeviceNumber dn : cached) {
                if (Collections.binarySearch(changedCUs, dn.getCu()) < 0) continue;
                removed.add(dn);
            }
            if (!added.isEmpty()) {
                cacheLogger.log(Level.INFO, "Adding {0} DNs to {1} cache", new Object[]{added.size(), serialNum});
                CacheLib.addDataToCache(map, added, clz, serialNum);
            }
            if (!removed.isEmpty()) {
                int numRemoved = removed.size();
                map = map.isEmpty() ? map : new HashMap(numRemoved);
                cacheLogger.log(Level.INFO, "Removing {0} DNs from {1} cache", new Object[]{removed.size(), serialNum});
                CacheLib.removeDataFromCache(map, (Serializable[])removed.toArray(new DeviceNumber[numRemoved]), clz, (String)serialNum);
            }
        }
        catch (Throwable t) {
            while (null != t.getCause()) {
                t = t.getCause();
            }
            cacheLogger.log(Level.SEVERE, "Exception trying to update DeviceNumber on " + serialNum, t);
        }
        cacheLogger.log(Level.INFO, "Done updating DNs in cache for ", serialNum);
    }

    private static boolean processInfoDetail(IteratorCallback<DeviceNumber> callback, String serialNum, Robj_interface_RJiLDEVInfoDetail3 infoDetail, Robj_interface_LUNMgetLDEVStatus[] statusDetails, Hashtable<Integer, String> raidLevels, boolean isObjectPath, String deviceIDKeyVal, short clprNum, boolean hasProperties, boolean compositeOnly) throws RemoteException, GetRmiException, SANRmiException, WBEMException {
        int ret = 0;
        if (deviceIDKeyVal != null) {
            ret = DeviceNumber.deviceIDMatchesInfo((Robj_interface_RJiLDEVInfoDetail2)infoDetail, deviceIDKeyVal) ? 1 : 2;
        }
        if (clprNum != -1 && infoDetail.getSCLPR() != clprNum) {
            ret = 2;
        }
        if (ret != 2) {
            Robj_interface_LUNMgetLDEVStatus statusDetail;
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNum);
            RMIObjectCache rmiObj = device.getRMIObject();
            Robj_interface_RJiLDEVIndex key = (Robj_interface_RJiLDEVIndex)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJILDEVINDEX);
            key.setSCU(infoDetail.getSCU());
            key.setSLDKC(infoDetail.getSLDKC());
            key.setSLDEV(infoDetail.getSLDEV());
            int idx = Arrays.binarySearch(statusDetails, key, new HealthStatusComparator());
            if (idx >= 0) {
                statusDetail = statusDetails[idx];
            } else {
                statusDetail = null;
                cacheLogger.log(Level.SEVERE, "Unable to find health status for DN {0}, default to \"OK\"", BaseDeviceNumber.makeUniqueDN(infoDetail.getSLDKC(), infoDetail.getSCU(), infoDetail.getSLDEV()));
            }
            DeviceNumber dn = DeviceNumber.createDeviceNumberFromInfoDetail(serialNum, infoDetail, statusDetail, raidLevels);
            if (!(null == dn || compositeOnly && dn.SLUSEElmCount == 0)) {
                if (ResourceRestriction.isVolumeUsable(dn)) {
                    if (!callback.returnItem(dn)) {
                        ret = -1;
                    }
                } else {
                    cacheLogger.log(Level.FINE, "Skipping DN {0}", dn.getDn());
                }
            }
        } else {
            ret = 0;
        }
        return ret == 0;
    }

    public static DeviceNumber[] removeDNsFromCache(LinkedList<Short[]> pList, String serialNum) throws WBEMException {
        Short[] cuLdevVals;
        ArrayList<DeviceNumber> dns = new ArrayList<DeviceNumber>(pList.size());
        cacheLogger.log(Level.INFO, "Processing {0} removed DNs for {1}", new Object[]{pList.size(), serialNum});
        while ((cuLdevVals = pList.poll()) != null) {
            short cuIndex = cuLdevVals[0];
            short ldevIndex = cuLdevVals[1];
            DNComparator<DeviceNumber> comparator = new DNComparator<DeviceNumber>(-1, cuIndex, ldevIndex);
            HitachiCacheInterface cache = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject().smisGetHitachiCacheIF();
            cacheLogger.log(Level.INFO, "Looking up {0} in cache {1}", new Object[]{comparator, serialNum});
            DeviceNumber[] temp = (DeviceNumber[])cache.getCachedObject(clz);
            cacheLogger.log(Level.INFO, "Cache {0} returned {1} items ", new Object[]{serialNum, temp == null ? "null" : Integer.valueOf(temp.length)});
            if (temp == null) continue;
            for (DeviceNumber dn : temp) {
                if (!comparator.isMatch(dn)) continue;
                dns.add(dn);
            }
        }
        Serializable[] ret = new DeviceNumber[]{};
        cacheLogger.log(Level.INFO, "Removing {0} DNs from cache {1}", new Object[]{dns.size(), serialNum});
        if (dns != null && dns.size() > 0) {
            HashMap dnMap = new HashMap();
            ret = dns.toArray(new DeviceNumber[dns.size()]);
            CacheLib.removeDataFromCache(dnMap, (Serializable[])ret, clz, (String)serialNum);
            cacheLogger.log(Level.INFO, "Done removing DNs from cache {0}", serialNum);
        }
        cacheLogger.log(Level.INFO, "Done processing removed DNs for cache {0}", serialNum);
        return ret;
    }

    private static final void setDataOrganization(DeviceNumber dn, byte byVolumeFlag) {
        switch (byVolumeFlag) {
            case 1: 
            case 2: {
                dn.dataOrganization = ProviderConstants.UINT16_FOUR;
                break;
            }
            case 3: {
                dn.dataOrganization = ProviderConstants.UINT16_TWO;
                break;
            }
            default: {
                providerLogger.severe("setDataOrganization - unknown volumeFlag: " + byVolumeFlag);
                dn.dataOrganization = ProviderConstants.UINT16_ONE;
            }
        }
    }

    private static final void setGuardMode(DeviceNumber dn, byte gs) {
        switch (gs) {
            case -119: {
                dn.mProtected = true;
                dn.guardMode = new UnsignedInteger16[1];
                dn.guardMode[0] = ProviderConstants.UINT16_ZED;
                dn.mVolumeAccess = 4;
                dn.mLUNMaskingAllowed = true;
                break;
            }
            case -127: {
                dn.guardMode = new UnsignedInteger16[1];
                dn.guardMode[0] = ProviderConstants.UINT16_ZED;
                dn.mVolumeAccess = 4;
                break;
            }
            case -126: {
                dn.guardMode = new UnsignedInteger16[1];
                dn.guardMode[0] = ProviderConstants.UINT16_ONE;
                dn.mVolumeAccess = 2;
                break;
            }
            case -118: {
                dn.guardMode = new UnsignedInteger16[1];
                dn.guardMode[0] = ProviderConstants.UINT16_ONE;
                dn.mVolumeAccess = 2;
                dn.mLUNMaskingAllowed = true;
                break;
            }
            case -64: {
                dn.guardMode = new UnsignedInteger16[1];
                dn.guardMode[0] = ProviderConstants.UINT16_EIGHT;
                dn.mVolumeAccess = 1;
                break;
            }
            case -63: {
                dn.guardMode = new UnsignedInteger16[2];
                dn.guardMode[0] = ProviderConstants.UINT16_ZED;
                dn.guardMode[1] = ProviderConstants.UINT16_EIGHT;
                dn.mProtected = true;
                dn.mVolumeAccess = 4;
                break;
            }
            case -62: {
                dn.guardMode = new UnsignedInteger16[2];
                dn.guardMode[0] = ProviderConstants.UINT16_ONE;
                dn.guardMode[1] = ProviderConstants.UINT16_EIGHT;
                dn.mVolumeAccess = 2;
                break;
            }
            case -128: 
            case 0: {
                dn.mVolumeAccess = 1;
                dn.guardMode = null;
                break;
            }
            case -120: {
                dn.mLUNMaskingAllowed = true;
                break;
            }
            default: {
                providerLogger.log(Level.WARNING, "guardMode is null for DN({0}) on {2} value is {2} radix 10", new Object[]{dn.getDNAsString(), ProviderLibs.getHexString(new byte[]{gs}), dn.getSerialNumber()});
                dn.guardMode = null;
            }
        }
    }

    private DeviceNumber(DeviceNumber dn) throws RemoteException, GetRmiException, WBEMException {
        super(dn.getSerialNumber(), dn.getLdkc(), dn.getLdev(), dn.getCu(), dn.getEmulationTypeVal());
        this.copyDN(dn);
    }

    private DeviceNumber(String serialNum, short ldkc, short cu, short ldev, long spaceConsumed, int iEmulationType) throws RemoteException, GetRmiException, WBEMException {
        super(serialNum, ldkc, ldev, cu, iEmulationType);
        this.fb4 = 0;
        this.pg = 0;
        this.vdev = 0;
        this.compositeComponents = new ArrayList(0);
        this.BLUPathCmdDev = false;
        this.BSystemLU = false;
        this.consistsOf = null;
        this.external = false;
        this.guardMode = null;
        this.mProtected = false;
        this.mVolumeAccess = 0;
        this.mLUNMaskingAllowed = false;
        this.migrationServices = false;
        this.need2CalcKBytes = true;
        this.numOfKBytes = 0L;
        this.SLUSEElmCount = 0;
        this.systemDisk = false;
        this.volType = 0;
        this.volumeFlag = 0;
        this.volumeIsPool = false;
        this.mReserved = false;
        this.mVVol = false;
        this.numOfCylinders = -1L;
    }

    private synchronized void calculateNumKBytes() {
        if (this.isAOUPoolVol() || this.isQSPoolVol()) {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            if (this.isOpenVolume()) {
                ThinPool tp;
                try {
                    RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getSerialNumber());
                    RMIObjectCache rmiObj = device.getRMIObject();
                    tp = ThinPool.find(rmiObj, this.getSPoolID(), ThinPool.ThinPoolType.ALL);
                }
                catch (WBEMException we) {
                    tp = null;
                    logger.log(Level.SEVERE, "Unable to get number of kBytes for DeviceNumber " + this.getDNAsString(), we);
                }
                if (tp != null) {
                    ThinPool.PoolVolLDEVInfo ldevInfo = tp.getContainedLDEVInfo(this.getDNAsString());
                    if (ldevInfo != null) {
                        this.numOfKBytes = ldevInfo.getVolPages() * ProviderConstants.THINPOOL_METADATASPACE_CONSTANT / 1024L;
                        this.need2CalcKBytes = false;
                    } else {
                        logger.severe("DN(" + this.getDNAsString() + ") is not contained by ThinPool " + this.getSPoolID());
                    }
                } else {
                    logger.severe("DN(" + this.getDNAsString() + ") says it is contained by ThinPool " + this.getSPoolID() + " but no such ThinPool exists");
                }
            } else {
                logger.severe("DN(" + this.getDNAsString() + ") is not OPEN");
            }
        } else {
            this.need2CalcKBytes = false;
        }
    }

    private boolean checkAOUorQSPoolVol(boolean checkAOU) {
        boolean ret = false;
        try {
            ThinPool.ThinPoolType tpType;
            short tpID;
            RMIObjectMapping mapping;
            RMIObjectCache rmiObj;
            ThinPool tp;
            if (this.isVolumeIsPool() && (tp = ThinPool.find(rmiObj = (mapping = RMIObjectMapping.getRMIObjectMapping(this.getSerialNumber())).getRMIObject(), tpID = this.getSPoolID(), tpType = checkAOU ? ThinPool.ThinPoolType.AOU : ThinPool.ThinPoolType.QS)) != null) {
                if (checkAOU) {
                    if (tp.isAOUPool()) {
                        ret = true;
                    }
                } else if (tp.isSnapShotPool()) {
                    ret = true;
                }
            }
        }
        catch (Throwable t) {
            providerLogger.log(Level.SEVERE, "ThinPool on " + this.getSerialNumber() + " failed find op with exception: " + t.toString(), t);
        }
        return ret;
    }

    private void copyDN(DeviceNumber newDN) {
        cacheLogger.log(Level.FINE, "Copying DN {0}", this.getDn());
        super.copyBDN(newDN);
        this.fb4 = newDN.fb4;
        this.pg = newDN.pg;
        this.vdev = newDN.vdev;
        this.healthState = newDN.healthState;
        this.BLUPathCmdDev = newDN.BLUPathCmdDev;
        this.BSystemLU = newDN.BSystemLU;
        this.consistsOf = newDN.consistsOf;
        this.external = newDN.external;
        this.mProtected = newDN.mProtected;
        this.mVolumeAccess = newDN.mVolumeAccess;
        this.mLUNMaskingAllowed = newDN.mLUNMaskingAllowed;
        this.migrationServices = newDN.migrationServices;
        this.numOfKBytes = newDN.numOfKBytes;
        this.SLUSEElmCount = newDN.SLUSEElmCount;
        this.systemDisk = newDN.systemDisk;
        this.volType = newDN.volType;
        this.volumeFlag = newDN.volumeFlag;
        this.volumeIsPool = newDN.volumeIsPool;
        this.AOUVol = newDN.isAOUVol();
        this.BJNLVolume = newDN.isBJNLVolume();
        this.blockVolume = newDN.isBlockVolume();
        this.externalMFVolume = newDN.isExternalMFVolume();
        this.raidLevel = newDN.getRaidLevel();
        this.dataOrganization = newDN.getDataOrganization();
        this.guardMode = newDN.getGuardMode();
        this.blockSize = new UnsignedInteger64(newDN.getBlockSize().bigIntegerValue());
        this.mFirstLUNPortID = newDN.mFirstLUNPortID;
        this.SSLPR = newDN.getSSLPR();
        this.SCLPR = newDN.getSCLPR();
        this.MFVolume = newDN.isMFVolume();
        this.middleVolume = newDN.isMiddleVolume();
        this.internalVolume = newDN.isInternalVolume();
        this.QSVvol = newDN.isQSVvol();
        this.byDriveType = newDN.getByDriveType();
        this.normalDrive = newDN.isNormalDrive();
        this.SATADrive = newDN.isSATADrive();
        this.SSDDrive = newDN.isSSDDrive();
        this.BCacheMode = newDN.isBCacheMode();
        this.BRmtCmdDev = newDN.isBRmtCmdDev();
        this.BCvsVolume = newDN.isBCvsVolume();
        this.BEncrypt = newDN.isBEncrypt();
        this.ByEncryptKey = newDN.getByEncryptKey();
        this.ByProtectionLevel = newDN.getByProtectionLevel();
        this.ByCurrentMPBladeID = newDN.getByCurrentMPBladeID();
        this.ByUserMPBladeID = newDN.getByUserMPBladeID();
        this.ILUPathNumber = newDN.getILUPathNumber();
        this.BLUPathCmdDevSec = newDN.isBLUPathCmdDevSec();
        this.BCmdDevAuth = newDN.isBCmdDevAuth();
        this.BDevGrpDefine = newDN.isBDevGrpDefine();
        this.SPoolID = newDN.getSPoolID();
        this.ByExtDriveType = newDN.getByExtDriveType();
        byte[] wwns = newDN.getExtWWN();
        if (wwns != null) {
            this.extWWN = new byte[wwns.length];
            for (int x = 0; x < wwns.length; ++x) {
                this.extWWN[x] = wwns[x];
            }
        } else {
            this.extWWN = null;
        }
        this.ExtNormalDrive = newDN.isExtNormalDrive();
        this.ExtSATADrive = newDN.isExtSATADrive();
        this.ExtSSDDrive = newDN.isExtSSDDrive();
        this.guardMode = newDN.guardMode == null ? null : new UnsignedInteger16[newDN.guardMode.length];
        for (int index = 0; this.guardMode != null && index < newDN.guardMode.length; ++index) {
            this.guardMode[index] = new UnsignedInteger16(newDN.guardMode[index].intValue());
        }
        int size = newDN.compositeComponents.size();
        this.compositeComponents = new ArrayList(size);
        for (Long val : newDN.compositeComponents) {
            this.compositeComponents.add(new Long(val));
        }
        cacheLogger.log(Level.FINE, "Done copying DN {0}", this.getDn());
    }

    public boolean denyAsCopyTarget() {
        boolean ret = false;
        if (null != this.guardMode) {
            for (UnsignedInteger16 gm : this.guardMode) {
                if (null == gm || gm.intValue() != 8) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceNumber other = (DeviceNumber)obj;
        if (this.AOUVol != other.AOUVol) {
            return false;
        }
        if (this.BCacheMode != other.BCacheMode) {
            return false;
        }
        if (this.BCmdDevAuth != other.BCmdDevAuth) {
            return false;
        }
        if (this.BCvsVolume != other.BCvsVolume) {
            return false;
        }
        if (this.BDevGrpDefine != other.BDevGrpDefine) {
            return false;
        }
        if (this.BEncrypt != other.BEncrypt) {
            return false;
        }
        if (this.BJNLVolume != other.BJNLVolume) {
            return false;
        }
        if (this.BLUPathCmdDev != other.BLUPathCmdDev) {
            return false;
        }
        if (this.BLUPathCmdDevSec != other.BLUPathCmdDevSec) {
            return false;
        }
        if (this.BRmtCmdDev != other.BRmtCmdDev) {
            return false;
        }
        if (this.BSystemLU != other.BSystemLU) {
            return false;
        }
        if (this.ByCurrentMPBladeID != other.ByCurrentMPBladeID) {
            return false;
        }
        if (this.ByEncryptKey != other.ByEncryptKey) {
            return false;
        }
        if (this.ByExtDriveType != other.ByExtDriveType) {
            return false;
        }
        if (this.ByProtectionLevel != other.ByProtectionLevel) {
            return false;
        }
        if (this.ByUserMPBladeID != other.ByUserMPBladeID) {
            return false;
        }
        if (this.ExtNormalDrive != other.ExtNormalDrive) {
            return false;
        }
        if (this.ExtSATADrive != other.ExtSATADrive) {
            return false;
        }
        if (this.ExtSSDDrive != other.ExtSSDDrive) {
            return false;
        }
        if (this.ILUPathNumber != other.ILUPathNumber) {
            return false;
        }
        if (this.MFVolume != other.MFVolume) {
            return false;
        }
        if (this.QSVvol != other.QSVvol) {
            return false;
        }
        if (this.SATADrive != other.SATADrive) {
            return false;
        }
        if (this.SCLPR != other.SCLPR) {
            return false;
        }
        if (this.SLUSEElmCount != other.SLUSEElmCount) {
            return false;
        }
        if (this.SPoolID != other.SPoolID) {
            return false;
        }
        if (this.SSDDrive != other.SSDDrive) {
            return false;
        }
        if (this.SSLPR != other.SSLPR) {
            return false;
        }
        if (this.blockSize == null ? other.blockSize != null : !this.blockSize.equals((Object)other.blockSize)) {
            return false;
        }
        if (this.blockVolume != other.blockVolume) {
            return false;
        }
        if (this.byDriveType != other.byDriveType) {
            return false;
        }
        if (this.compositeComponents == null ? other.compositeComponents != null : !this.compositeComponents.equals(other.compositeComponents)) {
            return false;
        }
        if (this.consistsOf == null ? other.consistsOf != null : !this.consistsOf.equals((Object)other.consistsOf)) {
            return false;
        }
        if (this.dataOrganization == null ? other.dataOrganization != null : !this.dataOrganization.equals((Object)other.dataOrganization)) {
            return false;
        }
        if (!Arrays.equals(this.extWWN, other.extWWN)) {
            return false;
        }
        if (this.external != other.external) {
            return false;
        }
        if (this.externalMFVolume != other.externalMFVolume) {
            return false;
        }
        if (this.fb4 != other.fb4) {
            return false;
        }
        if (!Arrays.equals(this.guardMode, other.guardMode)) {
            return false;
        }
        if (this.internalVolume != other.internalVolume) {
            return false;
        }
        if (this.mFirstLUNPortID != other.mFirstLUNPortID) {
            return false;
        }
        if (this.mLUNMaskingAllowed != other.mLUNMaskingAllowed) {
            return false;
        }
        if (this.mProtected != other.mProtected) {
            return false;
        }
        if (this.mVolumeAccess != other.mVolumeAccess) {
            return false;
        }
        if (this.middleVolume != other.middleVolume) {
            return false;
        }
        if (this.migrationServices != other.migrationServices) {
            return false;
        }
        if (this.normalDrive != other.normalDrive) {
            return false;
        }
        if (this.getNumOfKBytes() != other.getNumOfKBytes()) {
            return false;
        }
        if (this.pg != other.pg) {
            return false;
        }
        if (this.raidLevel == null ? other.raidLevel != null : !this.raidLevel.equals(other.raidLevel)) {
            return false;
        }
        if (this.systemDisk != other.systemDisk) {
            return false;
        }
        if (this.vdev != other.vdev) {
            return false;
        }
        if (this.volType != other.volType) {
            return false;
        }
        if (this.volumeFlag != other.volumeFlag) {
            return false;
        }
        if (this.volumeIsPool != other.volumeIsPool) {
            return false;
        }
        return this.healthState == other.healthState;
    }

    public String getAttribute() {
        return this.mAttribute;
    }

    public UnsignedInteger64 getBlockSize() {
        return this.blockSize;
    }

    public byte getByCurrentMPBladeID() {
        return this.ByCurrentMPBladeID;
    }

    public byte getByDriveType() {
        return this.byDriveType;
    }

    public byte getByEncryptKey() {
        return this.ByEncryptKey;
    }

    public byte getByExtDriveType() {
        return this.ByExtDriveType;
    }

    public byte getByProtectionLevel() {
        return this.ByProtectionLevel;
    }

    public byte getByUserMPBladeID() {
        return this.ByUserMPBladeID;
    }

    public Long[] getCompositeComponents() {
        return this.compositeComponents.toArray(new Long[this.compositeComponents.size()]);
    }

    public UnsignedInteger16 getConsistsOf(RMIObjectCache rmiobj) throws RemoteException, SANRmiException {
        UnsignedInteger16 ret = this.consistsOf;
        if (ret == null) {
            ret = rmiobj != null ? (this.consistsOf = ProviderLibs.consistsOf(rmiobj, this.getFb4(), this.getPg())) : ProviderConstants.UINT16_ZED;
        }
        return ret;
    }

    public UnsignedInteger16 getDataOrganization() {
        return this.dataOrganization;
    }

    public byte[] getExtWWN() {
        return this.extWWN;
    }

    public int getFb4() {
        return this.fb4;
    }

    public short getFirstLUNPort() {
        return this.mFirstLUNPortID;
    }

    public UnsignedInteger16[] getGuardMode() {
        return this.guardMode;
    }

    public UnsignedInteger16 getHealthState() {
        UnsignedInteger16 ret;
        switch (this.healthState) {
            case 2: {
                ret = new UnsignedInteger16(20);
                break;
            }
            case 6: {
                ret = ProviderConstants.UINT16_ZED;
                break;
            }
            default: {
                ret = ProviderConstants.UINT16_FIVE;
            }
        }
        return ret;
    }

    public int getILUPathNumber() {
        return this.ILUPathNumber;
    }

    public UnsignedInteger64 getNumOfBlocks() {
        return new UnsignedInteger64(BigInteger.valueOf(this.getNumOfBlocksAsLong()));
    }

    public long getNumOfBlocksAsLong() {
        Long[] compLDevNums = this.getCompositeComponents();
        long numOfBlocks = 0L;
        if (compLDevNums.length == 0) {
            numOfBlocks = this.getNumOfKBytes() * 1024L / this.blockSize.longValue();
        } else {
            WBEMException we = null;
            for (Long compLDevNum : compLDevNums) {
                DeviceNumber compLDev;
                try {
                    compLDev = DeviceNumber.find(compLDevNum.toString(), RMIObjectMapping.getRMIObjectMapping(this.getSerialNumber()).getRMIObject());
                }
                catch (WBEMException e) {
                    we = e;
                    compLDev = null;
                }
                if (null != compLDev) {
                    numOfBlocks += compLDev.getNumOfBytes() / this.blockSize.longValue();
                    continue;
                }
                providerLogger.log(Level.SEVERE, "Unable to get # of blocks for component DN: " + compLDevNum + "on " + this.getSerialNumber(), we);
            }
        }
        return numOfBlocks;
    }

    public long getNumOfBytes() {
        return this.getNumOfKBytes() * 1024L;
    }

    public long getNumOfCylinders() {
        return this.numOfCylinders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumOfKBytes() {
        if (this.need2CalcKBytes) {
            DeviceNumber deviceNumber = this;
            synchronized (deviceNumber) {
                if (this.need2CalcKBytes) {
                    this.calculateNumKBytes();
                }
            }
        }
        return -1L == this.numOfKBytes ? 0L : this.numOfKBytes;
    }

    public int getPg() {
        return this.pg;
    }

    public String getRaidLevel() {
        return this.raidLevel;
    }

    public byte getRawHealthState() {
        return this.healthState;
    }

    public short getSCLPR() {
        return this.SCLPR;
    }

    public short getSLUSEElmCount() {
        return this.SLUSEElmCount;
    }

    public long getSpaceConsumed() {
        long ret = 0L;
        if (3 == this.volType) {
            DeviceNumberAOUProcessor.DeviceNumberAOUInfo aouInfo = DeviceNumberAOUProcessor.findAOUInfo(this);
            if (null != aouInfo) {
                ret = aouInfo.getAouVolUsed();
            } else {
                providerLogger.log(Level.FINE, "unable to find AOUVolInf for DN {0}, this is OK. Default space consumed to \"0\"", this.getDn());
                ret = 0L;
            }
        } else {
            ret = this.isAOUPoolVol() || this.isQSPoolVol() ? 0L : this.getNumOfBlocksAsLong() * this.blockSize.longValue();
        }
        return ret;
    }

    public short getSPoolID() {
        return this.SPoolID;
    }

    public short getSSLPR() {
        return this.SSLPR;
    }

    public short getThinPoolID() {
        DeviceNumberAOUProcessor.DeviceNumberAOUInfo aouInfo = DeviceNumberAOUProcessor.findAOUInfo(this);
        return null == aouInfo ? (short)-1 : (short)aouInfo.getPoolID();
    }

    public UnsignedInteger16 getUsageValue() {
        UnsignedInteger16 ret = ProviderConstants.UINT16_ONE;
        boolean sourceCandidate = this.isSourceCandidate();
        boolean targetCandidate = this.isTargetCandidate();
        byte volFlag = this.getVolumeFlag();
        providerLogger.fine("DN(" + this.getDNAsString() + ") volFlag: " + volFlag);
        if (volFlag != 2) {
            ret = ProviderConstants.UINT16_TWO;
            boolean remoteReplica = RmcpPairInfo.isRemoteReplica(this);
            boolean deltaReplica = this.volType == 2;
            boolean localReplica = this.isLocalReplica();
            if (this.isCommandDevice() || this.isSystemDisk()) {
                providerLogger.fine("DN(" + this.getDNAsString() + ") is commandDevice(" + this.isCommandDevice() + ") or" + "systemDisk(" + this.isSystemDisk() + ")");
                ret = ProviderConstants.UINT16_THREE;
            } else if (this.isMigrationServices()) {
                providerLogger.fine("DN(" + this.getDNAsString() + ") Migration srvc");
                ret = ProviderConstants.UINT16_FIVE;
            } else if (deltaReplica) {
                providerLogger.fine("DN(" + this.getDNAsString() + ") is Delta replica");
                ret = ProviderConstants.UINT16_TWELVE;
            }
            if (this.isAOUPoolVol()) {
                providerLogger.fine("DN(" + this.getDNAsString() + ") is AOUPoolVol");
                ret = ProviderConstants.UINT16_32769;
            }
            if (this.isQSPoolVol()) {
                providerLogger.fine("DN(" + this.getDNAsString() + ") is QSPoolVol");
                ret = ProviderConstants.UINT16_ONE;
            }
            if (this.volType == 3) {
                providerLogger.fine("DN(" + this.getDNAsString() + ") is thin provisioned");
                ret = localReplica && sourceCandidate && targetCandidate ? new UnsignedInteger16(32772) : (localReplica && sourceCandidate ? new UnsignedInteger16(32770) : (localReplica && targetCandidate ? new UnsignedInteger16(32771) : ProviderConstants.UINT16_32768));
            } else if (localReplica) {
                ret = sourceCandidate && targetCandidate ? ProviderConstants.UINT16_TEN : (sourceCandidate ? ProviderConstants.UINT16_SIX : (targetCandidate ? ProviderConstants.UINT16_EIGHT : ProviderConstants.UINT16_FOUR));
            } else if (remoteReplica) {
                ret = sourceCandidate ? ProviderConstants.UINT16_SEVEN : (targetCandidate ? ProviderConstants.UINT16_NINE : ProviderConstants.UINT16_FOUR);
            }
        }
        return ret;
    }

    public int getVdev() {
        return this.vdev;
    }

    public int getVolAccess() {
        return this.mVolumeAccess;
    }

    public Hashtable<String, Short> getVolAtrbHash() {
        return volAtrbHash;
    }

    public byte getVolType() {
        return this.volType;
    }

    public String getVolTypeAsString() {
        return DeviceNumber.getVolTypeAsString(this.volType);
    }

    public byte getVolumeFlag() {
        return this.volumeFlag;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.AOUVol ? 1231 : 1237);
        result = 31 * result + (this.BCacheMode ? 1231 : 1237);
        result = 31 * result + (this.BCmdDevAuth ? 1231 : 1237);
        result = 31 * result + (this.BCvsVolume ? 1231 : 1237);
        result = 31 * result + (this.BDevGrpDefine ? 1231 : 1237);
        result = 31 * result + (this.BEncrypt ? 1231 : 1237);
        result = 31 * result + (this.BJNLVolume ? 1231 : 1237);
        result = 31 * result + (this.BLUPathCmdDev ? 1231 : 1237);
        result = 31 * result + (this.BLUPathCmdDevSec ? 1231 : 1237);
        result = 31 * result + (this.BRmtCmdDev ? 1231 : 1237);
        result = 31 * result + (this.BSystemLU ? 1231 : 1237);
        result = 31 * result + this.ByCurrentMPBladeID;
        result = 31 * result + this.ByEncryptKey;
        result = 31 * result + this.ByExtDriveType;
        result = 31 * result + this.ByProtectionLevel;
        result = 31 * result + this.ByUserMPBladeID;
        result = 31 * result + (this.ExtNormalDrive ? 1231 : 1237);
        result = 31 * result + (this.ExtSATADrive ? 1231 : 1237);
        result = 31 * result + (this.ExtSSDDrive ? 1231 : 1237);
        result = 31 * result + this.ILUPathNumber;
        result = 31 * result + (this.MFVolume ? 1231 : 1237);
        result = 31 * result + (this.QSVvol ? 1231 : 1237);
        result = 31 * result + (this.SATADrive ? 1231 : 1237);
        result = 31 * result + this.SCLPR;
        result = 31 * result + this.SLUSEElmCount;
        result = 31 * result + this.SPoolID;
        result = 31 * result + (this.SSDDrive ? 1231 : 1237);
        result = 31 * result + this.SSLPR;
        result = 31 * result + (this.blockSize == null ? 0 : this.blockSize.hashCode());
        result = 31 * result + (this.blockVolume ? 1231 : 1237);
        result = 31 * result + this.byDriveType;
        result = 31 * result + (this.compositeComponents == null ? 0 : this.compositeComponents.hashCode());
        result = 31 * result + (this.consistsOf == null ? 0 : this.consistsOf.hashCode());
        result = 31 * result + (this.dataOrganization == null ? 0 : this.dataOrganization.hashCode());
        result = 31 * result + Arrays.hashCode(this.extWWN);
        result = 31 * result + (this.external ? 1231 : 1237);
        result = 31 * result + (this.externalMFVolume ? 1231 : 1237);
        result = 31 * result + this.fb4;
        result = 31 * result + Arrays.hashCode(this.guardMode);
        result = 31 * result + (this.internalVolume ? 1231 : 1237);
        result = 31 * result + this.mFirstLUNPortID;
        result = 31 * result + (this.mLUNMaskingAllowed ? 1231 : 1237);
        result = 31 * result + (this.mProtected ? 1231 : 1237);
        result = 31 * result + this.mVolumeAccess;
        result = 31 * result + (this.middleVolume ? 1231 : 1237);
        result = 31 * result + (this.migrationServices ? 1231 : 1237);
        result = 31 * result + (this.normalDrive ? 1231 : 1237);
        long kBytes = this.getNumOfKBytes();
        result = 31 * result + (int)(kBytes ^ kBytes >>> 32);
        result = 31 * result + this.pg;
        result = 31 * result + (this.raidLevel == null ? 0 : this.raidLevel.hashCode());
        result = 31 * result + (this.systemDisk ? 1231 : 1237);
        result = 31 * result + this.vdev;
        result = 31 * result + this.volType;
        result = 31 * result + this.volumeFlag;
        result = 31 * result + (this.volumeIsPool ? 1231 : 1237);
        return result;
    }

    public boolean hasPaths() throws WBEMException {
        boolean ret = false;
        CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
        RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(this.getSerialNumber());
        RMIObjectCache rmiObj = mapping.getRMIObject();
        LUPathObject.getLUPaths(rmiObj, callback, this.getDn());
        LinkedList<LUPathObject> pathInfo = callback.getReturnValue();
        callback = null;
        if (pathInfo != null && pathInfo.size() > 0) {
            ret = true;
        }
        return ret;
    }

    public boolean isAOUPoolVol() {
        return this.checkAOUorQSPoolVol(true);
    }

    public boolean isAOUVol() {
        return this.AOUVol;
    }

    public boolean isBCacheMode() {
        return this.BCacheMode;
    }

    public boolean isBCmdDevAuth() {
        return this.BCmdDevAuth;
    }

    public boolean isBCvsVolume() {
        return this.BCvsVolume;
    }

    public boolean isBDevGrpDefine() {
        return this.BDevGrpDefine;
    }

    public boolean isBEncrypt() {
        return this.BEncrypt;
    }

    public boolean isBJNLVolume() {
        return this.BJNLVolume;
    }

    public boolean isBlockVolume() {
        return this.blockVolume;
    }

    public boolean isBLUPathCmdDev() {
        return this.BLUPathCmdDev;
    }

    public boolean isBLUPathCmdDevSec() {
        return this.BLUPathCmdDevSec;
    }

    public boolean isBRmtCmdDev() {
        return this.BRmtCmdDev;
    }

    public boolean isBSystemLU() {
        return this.BSystemLU;
    }

    public boolean isCommandDevice() {
        return this.BLUPathCmdDev;
    }

    public Boolean isCompressed(RMIObjectCache rmiObj) {
        Boolean ret = Boolean.FALSE;
        if (this.isAOUVol()) {
            DeviceNumberAOUProcessor.DeviceNumberAOUInfo aouInf = DeviceNumberAOUProcessor.findAOUInfo(this);
            if (null != aouInf) {
                ret = aouInf.isCompressed();
            } else {
                providerLogger.log(Level.SEVERE, "DeviceNumber {0} is thin but there is no AOU info", this.getDn());
            }
        }
        return ret;
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean isExternalMFVolume() {
        return this.externalMFVolume;
    }

    public boolean isExtNormalDrive() {
        return this.ExtNormalDrive;
    }

    public boolean isExtSATADrive() {
        return this.ExtSATADrive;
    }

    public boolean isExtSSDDrive() {
        return this.ExtSSDDrive;
    }

    public boolean isInternalVolume() {
        return this.internalVolume;
    }

    public boolean isLocalReplica() {
        return PairInfo.isLocalReplica(this);
    }

    public boolean isLUNMaskingAllowed() {
        return this.mLUNMaskingAllowed;
    }

    public boolean isMFVolume() {
        return this.MFVolume;
    }

    public boolean isMiddleVolume() {
        return this.middleVolume;
    }

    public boolean isMigrationServices() {
        return this.migrationServices;
    }

    public boolean isNormalDrive() {
        return this.normalDrive;
    }

    public boolean isProtected() {
        return this.mProtected;
    }

    public boolean isQSPoolVol() {
        return this.checkAOUorQSPoolVol(false);
    }

    public boolean isQSVvol() {
        return this.QSVvol;
    }

    public boolean isReserved() {
        return this.mReserved;
    }

    private boolean isSame(DeviceNumber newDN) {
        boolean ret = true;
        ret = this.equals(newDN);
        return ret;
    }

    public boolean isSATADrive() {
        return this.SATADrive;
    }

    public boolean isSourceCandidate() {
        Boolean isSource = PairInfo.isSourceCandidate(this);
        return null != isSource && isSource != false;
    }

    public boolean isSSDDrive() {
        return this.SSDDrive;
    }

    public boolean isSystemDisk() {
        return this.systemDisk;
    }

    public boolean isTargetCandidate() {
        Boolean isTarget = PairInfo.isTargetCandidate(this);
        return null != isTarget && isTarget != false;
    }

    public boolean isTierRelocationFrozen() {
        DeviceNumberAOUProcessor.DeviceNumberAOUInfo aouInfo = DeviceNumberAOUProcessor.findAOUInfo(this);
        return aouInfo.isTierRelocationFrozen();
    }

    public boolean isVirtualVolume() {
        return this.mVVol;
    }

    public boolean isVolumeIsPool() {
        return this.volumeIsPool;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.delete(0, 4);
        builder.deleteCharAt(builder.length() - 1);
        builder.append(", blockSize=");
        builder.append(this.blockSize);
        builder.append(", BLUPathCmdDev=");
        builder.append(this.BLUPathCmdDev);
        builder.append(", BSystemLU=");
        builder.append(this.BSystemLU);
        builder.append(", compositeComponents=");
        builder.append(this.compositeComponents);
        builder.append(", consistsOf=");
        builder.append(this.consistsOf);
        builder.append(", dataOrganization=");
        builder.append(this.dataOrganization);
        builder.append(", external=");
        builder.append(this.external);
        builder.append(", fb4=");
        builder.append(this.fb4);
        builder.append(", guardMode=");
        builder.append(Arrays.toString(this.guardMode));
        builder.append(", migrationServices=");
        builder.append(this.migrationServices);
        builder.append(", numOfBytes=");
        builder.append(this.numOfKBytes);
        builder.append(", pg=");
        builder.append(this.pg);
        builder.append(", raidLevel=");
        builder.append(this.raidLevel);
        builder.append(", SLUSEElmCount=");
        builder.append(this.SLUSEElmCount);
        builder.append(", systemDisk=");
        builder.append(this.systemDisk);
        builder.append(", vdev=");
        builder.append(this.vdev);
        builder.append(", volType=");
        builder.append(this.volType);
        builder.append(", volumeFlag=");
        builder.append(this.volumeFlag);
        builder.append(", volumeIsPool=");
        builder.append(this.volumeIsPool);
        builder.append(", mProtected=");
        builder.append(this.mProtected);
        builder.append(", mVolumeAccess=");
        builder.append(this.mVolumeAccess);
        builder.append(", mLUNMaskingAllowed=");
        builder.append(this.mLUNMaskingAllowed);
        builder.append(", AOUVol=");
        builder.append(this.AOUVol);
        if (this.AOUVol) {
            DeviceNumberAOUProcessor.DeviceNumberAOUInfo aouInfo = DeviceNumberAOUProcessor.findAOUInfo(this);
            builder.append(aouInfo);
        }
        builder.append(", BJNLVolume=");
        builder.append(this.BJNLVolume);
        builder.append(", externalMFVolume=");
        builder.append(this.externalMFVolume);
        builder.append(", blockVolume=");
        builder.append(this.blockVolume);
        builder.append(", mFirstLUNPortID=");
        builder.append(this.mFirstLUNPortID);
        builder.append(", SSLPR=");
        builder.append(this.SSLPR);
        builder.append(", SCPLR=");
        builder.append(this.SCLPR);
        builder.append(", MFVolume=");
        builder.append(this.MFVolume);
        builder.append(", middleVolume=");
        builder.append(this.middleVolume);
        builder.append(", internalVolume=");
        builder.append(this.internalVolume);
        builder.append(", QSVvol=");
        builder.append(this.QSVvol);
        builder.append(", byDriveType=");
        builder.append(this.byDriveType);
        builder.append(", normalDrive=");
        builder.append(this.normalDrive);
        builder.append(", SATADrive=");
        builder.append(this.SATADrive);
        builder.append(", SSDDrive=");
        builder.append(this.SSDDrive);
        builder.append(", BCacheMode=");
        builder.append(this.BCacheMode);
        builder.append(", BRmtCmdDev=");
        builder.append(this.BRmtCmdDev);
        builder.append(", BCvsVolume=");
        builder.append(this.BCvsVolume);
        builder.append(", BEncrypt=");
        builder.append(this.BEncrypt);
        builder.append(", ByEncryptKey=");
        builder.append(this.ByEncryptKey);
        builder.append(", ByProtectionLevel=");
        builder.append(this.ByProtectionLevel);
        builder.append(", ByCurrentMPBladeID=");
        builder.append(this.ByCurrentMPBladeID);
        builder.append(", ByUserMPBladeID=");
        builder.append(this.ByUserMPBladeID);
        builder.append(", ILUPathNumber=");
        builder.append(this.ILUPathNumber);
        builder.append(", BLUPathCmdDevSec=");
        builder.append(this.BLUPathCmdDevSec);
        builder.append(", BCmdDevAuth=");
        builder.append(this.BCmdDevAuth);
        builder.append(", BDevGrpDefine=");
        builder.append(this.BDevGrpDefine);
        builder.append(", SPoolID=");
        builder.append(this.SPoolID);
        builder.append(", ByExtDriveType=");
        builder.append(this.ByExtDriveType);
        builder.append(", extWWN=");
        builder.append(Arrays.toString(this.extWWN));
        builder.append(", ExtNormalDrive=");
        builder.append(this.ExtNormalDrive);
        builder.append(", ExtSATADrive=");
        builder.append(this.ExtSATADrive);
        builder.append(", ExtSSDDrive=");
        builder.append(this.ExtSSDDrive);
        builder.append("]");
        return builder.toString();
    }

    private static class WorkerThread
    implements Task {
        private final IteratorCallback<DeviceNumber> callback;
        private final boolean compositeOnly;
        private final String deviceIDKeyVal;
        private final boolean hasProperties;
        private final boolean isObjectPath;
        private final Hashtable<Integer, String> raidLevels;
        private final TaskProcessor theTask;
        private Robj_interface_RJiLDEVInfoDetail3 theVal = null;
        private final short clprNum;
        private final String serialNum;
        private final Robj_interface_LUNMgetLDEVStatus[] statusDetail;

        public WorkerThread(IteratorCallback<DeviceNumber> callback, String serialNum, Robj_interface_RJiLDEVInfoDetail3 val, Robj_interface_LUNMgetLDEVStatus[] statusDetails, Hashtable<Integer, String> raidLevels, boolean isObjectPath, String deviceIDKeyVal, short pCLPRNum, boolean hasProperties, boolean compositeOnly, TaskProcessor pTheTask) {
            this.callback = callback;
            this.serialNum = serialNum;
            this.theVal = val;
            this.statusDetail = statusDetails;
            this.raidLevels = raidLevels;
            this.isObjectPath = isObjectPath;
            this.deviceIDKeyVal = deviceIDKeyVal;
            this.hasProperties = hasProperties;
            this.compositeOnly = compositeOnly;
            this.theTask = pTheTask;
            this.clprNum = pCLPRNum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                boolean ret;
                if (!this.theTask.shouldStop() && !(ret = DeviceNumber.processInfoDetail(this.callback, this.serialNum, this.theVal, this.statusDetail, this.raidLevels, this.isObjectPath, this.deviceIDKeyVal, this.clprNum, this.hasProperties, this.compositeOnly))) {
                    this.theTask.setStop(true);
                }
            }
            catch (Exception e) {
                WBEMException we = e.getClass().isInstance(WBEMException.class) ? (WBEMException)((Object)e) : new WBEMException(1, "Exception while processing items", null, (Throwable)e);
                this.callback.exceptionOccurred(we);
                this.theTask.setStop(true);
            }
            finally {
                int counter = this.theTask.taskDone();
                if (counter < 1) {
                    this.callback.done();
                }
            }
        }
    }

    private static class ThreadedGetUnCachedDNs
    implements Runnable {
        RMIObjectCache rmiObj;
        IteratorCallback<DeviceNumber> callback;
        boolean isObjectPath;
        boolean hasProperties;
        String deviceIDKeyVal;
        int pFB4;
        int pPG;
        int pVdev;
        boolean pCompositeOnly;
        short pCLPRNum;
        private final String serialNum;

        public ThreadedGetUnCachedDNs(RMIObjectCache rmiObj, IteratorCallback<DeviceNumber> callback, boolean isObjectPath, boolean hasProperties, String deviceIDKeyVal, int pFB4, int pPG, int pVdev, boolean pCompositeOnly, short pCLPRNum) throws WBEMException {
            this.serialNum = rmiObj.getSMISMappingContainer().getSerialNumber();
            this.rmiObj = rmiObj;
            this.callback = callback;
            this.isObjectPath = isObjectPath;
            this.hasProperties = hasProperties;
            this.deviceIDKeyVal = deviceIDKeyVal;
            this.pFB4 = pFB4;
            this.pPG = pPG;
            this.pVdev = pVdev;
            this.pCompositeOnly = pCompositeOnly;
            this.pCLPRNum = pCLPRNum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                try {
                    AbstractBaseCommonObject.providerLogger.log(Level.INFO, "entered ThreadedGetUnCachedDNs for {0}", this.serialNum);
                    final String serialNum = this.rmiObj.getSMISMappingContainer().getSerialNumber();
                    Thread t = new Thread("Get SSID Info"){

                        @Override
                        public void run() {
                            try {
                                ProviderLibs.getSSIDInfo(ThreadedGetUnCachedDNs.this.rmiObj);
                            }
                            catch (Throwable t) {
                                AbstractBaseCommonObject.providerLogger.log(Level.SEVERE, "WBEM exception updating SSIDs on" + serialNum, t);
                            }
                        }
                    };
                    t.setDaemon(true);
                    t.start();
                    Hashtable<Integer, String> raidLevels = ProviderLibs.getSupportedRaidLevels();
                    Robj_interface_RJiLDEVIndex[] indexes = null;
                    indexes = this.deviceIDKeyVal != null ? DeviceNumber.getLDEVIndexesByCU(this.deviceIDKeyVal, this.rmiObj) : (this.pFB4 != -1 ? DeviceNumber.getLDEVIndexesByVDEV(this.pFB4, this.pPG, this.pVdev, this.rmiObj) : this.rmiObj.getLDEVIndex());
                    Robj_interface_RJiLDEVInfoDetail3[] infoDetails = this.rmiObj.smisGetLDEVInfoDetail3(indexes);
                    if (infoDetails.length > 0) {
                        Robj_interface_LUNMgetLDEVStatus[] statusDetails = this.rmiObj.getLDEVStatus(indexes);
                        Arrays.sort(statusDetails, new HealthStatusComparator());
                        TaskProcessor task = new TaskProcessor("DevNum:" + serialNum, infoDetails.length);
                        for (Robj_interface_RJiLDEVInfoDetail3 infoDetail : infoDetails) {
                            if (task.shouldStop()) {
                                this.callback.done();
                                break block10;
                            }
                            WorkerThread worker = new WorkerThread(this.callback, this.rmiObj.getSMISMappingContainer().getSerialNumber(), infoDetail, statusDetails, raidLevels, this.isObjectPath, this.deviceIDKeyVal, this.pCLPRNum, this.hasProperties, this.pCompositeOnly, task);
                            task.addTask(worker);
                        }
                        break block10;
                    }
                    this.callback.done();
                }
                catch (WBEMException we) {
                    this.callback.exceptionOccurred(we);
                }
                catch (Throwable t) {
                    this.callback.exceptionOccurred(new WBEMException(1, "Error: " + t.toString(), null, t));
                }
                finally {
                    AbstractBaseCommonObject.providerLogger.log(Level.INFO, "Exiting ThreadedGetUnCachedDNs for {0}", this.serialNum);
                }
            }
        }
    }

    private static class ModifyCacheThread
    implements Task {
        DeviceNumber actualDN;
        Wait4ProcessTasks theTask;
        List<DeviceNumber> cachedDNs;
        private List<DeviceNumber> modified;
        private List<DeviceNumber> added;
        private final Logger logger;

        public ModifyCacheThread(DeviceNumber dnFrmBackEnd, List<DeviceNumber> cached, List<DeviceNumber> modified, List<DeviceNumber> added, HashMap<String, List<DeviceNumber>> addedMap, Wait4ProcessTasks task, Logger logger) {
            this(dnFrmBackEnd, cached, task, logger);
            this.modified = modified;
            this.added = added;
        }

        public ModifyCacheThread(DeviceNumber actualDN, List<DeviceNumber> previousDNs, Wait4ProcessTasks task, Logger logger) {
            this.actualDN = actualDN;
            this.theTask = task;
            this.cachedDNs = previousDNs;
            this.logger = logger;
            this.added = null;
            this.modified = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doOldStyleModify() throws WBEMException, RemoteException, GetRmiException {
            DeviceNumber cachedDN = DeviceNumber.find(this.actualDN.getDNAsString(), false, RMIObjectMapping.getRMIObjectMapping(this.actualDN.getSerialNumber()).getRMIObject());
            if (cachedDN != null) {
                if (!cachedDN.isSame(this.actualDN)) {
                    this.logger.log(Level.INFO, "DN ({0}) has been modified, updating cache {1}", new Object[]{this.actualDN.getDNAsString(), this.actualDN.getSerialNumber()});
                    List<DeviceNumber> list = this.cachedDNs;
                    synchronized (list) {
                        this.cachedDNs.add(new DeviceNumber(cachedDN));
                    }
                    cachedDN.copyDN(this.actualDN);
                }
            } else {
                this.logger.log(Level.SEVERE, "DN({0}) was marked modified but is not cached {1}", new Object[]{this.actualDN.getDNAsString(), this.actualDN.getSerialNumber()});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            if (this.actualDN != null && !this.theTask.shouldStop()) {
                try {
                    if (this.added == null) {
                        this.doOldStyleModify();
                    } else {
                        this.newStyleModify();
                    }
                }
                catch (Throwable t) {
                    this.logger.log(Level.SEVERE, "Can not modify DN(" + this.actualDN.getDNAsString() + ") - error copying: " + this.actualDN.getSerialNumber(), t);
                }
                finally {
                    this.theTask.taskProcessed();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void newStyleModify() throws RemoteException, GetRmiException, WBEMException {
            DeviceNumber cachedDN = null;
            List<DeviceNumber> list = this.cachedDNs;
            synchronized (list) {
                int indexInCache = Collections.binarySearch(this.cachedDNs, this.actualDN);
                if (indexInCache >= 0) {
                    cachedDN = this.cachedDNs.remove(indexInCache);
                }
            }
            if (cachedDN != null) {
                if (!cachedDN.isSame(this.actualDN)) {
                    this.logger.log(Level.INFO, "DN ({0}) has been modified, updating cache {1}", new Object[]{this.actualDN.getDNAsString(), this.actualDN.getSerialNumber()});
                    list = this.modified;
                    synchronized (list) {
                        this.modified.add(new DeviceNumber(cachedDN));
                    }
                    cachedDN.copyDN(this.actualDN);
                }
            } else {
                this.logger.log(Level.INFO, "DN ({0}) has been added to {1}", new Object[]{this.actualDN.getDNAsString(), this.actualDN.getSerialNumber()});
                this.added.add(this.actualDN);
            }
        }
    }

    private static class HealthStatusComparator
    implements Comparator<Robj_interface_RJiLDEVIndex> {
        private HealthStatusComparator() {
        }

        @Override
        public int compare(Robj_interface_RJiLDEVIndex o1, Robj_interface_RJiLDEVIndex o2) {
            long o2Val;
            long o1Val = BaseDeviceNumber.makeUniqueDN(o1.getSLDKC(), o1.getSCU(), o1.getSLDEV());
            return o1Val < (o2Val = BaseDeviceNumber.makeUniqueDN(o2.getSLDKC(), o2.getSCU(), o2.getSLDEV())) ? -1 : (o1Val == o2Val ? 0 : 1);
        }
    }

    private static class FindDNCallback
    extends FindMethodCallbackHandler<DeviceNumber> {
        private BaseDeviceNumber bdn2Match;

        public FindDNCallback(String serialNum, String deviceIDKeyVal) throws WBEMException {
            short[] vals = BaseDeviceNumber.getDevIdStringValues(deviceIDKeyVal);
            try {
                this.bdn2Match = new BaseDeviceNumber(serialNum, vals[0], vals[2], vals[1], 625);
            }
            catch (RemoteException | GetRmiException e) {
                throw new WBEMException(1, "Failed creating BaseDeviceNumber", null, e);
            }
        }

        public void returnItems(DeviceNumber[] items, HitachiCacheComparator<DeviceNumber> comparator) {
            Arrays.sort(items);
            int found = Arrays.binarySearch(items, this.bdn2Match);
            if (found >= 0) {
                this.returnItem(items[found]);
            } else {
                this.setCompleted(true);
            }
        }
    }
}

