/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.AbstractNickName;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import com.ws.wbem.CloseableAddableIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJiResourceName;

public class LDevNickname
extends AbstractNickName
implements Comparable<LDevNickname> {
    private static final Class<LDevNickname[]> clz = LDevNickname[].class;
    private static final long serialVersionUID = -8551378405965267479L;

    private static HashMap<String, List<LDevNickname>> addLDevNicknameToMap(ClosableAddableIteratorCB<LDevNickname> callback, List<LDevNickname> nicknames) {
        HashMap<String, List<LDevNickname>> map = new HashMap<String, List<LDevNickname>>();
        CloseableAddableIterator<LDevNickname> wrappedIter = callback.getWrappedCloseableAddableIter();
        while (wrappedIter.hasNext()) {
            LDevNickname nickname = (LDevNickname)wrappedIter.next();
            LDevNickname.addLDevNicknameToMap(map, nickname);
            nicknames.add(nickname);
        }
        return map;
    }

    private static void addLDevNicknameToMap(HashMap<String, List<LDevNickname>> map, LDevNickname nickname) {
        String key = CacheLib.getLDEVNicknameByDN(nickname.getDeviceNumber());
        CacheLib.addToMap(map, key, nickname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping mapping) throws WBEMException {
        RMIObjectCache rmiObj = mapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!cache.isCached(clz)) {
            Class<LDevNickname> clazz = LDevNickname.class;
            synchronized (LDevNickname.class) {
                if (!cache.isCached(clz)) {
                    ClosableAddableIteratorCB<LDevNickname> callback = new ClosableAddableIteratorCB<LDevNickname>();
                    LDevNickname.getUnCachedLDevNicknames(rmiObj, callback, null);
                    ArrayList<LDevNickname> nicknames = new ArrayList<LDevNickname>();
                    HashMap map = LDevNickname.addLDevNicknameToMap(callback, nicknames);
                    CacheLib.addDataToCache(map, nicknames, clz, mapping.getSerialNumber());
                } else {
                    cacheLogger.warning("LDevNickname is already in the cache");
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            cacheLogger.warning("LDevNickname is already in the cache");
        }
    }

    public static final LDevNickname find(DeviceNumber deviceNumber) throws WBEMException {
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(deviceNumber.getSerialNumber()).getRMIObject();
        return LDevNickname.find(rmiObj, deviceNumber.getDNAsString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final LDevNickname find(RMIObjectCache rmiObj, String lDevID) throws WBEMException {
        LDevNickname ret = null;
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            String key = CacheLib.getLDEVNicknameByDN(lDevID);
            LDevNickname[] nicknames = (LDevNickname[])cache.getCachedObject(key, clz);
            if (nicknames == null) return ret;
            if (nicknames.length != 1) throw new WBEMException(1, rmiObj.getSMISMappingContainer().getSerialNumber() + " has " + nicknames.length + " nicknames " + " for DeviceID: " + lDevID + " but there should only be one.");
            return nicknames[0];
        }
        providerLogger.log(Level.WARNING, "LDevNickname not cached on {0} this will affect performance", rmiObj.getSMISMappingContainer().getSerialNumber());
        try {
            FindMethodCallbackHandler<LDevNickname> callback = new FindMethodCallbackHandler<LDevNickname>();
            LDevNickname.getUnCachedLDevNicknames(rmiObj, callback, lDevID);
            return callback.getReturnValue();
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable e) {
            throw new WBEMException(1, e.toString(), null, e);
        }
    }

    private static final void getNicknames(IteratorCallback<LDevNickname> callback, String deviceNumber) throws WBEMException {
        Collection<RMIObjectMapping> mappings = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping mapObj : mappings) {
            if (null != mapObj) {
                LDevNickname.getNicknames(mapObj.getRMIObject(), callback, deviceNumber);
                continue;
            }
            providerLogger.severe("One of the objects returned from getAllMappings is null");
        }
    }

    public static final void getNicknames(RMIObjectCache rmiObj, IteratorCallback<LDevNickname> callback, String deviceNumber) throws WBEMException {
        if (null == rmiObj) {
            LDevNickname.getNicknames(callback, deviceNumber);
            return;
        }
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            AbstractBaseCommonObject[] nicknames = null;
            String key = null;
            if (null == deviceNumber) {
                nicknames = (LDevNickname[])cache.getCachedObject(clz);
            } else {
                key = CacheLib.getLDEVNicknameByDN(deviceNumber);
                nicknames = (LDevNickname[])cache.getCachedObject(key, clz);
            }
            if (nicknames != null) {
                callback.returnItems(nicknames);
            } else {
                providerLogger.log(Level.WARNING, "No LDevNicknames in {0}", rmiObj.getSMISMappingContainer().getSerialNumber());
                callback.done();
            }
        } else {
            LogRecord record = new LogRecord(Level.WARNING, "LDEVNickName not cached on {0}, performance issue");
            record.setParameters(new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber()});
            record.setThrown(new Exception(record.getMessage()));
            cacheLogger.log(record);
            LDevNickname.getUnCachedLDevNicknames(rmiObj, callback, deviceNumber);
        }
    }

    private static void getUnCachedLDevNicknames(RMIObjectCache rmiObj, IteratorCallback<LDevNickname> callback, String deviceNum) {
        block7: {
            try {
                CommonClassAsList<DeviceNumber> dnCallback = new CommonClassAsList<DeviceNumber>();
                DeviceNumber.getDNs(rmiObj, dnCallback, false, false, deviceNum);
                LinkedList<DeviceNumber> dns = dnCallback.getReturnValue();
                dnCallback = null;
                int numLDEVs = dns.size();
                if (numLDEVs > 0) {
                    DeviceNumber dn;
                    int[] ldevIndexes = new int[numLDEVs];
                    int count = 0;
                    while ((dn = dns.poll()) != null) {
                        ldevIndexes[count++] = Integer.parseInt(dn.getDNAsString());
                    }
                    Robj_interface_RJiResourceName[] resourceNames = rmiObj.getResourceName(1, ldevIndexes);
                    if (null != resourceNames && resourceNames.length > 0) {
                        String serialNum = rmiObj.getSMISMappingContainer().getSerialNumber();
                        TaskProcessor task = new TaskProcessor("LDevNickname - " + serialNum, resourceNames.length);
                        for (Robj_interface_RJiResourceName resourceName : resourceNames) {
                            if (task.shouldStop()) {
                                callback.done();
                                break block7;
                            }
                            WorkerThread worker = new WorkerThread(serialNum, callback, resourceName, task);
                            task.addTask(worker);
                        }
                        break block7;
                    }
                    callback.done();
                    break block7;
                }
                callback.done();
            }
            catch (Exception e) {
                WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
                callback.exceptionOccurred(we);
                callback.done();
            }
        }
    }

    public static void modifyCachedNickename(List<LDevNickname> added, List<LDevNickname> removed, List<LDevNickname> modified, String serialNum) throws WBEMException {
        try {
            LDevNickname cached;
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
            CommonClassAsList<LDevNickname> callback = new CommonClassAsList<LDevNickname>();
            LDevNickname.getNicknames(rmiObj, callback, null);
            LinkedList<LDevNickname> cachedList = callback.getReturnValue();
            callback = null;
            cacheLogger.log(Level.INFO, "Found {0} cached LDevNicknames on {1}", new Object[]{cachedList.size(), serialNum});
            callback = new CommonClassAsList();
            LDevNickname.getUnCachedLDevNicknames(rmiObj, callback, null);
            LinkedList<LDevNickname> newList = callback.getReturnValue();
            callback = null;
            cacheLogger.log(Level.INFO, "Found {0} LDevNicknames on {1}", new Object[]{newList.size(), serialNum});
            Collections.sort(newList);
            Collections.sort(cachedList);
            while ((cached = cachedList.poll()) != null) {
                int index = Collections.binarySearch(newList, cached);
                if (index >= 0) {
                    LDevNickname newNick = (LDevNickname)newList.remove(index);
                    if (cached.equals(newNick)) continue;
                    modified.add(new LDevNickname(cached));
                    cached.setNickname(newNick.getNickname());
                    continue;
                }
                removed.add(cached);
            }
            added.addAll(newList);
            cacheLogger.log(Level.INFO, "Found that {0} LDevNicknames have been modified, {1}  removed and {2} added on {3}", new Object[]{modified.size(), removed.size(), added.size(), serialNum});
            HashMap<String, List<LDevNickname>> nicknameMap = new HashMap<String, List<LDevNickname>>();
            if (!removed.isEmpty()) {
                LDevNickname.removeItemsFromMap(nicknameMap, removed, serialNum);
                nicknameMap.clear();
            }
            if (!added.isEmpty()) {
                for (LDevNickname nickname : added) {
                    LDevNickname.addLDevNicknameToMap(nicknameMap, nickname);
                }
                CacheLib.addDataToCache(nicknameMap, added, clz, serialNum);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to modify LDevNickname in cache" + t, null, t);
        }
        cacheLogger.info("Done modifiying cached LDevNickname");
    }

    public static boolean processResourceName(IteratorCallback<LDevNickname> mCallback, Robj_interface_RJiResourceName resourceName, String serialNum) {
        boolean ret = true;
        String nickName = resourceName.getName();
        if (null != nickName && 0 != nickName.length()) {
            LDevNickname nickname = new LDevNickname(resourceName.getNumber(), resourceName.getName(), serialNum);
            ret = mCallback.returnItem(nickname);
        }
        return ret;
    }

    private static void removeItemsFromMap(HashMap<String, List<LDevNickname>> nickNameMap, List<LDevNickname> theList, String serialNum) throws WBEMException {
        for (LDevNickname nickName : theList) {
            LDevNickname.addLDevNicknameToMap(nickNameMap, nickName);
        }
        CacheLib.removeDataFromCache(nickNameMap, (Serializable[])theList.toArray(new LDevNickname[theList.size()]), clz, (String)serialNum);
    }

    private LDevNickname(int deviceNumber, String name, String serialNum) {
        super(String.valueOf(deviceNumber), serialNum, name);
    }

    public LDevNickname(LDevNickname cached) {
        super(new String(cached.getDeviceNumber()), new String(cached.getSerialNumber()), new String(cached.getNickname()));
    }

    @Override
    public int compareTo(LDevNickname other) {
        return this.getDeviceNumber().compareToIgnoreCase(other.getDeviceNumber());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LDevNickname ");
        builder.append(super.toString());
        return builder.toString();
    }

    private static class WorkerThread
    implements Task {
        private final IteratorCallback<LDevNickname> mCallback;
        private final TaskProcessor mTheTask;
        private final Robj_interface_RJiResourceName mTheVal;
        private final String mSerialNum;

        public WorkerThread(String serialNum, IteratorCallback<LDevNickname> callback, Robj_interface_RJiResourceName val, TaskProcessor pTheTask) {
            this.mSerialNum = serialNum;
            this.mCallback = callback;
            this.mTheVal = val;
            this.mTheTask = pTheTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                boolean ret;
                if (!this.mTheTask.shouldStop() && !(ret = LDevNickname.processResourceName(this.mCallback, this.mTheVal, this.mSerialNum))) {
                    this.mTheTask.setStop(true);
                }
            }
            catch (Throwable e) {
                WBEMException we = e.getClass().isInstance(WBEMException.class) ? (WBEMException)e : new WBEMException(1, "Exception while processing items", null, e);
                this.mCallback.exceptionOccurred(we);
                this.mTheTask.setStop(true);
            }
            finally {
                int counter = this.mTheTask.taskDone();
                if (counter < 1) {
                    this.mCallback.done();
                }
            }
        }
    }
}

