/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.ChassisInfo;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.PGInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.keyvalueapis.MNTreadDriveBoxInfo;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import com.ws.wbem.CloseableAddableIterator;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_CVSgetPGEncryptionInfoEx;
import sanproject.common.Robj_interface_DKCgetPDEVInfo2;
import sanproject.common.Robj_interface_DKCgetPDEVInfoEntry2;
import sanproject.common.Robj_interface_DKCgetPDEVInfoEntry3;
import sanproject.common.Robj_interface_DKCgetPDEVInfoEntry4;
import sanproject.common.Robj_interface_DKCgetPDEVInfoEntry5;
import sanproject.common.Robj_interface_DKCgetPDEVInfoEntry6;
import sanproject.common.Robj_interface_RJSetGettingParamDeviceEx;
import sanproject.common.Robj_interface_RJiPGIndex;

public class PDEVInfoEntry
extends AbstractBaseCommonObject
implements Comparable<PDEVInfoEntry> {
    public static final int SSDDRIVE = 5;
    public static final int SATADrive = 1;
    public static final int SASDRIVE = 0;
    public static final int FREE_DISK = 5;
    public static final int RESERVED = 4;
    public static final int DATA_DISK = 3;
    public static final int SPARE = 2;
    public static final int DATA = 1;
    public static String DKALL = "DKALL";
    private static Hashtable<String, Set<String>> dkuChassisLocations = new Hashtable();
    private static final long serialVersionUID = 1L;
    private static final Class<PDEVInfoEntry[]> clz = PDEVInfoEntry[].class;
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    private byte driveType;
    private int cdev;
    private int driveKind;
    private int hddRPM;
    private int rdev;
    private long hddCapa;
    private short clprNum;
    private short slprNum;
    private String hddKind;
    private String hddLocation;
    private String hddSerial;
    private String hddVer;
    private int fb4;
    private int pg;
    private boolean openVol;
    private long capacityInBytes;
    private String chassisLoc;
    private int hddStatus;
    private byte hddDriveDetail;
    private String hddSpecCapacity;
    private UnsignedInteger16 hddDrivePhysicalSize;
    private int hddEncryption;
    private long hddDiskCapacity;

    public static void addItemsToCache(LinkedList<PDEVInfoEntry> pdevs, String serialNum) {
        if (null != pdevs && !pdevs.isEmpty()) {
            HashMap map = new HashMap();
            PDEVInfoEntry entry = pdevs.poll();
            while (entry != null) {
                PDEVInfoEntry.addPDEVEntryToMap(map, entry);
                entry = pdevs.poll();
            }
            List<PDEVInfoEntry> list = map.remove(clz.toString());
            CacheLib.addDataToCache(map, list, clz, serialNum);
        }
    }

    private static void addPDEVEntryToMap(HashMap<String, List<PDEVInfoEntry>> map, PDEVInfoEntry entry) {
        String location;
        CacheLib.addToMap(map, clz.toString(), entry);
        String key = CacheLib.getPDEVLocKey(DKALL);
        CacheLib.addToMap(map, key, entry);
        key = CacheLib.getPDEVLocCdevRdevKey(DKALL, entry.getCdev(), entry.getRdev());
        CacheLib.addToMap(map, key, entry);
        if (-1 != entry.getFb4() && -1 != entry.getPg()) {
            key = CacheLib.getPDEVFB4PG(entry.getFb4(), entry.getPg());
            CacheLib.addToMap(map, key, entry);
        }
        if (null != (location = entry.getChassisLocation())) {
            key = null;
            key = CacheLib.getPDEVLocKey(location);
            CacheLib.addToMap(map, key, entry);
            key = CacheLib.getPDEVLocCdevRdevKey(location, entry.getCdev(), entry.getRdev());
            CacheLib.addToMap(map, key, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping mapping) throws WBEMException {
        RMIObjectCache rmiObj = mapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        ChassisInfo.populateDKCChassis(mapping);
        if (!cache.isCached(clz)) {
            Class<PDEVInfoEntry> clazz = PDEVInfoEntry.class;
            synchronized (PDEVInfoEntry.class) {
                if (!cache.isCached(clz)) {
                    CommonClassAsList<PDEVInfoEntry> callback = new CommonClassAsList<PDEVInfoEntry>();
                    PDEVInfoEntry.getUnCachedPDEVInfoEntry(rmiObj, callback, -1, -1, null);
                    LinkedList<PDEVInfoEntry> pdevs = callback.getReturnValue();
                    callback = null;
                    PDEVInfoEntry.addItemsToCache(pdevs, mapping.getSerialNumber());
                } else {
                    Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
                    logger.log(Level.FINE, "PDEVInfoEntry was added to {0}", mapping.getSerialNumber());
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
            logger.log(Level.WARNING, "PDEVInfo is already in {0}", mapping.getSerialNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compareBackEnd2Cache(LinkedList<PDEVInfoEntry> added, LinkedList<PDEVInfoEntry> modified, LinkedList<PDEVInfoEntry> removed, String serialNum) throws WBEMException {
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
        ClosableAddableIteratorCB<PDEVInfoEntry> callback = new ClosableAddableIteratorCB<PDEVInfoEntry>();
        PDEVInfoEntry.getUnCachedPDEVInfoEntry(rmiObj, callback, -1, -1, null);
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        PDEVInfoEntry[] cachedItems = (PDEVInfoEntry[])cache.getCachedObject(null, clz);
        removed.addAll(Arrays.asList(null != cachedItems ? cachedItems : new PDEVInfoEntry[]{}));
        Collections.sort(removed);
        CloseableAddableIterator<PDEVInfoEntry> backEndIter = callback.getWrappedCloseableAddableIter();
        while (backEndIter.hasNext()) {
            PDEVInfoEntry beItem = (PDEVInfoEntry)backEndIter.next();
            int index = Collections.binarySearch(removed, beItem);
            if (index > -1) {
                PDEVInfoEntry cItem;
                PDEVInfoEntry pDEVInfoEntry = cItem = removed.remove(index);
                synchronized (pDEVInfoEntry) {
                    if (!beItem.isSame(cItem)) {
                        modified.add(new PDEVInfoEntry(cItem));
                        cItem.copyPDEVInfoEntry(beItem);
                    }
                    continue;
                }
            }
            added.add(beItem);
        }
    }

    public static boolean dkuChassExists(String serialNum, String chassisLoc) {
        Set<String> theSet = dkuChassisLocations.get(serialNum);
        return null != theSet ? theSet.contains(chassisLoc) : false;
    }

    public static final PDEVInfoEntry find(RMIObjectCache rmiobj, int cdev, int rdev) throws WBEMException {
        PDEVInfoEntry ret = null;
        try {
            if (-1 != cdev && -1 != rdev) {
                FindMethodCallbackHandler<PDEVInfoEntry> callback = new FindMethodCallbackHandler<PDEVInfoEntry>();
                PDEVInfoEntry.getPDEVInfoEntry(rmiobj, callback, cdev, rdev);
                ret = callback.getReturnValue();
            }
        }
        catch (Exception e) {
            WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
            throw we;
        }
        return ret;
    }

    private static Robj_interface_CVSgetPGEncryptionInfoEx findEncryptInfo(List<Robj_interface_CVSgetPGEncryptionInfoEx> list, int fb4, int pg) {
        Robj_interface_CVSgetPGEncryptionInfoEx ret = null;
        for (Robj_interface_CVSgetPGEncryptionInfoEx item : list) {
            if (item.getIFB4() != fb4 || item.getIPG() != pg) continue;
            ret = item;
            break;
        }
        return ret;
    }

    public static Iterator<String> getDKUChassisLocations(String serialNumber) {
        Set<String> ret = dkuChassisLocations.get(serialNumber);
        return null != ret ? ret.iterator() : Collections.emptySet().iterator();
    }

    protected static void getPDEVInfoEntry(IteratorCallback<PDEVInfoEntry> callback, int cdev, int rdev, String pChassisLoc) throws WBEMException {
        Collection<RMIObjectMapping> mappings = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping mapObj : mappings) {
            if (null != mapObj) {
                PDEVInfoEntry.getPDEVInfoEntry(mapObj.getRMIObject(), callback, cdev, rdev, pChassisLoc, -1, -1);
                continue;
            }
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            logger.severe("One of the objects returned from getAllMappings is null");
        }
    }

    public static void getPDEVInfoEntry(RMIObjectCache rmiObj, IteratorCallback<PDEVInfoEntry> callback) throws WBEMException {
        PDEVInfoEntry.getPDEVInfoEntry(rmiObj, callback, -1, -1, null, -1, -1);
    }

    public static void getPDEVInfoEntry(RMIObjectCache rmiObj, IteratorCallback<PDEVInfoEntry> callback, int cdev, int rdev) throws WBEMException {
        PDEVInfoEntry.getPDEVInfoEntry(rmiObj, callback, cdev, rdev, null, -1, -1);
    }

    public static void getPDEVInfoEntry(RMIObjectCache rmiObj, IteratorCallback<PDEVInfoEntry> callback, int cdev, int rdev, String pChassisLoc, int fb4, int pg) throws WBEMException {
        if (null == rmiObj) {
            PDEVInfoEntry.getPDEVInfoEntry(callback, cdev, rdev, pChassisLoc);
            return;
        }
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            String key = null;
            String chassisLococation = pChassisLoc;
            if (null == chassisLococation) {
                chassisLococation = DKALL;
            }
            if (-1 == cdev && -1 == rdev && -1 == fb4 && -1 == pg) {
                key = CacheLib.getPDEVLocKey(chassisLococation);
            } else if (-1 != cdev && -1 != rdev) {
                key = CacheLib.getPDEVLocCdevRdevKey(chassisLococation, cdev, rdev);
            } else if (-1 != fb4 && -1 != pg) {
                key = CacheLib.getPDEVFB4PG(fb4, pg);
            } else {
                if (-1 == cdev && -1 == rdev && -1 != fb4 || -1 != pg) {
                    throw new WBEMException("Both cdev & rdev must be -1 or have a value. cdev: " + cdev + ", rdev: " + rdev);
                }
                throw new WBEMException("Both FB4 & PG must be -1 or have a value. Fb4: " + fb4 + ", PG: " + pg);
            }
            AbstractBaseCommonObject[] pdevInfo = (PDEVInfoEntry[])cache.getCachedObject(key, clz);
            callback.returnItems(pdevInfo);
        } else {
            LogRecord record = new LogRecord(Level.WARNING, "PDEVInfoEntry not cached on {0}, performance issue");
            record.setParameters(new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber()});
            record.setThrown(new Exception(record.getMessage()));
            cacheLogger.log(record);
            PDEVInfoEntry.getUnCachedPDEVInfoEntry(rmiObj, callback, cdev, rdev, pChassisLoc);
        }
    }

    private static void getUnCachedPDEVInfoEntry(RMIObjectCache rmiObj, IteratorCallback<PDEVInfoEntry> callback, int cdev, int rdev, String chassisLocation) throws WBEMException {
        block5: {
            try {
                Robj_interface_DKCgetPDEVInfo2 pdevInfo = rmiObj.getPDEVInfo2();
                Robj_interface_DKCgetPDEVInfoEntry2[] entries = pdevInfo.getObjEntry();
                if (entries != null && entries.length > 0) {
                    String serial = rmiObj.getSMISMappingContainer().getSerialNumber();
                    Robj_interface_RJSetGettingParamDeviceEx encryptParam = (Robj_interface_RJSetGettingParamDeviceEx)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJSETGETTINGPARAMDEVICEEX);
                    encryptParam.setBInternalDevice(true);
                    ArrayList<Robj_interface_CVSgetPGEncryptionInfoEx> encryptInfo = new ArrayList<Robj_interface_CVSgetPGEncryptionInfoEx>(Arrays.asList(rmiObj.getPGEncryptionInfoEx(encryptParam)));
                    MNTreadDriveBoxInfo driveSizes = new MNTreadDriveBoxInfo(rmiObj, "127.0.0.1");
                    TaskProcessor task = new TaskProcessor("PDEVEntry - " + serial, entries.length);
                    for (Robj_interface_DKCgetPDEVInfoEntry2 entry : entries) {
                        if (task.shouldStop()) {
                            callback.done();
                            break block5;
                        }
                        WorkerThread worker = new WorkerThread(serial, callback, entry, task, cdev, rdev, chassisLocation, encryptInfo, driveSizes);
                        task.addTask(worker);
                    }
                    break block5;
                }
                callback.done();
            }
            catch (Exception e) {
                WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
                callback.exceptionOccurred(we);
            }
        }
    }

    public static long isParityGroupCompatible(List<PDEVInfoEntry> pdevInfos) {
        PDEVInfoEntry firstDisk = pdevInfos.get(0);
        long ret = firstDisk.getHDDCapaInBytes().longValue();
        for (int idx = 1; idx < pdevInfos.size() && ret >= 0L; ++idx) {
            PDEVInfoEntry disk2Compare = pdevInfos.get(idx);
            if (!firstDisk.isPGCompatible(disk2Compare)) {
                ret = idx * -1;
                continue;
            }
            ret += disk2Compare.getHDDCapaInBytes().longValue();
        }
        return ret;
    }

    public static int[] parseDeviceID(String deviceID) {
        StringTokenizer tokenizer;
        int[] ret = null;
        if (null != deviceID && (tokenizer = new StringTokenizer(deviceID, ".")).countTokens() == 2) {
            try {
                ret = new int[]{Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken())};
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (null == ret) {
            mLogger.log(Level.WARNING, "Invalid Disk deviceID: {0}", deviceID);
        }
        return ret;
    }

    public static int[] parseTag(String tag, String[] systemName) {
        int index;
        int[] ret = null;
        if (null != tag && (index = tag.indexOf(ProviderConstants.ID_SEPERATOR_AS_CHAR)) > 0 && (index = tag.indexOf(ProviderConstants.ID_SEPERATOR_AS_CHAR, index + 1)) > 0 && index < tag.length() - 1) {
            String sysName = tag.substring(0, index);
            if (null != systemName && systemName.length > 0) {
                systemName[0] = sysName;
            }
            String deviceID = tag.substring(index + 1);
            ret = PDEVInfoEntry.parseDeviceID(deviceID);
        }
        if (null == ret) {
            mLogger.log(Level.WARNING, "Invalid Disk tag {0}", tag);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processPDEVInfoEntry(String serialNumber, IteratorCallback<PDEVInfoEntry> callback, Robj_interface_DKCgetPDEVInfoEntry2 theVal, String chassisLocation, List<Robj_interface_CVSgetPGEncryptionInfoEx> encryptInfo, MNTreadDriveBoxInfo driveSizes) {
        PDEVInfoEntry entry = new PDEVInfoEntry(serialNumber, theVal, encryptInfo, driveSizes);
        if (null != chassisLocation && !chassisLocation.equals(entry.getChassisLocation())) {
            return true;
        }
        String entryLocation = entry.getChassisLocation();
        if (null != entryLocation) {
            Set<String> theSet = dkuChassisLocations.get(serialNumber);
            if (null == theSet) {
                Hashtable<String, Set<String>> hashtable = dkuChassisLocations;
                synchronized (hashtable) {
                    theSet = dkuChassisLocations.get(serialNumber);
                    if (null == theSet) {
                        theSet = new HashSet<String>();
                        dkuChassisLocations.put(serialNumber, theSet);
                    }
                }
            }
            theSet.add(entryLocation);
        }
        return callback.returnItem(entry);
    }

    public static void removeItemsFromCache(List<PDEVInfoEntry> pdevs, String serialNum) throws WBEMException {
        if (null != pdevs && !pdevs.isEmpty()) {
            HashMap<String, List<PDEVInfoEntry>> map = new HashMap<String, List<PDEVInfoEntry>>();
            for (PDEVInfoEntry entry : pdevs) {
                PDEVInfoEntry.addPDEVEntryToMap(map, entry);
            }
            map.remove(clz.toString());
            CacheLib.removeDataFromCache(map, (Serializable[])pdevs.toArray(new PDEVInfoEntry[pdevs.size()]), clz, (String)serialNum);
        }
    }

    public static void updateCachedEntries(LinkedList<PDEVInfoEntry> added, LinkedList<PDEVInfoEntry> modified, LinkedList<PDEVInfoEntry> removed, String serialNum) {
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
        try {
            PDEVInfoEntry.compareBackEnd2Cache(added, modified, removed, serialNum);
            PDEVInfoEntry.removeItemsFromCache(removed, serialNum);
            PDEVInfoEntry.addItemsToCache(added, serialNum);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error updating PDEVInfoEntry cache: " + t, t);
        }
    }

    private PDEVInfoEntry(PDEVInfoEntry other) {
        super(other.getSerialNumber());
        this.copyPDEVInfoEntry(other);
    }

    private PDEVInfoEntry(String serialNumber, int cdev, int rdev) {
        super(serialNumber);
        this.cdev = cdev;
        this.rdev = rdev;
    }

    private PDEVInfoEntry(String serialNumber, Robj_interface_DKCgetPDEVInfoEntry2 entry, List<Robj_interface_CVSgetPGEncryptionInfoEx> encryptInfo, MNTreadDriveBoxInfo driveSizes) {
        block15: {
            this(serialNumber, entry.getICDEV(), entry.getIRDEV());
            this.driveType = entry.getByDriveType();
            this.driveKind = entry.getIDriveKind();
            this.hddRPM = entry.getIHDDrpm();
            this.hddCapa = entry.getLHDDCapa();
            this.clprNum = entry.getSCLPRNo();
            this.slprNum = entry.getSSLPRNo();
            this.hddKind = entry.getStrHDDKind();
            this.hddLocation = entry.getStrHDDLocation();
            this.hddSerial = entry.getStrHDDSerialNo();
            this.hddVer = entry.getStrHDDver();
            this.hddStatus = ((Robj_interface_DKCgetPDEVInfoEntry3)entry).getHDDStatus();
            this.hddDriveDetail = ((Robj_interface_DKCgetPDEVInfoEntry4)entry).getByDriveTypeDetail();
            this.hddSpecCapacity = ((Robj_interface_DKCgetPDEVInfoEntry5)entry).getStrHDDSpecCapa();
            this.hddDiskCapacity = ((Robj_interface_DKCgetPDEVInfoEntry6)entry).getLHDDCapaDependOnCE();
            this.hddDrivePhysicalSize = driveSizes.getType(this.cdev, this.rdev);
            try {
                ChassisInfo info = ChassisInfo.getChassisInfo(serialNumber);
                this.chassisLoc = info.getChassisLocation(this.cdev, this.rdev);
            }
            catch (WBEMException we) {
                mLogger.log(Level.SEVERE, "Error getting ChassisInfo", we);
                this.chassisLoc = "UNKNOWN";
            }
            Robj_interface_RJiPGIndex tPG = entry.getObjPGIndex();
            try {
                if (tPG != null) {
                    this.fb4 = tPG.getIFB4();
                    this.pg = tPG.getIPG();
                    PGInfo pgInf = PGInfo.find(serialNumber, this.fb4, this.pg);
                    if (pgInf != null) {
                        try {
                            this.openVol = pgInf.isOpen();
                        }
                        catch (WBEMException we) {
                            mLogger.log(Level.SEVERE, "Exception determining if PDEV is open", we);
                            this.openVol = true;
                        }
                        this.capacityInBytes = pgInf.getLPDEVSize();
                    } else {
                        mLogger.warning("Unable to find PGInfo(" + this.fb4 + ", " + this.pg);
                    }
                    Robj_interface_CVSgetPGEncryptionInfoEx t = PDEVInfoEntry.findEncryptInfo(encryptInfo, this.fb4, this.pg);
                    if (null != t) {
                        switch (t.getIEncrypt()) {
                            case 0: {
                                this.hddEncryption = 2;
                                break;
                            }
                            case 1: {
                                this.hddEncryption = 3;
                                break;
                            }
                            default: {
                                this.hddEncryption = 0;
                                break;
                            }
                        }
                    } else {
                        providerLogger.log(Level.FINE, "No encryption data for FB: {0}, PG: {1}", new Object[]{this.fb4, this.pg});
                    }
                    break block15;
                }
                this.fb4 = -2;
                this.pg = -2;
                this.capacityInBytes = 0L;
                this.openVol = true;
            }
            catch (WBEMException e) {
                mLogger.log(Level.SEVERE, "Exception getting PGinfo: " + (Object)((Object)e), e);
            }
        }
    }

    @Override
    public int compareTo(PDEVInfoEntry other) {
        int ret;
        int otherVal;
        int thisVal = this.getCdev();
        int n = thisVal == (otherVal = other.getCdev()) ? 0 : (ret = thisVal < otherVal ? -1 : 1);
        if (0 == ret) {
            thisVal = this.getRdev();
            ret = thisVal == (otherVal = other.getRdev()) ? 0 : (thisVal < otherVal ? -1 : 1);
        }
        return ret;
    }

    public void copyPDEVInfoEntry(PDEVInfoEntry other) {
        if (other == null) {
            throw new NullPointerException("Can't copy a null object");
        }
        this.capacityInBytes = other.capacityInBytes;
        this.cdev = other.cdev;
        this.chassisLoc = other.chassisLoc;
        this.clprNum = other.clprNum;
        this.driveKind = other.driveKind;
        this.driveType = other.driveType;
        this.fb4 = other.fb4;
        this.hddCapa = other.hddCapa;
        this.hddDriveDetail = other.hddDriveDetail;
        this.hddKind = other.hddKind;
        this.hddLocation = other.hddLocation;
        this.hddRPM = other.hddRPM;
        this.hddSerial = other.hddSerial;
        this.hddSpecCapacity = other.hddSpecCapacity;
        this.hddStatus = other.hddStatus;
        this.hddVer = other.hddVer;
        this.openVol = other.openVol;
        this.pg = other.pg;
        this.rdev = other.rdev;
        this.slprNum = other.slprNum;
        this.hddEncryption = other.hddEncryption;
        this.hddDrivePhysicalSize = other.hddDrivePhysicalSize;
        this.hddDiskCapacity = other.hddDiskCapacity;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PDEVInfoEntry other = (PDEVInfoEntry)obj;
        if (this.cdev != other.cdev) {
            return false;
        }
        return this.rdev == other.rdev;
    }

    public long getCapacityInBytes() {
        return this.capacityInBytes;
    }

    public int getCdev() {
        return this.cdev;
    }

    public String getChassisLocation() {
        if (this.chassisLoc.equals("UNKNOWN")) {
            try {
                ChassisInfo info = ChassisInfo.getChassisInfo(this.getSerialNumber());
                this.chassisLoc = info.getChassisLocation(this.cdev, this.rdev);
            }
            catch (WBEMException we) {
                mLogger.log(Level.SEVERE, "Error getting ChassisInfo", we);
            }
        }
        return this.chassisLoc;
    }

    public short getClprNum() {
        return this.clprNum;
    }

    public String getDeviceID() {
        StringBuffer deviceID = new StringBuffer(String.valueOf(this.cdev));
        deviceID.append(".");
        deviceID.append(String.valueOf(this.rdev));
        return deviceID.toString();
    }

    public int getDriveKind() {
        return this.driveKind;
    }

    public String getDriveKindStr() {
        String ret;
        switch (this.driveKind) {
            case 1: {
                ret = "Data";
                break;
            }
            case 2: {
                ret = "Spare";
                break;
            }
            case 3: {
                ret = "Data disk";
                break;
            }
            case 4: {
                ret = "Reserved disk";
                break;
            }
            case 5: {
                ret = "Free Disk";
                break;
            }
            default: {
                mLogger.severe("UNKNOWN drive kind: " + this.driveKind);
                ret = "UNKNOWN";
            }
        }
        return ret;
    }

    public byte getDriveType() {
        return this.driveType;
    }

    public String getDriveTypeString() {
        String ret;
        switch (this.driveType) {
            case 0: {
                ret = "Normal (SAS) drive";
                break;
            }
            case 1: {
                ret = "SATA drive";
                break;
            }
            case 5: {
                ret = "SSD drive";
                break;
            }
            default: {
                mLogger.severe("UNKNOWN Drive Type: " + this.driveType);
                ret = "UNKNOWN";
            }
        }
        return ret;
    }

    public int getFb4() {
        return this.fb4;
    }

    public long getHddCapa() {
        return this.hddCapa;
    }

    public BigInteger getHDDCapaInBytes() {
        BigInteger oneK = BigInteger.valueOf(1000L);
        BigInteger capacity = BigInteger.valueOf(this.getHddCapa());
        capacity = capacity.multiply(oneK);
        capacity = capacity.multiply(oneK);
        return capacity;
    }

    public BigInteger getHDDCapaInKBytes() {
        BigInteger oneK = BigInteger.valueOf(1000L);
        BigInteger capacity = BigInteger.valueOf(this.getHddCapa());
        capacity = capacity.multiply(oneK);
        return capacity;
    }

    public BigInteger getHddDiskCapacity() {
        return BigInteger.valueOf(this.hddDiskCapacity);
    }

    public BigInteger getHddDiskCapacityInBytes() {
        BigInteger oneK = BigInteger.valueOf(1000L);
        BigInteger capacity = this.getHddDiskCapacity();
        capacity = capacity.multiply(oneK);
        capacity = capacity.multiply(oneK);
        return capacity;
    }

    public BigInteger getHddDiskCapacityInKBytes() {
        BigInteger oneK = BigInteger.valueOf(1000L);
        BigInteger capacity = this.getHddDiskCapacity();
        capacity = capacity.multiply(oneK);
        return capacity;
    }

    public final byte getHddDriveDetail() {
        return this.hddDriveDetail;
    }

    public UnsignedInteger16 getHddDrivePhysicalSize() {
        return this.hddDrivePhysicalSize;
    }

    public int getHddEncryption() {
        return this.hddEncryption;
    }

    public String getHddKind() {
        return this.hddKind;
    }

    public String getHddLocation() {
        return this.hddLocation;
    }

    public int getHddRPM() {
        return this.hddRPM;
    }

    public String getHddSerial() {
        return this.hddSerial;
    }

    public String getHddSpecCapacity() {
        return this.hddSpecCapacity;
    }

    public int getHddStatus() {
        return this.hddStatus;
    }

    public String getHddVer() {
        return this.hddVer;
    }

    public int getPg() {
        return this.pg;
    }

    public int getRdev() {
        return this.rdev;
    }

    public short getSlprNum() {
        return this.slprNum;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.cdev;
        result = 31 * result + this.clprNum;
        result = 31 * result + this.driveKind;
        result = 31 * result + this.driveType;
        result = 31 * result + this.fb4;
        result = 31 * result + (int)(this.hddCapa ^ this.hddCapa >>> 32);
        result = 31 * result + (int)(this.capacityInBytes ^ this.capacityInBytes >>> 32);
        result = 31 * result + (this.hddKind == null ? 0 : this.hddKind.hashCode());
        result = 31 * result + (this.hddLocation == null ? 0 : this.hddLocation.hashCode());
        result = 31 * result + this.hddRPM;
        result = 31 * result + (this.chassisLoc == null ? 0 : this.chassisLoc.hashCode());
        result = 31 * result + (this.hddSerial == null ? 0 : this.hddSerial.hashCode());
        result = 31 * result + (this.hddVer == null ? 0 : this.hddVer.hashCode());
        result = 31 * result + this.pg;
        result = 31 * result + this.rdev;
        result = 31 * result + this.slprNum;
        return result;
    }

    public boolean isOpenVol() {
        return this.openVol;
    }

    private boolean isPGCompatible(PDEVInfoEntry disk2Compare) {
        if (this.getHddRPM() != disk2Compare.getHddRPM()) {
            return false;
        }
        if (this.getHddDriveDetail() != disk2Compare.getHddDriveDetail()) {
            return false;
        }
        if (this.getHddCapa() != disk2Compare.getHddCapa()) {
            return false;
        }
        if (this.getHddStatus() != disk2Compare.getHddStatus()) {
            return false;
        }
        return this.getDriveKind() == disk2Compare.getDriveKind();
    }

    public boolean isSame(PDEVInfoEntry other) {
        if (!this.equals(other)) {
            return false;
        }
        if (this.clprNum != other.clprNum) {
            return false;
        }
        if (this.driveKind != other.driveKind) {
            return false;
        }
        if (this.driveType != other.driveType) {
            return false;
        }
        if (this.fb4 != other.fb4) {
            return false;
        }
        if (this.hddCapa != other.hddCapa) {
            return false;
        }
        if (this.capacityInBytes != other.getCapacityInBytes()) {
            return false;
        }
        if (this.hddKind == null ? other.hddKind != null : !this.hddKind.equals(other.hddKind)) {
            return false;
        }
        if (this.hddLocation == null ? other.hddLocation != null : !this.hddLocation.equals(other.hddLocation)) {
            return false;
        }
        if (this.chassisLoc == null ? other.chassisLoc != null : !this.chassisLoc.equals(other.chassisLoc)) {
            return false;
        }
        if (this.hddRPM != other.hddRPM) {
            return false;
        }
        if (this.hddSerial == null ? other.hddSerial != null : !this.hddSerial.equals(other.hddSerial)) {
            return false;
        }
        if (this.hddVer == null ? other.hddVer != null : !this.hddVer.equals(other.hddVer)) {
            return false;
        }
        if (this.pg != other.pg) {
            return false;
        }
        if (this.slprNum != other.slprNum) {
            return false;
        }
        if (this.hddStatus != other.hddStatus) {
            return false;
        }
        if (this.hddEncryption != other.hddEncryption) {
            return false;
        }
        if (this.hddDrivePhysicalSize.equals((Object)other.hddDrivePhysicalSize)) {
            return false;
        }
        if (this.hddDiskCapacity != other.hddDiskCapacity) {
            return false;
        }
        return this.getHddDriveDetail() == other.getHddDriveDetail();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PDEVInfoEntry [serialNumber=");
        builder.append(this.getSerialNumber());
        builder.append(", cdev=");
        builder.append(this.cdev);
        builder.append(", rdev=");
        builder.append(this.rdev);
        builder.append(", fb4=");
        builder.append(this.fb4);
        builder.append(", pg=");
        builder.append(this.pg);
        builder.append(", Encryption=");
        builder.append(this.hddEncryption);
        builder.append(", clprNum=");
        builder.append(this.clprNum);
        builder.append(", slprNum=");
        builder.append(this.slprNum);
        builder.append(", driveType=");
        builder.append(this.driveType);
        builder.append(", driveTypeDetail=");
        builder.append(this.hddDriveDetail);
        builder.append(", driveKind=");
        builder.append(this.driveKind);
        builder.append(", DiskCapacity=");
        builder.append(this.hddDiskCapacity);
        builder.append(", hddRPM=");
        builder.append(this.hddRPM);
        builder.append(", hddCapa=");
        builder.append(this.hddCapa);
        builder.append(", hddKind=");
        builder.append(this.hddKind);
        builder.append(", hddLocation=");
        builder.append(this.hddLocation);
        builder.append(", hddSerial=");
        builder.append(this.hddSerial);
        builder.append(", hddStatus=");
        builder.append(this.hddStatus);
        builder.append(", hddVer=");
        builder.append(this.hddVer);
        builder.append(", openVol=");
        builder.append(this.openVol);
        builder.append(", capacityInBytes=");
        builder.append(this.capacityInBytes);
        builder.append(", chassisLoc=");
        builder.append(this.chassisLoc);
        builder.append(", hddDrivePhysicalSize=");
        builder.append(this.hddDrivePhysicalSize);
        builder.append("]");
        return builder.toString();
    }

    private static class WorkerThread
    implements Task {
        private final IteratorCallback<PDEVInfoEntry> mCallback;
        private final TaskProcessor mTheTask;
        Robj_interface_DKCgetPDEVInfoEntry2 mTheVal;
        int mCdev;
        int mRdev;
        String mChassisLocation;
        private final String mSerialNumber;
        List<Robj_interface_CVSgetPGEncryptionInfoEx> encryptInfo;
        private final MNTreadDriveBoxInfo driveSizes;

        public WorkerThread(String serial, IteratorCallback<PDEVInfoEntry> callback, Robj_interface_DKCgetPDEVInfoEntry2 val, TaskProcessor pTheTask, int cdev, int rdev, String chassisLocation, List<Robj_interface_CVSgetPGEncryptionInfoEx> encryptInfo, MNTreadDriveBoxInfo driveSizes) {
            this.mSerialNumber = serial;
            this.mCallback = callback;
            this.mTheVal = val;
            this.mTheTask = pTheTask;
            this.mCdev = cdev;
            this.mRdev = rdev;
            this.mChassisLocation = chassisLocation;
            this.encryptInfo = encryptInfo;
            this.driveSizes = driveSizes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                boolean ret;
                if (!this.mTheTask.shouldStop() && (-1 == this.mCdev || this.mTheVal.getICDEV() == this.mCdev && this.mTheVal.getIRDEV() == this.mRdev) && !(ret = PDEVInfoEntry.processPDEVInfoEntry(this.mSerialNumber, this.mCallback, this.mTheVal, this.mChassisLocation, this.encryptInfo, this.driveSizes))) {
                    this.mTheTask.setStop(true);
                }
            }
            catch (Throwable e) {
                WBEMException we = e.getClass().isInstance(WBEMException.class) ? (WBEMException)e : new WBEMException(1, "Exception while processing PDEVINfo on " + this.mSerialNumber, null, e);
                this.mCallback.exceptionOccurred(we);
                this.mTheTask.setStop(true);
            }
            finally {
                int counter = this.mTheTask.taskDone();
                if (counter < 1) {
                    this.mCallback.done();
                }
            }
        }
    }
}

