/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.UserDefinedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;

public class ProviderDataProperties {
    private static volatile ProviderDataProperties singleton = null;
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    public static final String PROVIDERDATA_PROPERTIES = "providerdata.properties";
    private final Properties mProps = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProviderDataProperties getProviderData() throws WBEMException {
        ProviderDataProperties t = singleton;
        if (null != t) return t;
        Class<ProviderDataProperties> clazz = ProviderDataProperties.class;
        synchronized (ProviderDataProperties.class) {
            t = singleton;
            if (null != t) return t;
            singleton = new ProviderDataProperties();
            return singleton;
        }
    }

    private ProviderDataProperties() throws WBEMException {
        File udFile = null;
        StringBuilder propFile = new StringBuilder(ProviderConstants.getDatDirectory());
        propFile.append(PROVIDERDATA_PROPERTIES);
        udFile = new File(propFile.toString());
        if (udFile.exists()) {
            try (FileInputStream in = new FileInputStream(udFile);){
                mLogger.log(Level.INFO, "Loading provider data from {0}", propFile);
                this.mProps.load(in);
                mLogger.log(Level.INFO, "Loaded data, values:{0}{1}", new Object[]{System.getProperty("line.separator"), this.mProps});
            }
            catch (FileNotFoundException fnf) {
                mLogger.log(Level.WARNING, "providerdata.properties could not be found", fnf);
            }
            catch (IOException ioe) {
                throw new WBEMException(1, "Error getting data from providerdata.properties", null, (Throwable)ioe);
            }
        } else {
            mLogger.log(Level.INFO, "{0} could not be found", propFile);
        }
    }

    protected void addOrUpdateProperty(String key, String value) {
        this.mProps.put(key, value);
    }

    public String getProperty(String propName) {
        return this.getProperty(propName, null);
    }

    public String getProperty(String propName, String defaultValue) {
        return this.mProps.getProperty(propName, defaultValue);
    }

    public String getResourceGroupRestriction() throws WBEMException {
        String udpRSG = UserDefinedProperties.getResourceRestriction();
        if (null != udpRSG) {
            this.addOrUpdateProperty("ResourceGroup", udpRSG);
            this.saveProperties();
        }
        return this.mProps.getProperty("ResourceGroup", null);
    }

    public String getRestrictedPoolIDForSnapshot() {
        String val = null;
        val = this.mProps.getProperty("PoolIDForSnapshot", null);
        return val;
    }

    public String getRestrictedVVolForSnapshot() {
        String val = null;
        val = this.mProps.getProperty("VVolForSnapshot", null);
        return val;
    }

    protected void saveProperties() throws WBEMException {
        File udFile = null;
        StringBuilder propFile = new StringBuilder(ProviderConstants.getDatDirectory());
        propFile.append(PROVIDERDATA_PROPERTIES);
        udFile = new File(propFile.toString());
        try (FileOutputStream out = new FileOutputStream(udFile);){
            mLogger.info("providerdata.properties writing data");
            this.mProps.store(out, null);
        }
        catch (FileNotFoundException fnf) {
            mLogger.log(Level.WARNING, "providerdata.properties could not opened for writing", fnf);
        }
        catch (IOException ioe) {
            throw new WBEMException(1, "Error writing data to providerdata.properties", null, (Throwable)ioe);
        }
    }

    public boolean useLegacyVolumeName() {
        String val = this.mProps.getProperty("ReportLegacyVolumeName", "false");
        return Boolean.parseBoolean(val);
    }
}

