/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.LDevNickname;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class AdvancedStorageSettingInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"InstanceID"});
            if (null != expectedValues) {
                if (1 == devices.size()) {
                    RMIObjectMapping device = devices.get(0);
                    String instID = (String)expectedValues.get("InstanceID");
                    DeviceNumber dn = this.getDNFromInstanceID(instID, device);
                    this.processAOUVol(op, device, dn, refInfo, isObjectPath, propertyList, iter);
                }
            } else {
                for (RMIObjectMapping device : devices) {
                    ClosableAddableIteratorCB<DeviceNumber> callback = new ClosableAddableIteratorCB<DeviceNumber>();
                    DeviceNumber.getDNs(device.getRMIObject(), callback, (short)-1);
                    CloseableAddableIterator<DeviceNumber> dns = callback.getWrappedCloseableAddableIter();
                    while (dns.hasNext()) {
                        this.processAOUVol(op, device, (DeviceNumber)dns.next(), refInfo, isObjectPath, propertyList, iter);
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        RMIObjectMapping device = (RMIObjectMapping)o[0];
        DeviceNumber dn = (DeviceNumber)o[1];
        try {
            CIMInstance instRet = null;
            if (null != op && null != device) {
                String nickName;
                LDevNickname nickNameObj = LDevNickname.find(dn);
                if (null != nickNameObj) {
                    nickName = nickNameObj.getNickname();
                } else {
                    StringBuilder t = new StringBuilder(device.getStorageSystemName());
                    t = t.append(".");
                    t = t.append(dn.getLDEVIDString());
                    nickName = t.toString();
                }
                String capDesc = device.getStorageSystemName() + "." + dn.getDn();
                CIMProperty[] keys = retOP.getKeys();
                CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("InitialStorageTieringSelection", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_THREE, false), new CIMProperty("InitialStorageTierMethodology", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FOUR, false), new CIMProperty("RelativePerformanceOrderLimit", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("StorageTieringFrozen", CIMDataType.BOOLEAN_T, (Object)dn.isTierRelocationFrozen(), false), new CIMProperty("InitialRelativePerformanceOrderSet", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_ZED, ProviderConstants.UINT16_ONE, ProviderConstants.UINT16_TWO}, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)capDesc, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)capDesc, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)nickName, false), new CIMProperty("ChangeableType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("DataRedundancyMax", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false), new CIMProperty("DataRedundancyMin", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false), new CIMProperty("DataRedundancyGoal", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false), new CIMProperty("PackageRedundancyMax", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("PackageRedundancyMin", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("PackageRedundancyGoal", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false)};
                instRet = new CIMInstance(retOP, props).filterProperties(propList);
            }
            return instRet;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        CIMObjectPath ret;
        block5: {
            ProviderLibs.validateVARArgs(new Class[]{RMIObjectMapping.class, DeviceNumber.class}, o, "HITACHI_AdvancedStorageSetting");
            ret = null;
            RMIObjectMapping device = (RMIObjectMapping)o[0];
            DeviceNumber dn = (DeviceNumber)o[1];
            try {
                if (null == op) break block5;
                StringBuilder systemName = new StringBuilder();
                try {
                    systemName = systemName.append(device.getStorageSystemName());
                    systemName = systemName.append(".");
                    systemName = systemName.append(dn.getDNAsString());
                }
                catch (Throwable th) {
                    throw new WBEMException(1, th.toString(), null, th);
                }
                CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)systemName.toString(), true)};
                ret = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_AdvancedStorageSetting", keys, op.getXmlSchemaName());
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        return ret;
    }

    private DeviceNumber getDNFromInstanceID(String instID, RMIObjectMapping device) throws WBEMException {
        String devID = ProviderLibs.getEndString(instID);
        mLogger.log(Level.FINE, "Looking up DN {0} on device {1} parsed from {2}", new Object[]{devID, device.getSerialNumber(), instID});
        return DeviceNumber.find(devID, device.getRMIObject());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            DeviceNumber dn;
            String instID = (String)op.getKeyValue("InstanceID");
            if (null == instID) {
                throw new WBEMException(6, op.toString());
            }
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
            if (instID.startsWith(device.getStorageSystemName()) && null != (dn = this.getDNFromInstanceID(instID, device))) {
                return this.generateInstance(op, propertyList, device, dn);
            }
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    private void processAOUVol(CIMObjectPath op, RMIObjectMapping device, DeviceNumber dn, ReferenceInfo refInfo, boolean isObjectPath, String[] propertyList, CustomCloseableIterator<?> iter) throws Exception {
        ThinPool tp;
        if (null != dn && dn.isAOUVol() && null != (tp = ThinPool.find(device.getRMIObject(), dn.getThinPoolID(), ThinPool.ThinPoolType.AOU)) && 2 == tp.getByPoolKind() && tp.isTierAllocationFunctionON()) {
            if (null != refInfo) {
                CIMObjectPath retOP = this.generateObjectPath(op, device, dn);
                refInfo.addReference(iter, retOP);
            } else if (isObjectPath) {
                iter.add(this.generateObjectPath(op, device, dn));
            } else {
                iter.add(this.generateInstance(op, propertyList, device, dn));
            }
        }
    }
}

