/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class DiskDriveDiskDriveViewInstrumentation
extends BaseAssocInstrumentation {
    protected DiskDriveDiskDriveViewInstrumentation() {
        super("HITACHI_DiskDriveDiskDriveView", "HITACHI_DiskDrive", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DiskDriveInstrumentation"), "HITACHI_DiskDriveView", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DiskDriveViewInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_DiskDriveDiskDriveView".equalsIgnoreCase(assocName.getObjectName())) {
                PDEVInfoEntry entry;
                int[] deviceIDValues;
                RMIObjectMapping device;
                String deviceID = null;
                String sysName = null;
                boolean returnDiskDrive = false;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Antecedent")) && (null == resultRole || resultRole.equalsIgnoreCase("Dependent")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    deviceID = objectName.getKey("DeviceID") != null && objectName.getKey("DeviceID").getValue() != null ? (String)objectName.getKey("DeviceID").getValue() : null;
                    sysName = objectName.getKey("SystemName") != null && objectName.getKey("SystemName").getValue() != null ? (String)objectName.getKey("SystemName").getValue() : null;
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "DDSystemName");
                    deviceID = objectName.getKey("DDDeviceID") != null && objectName.getKey("DDDeviceID").getValue() != null ? (String)objectName.getKey("DDDeviceID").getValue() : null;
                    sysName = objectName.getKey("DDSystemName") != null && objectName.getKey("DDSystemName").getValue() != null ? (String)objectName.getKey("DDSystemName").getValue() : null;
                    returnDiskDrive = true;
                } else {
                    device = null;
                }
                if (null != device && null != deviceID && null != sysName && sysName.equals(device.getStorageSystemName()) && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID(deviceID)) && (entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1])) != null) {
                    if (returnDiskDrive) {
                        if (isObjectPath) {
                            iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, entry));
                        } else {
                            iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, entry));
                        }
                    } else if (isObjectPath) {
                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, entry));
                    } else {
                        iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, entry));
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackIMPL<PDEVInfoEntry> callback = new CallbackIMPL<PDEVInfoEntry>(deviceIter, isObjectPath, refInfo, op, propertyList);
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opDiskDrive;
            String cpnDDView = this.getReference2PropertyName();
            CIMObjectPath opDDView = op.getKey(cpnDDView) != null ? (CIMObjectPath)op.getKey(cpnDDView).getValue() : null;
            String cpnDiskDrive = this.getReference1PropertyName();
            CIMObjectPath cIMObjectPath = opDiskDrive = op.getKey(cpnDiskDrive) != null ? (CIMObjectPath)op.getKey(cpnDiskDrive).getValue() : null;
            if (null != opDiskDrive && null != opDDView && this.getReference1Instrumentation().instanceExists(opDiskDrive) && this.getReference2Instrumentation().instanceExists(opDDView)) {
                PDEVInfoEntry entry;
                int[] deviceIDValues;
                String diskDriveSystemName;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opDiskDrive, "SystemName");
                String ddViewDeviceID = opDDView.getKey("DDDeviceID") != null && opDDView.getKey("DDDeviceID").getValue() != null ? (String)opDDView.getKey("DDDeviceID").getValue() : null;
                String ddViewSystemName = opDDView.getKey("DDSystemName") != null && opDDView.getKey("DDSystemName").getValue() != null ? (String)opDDView.getKey("DDSystemName").getValue() : null;
                String diskDriveDeviceID = opDiskDrive.getKey("DeviceID") != null && opDiskDrive.getKey("DeviceID").getValue() != null ? (String)opDiskDrive.getKey("DeviceID").getValue() : null;
                String string = diskDriveSystemName = opDiskDrive.getKey("SystemName") != null && opDiskDrive.getKey("SystemName").getValue() != null ? (String)opDiskDrive.getKey("SystemName").getValue() : null;
                if (null != diskDriveSystemName && null != ddViewSystemName && null != diskDriveDeviceID && null != ddViewDeviceID && diskDriveSystemName.equals(ddViewSystemName) && diskDriveDeviceID.equals(ddViewDeviceID) && diskDriveSystemName.equals(device.getStorageSystemName()) && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID(diskDriveDeviceID)) && (entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1])) != null) {
                    opDiskDrive = this.getReference1Instrumentation().generateObjectPath(op, entry);
                    opDDView = this.getReference2Instrumentation().generateObjectPath(op, entry);
                    return this.generateInstance(op, propertyList, opDiskDrive, opDDView);
                }
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_DiskDriveDiskDriveView".equalsIgnoreCase(assocName.getObjectName())) {
                PDEVInfoEntry entry;
                int[] deviceIDValues;
                RMIObjectMapping device;
                String deviceID = null;
                String sysName = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    deviceID = objectName.getKey("DeviceID") != null && objectName.getKey("DeviceID").getValue() != null ? (String)objectName.getKey("DeviceID").getValue() : null;
                    sysName = objectName.getKey("SystemName") != null && objectName.getKey("SystemName").getValue() != null ? (String)objectName.getKey("SystemName").getValue() : null;
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "DDSystemName");
                    deviceID = objectName.getKey("DDDeviceID") != null && objectName.getKey("DDDeviceID").getValue() != null ? (String)objectName.getKey("DDDeviceID").getValue() : null;
                    sysName = objectName.getKey("DDSystemName") != null && objectName.getKey("DDSystemName").getValue() != null ? (String)objectName.getKey("DDSystemName").getValue() : null;
                } else {
                    device = null;
                }
                if (null != device && null != deviceID && null != sysName && sysName.equals(device.getStorageSystemName()) && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID(deviceID)) && (entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1])) != null) {
                    CIMObjectPath opDiskDrive = this.getReference1Instrumentation().generateObjectPath(objectName, entry);
                    CIMObjectPath opDDview = this.getReference2Instrumentation().generateObjectPath(objectName, entry);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opDiskDrive, opDDview));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, opDiskDrive, opDDview));
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    public class CallbackIMPL<E extends PDEVInfoEntry>
    extends IteratorCallbackIMPL<E> {
        public CallbackIMPL(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block5: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E entry = item;
                        CIMObjectPath opDiskDrive = DiskDriveDiskDriveViewInstrumentation.this.getReference1Instrumentation().generateObjectPath(this.mOP, entry);
                        CIMObjectPath opDDView = DiskDriveDiskDriveViewInstrumentation.this.getReference2Instrumentation().generateObjectPath(this.mOP, entry);
                        if (this.mIsObjectPath) {
                            this.mIter.add(DiskDriveDiskDriveViewInstrumentation.this.generateObjectPath(this.mOP, opDiskDrive, opDDView));
                            break block5;
                        }
                        this.mIter.add(DiskDriveDiskDriveViewInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, opDiskDrive, opDDView));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                        ret = false;
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

