/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DiskDriveStatus;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.DiskDriveInstrumentation;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class DiskDriveViewInstrumentation
extends BaseInstrumentation {
    private void addDiskDriveProps(PDEVInfoEntry entry, ArrayList<CIMProperty<?>> props) {
        props.add(new CIMProperty("DDName", CIMDataType.STRING_T, (Object)entry.getDeviceID(), false));
        props.add(new CIMProperty("DDLocationIndicator", CIMDataType.UINT16_T, null, false));
        props.add(new CIMProperty("DDDiskType", CIMDataType.UINT16_T, (Object)DiskDriveInstrumentation.getDiskTypeAsUINT16(entry), false));
        props.add(new CIMProperty("DDFormFactor", CIMDataType.UINT16_T, (Object)DiskDriveInstrumentation.getFormFactorAsUINT16(entry), false));
        props.add(new CIMProperty("DDEncryption", CIMDataType.UINT16_T, (Object)DiskDriveInstrumentation.getEncryptionAsUINT16(entry), false));
        DiskDriveStatus status = DiskDriveStatus.getStatus(entry.getHddStatus());
        props.add(new CIMProperty("DDOperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(status.getOpStatus())}, false));
    }

    private void addPhysicalDiskProps(PDEVInfoEntry entry, ArrayList<CIMProperty<?>> props) throws Exception {
        String tag = RMIObjectMapping.getRMIObjectMapping(entry.getSerialNumber()).getStorageSystemName() + "." + entry.getDeviceID();
        String model = entry.getHddKind();
        Object partNum = null;
        String serialNum = entry.getHddSerial();
        props.add(new CIMProperty("PPCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_PhysicalDisk", false));
        props.add(new CIMProperty("PPTag", CIMDataType.STRING_T, (Object)tag, false));
        props.add(new CIMProperty("PPManufacturer", CIMDataType.STRING_T, (Object)"HITACHI", false));
        props.add(new CIMProperty("PPModel", CIMDataType.STRING_T, (Object)model, false));
        props.add(new CIMProperty("PPSerialNumber", CIMDataType.STRING_T, (Object)serialNum, false));
        props.add(new CIMProperty("PPPartNumber", CIMDataType.STRING_T, partNum, false));
    }

    private void addSoftwareIdentityProps(PDEVInfoEntry entry, ArrayList<CIMProperty<?>> props) throws Exception {
        String instanceID = RMIObjectMapping.getRMIObjectMapping(entry.getSerialNumber()).getStorageSystemName() + "." + entry.getDeviceID();
        props.add(new CIMProperty("SIInstanceID", CIMDataType.STRING_T, (Object)instanceID, false));
        props.add(new CIMProperty("SIVersionString", CIMDataType.STRING_T, (Object)"0", false));
        props.add(new CIMProperty("SIManufacturer", CIMDataType.STRING_T, (Object)"HITACHI", false));
        props.add(new CIMProperty("SIBuildNumber", CIMDataType.UINT16_T, null, false));
        props.add(new CIMProperty("SIMajorVersion", CIMDataType.UINT16_T, null, false));
        props.add(new CIMProperty("SIRevisionNumber", CIMDataType.UINT16_T, null, false));
        props.add(new CIMProperty("SIMinorVersion", CIMDataType.UINT16_T, null, false));
    }

    private void addStorageExtentProps(PDEVInfoEntry entry, ArrayList<CIMProperty<?>> props) throws Exception {
        UnsignedInteger64 cpvDiskCap = new UnsignedInteger64(String.valueOf(entry.getCapacityInBytes()));
        props.add(new CIMProperty("SESystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", false));
        props.add(new CIMProperty("SESystemName", CIMDataType.STRING_T, (Object)RMIObjectMapping.getRMIObjectMapping(entry.getSerialNumber()).getStorageSystemName(), false));
        props.add(new CIMProperty("SECreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_DiskExtent", false));
        props.add(new CIMProperty("SEDeviceID", CIMDataType.STRING_T, (Object)entry.getDeviceID(), false));
        props.add(new CIMProperty("SEBlockSize", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_512, false));
        props.add(new CIMProperty("SENumberOfBlocks", CIMDataType.UINT64_T, (Object)cpvDiskCap, false));
        props.add(new CIMProperty("SEConsumableBlocks", CIMDataType.UINT64_T, (Object)cpvDiskCap, false));
        props.add(new CIMProperty("SEExtentStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_SIX}, false));
        props.add(new CIMProperty("SEOperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(ProviderConstants.OP_STATUS_INDEX.OK.getStatusValue())}, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices;
            int expCDevNum = -1;
            int expRDevNum = -1;
            String chassis = null;
            if (null != expectedValues) {
                String sysName;
                Integer iRDevNum;
                Integer iCDevNum = (Integer)expectedValues.get("CDevNum");
                if (null != iCDevNum) {
                    expCDevNum = iCDevNum;
                }
                if (null != (iRDevNum = (Integer)expectedValues.get("RDevNum"))) {
                    expRDevNum = iRDevNum;
                }
                if (null != (sysName = (String)expectedValues.get("DDSystemName"))) {
                    chassis = ProviderLibs.getEndString(sysName);
                } else {
                    sysName = (String)expectedValues.get("SystemName");
                    if (null == sysName) {
                        throw new WBEMException("Could not find device: " + sysName);
                    }
                }
                String serial = ProviderLibs.getSerialFromString(sysName);
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serial);
                if (null == device) throw new WBEMException("Could not find device: " + sysName);
                devices = new ArrayList<RMIObjectMapping>(1);
                devices.add(device);
            } else {
                devices = ProviderLibs.getManagedDevices(op, "DDSystemName", expectedValues);
            }
            for (RMIObjectMapping device : devices) {
                CommonClassAsList<PDEVInfoEntry> callback = new CommonClassAsList<PDEVInfoEntry>();
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, expCDevNum, expRDevNum, chassis, -1, -1);
                LinkedList<PDEVInfoEntry> pdevs = callback.getReturnValue();
                for (PDEVInfoEntry pdev : pdevs) {
                    CIMObjectPath retOP;
                    if (null != refInfo) {
                        retOP = this.generateObjectPath(op, pdev);
                        refInfo.addReference(iter, retOP);
                        continue;
                    }
                    if (isObjectPath) {
                        retOP = this.generateObjectPath(op, pdev);
                        iter.add(retOP);
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, pdev));
                }
            }
            return;
        }
        catch (WBEMException we) {
            iter.setException(we);
            iter.close();
            return;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, "Exception during enum operation: " + th, null, th);
            iter.setException(we);
            iter.close();
            return;
        }
        finally {
            if (iter != null && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        PDEVInfoEntry entry = (PDEVInfoEntry)o[0];
        try {
            CIMProperty[] keys = retOP.getKeys();
            ArrayList props = new ArrayList();
            props.add(keys[0]);
            props.add(keys[1]);
            props.add(keys[2]);
            props.add(keys[3]);
            this.addStorageExtentProps(entry, props);
            this.addDiskDriveProps(entry, props);
            this.addPhysicalDiskProps(entry, props);
            this.addSoftwareIdentityProps(entry, props);
            String ddv = "HITACHI_DiskDriveView".substring("HITACHI_".length());
            props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)ddv, false));
            props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)ddv, false));
            props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)ddv, false));
            return new CIMInstance(retOP, props.toArray(new CIMProperty[props.size()])).filterProperties(propList);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{PDEVInfoEntry.class}, o, "HITACHI_DiskDriveView");
        PDEVInfoEntry entry = (PDEVInfoEntry)o[0];
        String systemName = RMIObjectMapping.getRMIObjectMapping(entry.getSerialNumber()).getStorageSystemName();
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("DDCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_DiskDrive", true), new CIMProperty("DDDeviceID", CIMDataType.STRING_T, (Object)entry.getDeviceID(), true), new CIMProperty("DDSystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("DDSystemName", CIMDataType.STRING_T, (Object)systemName, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_DiskDriveView", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "DDSystemName");
        try {
            PDEVInfoEntry entry;
            int[] deviceIDValues;
            String ssName;
            CIMProperty cpDeviceID = op.getKey("DDDeviceID");
            String cvDeviceID = (String)(cpDeviceID != null ? cpDeviceID.getValue() : null);
            CIMProperty cpCCN = op.getKey("DDCreationClassName");
            String cvCCN = (String)(cpCCN != null ? cpCCN.getValue() : null);
            CIMProperty cpSCCN = op.getKey("DDSystemCreationClassName");
            String cvSCCN = (String)(cpSCCN != null ? cpSCCN.getValue() : null);
            CIMProperty cpSystemName = op.getKey("DDSystemName");
            String cvSystemName = (String)(cpSystemName != null ? cpSystemName.getValue() : null);
            if (null != cvDeviceID && null != cvCCN && null != cvSCCN && null != cvSystemName && cvSystemName.equals(ssName = device.getStorageSystemName()) && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID(cvDeviceID)) && null != (entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1]))) {
                return this.generateInstance(op, propertyList, entry);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op != null ? op.toString() : null);
    }
}

