/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.StorageVolumeCallbackHandler;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMDataType;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class ElementSettingDataThinProvisioningVolumeInstrumentation
extends BaseAssocInstrumentation {
    private static final String CCN_HITACHI_ELEMENTSETTINGDATATHINPROVISIONINGVOLUME = "HITACHI_ElementSettingDataThinProvisioningVolume";
    private static final String CCN_SETTINGDATA = "HITACHI_ThinProvisioningVolumeSetting";

    protected ElementSettingDataThinProvisioningVolumeInstrumentation() {
        super(CCN_HITACHI_ELEMENTSETTINGDATATHINPROVISIONINGVOLUME, "HITACHI_StorageVolume", "ManagedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"), CCN_SETTINGDATA, "SettingData", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ThinProvisioningVolumeSettingInstrumentation"));
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                StorageVolumeCallbackHandler<DeviceNumber> callback = new StorageVolumeCallbackHandler<DeviceNumber>(deviceIter, isObjectPath, refInfo, op, propertyList, VolumeTypeEnum.AOUVOL, this);
                DeviceNumber.getDNs(device.getRMIObject(), callback, (short)-1, false, VolumeTypeEnum.AOUVOL);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMProperty<?>[] getAdditionalProperties() {
        return new CIMProperty[]{new CIMProperty("IsDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("IsCurrent", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false)};
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath opRef2) {
        String sysName;
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String string = sysName = null != opRef2 && null != opRef2.getKey("InstanceID") ? (String)opRef2.getKey("InstanceID").getValue() : null;
        if (null != sysName) {
            hTable.put("DeviceID", ProviderLibs.getEndString(sysName));
            int index = sysName.indexOf(".");
            if (-1 != index) {
                String name = sysName.substring(index + 1);
                hTable.put("SystemName", ProviderLibs.getAllButEndString(name, ProviderConstants.ID_SEPERATOR_AS_CHAR));
            }
        }
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opStorageVolume) {
        String[] props;
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        for (String prop : props = new String[]{"SystemName", "DeviceID"}) {
            String val;
            String string = val = null != opStorageVolume && null != opStorageVolume.getKey(prop) ? (String)opStorageVolume.getKey(prop).getValue() : null;
            if (val == null) continue;
            hTable.put(prop, val);
        }
        return hTable;
    }
}

