/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class FreeSpaceBasedOnArrayGroupInstrumentation
extends BaseAssocInstrumentation {
    protected FreeSpaceBasedOnArrayGroupInstrumentation() {
        super("HITACHI_FreeSpaceBasedOnArrayGroup", "HITACHI_ArrayGroup", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ArrayGroupInstrumentation"), "HITACHI_FreeSpace", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.FreeSpaceInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            boolean closeIter = false;
            if (null != assocName && "HITACHI_FreeSpaceBasedOnArrayGroup".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Antecedent")) && (null == resultRole || resultRole.equalsIgnoreCase("Dependent"))) {
                    if (!shouldTestInst || this.getReference1Instrumentation().instanceExists(objectName)) {
                        String sysName;
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        String chassisArrayID = objectName.getKey("DeviceID") != null && objectName.getKey("DeviceID").getValue() != null ? (String)objectName.getKey("DeviceID").getValue() : null;
                        String string = sysName = objectName.getKey("SystemName") != null && objectName.getKey("SystemName").getValue() != null ? (String)objectName.getKey("SystemName").getValue() : null;
                        if (null != chassisArrayID && null != sysName && sysName.equals(device.getStorageSystemName())) {
                            CallbackHandler<ChassisArrayGroup> callback = new CallbackHandler<ChassisArrayGroup>(iter, isObjectPath, null, objectName, propertyList, true);
                            ChassisArrayGroup.getChassisArrayGroup(device.getRMIObject(), callback, isObjectPath, chassisArrayID);
                        }
                    } else {
                        closeIter = true;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    closeIter = true;
                    if (!shouldTestInst || this.getReference2Instrumentation().instanceExists(objectName)) {
                        ChassisArrayGroup cag;
                        String sysName;
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        String deviceID = objectName.getKey("DeviceID") != null && objectName.getKey("DeviceID").getValue() != null ? (String)objectName.getKey("DeviceID").getValue() : null;
                        String chassisArrayID = ProviderLibs.getAllButEndString(deviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                        String string = sysName = objectName.getKey("SystemName") != null && objectName.getKey("SystemName").getValue() != null ? (String)objectName.getKey("SystemName").getValue() : null;
                        if (null != chassisArrayID && chassisArrayID.length() > 0 && null != sysName && sysName.equals(device.getStorageSystemName()) && null != (cag = ChassisArrayGroup.find(device.getRMIObject(), isObjectPath, chassisArrayID))) {
                            if (isObjectPath) {
                                iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, cag));
                            } else {
                                iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, cag));
                            }
                        }
                    }
                } else {
                    closeIter = true;
                }
            } else {
                closeIter = true;
            }
            if (closeIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackHandler<ChassisArrayGroup> callback = new CallbackHandler<ChassisArrayGroup>(deviceIter, isObjectPath, refInfo, op, propertyList, false);
                ChassisArrayGroup.getChassisArrayGroup(device.getRMIObject(), callback, isObjectPath);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opFreeSpace;
            String cpnArrayGroup = this.getReference1PropertyName();
            CIMObjectPath opArrayGroup = op.getKey(cpnArrayGroup) != null ? (CIMObjectPath)op.getKey(cpnArrayGroup).getValue() : null;
            String cpnFreeSpace = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opFreeSpace = op.getKey(cpnFreeSpace) != null ? (CIMObjectPath)op.getKey(cpnFreeSpace).getValue() : null;
            if (null != opFreeSpace && null != opArrayGroup && this.getReference1Instrumentation().instanceExists(opArrayGroup) && this.getReference2Instrumentation().instanceExists(opFreeSpace)) {
                String fsSysName;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opArrayGroup, "SystemName");
                String agChassisArrayID = opArrayGroup.getKey("DeviceID") != null && opArrayGroup.getKey("DeviceID").getValue() != null ? (String)opArrayGroup.getKey("DeviceID").getValue() : null;
                String agSysName = opArrayGroup.getKey("SystemName") != null && opArrayGroup.getKey("SystemName").getValue() != null ? (String)opArrayGroup.getKey("SystemName").getValue() : null;
                String fsDeviceID = opFreeSpace.getKey("DeviceID") != null && opFreeSpace.getKey("DeviceID").getValue() != null ? (String)opFreeSpace.getKey("DeviceID").getValue() : null;
                String fsChassisArrayID = ProviderLibs.getAllButEndString(fsDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                String string = fsSysName = opFreeSpace.getKey("SystemName") != null && opFreeSpace.getKey("SystemName").getValue() != null ? (String)opFreeSpace.getKey("SystemName").getValue() : null;
                if (null != fsSysName && null != agSysName && null != agChassisArrayID && null != fsChassisArrayID && fsSysName.equals(agSysName) && agChassisArrayID.equals(fsChassisArrayID) && fsSysName.equals(device.getStorageSystemName())) {
                    Integer[] cagVals = ProviderLibs.getChassisAndArrayGroupFromDeviceID(fsDeviceID);
                    ChassisArrayGroup cag = ChassisArrayGroup.find(device.getRMIObject(), null, cagVals[0], cagVals[1], false);
                    if (cag != null) {
                        opArrayGroup = this.getReference1Instrumentation().generateObjectPath(op, cag);
                        opFreeSpace = this.getReference2Instrumentation().generateObjectPath(op, cag, cagVals[2]);
                        return this.generateInstance(op, propertyList, opArrayGroup, opFreeSpace);
                    }
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    protected CIMProperty<?>[] getProperties(CIMProperty<?>[] keys) throws WBEMException {
        CIMProperty[] ret;
        ArrayList props = new ArrayList();
        ProviderLibs.addKeysToProperties(keys, props);
        props.add(new CIMProperty("StartingAddress", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false));
        props.add(new CIMProperty("EndingAddress", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false));
        props.add(new CIMProperty("OrderIndex", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false));
        try {
            ret = props.toArray(new CIMProperty[props.size()]);
        }
        catch (Exception e) {
            throw new WBEMException(1, "Unable to convert list to array", null, (Throwable)e);
        }
        return ret;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean closeIter = true;
            if (null != assocName && "HITACHI_FreeSpaceBasedOnArrayGroup".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    CIMInstance instArrayGroup = null;
                    try {
                        instArrayGroup = this.getReference1Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException e) {
                        // empty catch block
                    }
                    if (null != instArrayGroup) {
                        String chassisArrayID = objectName.getKey("DeviceID") != null && objectName.getKey("DeviceID").getValue() != null ? (String)objectName.getKey("DeviceID").getValue() : null;
                        String sysName = objectName.getKey("SystemName") != null && objectName.getKey("SystemName").getValue() != null ? (String)objectName.getKey("SystemName").getValue() : null;
                        String serial = ProviderLibs.getSerialFromString(sysName);
                        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serial);
                        if (null != sysName && sysName.equals(device.getStorageSystemName())) {
                            Hashtable<String, Object> searchProps = new Hashtable<String, Object>();
                            searchProps.put("ChassisArrayID", chassisArrayID);
                            searchProps.put("SystemName", sysName);
                            CIMObjectPath fsOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null);
                            ReferenceInfo newRefInfo = new ReferenceInfo(instArrayGroup.getObjectPath(), null, this.getReference1PropertyName(), this.getReference2PropertyName(), propertyList, isObjectPath, this);
                            this.getReference2Instrumentation().enumerate(iter, fsOP, new String[0], null, null, continueOnError, true, searchProps, newRefInfo);
                            closeIter = false;
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    CIMInstance instFreeSpace = null;
                    try {
                        instFreeSpace = this.getReference2Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException e) {
                        // empty catch block
                    }
                    if (null != instFreeSpace) {
                        ChassisArrayGroup cag;
                        String deviceID = objectName.getKey("DeviceID") != null && objectName.getKey("DeviceID").getValue() != null ? (String)objectName.getKey("DeviceID").getValue() : null;
                        String chassisArrayID = ProviderLibs.getAllButEndString(deviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                        String sysName = objectName.getKey("SystemName") != null && objectName.getKey("SystemName").getValue() != null ? (String)objectName.getKey("SystemName").getValue() : null;
                        String serial = ProviderLibs.getSerialFromString(sysName);
                        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serial);
                        if (null != chassisArrayID && chassisArrayID.length() > 0 && null != sysName && sysName.equals(device.getStorageSystemName()) && null != (cag = ChassisArrayGroup.find(device.getRMIObject(), isObjectPath, chassisArrayID))) {
                            CIMObjectPath opFreeSpace = instFreeSpace.getObjectPath();
                            CIMObjectPath opArrayGroup = this.getReference1Instrumentation().generateObjectPath(objectName, cag);
                            if (isObjectPath) {
                                iter.add(this.generateObjectPath(objectName, opArrayGroup, opFreeSpace));
                            } else {
                                iter.add(this.generateInstance(objectName, propertyList, opArrayGroup, opFreeSpace));
                            }
                        }
                    }
                }
            }
            if (closeIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    private class CallbackHandler<E extends ChassisArrayGroup>
    extends IteratorCallbackIMPL<E> {
        boolean mIsAssocEnumCall;

        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, boolean isAssocEnumCall) {
            super(iter, isObjectPath, refInfo, op, propertyList);
            this.mIsAssocEnumCall = false;
            this.mIsAssocEnumCall = isAssocEnumCall;
        }

        private void doAssocEnumReturn(ChassisArrayGroup cag, int x) throws Exception {
            if (this.mIsObjectPath) {
                this.mIter.add(FreeSpaceBasedOnArrayGroupInstrumentation.this.getReference2Instrumentation().generateObjectPath(this.mOP, cag, x));
            } else {
                this.mIter.add(FreeSpaceBasedOnArrayGroupInstrumentation.this.getReference2Instrumentation().generateInstance(this.mOP, this.mPropertyList, cag, x));
            }
        }

        private void doEnumReturn(ChassisArrayGroup cag, int x) throws Exception {
            if (!cag.isAouVol()) {
                CIMObjectPath agOP = FreeSpaceBasedOnArrayGroupInstrumentation.this.getReference1Instrumentation().generateObjectPath(this.mOP, cag);
                CIMObjectPath fsOP = FreeSpaceBasedOnArrayGroupInstrumentation.this.getReference2Instrumentation().generateObjectPath(this.mOP, cag, x);
                if (this.mIsObjectPath) {
                    this.mIter.add(FreeSpaceBasedOnArrayGroupInstrumentation.this.generateObjectPath(this.mOP, agOP, fsOP));
                } else {
                    this.mIter.add(FreeSpaceBasedOnArrayGroupInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, agOP, fsOP));
                }
            }
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (!this.mIter.isClosed()) {
                try {
                    E cag = item;
                    int numFreeSpaces = ((ChassisArrayGroup)cag).getFsIndex();
                    for (int x = 0; x < numFreeSpaces; ++x) {
                        if (this.mIsAssocEnumCall) {
                            this.doAssocEnumReturn((ChassisArrayGroup)cag, x);
                            continue;
                        }
                        this.doEnumReturn((ChassisArrayGroup)cag, x);
                    }
                }
                catch (WBEMException we) {
                    this.mIter.setException(we);
                    this.mIter.close();
                }
                catch (Throwable thrown) {
                    WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            } else {
                ret = false;
            }
            return ret;
        }
    }
}

