/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ExternalChassisArrayGroup;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import javax.wbem.WBEMException;

public class ImportedStorageExtentInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_ImportedStorageExtent", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_ImportedStorageExtent added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_ImportedStorageExtent", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_ImportedStorageExtent deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_ImportedStorageExtent", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance prevInstance = this.generateInstance(op, null, pObj);
                ExternalChassisArrayGroup ecag = (ExternalChassisArrayGroup)pObj;
                ExternalChassisArrayGroup newECAG = ExternalChassisArrayGroup.find(ecag.getChassis(), (Integer)ecag.getArrayGroup(), RMIObjectMapping.getRMIObjectMapping(ecag.getSerialNumber()).getRMIObject(), false);
                if (newECAG != null) {
                    CIMInstance sourceInstance = this.generateInstance(op, null, newECAG);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstModificationInstance(sourceInstance, prevInstance);
                    mHandle.deliverEvent(indication, null);
                } else {
                    mLogger.severe("Unable to find an external extent: " + ecag);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_ImportedStorageExtent modified indication instance", t);
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues, new String[]{"SystemName", "InstanceID"});
            int fb4 = -1;
            int ag = -1;
            int pg = -1;
            if (null != expectedValues) {
                String expInstID;
                if (1 != devices.size()) {
                    throw new WBEMException("Found " + devices.size() + " managed devices for " + op);
                }
                String string = expInstID = null != expectedValues ? (String)expectedValues.get("InstanceID") : null;
                if (null != expInstID) {
                    Integer[] rets = ProviderLibs.getStoragePoolChassisAndArrayGroup(expInstID);
                    fb4 = rets[0];
                    ag = rets[1];
                } else {
                    String expDevID = null != expectedValues ? (String)expectedValues.get("DeviceID") : null;
                    DeviceNumber dn = DeviceNumber.find(expDevID, devices.get(0).getRMIObject());
                    if (null != dn) {
                        fb4 = dn.getFb4();
                        pg = dn.getPg();
                    }
                }
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackHandler<ExternalChassisArrayGroup> callback = new CallbackHandler<ExternalChassisArrayGroup>(deviceIter, isObjectPath, refInfo, op, propertyList, ag);
                ExternalChassisArrayGroup.getExternalChassisArrayGroup(device.getRMIObject(), callback, isObjectPath, fb4, pg, ag);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath opRet = this.generateObjectPath(op, o);
        ExternalChassisArrayGroup ecag = (ExternalChassisArrayGroup)o[0];
        try {
            CIMInstance ret = null;
            String name = String.valueOf(ecag.getChassis()) + "." + ecag.getArrayGroup();
            ArrayList props = new ArrayList();
            CIMProperty[] keys = opRet.getKeys();
            ProviderLibs.addKeysToProperties(keys, props);
            props.add(new CIMProperty("ConsistsOf", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
            props.add(new CIMProperty("ExternalStorageName", CIMDataType.STRING_T, (Object)ecag.getExternalStorageName(), false));
            props.add(new CIMProperty("ExternalStorageSerialNumber", CIMDataType.STRING_T, (Object)ecag.getExternalStorageSerialNumber(), false));
            props.add(new CIMProperty("ExternalDeviceID", CIMDataType.STRING_T, (Object)ecag.getExternalDeviceID(), false));
            props.add(new CIMProperty("ExternalStorageVolumeName", CIMDataType.STRING_T, (Object)ecag.getExternalStorageVolumeName(), false));
            props.add(new CIMProperty("ExternalStorageProductName", CIMDataType.STRING_T, (Object)ecag.getExternalStorageProductName(), false));
            props.add(new CIMProperty("ExternalVendor", CIMDataType.STRING_T, (Object)ecag.getExternalVendor(), false));
            props.add(new CIMProperty("ExternalTargetPortWWN", CIMDataType.STRING_ARRAY_T, (Object)ecag.getExternalTargetPortWWN(), false));
            props.add(new CIMProperty("ExternalDeviceNumber", CIMDataType.STRING_ARRAY_T, (Object)ecag.getExternalDeviceNumber(), false));
            props.add(new CIMProperty("SVDeviceIDs", CIMDataType.STRING_ARRAY_T, (Object)ecag.getSVDeviceIDs("HITACHI_ImportedStorageExtent"), false));
            props.add(new CIMProperty("DataOrganization", CIMDataType.UINT16_T, (Object)ecag.getDataOrg(), false));
            props.add(new CIMProperty("ErrorMethodology", CIMDataType.STRING_T, (Object)ecag.getRaidLevel(), false));
            props.add(new CIMProperty("BlockSize", CIMDataType.UINT64_T, (Object)ecag.getBlockSize(), false));
            UnsignedInteger64 cvNumberOfBlocks = ecag.getNumberOfBlocks();
            props.add(new CIMProperty("NumberOfBlocks", CIMDataType.UINT64_T, (Object)cvNumberOfBlocks, false));
            UnsignedInteger64 cvConsumableBlocks = ecag.getConsumableblocks();
            props.add(new CIMProperty("ConsumableBlocks", CIMDataType.UINT64_T, (Object)cvConsumableBlocks, false));
            props.add(new CIMProperty("IsBasedOnUnderlyingRedundancy", CIMDataType.BOOLEAN_T, (Object)new Boolean(false), false));
            props.add(new CIMProperty("SequentialAccess", CIMDataType.BOOLEAN_T, (Object)new Boolean(false), false));
            UnsignedInteger16[] cvExtentStatus = new UnsignedInteger16[]{ProviderConstants.UINT16_SIX};
            props.add(new CIMProperty("ExtentStatus", CIMDataType.UINT16_ARRAY_T, (Object)cvExtentStatus, false));
            props.add(new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)new Boolean(false), false));
            UnsignedInteger16 cvDataRedundancy = ProviderConstants.UINT16_ONE;
            props.add(new CIMProperty("DataRedundancy", CIMDataType.UINT16_T, (Object)cvDataRedundancy, false));
            UnsignedInteger16 cvPackageRedundancy = ProviderConstants.UINT16_ZED;
            props.add(new CIMProperty("PackageRedundancy", CIMDataType.UINT16_T, (Object)cvPackageRedundancy, false));
            UnsignedInteger8 cvSorageSystemName = ProviderConstants.UINT8_100;
            props.add(new CIMProperty("DeltaReservation", CIMDataType.UINT8_T, (Object)cvSorageSystemName, false));
            props.add(new CIMProperty("Primordial", CIMDataType.BOOLEAN_T, (Object)new Boolean(true), false));
            props.add(new CIMProperty("Name", CIMDataType.STRING_T, (Object)name, false));
            props.add(new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
            props.add(new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false));
            props.add(new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
            props.add(new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(ProviderConstants.OP_STATUS_INDEX.OK.getStatusValue())}, false));
            props.add(new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false));
            props.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
            props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)name, false));
            props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)name, false));
            props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)("HITACHI_ImportedStorageExtent:" + name), false));
            props.add(new CIMProperty("ExtentDiscriminator", CIMDataType.STRING_ARRAY_T, (Object)new String[]{"SNIA:Imported"}, false));
            ret = new CIMInstance(opRet, props.toArray(new CIMProperty[props.size()])).filterProperties(propList);
            return ret;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath p, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{ExternalChassisArrayGroup.class}, o, "HITACHI_ImportedStorageExtent");
        ExternalChassisArrayGroup ecag = (ExternalChassisArrayGroup)o[0];
        try {
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(ecag.getSerialNumber());
            String sysName = device.getStorageSystemName();
            String deviceID = String.valueOf(ecag.getChassis()) + "." + ecag.getArrayGroup();
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_ImportedStorageExtent", true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)sysName, true), new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)deviceID, true)};
            return new CIMObjectPath(p.getScheme(), p.getHost(), p.getPort(), p.getNamespace(), "HITACHI_ImportedStorageExtent", keys, p.getXmlSchemaName());
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            Integer ag;
            String sysNameKeyVal;
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
            String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            String sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            String deviceIDKeyVal = null != op.getKey("DeviceID") ? (String)op.getKey("DeviceID").getValue() : null;
            String string = sysNameKeyVal = null != op.getKey("SystemName") ? (String)op.getKey("SystemName").getValue() : null;
            if (null == deviceIDKeyVal || null == sysNameKeyVal || null == ccName || !ccName.equals("HITACHI_ImportedStorageExtent") || null == sccName || !sccName.equals("HITACHI_StorageSystem")) {
                throw new WBEMException(6, op.toString());
            }
            int firstDot = deviceIDKeyVal.indexOf(".");
            String sub = deviceIDKeyVal.substring(0, firstDot++);
            Integer fb4 = Integer.valueOf(sub);
            ExternalChassisArrayGroup data = ExternalChassisArrayGroup.find(fb4, ag = Integer.valueOf(sub = deviceIDKeyVal.substring(firstDot)), device.getRMIObject(), false);
            if (data != null) {
                return this.generateInstance(op, propertyList, data);
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM HITACHI_InstCreation WHERE SourceInstance ISA HITACHI_ImportedStorageExtent".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM HITACHI_InstDeletion WHERE SourceInstance ISA HITACHI_ImportedStorageExtent".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM HITACHI_InstModification WHERE SourceInstance ISA HITACHI_ImportedStorageExtent".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.ECAG, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.ECAG, this, null);
        }
    }

    private class CallbackHandler<E extends ExternalChassisArrayGroup>
    extends IteratorCallbackIMPL<E> {
        private int arrayGroup;

        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, int ag) {
            super(iter, isObjectPath, refInfo, op, propertyList);
            this.arrayGroup = -1;
            this.arrayGroup = ag;
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block7: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E ecag = item;
                        if (-1 != this.arrayGroup && ((ChassisArrayGroup)ecag).getArrayGroup() != this.arrayGroup) {
                            ret = true;
                            break block7;
                        }
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, ImportedStorageExtentInstrumentation.this.generateObjectPath(this.mOP, ecag));
                            break block7;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(ImportedStorageExtentInstrumentation.this.generateObjectPath(this.mOP, ecag));
                            break block7;
                        }
                        this.mIter.add(ImportedStorageExtentInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, ecag));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

