/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstrumentationRegistry {
    private static HashMap<String, BaseInstrumentation> map = new HashMap(300);
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");

    protected InstrumentationRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseInstrumentation getInstance(String classname) {
        BaseInstrumentation singleton = map.get(classname);
        if (singleton == null) {
            HashMap<String, BaseInstrumentation> hashMap = map;
            synchronized (hashMap) {
                singleton = map.get(classname);
                if (singleton == null) {
                    try {
                        singleton = (BaseInstrumentation)Class.forName(classname).newInstance();
                    }
                    catch (Throwable e) {
                        mLogger.log(Level.SEVERE, "Could not load instrumentation file: " + classname, e);
                        throw new IllegalArgumentException(classname + " can not be loaded", e);
                    }
                    map.put(classname, singleton);
                }
            }
        }
        return singleton;
    }
}

