/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.SnapshotInfo2;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class MemberOfSnapshotTargetVolumeCollectionInstrumentation
extends BaseAssocInstrumentation {
    protected MemberOfSnapshotTargetVolumeCollectionInstrumentation() {
        super("HITACHI_MemberOfSnapshotTargetVolumeCollection", "HITACHI_AllocatedSnapshotTargetResources", "Collection", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.AllocatedSnapshotTargetResourcesInstrumentation"), "HITACHI_StorageVolume", "Member", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_MemberOfSnapshotTargetVolumeCollection".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Collection")) && (null == resultRole || resultRole.equalsIgnoreCase("Member"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        SnapshotInfo2 pairData;
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                        CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                        SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback);
                        LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                        while ((pairData = (SnapshotInfo2)pairDataList.poll()) != null) {
                            DeviceNumber sVolDN = pairData.getSVol();
                            if (isObjectPath) {
                                iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, sVolDN));
                                continue;
                            }
                            iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, sVolDN));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("Member")) && (null == resultRole || resultRole.equalsIgnoreCase("Collection")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                    if (null != cpDeviceID) {
                        String deviceNum = (String)cpDeviceID.getValue();
                        CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                        SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, deviceNum, Boolean.FALSE);
                        LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                        if (!pairDataList.isEmpty()) {
                            pairDataList = null;
                            if (isObjectPath) {
                                iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                            } else {
                                iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                            }
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                SnapshotInfo2 pairData;
                CIMObjectPath opSnapshotTargetResource = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback);
                LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                while ((pairData = (SnapshotInfo2)pairDataList.poll()) != null) {
                    DeviceNumber sVolDN = pairData.getSVol();
                    CIMObjectPath opStorageVolume = this.getReference2Instrumentation().generateObjectPath(op, sVolDN);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, opSnapshotTargetResource, opStorageVolume));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, opSnapshotTargetResource, opStorageVolume));
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        block9: {
            try {
                String pnStorageVolume = this.getReference2PropertyName();
                CIMObjectPath opStorageVolume = opObjectName.getKey(pnStorageVolume) != null ? (CIMObjectPath)opObjectName.getKey(pnStorageVolume).getValue() : null;
                CIMInstance instStorageVolume = null;
                try {
                    instStorageVolume = this.getReference2Instrumentation().getInstance(opStorageVolume, null);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageVolume, "SystemName");
                if (null == instStorageVolume) break block9;
                String pnSnapshotTargetResource = this.getReference1PropertyName();
                CIMObjectPath opSnapshotTargetResource = opObjectName.getKey(pnSnapshotTargetResource) != null ? (CIMObjectPath)opObjectName.getKey(pnSnapshotTargetResource).getValue() : null;
                CIMInstance instSnapshotTargetResource = null;
                try {
                    instSnapshotTargetResource = this.getReference1Instrumentation().getInstance(opSnapshotTargetResource, new String[0]);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null != instSnapshotTargetResource) {
                    opStorageVolume = instStorageVolume.getObjectPath();
                    String cpvDeviceID = (String)instStorageVolume.getPropertyValue("DeviceID");
                    CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                    SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, cpvDeviceID, Boolean.FALSE);
                    LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                    if (!pairDataList.isEmpty()) {
                        return this.generateInstance(opObjectName, propertyList, instSnapshotTargetResource.getObjectPath(), opStorageVolume);
                    }
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_MemberOfSnapshotTargetVolumeCollection".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_AllocatedSnapshotTargetResources") && (null == role || role.equalsIgnoreCase("Collection")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    SnapshotInfo2 pairData;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    CIMObjectPath opSnapshotTargetResource = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                    SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback);
                    LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                    while ((pairData = (SnapshotInfo2)pairDataList.poll()) != null) {
                        DeviceNumber sVolDN = pairData.getSVol();
                        CIMObjectPath opStorageVolume = this.getReference2Instrumentation().generateObjectPath(objectName, sVolDN);
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(objectName, opSnapshotTargetResource, opStorageVolume));
                            continue;
                        }
                        iter.add(this.generateInstance(objectName, propertyList, opSnapshotTargetResource, opStorageVolume));
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageVolume") && (null == role || role.equalsIgnoreCase("Member")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                    if (null != cpDeviceID) {
                        String deviceNum = (String)cpDeviceID.getValue();
                        CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                        SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, deviceNum, Boolean.FALSE);
                        LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                        if (!pairDataList.isEmpty()) {
                            DeviceNumber dn = ((SnapshotInfo2)pairDataList.poll()).getSVol();
                            pairDataList = null;
                            CIMObjectPath opStorageVolume = this.getReference2Instrumentation().generateObjectPath(objectName, dn);
                            CIMObjectPath opSnapshotTargetResource = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                            if (isObjectPath) {
                                iter.add(this.generateObjectPath(objectName, opSnapshotTargetResource, opStorageVolume));
                            } else {
                                iter.add(this.generateInstance(objectName, propertyList, opSnapshotTargetResource, opStorageVolume));
                            }
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

