/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.common.TierInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public final class MemberOfStorageTierInstrumentation
extends BaseAssocInstrumentation {
    protected MemberOfStorageTierInstrumentation() {
        super("HITACHI_MemberOfStorageTier", "HITACHI_StorageTier", "Collection", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageTierInstrumentation"), "HITACHI_StorageVolume", "Member", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_MemberOfStorageTier".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    if (!shouldTestInst || this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                        String instanceID = null != objectName.getKey("InstanceID") ? (String)objectName.getKey("InstanceID").getValue() : null;
                        short[] instanceIDVals = TierInfo.getStorageTierInstanceIDValues(instanceID, null);
                        if (null != instanceIDVals) {
                            this.getStorageVolumesFromThinPool(device.getRMIObject(), iter, objectName, propertyList, isObjectPath, instanceIDVals[0], instanceIDVals[1], -1L, true);
                        }
                    }
                } else if (!(!objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) || null != role && !role.equalsIgnoreCase(this.getReference2PropertyName()) || null != resultRole && !resultRole.equalsIgnoreCase(this.getReference1PropertyName()) || shouldTestInst && !this.getReference2Instrumentation().instanceExists(objectName))) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    String strDevID = null != objectName.getKey("DeviceID") ? (String)objectName.getKey("DeviceID").getValue() : null;
                    DeviceNumber dn = DeviceNumber.find(strDevID, device.getRMIObject());
                    if (dn != null) {
                        ThinPool tp;
                        CommonClassAsList<ThinPool> callback = new CommonClassAsList<ThinPool>();
                        ThinPool.getThinPools(device.getRMIObject(), callback, dn.getThinPoolID(), -1L, ThinPool.ThinPoolType.AOU, true);
                        LinkedList<ThinPool> tps = callback.getReturnValue();
                        callback = null;
                        while (null != (tp = tps.poll())) {
                            TierInfo[] tierInfos;
                            if (tp == null || !tp.checkIfDNContainsPool(dn)) continue;
                            for (TierInfo tierInfo : tierInfos = tp.getTierInfo()) {
                                if (!tierInfo.createdFromLDev(strDevID)) continue;
                                if (isObjectPath) {
                                    iter.add(this.getReference1Instrumentation().generateObjectPath(assocName, tierInfo));
                                    continue;
                                }
                                iter.add(this.getReference1Instrumentation().generateInstance(assocName, propertyList, tierInfo));
                            }
                        }
                    } else {
                        mLogger.info("Could not find a DeviceNumber with ID: " + strDevID);
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        int poolID = -1;
        long ldevNum = -1L;
        int tierNum = -1;
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                ThinPool thinPool;
                CommonClassAsList<ThinPool> callback = new CommonClassAsList<ThinPool>();
                ThinPool.getThinPools(device.getRMIObject(), callback, (short)-1, -1L, ThinPool.ThinPoolType.AOU, true);
                LinkedList<ThinPool> thinPools = callback.getReturnValue();
                callback = null;
                while (null != (thinPool = thinPools.poll())) {
                    this.getStorageVolumesFromThinPool(device.getRMIObject(), iter, op, propertyList, isObjectPath, thinPool.getPoolID(), (short)-1, -1L, false);
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (iter != null && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        block10: {
            try {
                String pnStorageVolume = this.getReference2PropertyName();
                CIMObjectPath opStorageVolume = opObjectName.getKey(pnStorageVolume) != null ? (CIMObjectPath)opObjectName.getKey(pnStorageVolume).getValue() : null;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageVolume, "SystemName");
                CIMInstance instStorageVolume = null;
                try {
                    instStorageVolume = this.getReference2Instrumentation().getInstance(opStorageVolume, null);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null == instStorageVolume) break block10;
                String pnStorageTier = this.getReference1PropertyName();
                CIMObjectPath opStorageTier = opObjectName.getKey(pnStorageTier) != null ? (CIMObjectPath)opObjectName.getKey(pnStorageTier).getValue() : null;
                CIMInstance instStorageTier = null;
                try {
                    instStorageTier = this.getReference1Instrumentation().getInstance(opStorageTier, null);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null != instStorageTier) {
                    String instanceID = (String)instStorageTier.getPropertyValue("InstanceID");
                    short[] instanceIDVals = TierInfo.getStorageTierInstanceIDValues(instanceID, null);
                    String ldev = (String)instStorageVolume.getPropertyValue("DeviceID");
                    if (null != instanceIDVals) {
                        TierInfo[] tierInfo;
                        short poolID = instanceIDVals[0];
                        short tier = instanceIDVals[1];
                        ThinPool thinPool = ThinPool.find(device.getRMIObject(), poolID, true);
                        if (null != thinPool && null != (tierInfo = thinPool.getTierInfo()) && tierInfo.length > tier && tierInfo[tier].createdFromLDev(ldev)) {
                            return this.generateInstance(opObjectName, propertyList, instStorageTier.getObjectPath(), instStorageVolume.getObjectPath());
                        }
                    }
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    private void getStorageVolumesFromThinPool(RMIObjectCache objCache, CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, boolean isObjectPath, short tPoolID, short tierNum, long ldevNum, boolean isAssocCall) throws Exception {
        ThinPool tp = ThinPool.find(objCache, tPoolID, true);
        if (tp != null) {
            TierInfo[] tierInfos = tp.getTierInfo();
            if (null == tierInfos || 0 == tierInfos.length) {
                return;
            }
            if (-1 != tierNum) {
                if (tierNum >= tierInfos.length) {
                    return;
                }
                TierInfo tmpTierInfo = tierInfos[tierNum];
                tierInfos = new TierInfo[]{tmpTierInfo};
            }
            for (TierInfo tierInfo : tierInfos) {
                Long[] ldevs;
                Long[] longArray;
                if (-1L != ldevNum && !tierInfo.createdFromLDev(ldevNum)) continue;
                CIMObjectPath opStorageTier = this.getReference1Instrumentation().generateObjectPath(op, tierInfo);
                if (-1L == ldevNum) {
                    longArray = tierInfo.getLDevs();
                } else {
                    Long[] longArray2 = new Long[1];
                    longArray = longArray2;
                    longArray2[0] = ldevNum;
                }
                for (Long ldev : ldevs = longArray) {
                    DeviceNumber dn = DeviceNumber.find(Long.toString(ldev), RMIObjectMapping.getRMIObjectMapping(tierInfo.getSerialNumber()).getRMIObject());
                    CIMObjectPath opStorageVolume = this.getReference2Instrumentation().generateObjectPath(op, dn);
                    if (isObjectPath) {
                        CIMObjectPath retOP = !isAssocCall ? this.generateObjectPath(op, opStorageTier, opStorageVolume) : opStorageVolume;
                        if (retOP == null) continue;
                        iter.add(retOP);
                        continue;
                    }
                    CIMInstance ret = !isAssocCall ? this.generateInstance(op, propertyList, opStorageTier, opStorageVolume) : this.getReference2Instrumentation().generateInstance(op, propertyList, dn);
                    if (ret == null) continue;
                    iter.add(ret);
                }
            }
        } else {
            mLogger.info("Could not find a thin pool with ID: " + tPoolID);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_MemberOfStorageTier".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping map = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                        String instanceID = null != objectName.getKey("InstanceID") ? (String)objectName.getKey("InstanceID").getValue() : null;
                        short[] instanceIDVals = TierInfo.getStorageTierInstanceIDValues(instanceID, null);
                        if (null != instanceIDVals) {
                            this.getStorageVolumesFromThinPool(map.getRMIObject(), iter, objectName, propertyList, isObjectPath, instanceIDVals[0], instanceIDVals[1], -1L, false);
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    String strDevID = null != objectName.getKey("DeviceID") ? (String)objectName.getKey("DeviceID").getValue() : null;
                    DeviceNumber dn = DeviceNumber.find(strDevID, device.getRMIObject());
                    if (dn != null) {
                        ThinPool tp;
                        CommonClassAsList<ThinPool> callback = new CommonClassAsList<ThinPool>();
                        ThinPool.getThinPools(device.getRMIObject(), callback, dn.getThinPoolID(), -1L, ThinPool.ThinPoolType.AOU, true);
                        LinkedList<ThinPool> tps = callback.getReturnValue();
                        callback = null;
                        while (null != (tp = tps.poll())) {
                            TierInfo[] tierInfos;
                            if (tp == null || !tp.checkIfDNContainsPool(dn)) continue;
                            for (TierInfo tierInfo : tierInfos = tp.getTierInfo()) {
                                if (!tierInfo.createdFromLDev(strDevID)) continue;
                                CIMObjectPath opStorageVolume = this.getReference2Instrumentation().generateObjectPath(objectName, dn);
                                CIMObjectPath opStorageTier = this.getReference1Instrumentation().generateObjectPath(objectName, tierInfo);
                                if (isObjectPath) {
                                    iter.add(this.generateObjectPath(assocName, opStorageTier, opStorageVolume));
                                    continue;
                                }
                                iter.add(this.generateInstance(assocName, propertyList, opStorageTier, opStorageVolume));
                            }
                        }
                    } else {
                        mLogger.info("Could not find a DeviceNumber with ID: " + strDevID);
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
    }
}

