/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DKStatusInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class PowerSupplyInstrumentation
extends BaseInstrumentation {
    private static final String CV_NAME_DKC = "DKC Power Supply";
    private static final String CV_NAME_DKU = "DKU Power Supply";

    protected PowerSupplyInstrumentation() {
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
        try {
            for (RMIObjectMapping device : devices) {
                DKStatusInfo dkInfo = DKStatusInfo.getDKStatusInfo(device.getRMIObject());
                if (null != refInfo) {
                    CIMObjectPath retOP;
                    if (null != dkInfo.getDKCStatusInfo()) {
                        retOP = this.generateObjectPath(op, CV_NAME_DKC, dkInfo);
                        refInfo.addReference(iter, retOP);
                    }
                    if (null == dkInfo.getDKUStatusInfo()) continue;
                    retOP = this.generateObjectPath(op, CV_NAME_DKU, dkInfo);
                    refInfo.addReference(iter, retOP);
                    continue;
                }
                if (isObjectPath) {
                    if (null != dkInfo.getDKCStatusInfo()) {
                        iter.add(this.generateObjectPath(op, CV_NAME_DKC, dkInfo));
                    }
                    if (null == dkInfo.getDKUStatusInfo()) continue;
                    iter.add(this.generateObjectPath(op, CV_NAME_DKU, dkInfo));
                    continue;
                }
                if (null != dkInfo.getDKCStatusInfo()) {
                    iter.add(this.generateInstance(op, propertyList, CV_NAME_DKC, dkInfo));
                }
                if (null == dkInfo.getDKUStatusInfo()) continue;
                iter.add(this.generateInstance(op, propertyList, CV_NAME_DKU, dkInfo));
            }
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath opInstance = this.generateObjectPath(op, o);
        String cvPwrSupplyName = (String)o[0];
        DKStatusInfo dkInfo = (DKStatusInfo)o[1];
        UnsignedInteger16 cvStatus = null;
        String[] cvDescription = new String[1];
        int status = 1;
        if (CV_NAME_DKC.equals(cvPwrSupplyName)) {
            if (null == dkInfo.getDKCStatusInfo()) {
                return null;
            }
            status = dkInfo.getDKCStatusInfo().getNDKCHWPS();
        } else if (CV_NAME_DKU.equals(cvPwrSupplyName)) {
            if (null == dkInfo.getDKUStatusInfo()) {
                return null;
            }
            status = dkInfo.getDKUStatusInfo().getNDKUHWPS();
        } else {
            throw new IllegalArgumentException("Invalid name passed in");
        }
        switch (status) {
            case 1: {
                cvStatus = ProviderConstants.UINT16_TWO;
                cvDescription[0] = ProviderConstants.getOpStatusDescription(2);
                break;
            }
            case 2: {
                cvStatus = ProviderConstants.UINT16_SIX;
                cvDescription[0] = ProviderConstants.getOpStatusDescription(6);
                break;
            }
            case 3: {
                cvStatus = ProviderConstants.UINT16_FIVE;
                cvDescription[0] = ProviderConstants.getOpStatusDescription(5);
                break;
            }
            case 4: {
                cvStatus = ProviderConstants.UINT16_FOUR;
                cvDescription[0] = ProviderConstants.getOpStatusDescription(4);
                break;
            }
            case 5: {
                cvStatus = new UnsignedInteger16(11);
                cvDescription[0] = ProviderConstants.getOpStatusDescription(11);
                break;
            }
            default: {
                mLogger.severe("Unexpected value battery status: " + status);
            }
        }
        CIMProperty[] props = new CIMProperty[]{opInstance.getKey("SystemName"), opInstance.getKey("SystemCreationClassName"), opInstance.getKey("CreationClassName"), opInstance.getKey("DeviceID"), new CIMProperty("Name", CIMDataType.STRING_T, (Object)cvPwrSupplyName, false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{cvStatus}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)cvDescription, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)cvPwrSupplyName, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)cvPwrSupplyName, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)cvPwrSupplyName, false)};
        return new CIMInstance(opInstance, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{String.class, DKStatusInfo.class}, o, "HITACHI_PowerSupply");
        String value = (String)o[0];
        DKStatusInfo dkInfo = (DKStatusInfo)o[1];
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)value, true), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_PowerSupply", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)RMIObjectMapping.getRMIObjectMapping(dkInfo.getSerialNumber()).getStorageSystemName(), true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_PowerSupply", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping rmiMap = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            CIMProperty cpDeviceID = op.getKey("DeviceID");
            if (null != cpDeviceID) {
                String cvDeviceID = (String)cpDeviceID.getValue();
                DKStatusInfo dkInfo = DKStatusInfo.getDKStatusInfo(rmiMap.getRMIObject());
                if (op.equalsModelPath(this.generateObjectPath(op, cvDeviceID, dkInfo))) {
                    return this.generateInstance(op, propertyList, cvDeviceID, dkInfo);
                }
            }
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }
}

