/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.PoolNickChanged;
import com.hitachi.smi.common.PoolNickname;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.StoragePoolInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import sanproject.serverux.data.SANRmiException;

public class SnapshotPoolInstrumentation
extends StoragePoolInstrumentation
implements CacheUpdateNotifier {
    private static final String VOLUMEDIVISORSIZE_VAL = "1048576";
    private PoolNickChanged nickNameListener;

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                ThinPool tp = (ThinPool)pObj;
                if (!tp.isAOUPool()) {
                    CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_SnapshotPool", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                    CIMInstance sourceInstance = this.generateInstance(op, null, tp);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                    mHandle.deliverEvent(indication, null);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SnapshotPool added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                ThinPool tp = (ThinPool)pObj;
                if (!tp.isAOUPool()) {
                    CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_SnapshotPool", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                    CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                    mHandle.deliverEvent(indication, null);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SnapshotPool deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                ThinPool tp = (ThinPool)pObj;
                if (!tp.isAOUPool()) {
                    CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_SnapshotPool", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                    CIMInstance prevInstance = this.generateInstance(op, null, pObj);
                    ThinPool newInst = ThinPool.find(RMIObjectMapping.getRMIObjectMapping(tp.getSerialNumber()).getRMIObject(), tp.getPoolID(), ThinPool.ThinPoolType.QS);
                    if (newInst != null) {
                        CIMInstance sourceInstance = this.generateInstance(op, null, newInst);
                        IndicationHelper helper = new IndicationHelper(mHandle);
                        CIMInstance indication = helper.createInstModificationInstance(sourceInstance, prevInstance);
                        mHandle.deliverEvent(indication, null);
                    } else {
                        mLogger.severe("Unable to find a SnapShotPool with ID: " + tp.getPoolID());
                    }
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SnapshotPool modified indication instance", t);
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
        try {
            String expID;
            short poolID = -1;
            String string = expID = null != expectedValues ? (String)expectedValues.get("InstanceID") : null;
            if (expID != null) {
                String poolIDStr = ProviderLibs.getEndString(expID);
                poolID = Short.valueOf(poolIDStr);
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackHandler<ThinPool> callback = new CallbackHandler<ThinPool>(deviceIter, isObjectPath, refInfo, op, propertyList);
                ThinPool.getThinPools(device.getRMIObject(), callback, poolID, false);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    protected UnsignedInteger32 extrinsic_GetSupportedSizeRange(CIMObjectPath pOp, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        String msg;
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        UnsignedInteger64 volumeSizeDivisor = new UnsignedInteger64(VOLUMEDIVISORSIZE_VAL);
        UnsignedInteger64 minVolSize = ProviderConstants.UINT64_ZED;
        UnsignedInteger64 maxVolSize = ProviderConstants.UINT64_ZED;
        CIMObjectPath goal = null;
        UnsignedInteger16 elementType = null;
        for (CIMArgument<?> arg : pInArgs) {
            if (arg.getName().equalsIgnoreCase("Goal")) {
                goal = (CIMObjectPath)arg.getValue();
                continue;
            }
            if (!arg.getName().equalsIgnoreCase("ElementType")) continue;
            elementType = (UnsignedInteger16)arg.getValue();
        }
        if (elementType == null) {
            msg = "ElementType can not be null";
            mLogger.severe("ElementType can not be null");
            minVolSize = maxVolSize = ProviderConstants.UINT64_ZED;
        } else if (3 != elementType.intValue()) {
            msg = "ElementType must have a value of 3, passed in" + elementType;
            mLogger.severe(msg);
            minVolSize = maxVolSize = ProviderConstants.UINT64_ZED;
        }
        if (maxVolSize.longValue() != 0L && goal != null) {
            ThinPool tp = ProviderLibs.getSnapShotPool(pOp);
            if (tp == null || !ProviderLibs.checkSettingGoal(goal, tp, mHandle)) {
                minVolSize = maxVolSize = ProviderConstants.UINT64_ZED;
            }
            goal = null;
        }
        pOutArgs[0] = new CIMArgument("MinimumVolumeSize", CIMDataType.UINT64_T, (Object)minVolSize);
        pOutArgs[1] = new CIMArgument("MaximumVolumeSize", CIMDataType.UINT64_T, (Object)maxVolSize);
        pOutArgs[2] = new CIMArgument("VolumeSizeDivisor", CIMDataType.UINT64_T, (Object)volumeSizeDivisor);
        return ret;
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath p, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(p, o);
        ThinPool tp = (ThinPool)o[0];
        try {
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(tp.getSerialNumber());
            ArrayList<CIMProperty> props = new ArrayList<CIMProperty>();
            CIMProperty[] keys = retOP.getKeys();
            props.add(keys[0]);
            StringBuilder poolID = new StringBuilder("SnapshotPool");
            poolID = poolID.append(':');
            poolID = poolID.append(device.getStorageSystemName());
            poolID = poolID.append(".");
            poolID = poolID.append(tp.getPoolID());
            String tpStrID = poolID.toString();
            UnsignedInteger16 consistsOfVal = tp.getConsistsOfAsU16();
            String label = null;
            try {
                PoolNickname poolLabel = PoolNickname.find(device.getRMIObject(), tp.getPoolID());
                if (poolLabel != null) {
                    label = poolLabel.getNickname();
                }
            }
            catch (WBEMException e) {
                mLogger.log(Level.SEVERE, "Error trying to get Pool Label: " + (Object)((Object)e), e);
            }
            props.add(new CIMProperty("Label", CIMDataType.STRING_T, (Object)label, false));
            props.add(new CIMProperty("ConsistsOf", CIMDataType.UINT16_T, (Object)consistsOfVal, false));
            UnsignedInteger16 usage = tp.getUsage();
            props.add(new CIMProperty("Usage", CIMDataType.UINT16_T, (Object)usage, false));
            props.add(new CIMProperty("PoolID", CIMDataType.STRING_T, (Object)tpStrID, false));
            props.add(new CIMProperty("Primordial", CIMDataType.BOOLEAN_T, (Object)false, false));
            long capacity = tp.getPoolCapaAsBytes();
            BigInteger calc = BigInteger.valueOf(capacity);
            UnsignedInteger64 cvTotalManagedSpace = new UnsignedInteger64(calc);
            props.add(new CIMProperty("TotalManagedSpace", CIMDataType.UINT64_T, (Object)cvTotalManagedSpace, false));
            UnsignedInteger64 cvRemaningManagedSpace = ProviderLibs.calcCTPRMS4Snapshot(tp, true);
            props.add(new CIMProperty("RemainingManagedSpace", CIMDataType.UINT64_T, (Object)cvRemaningManagedSpace, false));
            calc = null;
            props.add(new CIMProperty("Name", CIMDataType.STRING_T, (Object)tpStrID, false));
            props.add(new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false));
            props.add(new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false));
            props.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)tp.getHealthState(), false));
            props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)tpStrID, false));
            props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)tpStrID, false));
            props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)(null == label || 0 == label.length() ? tpStrID : label), false));
            props.add(new CIMProperty("SpaceLimitDetermination", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_THREE, false));
            props.add(new CIMProperty("SpaceLimit", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(BigInteger.valueOf(0x40000000000L)), false));
            props.add(new CIMProperty("ElementsShareSpace", CIMDataType.BOOLEAN_T, (Object)false, false));
            props.add(new CIMProperty("ReservedSpace", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false));
            return new CIMInstance(retOP, props.toArray(new CIMProperty[props.size()])).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{ThinPool.class}, o, "HITACHI_SnapshotPool");
        ThinPool tp = (ThinPool)o[0];
        try {
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(tp.getSerialNumber());
            String systemName = device.getStorageSystemName();
            String keyValue = systemName + "." + tp.getPoolID();
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)keyValue, true)};
            return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_SnapshotPool", keys, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            CIMProperty key = op.getKey("InstanceID");
            String value = (String)key.getValue();
            if (null != value) {
                String strModel = ProviderLibs.getAllButEndString(value, ".".charAt(0));
                if (device.getStorageSystemName().equalsIgnoreCase(strModel)) {
                    String strID = ProviderLibs.getEndString(value, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    short poolID = Short.parseShort(strID);
                    ThinPool data = ThinPool.find(device.getRMIObject(), poolID, ThinPool.ThinPoolType.QS);
                    if (data != null) {
                        return this.generateInstance(op, propertyList, data);
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (6 == we.getID() || 1 == we.getID()) {
                throw we;
            }
            throw new WBEMException(1, we.toString(), null, (Throwable)we);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    private synchronized PoolNickChanged getNicknameListener() {
        if (this.nickNameListener == null) {
            this.nickNameListener = new PoolNickChanged(this);
        }
        return this.nickNameListener;
    }

    @Override
    public UnsignedInteger64 getTotalManagedSpace(RMIObjectMapping rmiObj) throws RemoteException, SANRmiException, WBEMException {
        return ProviderConstants.UINT64_ZED;
    }

    @Override
    public Object invokeMethod(CIMObjectPath pOp, String pMethodName, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        Object oRet = null;
        if ("GetSupportedSizes".equalsIgnoreCase(pMethodName)) {
            oRet = this.extrinsic_getSupportedSizes(pOp, pOutArgs);
        } else if ("GetSupportedSizeRange".equalsIgnoreCase(pMethodName)) {
            if (pOp.getObjectName().contains("Primordial")) {
                pOutArgs[0] = new CIMArgument("MinimumVolumeSize", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
                pOutArgs[1] = new CIMArgument("MaximumVolumeSize", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
                pOutArgs[2] = new CIMArgument("VolumeSizeDivisor", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
                oRet = ProviderConstants.UINT32_TWO;
            } else {
                oRet = this.extrinsic_GetSupportedSizeRange(pOp, pInArgs, pOutArgs);
            }
        } else {
            throw new WBEMException(17, "StoragePool does not know about the method: " + pMethodName);
        }
        return oRet;
    }

    @Override
    public void modifyInstance(CIMInstance modifiedInst, String[] propertyList) throws WBEMException {
        CIMInstance currentInst;
        String propName;
        if (null != propertyList && 1 != propertyList.length) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)modifiedInst.getObjectPath(), (String)"Can only modify ElementName", (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)"ModifyInstance");
        }
        String string = propName = null == propertyList ? null : propertyList[0];
        if (!"ElementName".equalsIgnoreCase(propName)) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)modifiedInst.getObjectPath(), (String)("can not modify " + propName), (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)"ModifyInstance");
        }
        ThinPool tp = ProviderLibs.getSnapShotPool(modifiedInst.getObjectPath());
        if (tp != null) {
            try {
                currentInst = this.generateInstance(modifiedInst.getObjectPath(), propertyList, tp);
            }
            catch (Throwable t) {
                if (t instanceof WBEMException) {
                    throw (WBEMException)t;
                }
                throw new WBEMException(1, "Error generating instance for modification", null, t);
            }
        } else {
            throw new WBEMException(6, modifiedInst.getObjectPath().toString());
        }
        ProviderLibs.modifyElementName(currentInst, modifiedInst, tp, mHandle.getProperty("javax.wbem.provider.Principal"), modifiedInst.getObjectPath().getHost(), "CIM_AffectedJobElement", "HITACHI_StorageCSOwningJobElement");
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_StoragePool".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_StoragePool".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(true);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StoragePool".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(true);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StoragePool AND SourceInstance.CIM_StoragePool::TotalManagedSpace <> PreviousInstance.CIM_StoragePool::TotalManagedSpace".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.THINPOOL, this, null);
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.NICKNAME, this.getNicknameListener(), null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.THINPOOL, this, null);
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.NICKNAME, this.getNicknameListener(), null);
        }
    }

    private class CallbackHandler<E extends ThinPool>
    extends IteratorCallbackIMPL<E> {
        private CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block6: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E tp = item;
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, SnapshotPoolInstrumentation.this.generateObjectPath(this.mOP, tp));
                            break block6;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(SnapshotPoolInstrumentation.this.generateObjectPath(this.mOP, tp));
                            break block6;
                        }
                        this.mIter.add(SnapshotPoolInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, tp));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

