/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class SnapshotPoolSettingInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", ".", 2, expectedValues, "Name", ".", 2);
        try {
            String expVal;
            short poolID = -1;
            if (expectedValues != null && (expVal = (String)expectedValues.get("InstanceID")) != null) {
                String pool = ProviderLibs.getEndString(expVal, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                poolID = Short.parseShort(pool);
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackHandler<ThinPool> callback = new CallbackHandler<ThinPool>(deviceIter, isObjectPath, refInfo, op, propertyList);
                ThinPool.getThinPools(device.getRMIObject(), callback, poolID, false);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CIMProperty[] keys = retOP.getKeys();
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("DataOrganization", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("CUImage", CIMDataType.STRING_T, null, false), new CIMProperty("SubsystemID", CIMDataType.STRING_T, null, false), new CIMProperty("EmulatedDevice", CIMDataType.STRING_T, null, false), new CIMProperty("ExtentType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("DataRedundancyMax", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false), new CIMProperty("DataRedundancyMin", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false), new CIMProperty("DataRedundancyGoal", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false), new CIMProperty("PackageRedundancyMax", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("PackageRedundancyMin", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("PackageRedundancyGoal", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("DeltaReservationMax", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false), new CIMProperty("DeltaReservationMin", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false), new CIMProperty("DeltaReservationGoal", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false), new CIMProperty("ChangeableType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("ExtentStripeLength", CIMDataType.UINT16_T, null, false), new CIMProperty("ExtentStripeLengthMax", CIMDataType.UINT16_T, null, false), new CIMProperty("ExtentStripeLengthMin", CIMDataType.UINT16_T, null, false), new CIMProperty("ParityLayout", CIMDataType.UINT16_T, null, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)"UNKNOWN", false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)"UNKNOWN", false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)"UNKNOWN", false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{ThinPool.class}, o, "HITACHI_SnapshotPoolSetting");
        ThinPool tp = (ThinPool)o[0];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(tp.getSerialNumber());
        String keyValue = ProviderLibs.createInstanceID("HITACHI_SnapshotPoolSetting", device.getStorageSystemName(), null, BigInteger.valueOf(tp.getPoolID()), null);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)keyValue, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_SnapshotPoolSetting", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID", ".", 2);
        try {
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null == instID) {
                throw new WBEMException(6, op.toString());
            }
            String strPoolID = ProviderLibs.getEndString(instID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            short poolID = Short.valueOf(strPoolID);
            ThinPool data = ThinPool.find(device.getRMIObject(), poolID, ThinPool.ThinPoolType.QS);
            if (data != null) {
                return this.generateInstance(op, propertyList, data);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    private class CallbackHandler<E extends ThinPool>
    extends IteratorCallbackIMPL<E> {
        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block6: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E tp = item;
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, SnapshotPoolSettingInstrumentation.this.generateObjectPath(this.mOP, tp));
                            break block6;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(SnapshotPoolSettingInstrumentation.this.generateObjectPath(this.mOP, tp));
                            break block6;
                        }
                        this.mIter.add(SnapshotPoolSettingInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, tp));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

