/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class StorageConfigurationCapabilitiesInstrumentation
extends BaseInstrumentation {
    private static final UnsignedInteger16[] SYNC_ASYNC_ACTIONS = new UnsignedInteger16[]{ProviderConstants.UINT16_TWO, ProviderConstants.UINT16_THREE, ProviderConstants.UINT16_FOUR, ProviderConstants.UINT16_FIVE, ProviderConstants.UINT16_SIX, ProviderConstants.UINT16_EIGHT, ProviderConstants.UINT16_NINE};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices;
        String expSysName;
        String string = expSysName = null != expectedValues ? (String)expectedValues.get("InstanceID") : null;
        if (null == expectedValues) {
            devices = ProviderLibs.getManagedDevicesFromObjectPath(op, "InstanceID");
        } else {
            if (null == expSysName) throw new WBEMException("StorageConfigurationCapabilities called with association parameters, but SystemName was not provided");
            String serialNum = ProviderLibs.getSerialFromString(expSysName);
            RMIObjectMapping mapObj = RMIObjectMapping.getRMIObjectMapping(serialNum);
            String systemName = mapObj.getStorageSystemName();
            if (!expSysName.equalsIgnoreCase(systemName)) throw new WBEMException("StorageConfigurationCapabilities called with association parameters, but SystemName was not valid. Expected: " + expSysName + " " + " but got " + systemName);
            devices = new ArrayList<RMIObjectMapping>(1);
            devices.add(mapObj);
        }
        try {
            for (RMIObjectMapping device : devices) {
                String ssName = device.getStorageSystemName();
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, ssName));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, ssName));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, ssName));
            }
        }
        catch (WBEMException we) {
            if (null == iter) throw we;
            iter.setException(we);
            iter.close();
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null == iter) throw we;
            iter.setException(we);
            iter.close();
            throw we;
        }
        if (null == iter) return;
        iter.done();
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CIMProperty[] keys = retOP.getKeys();
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("SupportedSynchronousActions", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0], false), new CIMProperty("SupportedAsynchronousActions", CIMDataType.UINT16_ARRAY_T, (Object)SYNC_ASYNC_ACTIONS, false), new CIMProperty("SupportedStorageElementTypes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO, ProviderConstants.UINT16_FIVE, ProviderConstants.UINT16_EIGHT}, false), new CIMProperty("SupportedStoragePoolFeatures", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO, ProviderConstants.UINT16_THREE, ProviderConstants.UINT16_SIX}, false), new CIMProperty("SupportedStorageElementFeatures", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_THREE}, false), new CIMProperty("SupportedCopyTypes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_FOUR}, false), new CIMProperty("InitialReplicationState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)"StorageConfigurationCapabilities", false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)"StorageConfigurationCapabilities", false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)"StorageConfigurationCapabilities", false), new CIMProperty("ThinProvisionedClientSettableReserve", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("ThinProvisionedDefaultReserve", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{String.class}, o, "HITACHI_StorageConfigurationCapabilitiesOfUnpairedSnapshotVolumePool");
        String storageSystemName = (String)o[0];
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)storageSystemName, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageConfigurationCapabilities", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null == instID) {
                throw new WBEMException(6, op.toString());
            }
            String storageSystemName = device.getStorageSystemName();
            if (instID.equals(storageSystemName)) {
                return this.generateInstance(op, propertyList, storageSystemName);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    public Object invokeMethod(CIMObjectPath pOp, String pMethodName, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        if ("GetElementNameCapabilities".equalsIgnoreCase(pMethodName)) {
            int elType = -1;
            String goalClz = null;
            for (CIMArgument<?> arg : pInArgs) {
                if (arg.getName().equalsIgnoreCase("ElementType")) {
                    UnsignedInteger16 val = (UnsignedInteger16)arg.getValue();
                    elType = val.intValue();
                    continue;
                }
                if (!arg.getName().equalsIgnoreCase("Goal")) continue;
                CIMObjectPath goal = (CIMObjectPath)arg.getValue();
                goalClz = goal.getObjectName();
            }
            if (2 != elType && 7 != elType) {
                mLogger.log(Level.SEVERE, "Invalid element type supplied {0} must be '2' or '7'", elType);
                return ProviderConstants.UINT32_FIVE;
            }
            if (null == goalClz || goalClz.equalsIgnoreCase("HITACHI_StoragePool") || goalClz.equalsIgnoreCase("HITACHI_ThinProvisioningPool")) {
                pOutArgs[0] = new CIMArgument("ElementNameMask", CIMDataType.STRING_T, (Object)"[0-9 a-z A-Z \\b ! # \\$ % & ' \\( \\) + \\- \\. = @ \\[ \\] \\^ _ ` \\{ \\} ~]*");
                pOutArgs[1] = new CIMArgument("SupportedFeatures", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO, ProviderConstants.UINT16_FOUR});
                pOutArgs[2] = new CIMArgument("MaxElementNameLen", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(32));
            } else {
                mLogger.log(Level.WARNING, "Goal supplied is {0} it must be null, {1} or {2}", new Object[]{goalClz, "HITACHI_StoragePool", "HITACHI_ThinProvisioningPool"});
                pOutArgs[0] = new CIMArgument("ElementNameMask", CIMDataType.STRING_T, (Object)"");
                pOutArgs[1] = new CIMArgument("SupportedFeatures", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0]);
                pOutArgs[2] = new CIMArgument("MaxElementNameLen", CIMDataType.UINT16_T, null);
            }
            return ProviderConstants.UINT16_ZED;
        }
        throw new WBEMException(17, "HITACHI_StorageConfigurationCapabilities doesn't know the method: " + pMethodName);
    }
}

