/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class StorageConfigurationCapabilitiesOfConcretePoolInstrumentation
extends BaseInstrumentation {
    private static final UnsignedInteger16[] SYNC_ASYNC_ACTIONS = new UnsignedInteger16[]{ProviderConstants.UINT16_TWO, ProviderConstants.UINT16_THREE, ProviderConstants.UINT16_FIVE, ProviderConstants.UINT16_SIX};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            int ag;
            int vdev;
            int pg;
            int fb4;
            List<RMIObjectMapping> devices;
            block17: {
                devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, "InstanceID");
                fb4 = -1;
                pg = -1;
                vdev = -1;
                ag = -1;
                if (null != expectedValues) {
                    if (1 != devices.size()) {
                        throw new WBEMException("Unable to find managed device: " + expectedValues);
                    }
                    String expInstID = (String)expectedValues.get("InstanceID");
                    if (expInstID != null) {
                        Integer[] rets = ProviderLibs.getStoragePoolChassisAndArrayGroup(expInstID);
                        fb4 = rets[0];
                        ag = rets[1];
                    } else {
                        Integer expPG;
                        String deviceID = (String)expectedValues.get("DeviceID");
                        if (null != deviceID) {
                            DeviceNumber dn = DeviceNumber.find(deviceID, devices.get(0).getRMIObject());
                            if (dn != null) {
                                fb4 = dn.getFb4();
                                pg = dn.getPg();
                                vdev = dn.getVdev();
                                break block17;
                            } else {
                                if (null != iter) {
                                    iter.done();
                                }
                                return;
                            }
                        }
                        Integer expFB4 = (Integer)expectedValues.get("fb4");
                        if (null != expFB4) {
                            fb4 = expFB4;
                        }
                        if (null != (expPG = (Integer)expectedValues.get("pg"))) {
                            pg = expPG;
                        }
                    }
                }
            }
            for (RMIObjectMapping device : devices) {
                CallbackHandler<ChassisArrayGroup> callback = new CallbackHandler<ChassisArrayGroup>(iter, isObjectPath, refInfo, op, propertyList, ag);
                ChassisArrayGroup.getChassisArrayGroup(device.getRMIObject(), callback, isObjectPath, fb4, pg, vdev, ag);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o[0]);
        CIMProperty[] keys = retOP.getKeys();
        String name = "HITACHI_StorageConfigurationCapabilitiesOfConcretePool".substring("HITACHI_".length());
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("SupportedSynchronousActions", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0], false), new CIMProperty("SupportedAsynchronousActions", CIMDataType.UINT16_ARRAY_T, (Object)SYNC_ASYNC_ACTIONS, false), new CIMProperty("SupportedStorageElementTypes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO, ProviderConstants.UINT16_EIGHT}, false), new CIMProperty("SupportedStoragePoolFeatures", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("SupportedStorageElementFeatures", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_THREE}, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)name, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)name, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)name, false), new CIMProperty("ThinProvisionedClientSettableReserve", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("ThinProvisionedDefaultReserve", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{ChassisArrayGroup.class}, o, "HITACHI_StorageConfigurationCapabilitiesOfConcretePool");
        ChassisArrayGroup cag = (ChassisArrayGroup)o[0];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(cag.getSerialNumber());
        String instID = device.getStorageSystemName() + "." + String.valueOf(cag.getChassis()) + "." + cag.getArrayGroup();
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instID, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageConfigurationCapabilitiesOfConcretePool", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            ChassisArrayGroup cag;
            String instID;
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null != instID && null != (cag = ChassisArrayGroup.find(device.getRMIObject(), false, instID))) {
                return this.generateInstance(op, propertyList, cag);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    private class CallbackHandler<E extends ChassisArrayGroup>
    extends IteratorCallbackIMPL<E> {
        private int mArrayGroup;

        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, int ag) {
            super(iter, isObjectPath, refInfo, op, propertyList);
            this.mArrayGroup = -1;
            this.mArrayGroup = ag;
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block7: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E cag = item;
                        if (this.mArrayGroup != -1) {
                            ret = ((ChassisArrayGroup)cag).getArrayGroup() != this.mArrayGroup;
                        }
                        if (-1 != this.mArrayGroup && (this.mArrayGroup == -1 || ret)) break block7;
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, StorageConfigurationCapabilitiesOfConcretePoolInstrumentation.this.generateObjectPath(this.mOP, cag));
                            break block7;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(StorageConfigurationCapabilitiesOfConcretePoolInstrumentation.this.generateObjectPath(this.mOP, cag));
                            break block7;
                        }
                        this.mIter.add(StorageConfigurationCapabilitiesOfConcretePoolInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, cag));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

