/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class StorageProductInstrumentation
extends BaseInstrumentation {
    public static final String PRODUCT_VERSION = "0";

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices;
        String expSerialNumber;
        String string = expSerialNumber = null != expectedValues ? (String)expectedValues.get("IdentifyingNumber") : null;
        if (null == expectedValues) {
            devices = ProviderLibs.getManagedDevicesFromObjectPath(op, "SystemName", ".", 1);
        } else if (null != expSerialNumber) {
            RMIObjectMapping mapObj = RMIObjectMapping.getRMIObjectMapping(expSerialNumber);
            devices = new ArrayList<RMIObjectMapping>(1);
            devices.add(mapObj);
        } else {
            throw new WBEMException("StorageProduct called with association parmaters, but IdentifyingNumber was not provided");
        }
        try {
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getModel(), device.getSerialNumber(), device.getVendor()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getModel(), device.getSerialNumber(), device.getVendor()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getModel(), device.getSerialNumber(), device.getVendor()));
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws WBEMException {
        if (null == o || o.length != 3) {
            throw new IllegalArgumentException(ProviderConstants.GENERATE_OBJECTPATH_ILLEGAL_ARGUMENT + " " + "HITACHI_StorageProduct");
        }
        try {
            CIMObjectPath retOp = this.generateObjectPath(op, o);
            String model = (String)o[0];
            String sn = (String)o[1];
            CIMProperty[] keys = retOp.getKeys();
            CIMProperty<?>[] retProps = this.getProperties(propertyList, keys, model, sn);
            CIMInstance ci = new CIMInstance(retOp, retProps);
            return ci.filterProperties(propertyList);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{String.class, String.class, String.class}, o, this.getClass().getSimpleName());
        try {
            String model = (String)o[0];
            String sn = (String)o[1];
            String vendor = (String)o[2];
            CIMProperty<?>[] keys = this.getKeys(model, sn, vendor);
            return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageProduct", keys, op.getXmlSchemaName());
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        String idNum = (String)op.getKeyValue("IdentifyingNumber");
        if (null == idNum) {
            throw new WBEMException("No device managed with serial " + idNum);
        }
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(idNum);
        try {
            String name = null != op.getKey("Name") ? (String)op.getKey("Name").getValue() : null;
            String vend = null != op.getKey("Vendor") ? (String)op.getKey("Vendor").getValue() : null;
            String ver = null != op.getKey("Version") ? (String)op.getKey("Version").getValue() : null;
            String model = device.getModel();
            String sn = device.getSerialNumber();
            String vendor = device.getVendor();
            if (!(null != idNum && idNum.equals(sn) && null != name && name.equals(model) && null != vend && vend.equals(vendor) && null != ver && ver.equals(PRODUCT_VERSION))) {
                throw new WBEMException(6, op != null ? op.toString() : null);
            }
            return this.generateInstance(op, propertyList, model, sn, vendor);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    private CIMProperty<?>[] getKeys(String model, String sn, String vendor) {
        return new CIMProperty[]{new CIMProperty("IdentifyingNumber", CIMDataType.STRING_T, (Object)sn, true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)model, true), new CIMProperty("Vendor", CIMDataType.STRING_T, (Object)vendor, true), new CIMProperty("Version", CIMDataType.STRING_T, (Object)PRODUCT_VERSION, true)};
    }

    private CIMProperty<?>[] getProperties(String[] propertyList, CIMProperty<?>[] keys, String model, String sn) throws Exception {
        ArrayList props = new ArrayList();
        ProviderLibs.addKeysToProperties(keys, props);
        String val = model + "." + sn;
        props.add(new CIMProperty("SKUNumber", CIMDataType.STRING_T, (Object)val, false));
        props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)val, false));
        props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)val, false));
        props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)val, false));
        return props.toArray(new CIMProperty[props.size()]);
    }
}

