/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class StorageSystemDeviceArbitraryLogicalUnitInstrumentation
extends BaseAssocInstrumentation {
    protected StorageSystemDeviceArbitraryLogicalUnitInstrumentation() {
        super("HITACHI_StorageSystemDeviceArbitraryLogicalUnit", "HITACHI_StorageSystem", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation"), "HITACHI_SCSIArbitraryLogicalUnit", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIArbitraryLogicalUnitInstrumentation"));
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CIMObjectPath ssOP = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath depOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference2ClassName(), op.getKeys(), op.getXmlSchemaName());
                ReferenceInfo newRefInfo = new ReferenceInfo(ssOP, null, this.getReference1PropertyName(), this.getReference2PropertyName(), propertyList, isObjectPath, this);
                this.getReference2Instrumentation().enumerate(deviceIter, depOP, new String[0], null, null, continueOnError, true, this.getReference2SearchProperties(ssOP), newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        block6: {
            try {
                CIMInstance instSCSIArbitraryLU;
                RMIObjectMapping device;
                CIMObjectPath opStorageSystem;
                block7: {
                    String ssNameSCSIArbitraryLU;
                    String ssName;
                    CIMObjectPath opSCSIArbitraryLU;
                    String cpnStorageSystem = this.getReference1PropertyName();
                    opStorageSystem = op.getKey(cpnStorageSystem) != null ? (CIMObjectPath)op.getKey(cpnStorageSystem).getValue() : null;
                    String cpnSCSIArbitraryLU = this.getReference2PropertyName();
                    CIMObjectPath cIMObjectPath = opSCSIArbitraryLU = op.getKey(cpnSCSIArbitraryLU) != null ? (CIMObjectPath)op.getKey(cpnSCSIArbitraryLU).getValue() : null;
                    if (null == opSCSIArbitraryLU || null == opStorageSystem) break block6;
                    device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageSystem, "Name");
                    String string = ssName = opStorageSystem.getKey("Name") != null && opStorageSystem.getKey("Name").getValue() != null ? (String)opStorageSystem.getKey("Name").getValue() : null;
                    if (null == ssName) break block6;
                    String string2 = ssNameSCSIArbitraryLU = opSCSIArbitraryLU.getKey("SystemName") != null && opSCSIArbitraryLU.getKey("SystemName").getValue() != null ? (String)opSCSIArbitraryLU.getKey("SystemName").getValue() : null;
                    if (!ssName.equalsIgnoreCase(ssNameSCSIArbitraryLU)) break block6;
                    instSCSIArbitraryLU = null;
                    try {
                        instSCSIArbitraryLU = this.getReference2Instrumentation().getInstance(opSCSIArbitraryLU, null);
                    }
                    catch (WBEMException we) {
                        if (we.getID() == 6) break block7;
                        throw we;
                    }
                }
                if (null != instSCSIArbitraryLU) {
                    opStorageSystem = this.getReference1Instrumentation().generateObjectPath(opStorageSystem, device.getRMIObject());
                    return this.generateInstance(op, propertyList, opStorageSystem, instSCSIArbitraryLU.getObjectPath());
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath objectName) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String sysName = null != objectName && null != objectName.getKey("SystemName") ? (String)objectName.getKey("SystemName").getValue() : null;
        hTable.put("SystemName", sysName);
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath objectName) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String name = null != objectName && null != objectName.getKey("Name") ? (String)objectName.getKey("Name").getValue() : null;
        hTable.put("SystemName", name);
        return hTable;
    }
}

