/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class StorageSystemInstrumentation
extends BaseInstrumentation {
    private static final String CV_VENDORDISPLAYARRAYTYPESERIAL = "Vendor+Model+Serial";

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "Name", expectedValues, new String[]{"SystemName", "Name"});
            for (RMIObjectMapping device : devices) {
                CIMInstance ci = this.generateInstance(op, propertyList, device.getRMIObject());
                if (null != refInfo) {
                    refInfo.addReference(iter, ci.getObjectPath());
                    continue;
                }
                if (isObjectPath) {
                    iter.add(ci.getObjectPath());
                    continue;
                }
                iter.add(ci);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws WBEMException {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        try {
            RMIObjectMapping device = rmiObj.getSMISMappingContainer();
            String model = device.getModel();
            String serialNumber = device.getSerialNumber();
            String[] otherID = new String[]{"HITACHI+" + model + "+" + serialNumber, "HITACHI+" + model + "+" + serialNumber};
            String[] otherIDDesc = new String[]{"T10 Target Name Type 1", CV_VENDORDISPLAYARRAYTYPESERIAL};
            StringBuilder poolID = new StringBuilder("StorageSystem:");
            poolID = poolID.append(device.getStorageSystemName());
            String value = poolID.toString();
            CIMProperty[] keys = retOP.getKeys();
            CIMProperty[] props = new CIMProperty[]{keys[0], keys[1], new CIMProperty("NameFormat", CIMDataType.STRING_T, (Object)"Other", false), new CIMProperty("OtherIdentifyingInfo", CIMDataType.STRING_ARRAY_T, (Object)otherID, false), new CIMProperty("IdentifyingDescriptions", CIMDataType.STRING_ARRAY_T, (Object)otherIDDesc, false), new CIMProperty("Dedicated", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_THREE, new UnsignedInteger16(15), new UnsignedInteger16(21)}, false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)ProviderLibs.getStorageOpStatus(rmiObj), false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)value, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)value, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)value, false)};
            return new CIMInstance(retOP, props).filterProperties(propertyList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_StorageSystem");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String name = null;
        try {
            name = rmiObj.getSMISMappingContainer().getStorageSystemName();
        }
        catch (Exception e) {
            // empty catch block
        }
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)name, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageSystem", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "Name");
        try {
            String ccName;
            CIMProperty cpCCN = op.getKey("CreationClassName");
            String string = ccName = null != cpCCN ? (String)cpCCN.getValue() : null;
            if ("HITACHI_StorageSystem".equalsIgnoreCase(ccName)) {
                String nameVal;
                String name = device.getStorageSystemName();
                CIMProperty cpName = op.getKey("Name");
                String string2 = nameVal = null != cpName ? (String)cpName.getValue() : null;
                if (null != nameVal && nameVal.equals(name)) {
                    return this.generateInstance(op, propertyList, device.getRMIObject());
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }
}

