/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class StorageSystemPackageDKUInstrumentation
extends BaseAssocInstrumentation {
    protected StorageSystemPackageDKUInstrumentation() {
        super("HITACHI_StorageSystemPackageDKU", "HITACHI_DKUChassis", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DKUChassisInstrumentation"), "HITACHI_StorageSystem", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_StorageSystemPackageDKU".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("Dependent")) && (null == resultRole || resultRole.equalsIgnoreCase("Antecedent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    this.getReference1Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, this.createExpectedVals(device), null);
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Antecedent")) && (null == resultRole || resultRole.equalsIgnoreCase("Dependent")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                    if (isObjectPath) {
                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    private Hashtable<String, Object> createExpectedVals(RMIObjectMapping device) throws WBEMException {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        ret.put("SystemName", device.getStorageSystemName());
        return ret;
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        PassthruIterator deviceIter = new PassthruIterator(iter);
        try {
            for (RMIObjectMapping device : devices) {
                CIMObjectPath ssOP = this.getReference2Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath dkuOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_DKUChassis", null);
                ReferenceInfo newRefInfo = new ReferenceInfo(null, ssOP, "Antecedent", "Dependent", propertyList, isObjectPath, this);
                this.getReference1Instrumentation().enumerate(deviceIter, dkuOP, new String[0], null, null, continueOnError, true, this.createExpectedVals(device), newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opDKUChassis;
            String cpnStorageSystem = this.getReference2PropertyName();
            CIMObjectPath opStorageSystem = op.getKey(cpnStorageSystem) != null ? (CIMObjectPath)op.getKey(cpnStorageSystem).getValue() : null;
            String cpnDKUChassis = this.getReference1PropertyName();
            CIMObjectPath cIMObjectPath = opDKUChassis = op.getKey(cpnDKUChassis) != null ? (CIMObjectPath)op.getKey(cpnDKUChassis).getValue() : null;
            if (null != opDKUChassis && null != opStorageSystem) {
                String ssName;
                String string = ssName = opStorageSystem.getKey("Name") != null && opStorageSystem.getKey("Name").getValue() != null ? (String)opStorageSystem.getKey("Name").getValue() : null;
                if (null != ssName) {
                    String ssNameDKU;
                    String cvDKUChassisTag = opDKUChassis.getKey("Tag") != null && opDKUChassis.getKey("Tag").getValue() != null ? (String)opDKUChassis.getKey("Tag").getValue() : null;
                    String string2 = ssNameDKU = null != cvDKUChassisTag ? ProviderLibs.getAllButEndString(cvDKUChassisTag, ProviderConstants.ID_SEPERATOR_AS_CHAR) : null;
                    if (ssName.equalsIgnoreCase(ssNameDKU)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageSystem, "Name");
                        if (this.getReference1Instrumentation().instanceExists(opDKUChassis)) {
                            opDKUChassis = this.getReference1Instrumentation().generateObjectPath(opDKUChassis, device.getRMIObject(), ProviderLibs.getEndString(cvDKUChassisTag));
                            opStorageSystem = this.getReference2Instrumentation().generateObjectPath(opStorageSystem, device.getRMIObject());
                            return this.generateInstance(op, propertyList, opDKUChassis, opStorageSystem);
                        }
                    }
                }
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_StorageSystemPackageDKU".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageSystem") && (null == role || role.equalsIgnoreCase("Dependent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    CIMObjectPath dkuOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_DKUChassis", null, objectName.getXmlSchemaName());
                    CIMObjectPath newObjectName = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    ReferenceInfo newRefInfo = new ReferenceInfo(null, newObjectName, "Antecedent", "Dependent", propertyList, isObjectPath, this);
                    this.getReference1Instrumentation().enumerate(iter, dkuOP, new String[0], null, null, continueOnError, true, this.createExpectedVals(device), newRefInfo);
                    needToCloseIter = false;
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_DKUChassis") && (null == role || role.equalsIgnoreCase("Antecedent")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                    CIMObjectPath newObjectName = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    CIMObjectPath ssOP = this.getReference2Instrumentation().generateObjectPath(newObjectName, device.getRMIObject());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(newObjectName, newObjectName, ssOP));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, newObjectName, ssOP));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

