/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation.iSCSI;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.ISCSIreadAlliScsiInitiator;
import com.hitachi.smi.common.ISCSIreadPortNetworkConditions;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class iSCSIProtocolEndpointInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    public static final String CPV_OTHERTYPEDESCRIPTION = "iSCSI";
    public static final UnsignedInteger16 CPV_PROTOCOLIFTYPE = ProviderConstants.UINT16_ONE;

    protected static String createSystemName(FCPort port) throws Exception {
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(port.getSerialNumber());
        String ret = device.getStorageSystemName() + "." + port.getControlID();
        return ret;
    }

    public static int[] decodeName(String name) throws WBEMException {
        int[] ret;
        int idx = name.indexOf(ProviderConstants.ID_SEPERATOR_AS_CHAR);
        if (idx > 0) {
            try {
                ret = new int[]{Integer.parseInt(name.substring(0, idx)), Integer.parseInt(name.substring(idx + 1))};
            }
            catch (NumberFormatException nfe) {
                throw new WBEMException("Invalid value in name property: " + name);
            }
        } else {
            throw new WBEMException("Invalid name property: " + name);
        }
        return ret;
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening() && pObj instanceof ISCSITargetPort) {
            try {
                ISCSITargetPort addedPort = (ISCSITargetPort)pObj;
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_iSCSIProtocolEndpoint", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                IndicationHelper helper = new IndicationHelper(mHandle);
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(addedPort.getSerialNumber());
                FCPort fcPort = FCPort.find((short)addedPort.getPortId(), FCPort.PortTypeRequested.iSCSI, device.getRMIObject());
                if (null == fcPort) {
                    throw new WBEMException("iSCISTargetPort has no corresponging FCPort, id: " + addedPort.getPortId());
                }
                this.processPorts4Indication(op, helper, fcPort, addedPort.getTargets(), true);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_iSCSIProtocolEndpoint added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening() && pObj instanceof ISCSITargetPort) {
            try {
                ISCSITargetPort deletedPort = (ISCSITargetPort)pObj;
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_iSCSIProtocolEndpoint", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                IndicationHelper helper = new IndicationHelper(mHandle);
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(deletedPort.getSerialNumber());
                FCPort fcPort = FCPort.find((short)deletedPort.getPortId(), FCPort.PortTypeRequested.iSCSI, device.getRMIObject());
                if (null == fcPort) {
                    throw new WBEMException("iSCISTargetPort has no corresponging FCPort, id: " + deletedPort.getPortId());
                }
                this.processPorts4Indication(op, helper, fcPort, deletedPort.getTargets(), false);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_iSCSIProtocolEndpoint deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening() && pObj instanceof ISCSITargetPort) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_iSCSIProtocolEndpoint", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                ISCSITargetPort oldPort = (ISCSITargetPort)pObj;
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(oldPort.getSerialNumber());
                ISCSITargetPort newPort = ISCSITargetPort.find(device.getRMIObject(), oldPort.getPortId());
                if (newPort != null) {
                    FCPort fcPort = FCPort.find((short)oldPort.getPortId(), FCPort.PortTypeRequested.iSCSI, device.getRMIObject());
                    if (null == fcPort) {
                        throw new WBEMException("iSCISTargetPort has no corresponging FCPort, id: " + oldPort.getPortId());
                    }
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    List<ISCSITargetPort.ISCSITarget> newTargets = newPort.getTargets();
                    ISCSITargetPort.ISCSITargetComparator iSCSITargetComparator = new ISCSITargetPort.ISCSITargetComparator();
                    Collections.sort(newTargets, iSCSITargetComparator);
                    for (ISCSITargetPort.ISCSITarget oldTarget : oldPort.getTargets()) {
                        CIMInstance indication = null;
                        CIMInstance prevInstance = this.generateInstance(op, null, oldTarget, fcPort);
                        int idx = Collections.binarySearch(newTargets, oldTarget, iSCSITargetComparator);
                        if (idx >= 0) {
                            ISCSITargetPort.ISCSITarget newTarget = newTargets.remove(idx);
                            if (!oldTarget.equals(newTarget)) {
                                CIMInstance newInstance = this.generateInstance(op, null, newTarget, fcPort);
                                indication = helper.createInstModificationInstance(newInstance, prevInstance);
                            }
                        } else {
                            indication = helper.createInstDeletionInstance(prevInstance);
                        }
                        if (null == indication) continue;
                        mHandle.deliverEvent(indication, null);
                    }
                    if (!newTargets.isEmpty()) {
                        this.processPorts4Indication(op, helper, fcPort, newTargets, true);
                    }
                } else {
                    mLogger.log(Level.SEVERE, "Unable to find a iSCSI target port {0}: " + oldPort.getPortId());
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_iSCSIProtocolEndpoint modified indication instance", t);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues, new String[]{"ElementName", "SystemName"});
        try {
            short domainID;
            short portID;
            if (null != expectedValues) {
                String expName;
                String string = expName = null != expectedValues ? (String)expectedValues.get("Name") : null;
                if (null == expName) throw new WBEMException("Enumerate called for association operation but the 'Name' property was not passed in");
                int[] t = iSCSIProtocolEndpointInstrumentation.decodeName(expName);
                portID = t[0];
                domainID = (short)t[1];
            } else {
                domainID = -1;
                portID = -1;
            }
            for (RMIObjectMapping device : devices) {
                Thread[] t = new Thread[2];
                t[0] = new Thread(new TargetProcessing(iter, op, device, portID, domainID, propertyList, isObjectPath, refInfo));
                t[0].setDaemon(true);
                t[0].setName("iSCSIProtocolEndpoint target processor");
                t[0].start();
                t[1] = new Thread(new InitiatorProcessing(iter, op, device, portID, propertyList, isObjectPath, refInfo));
                t[1].setDaemon(true);
                t[1].setName("iSCSIProtocolEndpoint initiator processor");
                t[1].start();
                for (Thread tmp : t) {
                    if (null == tmp || !tmp.isAlive()) continue;
                    tmp.join();
                }
            }
            return;
        }
        catch (WBEMException we) {
            if (null == iter) throw we;
            iter.setException(we);
            iter.close();
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null == iter) throw we;
            iter.setException(we);
            iter.close();
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath pOP, String[] propList, Object ... o) throws Exception {
        UnsignedInteger16 role;
        String name;
        CIMObjectPath retOP = this.generateObjectPath(pOP, o);
        try {
            ISCSITargetPort.ISCSITarget target = (ISCSITargetPort.ISCSITarget)o[0];
            name = target.getName();
            role = ProviderConstants.UINT16_THREE;
        }
        catch (ClassCastException cce) {
            ISCSIreadAlliScsiInitiator initiator = (ISCSIreadAlliScsiInitiator)o[0];
            name = initiator.getName();
            role = ProviderConstants.UINT16_TWO;
        }
        CIMInstance ret = null;
        try {
            if (null != pOP) {
                ArrayList props = new ArrayList();
                CIMProperty[] keys = retOP.getKeys();
                ProviderLibs.addKeysToProperties(keys, props);
                FCPort port = (FCPort)o[1];
                ISCSIreadPortNetworkConditions iSCSIInfo = port.getISCSIInfo();
                props.add(new CIMProperty("Identifier", CIMDataType.STRING_T, (Object)iSCSIInfo.getMacAddressAsString(), false));
                props.add(new CIMProperty("ConnectionType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_SEVEN, false));
                props.add(new CIMProperty("Role", CIMDataType.UINT16_T, (Object)role, false));
                props.add(new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false));
                props.add(new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
                props.add(new CIMProperty("ProtocolIFType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false));
                props.add(new CIMProperty("OtherTypeDescription", CIMDataType.STRING_T, (Object)CPV_OTHERTYPEDESCRIPTION, false));
                props.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
                props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)name, false));
                ret = new CIMInstance(retOP, props.toArray(new CIMProperty[props.size()])).filterProperties(propList);
            }
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        return ret;
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath pOP, Object ... o) throws Exception {
        int id;
        int portID;
        FCPort port = null;
        CIMObjectPath ret = null;
        try {
            ProviderLibs.validateVARArgs(new Class[]{ISCSITargetPort.ISCSITarget.class, FCPort.class}, o, "HITACHI_iSCSIProtocolEndpoint");
            ISCSITargetPort.ISCSITarget target = (ISCSITargetPort.ISCSITarget)o[0];
            portID = target.getPortID();
            id = target.getId();
            port = (FCPort)o[1];
            ret = null;
        }
        catch (IllegalArgumentException iae) {
            ProviderLibs.validateVARArgs(new Class[]{ISCSIreadAlliScsiInitiator.class, FCPort.class}, o, "HITACHI_iSCSIProtocolEndpoint");
            ISCSIreadAlliScsiInitiator initiator = (ISCSIreadAlliScsiInitiator)o[0];
            portID = initiator.getPortID();
            id = -2;
            port = (FCPort)o[1];
            ret = null;
        }
        try {
            String systemName = iSCSIProtocolEndpointInstrumentation.createSystemName(port);
            String name = this.getName(portID, id);
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_iSCSIProtocolEndpoint", true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)name, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageProcessorSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, true)};
            ret = new CIMObjectPath(pOP.getScheme(), pOP.getHost(), pOP.getPort(), pOP.getNamespace(), "HITACHI_iSCSIProtocolEndpoint", keys, pOP.getXmlSchemaName());
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            String nameKeyVal;
            String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            String sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            String string = nameKeyVal = null != op.getKey("Name") ? (String)op.getKey("Name").getValue() : null;
            if (null != nameKeyVal && null != ccName && ccName.equals("HITACHI_iSCSIProtocolEndpoint") && null != sccName && sccName.equals("HITACHI_StorageProcessorSystem")) {
                ISCSIreadAlliScsiInitiator initiator;
                ISCSITargetPort targetPort;
                int[] t = iSCSIProtocolEndpointInstrumentation.decodeName(nameKeyVal);
                if (-2 != t[1]) {
                    targetPort = ISCSITargetPort.find(device.getRMIObject(), t[0]);
                    initiator = null;
                } else {
                    initiator = ISCSIreadAlliScsiInitiator.find(device.getRMIObject(), t[0]);
                    targetPort = null;
                }
                ISCSITargetPort.ISCSITarget target = null != targetPort ? targetPort.getTarget((short)t[1]) : null;
                if (null != target || null != initiator) {
                    FCPort fcPort = FCPort.find((short)t[0], FCPort.PortTypeRequested.iSCSI, device.getRMIObject());
                    if (null != fcPort) {
                        return this.generateInstance(op, propertyList, null == target ? initiator : target, fcPort);
                    }
                    mLogger.log(Level.SEVERE, "Unable to find FCPort with ID {0} associated with {1}", new Object[]{t[0], targetPort});
                } else {
                    mLogger.log(Level.SEVERE, "Unable to find iSCSIEndpoint with name {0}.{1} in {1}", new Object[]{t[0], t[1], null == targetPort ? initiator : targetPort});
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    private String getName(int portID, int id) {
        StringBuilder ret = new StringBuilder();
        ret = ret.append(portID);
        ret = ret.append(ProviderConstants.ID_SEPERATOR_AS_CHAR);
        ret = ret.append(id);
        return ret.toString();
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_iSCSIProtocolEndpoint".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_iSCSIProtocolEndpoint".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_SCSIProtocolEndpoint".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_SCSIProtocolEndpoint".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_SCSIProtocolEndpoint AND SourceInstance.OperationalStatus <> PreviousInstance.OperationalStatus".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_SCSIProtocolEndpoint AND SourceInstance.CIM_SCSIProtocolEndpoint::OperationalStatus <> PreviousInstance.CIM_SCSIProtocolEndpoint::OperationalStatus".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.PORTHOSTGROUP, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.PORTHOSTGROUP, this, null);
        }
    }

    private void processPorts4Indication(CIMObjectPath op, IndicationHelper helper, FCPort fcPort, List<ISCSITargetPort.ISCSITarget> targets, boolean isCreate) {
        for (ISCSITargetPort.ISCSITarget target : targets) {
            try {
                CIMInstance newInstance = this.generateInstance(op, null, target, fcPort);
                CIMInstance indication = isCreate ? helper.createInstCreationInstance(newInstance) : helper.createInstDeletionInstance(newInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Exception e) {
                mLogger.log(Level.SEVERE, "Exception trying to deliver iSCSITarget created indictaion", e);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Unexpect exception trying to deliver iSCSITarget created indictaion", t);
            }
        }
    }

    private class TargetProcessing
    implements Runnable {
        private final CIMObjectPath op;
        private final RMIObjectMapping device;
        private final int portID;
        private final short domainID;
        private final String[] propertyList;
        private final boolean isObjectPath;
        private final ReferenceInfo refInfo;
        private final CustomCloseableIterator<?> clientIter;

        TargetProcessing(CustomCloseableIterator<?> clientIter, CIMObjectPath op, RMIObjectMapping device, int portID, short domainID, String[] propertyList, boolean isObjectPath, ReferenceInfo refInfo) {
            this.clientIter = clientIter;
            this.op = op;
            this.device = device;
            this.portID = portID;
            this.domainID = domainID;
            this.propertyList = propertyList;
            this.isObjectPath = isObjectPath;
            this.refInfo = refInfo;
        }

        private void processTargets(CloseableAddableIterator<ISCSITargetPort> cbIter) throws Exception {
            while (cbIter.hasNext()) {
                ISCSITargetPort iSCSIPort = (ISCSITargetPort)cbIter.next();
                if (-1 != this.portID && this.portID != iSCSIPort.getPortId()) continue;
                mLogger.log(Level.FINE, "Processing iSCSIPort with id: {0}", iSCSIPort.getPortId());
                FCPort fcPort = FCPort.find((short)iSCSIPort.getPortId(), FCPort.PortTypeRequested.iSCSI, this.device.getRMIObject());
                if (null != fcPort) {
                    if (-1 == this.domainID) {
                        List<ISCSITargetPort.ISCSITarget> targets = iSCSIPort.getTargets();
                        mLogger.log(Level.FINE, "{0} has {1} targets", new Object[]{iSCSIPort.getPortId(), targets.size()});
                        for (ISCSITargetPort.ISCSITarget target : targets) {
                            CIMInstance inst = iSCSIProtocolEndpointInstrumentation.this.generateInstance(this.op, this.propertyList, target, fcPort);
                            if (null != this.refInfo) {
                                this.refInfo.addReference(this.clientIter, inst.getObjectPath());
                                continue;
                            }
                            if (this.isObjectPath) {
                                this.clientIter.add(inst.getObjectPath());
                                continue;
                            }
                            this.clientIter.add(inst);
                        }
                        continue;
                    }
                    try {
                        ISCSITargetPort.ISCSITarget target = iSCSIPort.getTarget(this.domainID);
                        if (null != target) {
                            CIMInstance inst = iSCSIProtocolEndpointInstrumentation.this.generateInstance(this.op, this.propertyList, target, fcPort);
                            if (null != this.refInfo) {
                                this.refInfo.addReference(this.clientIter, inst.getObjectPath());
                                continue;
                            }
                            if (this.isObjectPath) {
                                this.clientIter.add(inst.getObjectPath());
                                continue;
                            }
                            this.clientIter.add(inst);
                            continue;
                        }
                        mLogger.log(Level.FINE, "Could not find target {0} in port {1}", new Object[]{this.domainID, iSCSIPort.getPortId()});
                        continue;
                    }
                    catch (IndexOutOfBoundsException iobe) {
                        throw new WBEMException("iSCSIPort with ID " + iSCSIPort.getPortId() + " does not have a target with ID " + this.domainID);
                    }
                }
                throw new WBEMException("iSCSIPort with ID " + iSCSIPort.getPortId() + " has no matching FCPort");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClosableAddableIteratorCB<ISCSITargetPort> callback = new ClosableAddableIteratorCB<ISCSITargetPort>();
            try {
                mLogger.info("iSCSIProtocolEndpoint target ports starting");
                ISCSITargetPort.getISCSIPorts(this.device.getRMIObject(), callback, -1);
                CloseableAddableIterator<ISCSITargetPort> cbIter = callback.getWrappedCloseableAddableIter();
                this.processTargets(cbIter);
            }
            catch (WBEMException e) {
                callback.exceptionOccurred(e);
            }
            catch (Throwable e) {
                WBEMException we = new WBEMException(1, e.toString(), null, e);
                callback.exceptionOccurred(we);
            }
            finally {
                mLogger.info("iSCSIProtocolEndpoint exiting");
            }
        }
    }

    private class InitiatorProcessing
    implements Runnable {
        private final CIMObjectPath op;
        private final RMIObjectMapping device;
        private final int portID;
        private final String[] propertyList;
        private final boolean isObjectPath;
        private final ReferenceInfo refInfo;
        private final CustomCloseableIterator<?> clientIter;

        InitiatorProcessing(CustomCloseableIterator<?> clientIter, CIMObjectPath op, RMIObjectMapping device, int portID, String[] propertyList, boolean isObjectPath, ReferenceInfo refInfo) {
            this.clientIter = clientIter;
            this.op = op;
            this.device = device;
            this.portID = portID;
            this.propertyList = propertyList;
            this.isObjectPath = isObjectPath;
            this.refInfo = refInfo;
        }

        private void processInitiators(CloseableAddableIterator<ISCSIreadAlliScsiInitiator> cbIter) throws Exception {
            while (cbIter.hasNext()) {
                ISCSIreadAlliScsiInitiator initiator = (ISCSIreadAlliScsiInitiator)cbIter.next();
                if (-1 != this.portID && this.portID != initiator.getPortID()) continue;
                mLogger.log(Level.FINE, "Processing iSCSIInitiatorPort with id: {0}", initiator.getPortID());
                FCPort fcPort = FCPort.find((short)initiator.getPortID(), FCPort.PortTypeRequested.iSCSI, this.device.getRMIObject());
                if (null != fcPort) {
                    CIMInstance inst = iSCSIProtocolEndpointInstrumentation.this.generateInstance(this.op, this.propertyList, initiator, fcPort);
                    if (null != this.refInfo) {
                        this.refInfo.addReference(this.clientIter, inst.getObjectPath());
                        continue;
                    }
                    if (this.isObjectPath) {
                        this.clientIter.add(inst.getObjectPath());
                        continue;
                    }
                    this.clientIter.add(inst);
                    continue;
                }
                throw new WBEMException("iSCSIInitiatorPort with ID " + initiator.getPortID() + " has no matching FCPort");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClosableAddableIteratorCB<ISCSIreadAlliScsiInitiator> callback = new ClosableAddableIteratorCB<ISCSIreadAlliScsiInitiator>();
            try {
                mLogger.info("iSCSIProtocolEndpoint initiator ports starting");
                ISCSIreadAlliScsiInitiator.getAll(this.device.getRMIObject(), callback, this.portID);
                CloseableAddableIterator<ISCSIreadAlliScsiInitiator> cbIter = callback.getWrappedCloseableAddableIter();
                this.processInitiators(cbIter);
            }
            catch (WBEMException e) {
                callback.exceptionOccurred(e);
            }
            catch (Throwable e) {
                WBEMException we = new WBEMException(1, e.toString(), null, e);
                callback.exceptionOccurred(we);
            }
            finally {
                mLogger.info("iSCSIProtocolEndpoint exiting");
            }
        }
    }
}

