/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRemote;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.ModifyPortLabel;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_ChangeHostgroup;
import sanproject.serverux.data.SANRmiException;

public class CoalescedModifyPortLabelJob
extends Coalescable {
    private void changeFCportLabel(RMIObjectCache rmiObj, ModifyPortLabel mpl, List<CIMObjectPath> affectedElements, Queue<Object> resourceNames) throws RemoteException, SANRmiException {
        Robj_interface_ChangeHostgroup resourceName = (Robj_interface_ChangeHostgroup)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.CHANGEHOSTGROUP);
        resourceName.setSPort(mpl.getPortID());
        resourceName.setStrHostgroupNickName(mpl.getNewLabel());
        resourceName.setSHostgroupID(mpl.getDomainID());
        resourceNames.offer(resourceName);
    }

    private void changeiSCSIPortLabel(RMIObjectCache rmiObj, ModifyPortLabel mpl, List<CIMObjectPath> affectedElements, Queue<Object> resourceNames, SanRemote sanRemote) throws WBEMException {
        ISCSITargetPort iPort = ISCSITargetPort.find(rmiObj, mpl.getPortID());
        ISCSITargetPort.ISCSITarget target = iPort.getTarget(mpl.getDomainID());
        SanData generalParam = null;
        SanRequest sanrequest = null;
        try {
            if (resourceNames.isEmpty()) {
                generalParam = rmiObj.keyValueAPI_GetStorageInfoParam(sanRemote, mpl.getClientIP());
                rmiObj.addAccountInfo(generalParam);
                sanrequest = sanRemote.newRequest(generalParam, "LUNMupdateiScsiTarget");
            } else {
                generalParam = (SanData)resourceNames.poll();
                sanrequest = (SanRequest)resourceNames.poll();
            }
            resourceNames.offer(generalParam);
            resourceNames.offer(sanrequest);
            SanList iSCSIPorts = sanrequest.getList("iScsiPorts");
            if (null == iSCSIPorts) {
                iSCSIPorts = sanrequest.newList("iScsiPorts");
            }
            SanObject iSCSIPort = iSCSIPorts.addObj();
            iSCSIPort.putInt("Id", (int)mpl.getPortID());
            SanList names = iSCSIPort.newList("iScsiTargets");
            SanObject name = names.addObj();
            name.putInt("Id", (int)target.getId());
            name.putString("Alias", mpl.getNewLabel());
            name.putString("Name", target.getName());
        }
        catch (SanDataException | SanRmiException | RemoteException e) {
            Throwable t = e;
            while (null != t.getCause()) {
                t = t.getCause();
            }
            throw new WBEMException(1, "Error getting key/value objects", null, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeJob(List<AbstractJobImpl> actionItems) throws WBEMException {
        block10: {
            try {
                this.setAbstractJobImpls(actionItems);
                this.createConcreteJobFromAbstractJobs();
                mLogger.log(Level.INFO, "CoalescedJob {0} starting", this.getJob().getInstanceID());
                this.markServerJobStarted();
                if (this.processChildJobs()) {
                    this.apply(false);
                    break block10;
                }
                RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
                SanData generalParameter = (SanData)this.getItemQueue().poll();
                SanRequest request = (SanRequest)this.getItemQueue().poll();
                SanResponse response = this.invoke(rmiObj, generalParameter, request, rmiObj.keyValueAPI_GetSanRemote());
                try {
                    if (0 != response.errorCode()) {
                        SanObject errorInfo = response.getObj("ErrorInfo");
                        int[] message = errorInfo.getIntArray("MessageId");
                        String msg = String.format("Changing label failed with code %d, message %d-%d", response.errorCode(), message[0], message[1]);
                        throw new WBEMException(msg);
                    }
                    this.getHitachiJobServiceObject().updateServerJobPercentComplete(75, true);
                }
                catch (SanDataException e) {
                    throw new WBEMException(1, e.toString(), null, (Throwable)e);
                }
            }
            catch (Throwable t) {
                while (null != t.getCause()) {
                    t = t.getCause();
                }
                this.setResult(t);
            }
            finally {
                this.markServerJobDone();
            }
        }
    }

    private boolean processChildJobs() throws WBEMException {
        try {
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
            FCPort port = (FCPort)this.getAbstractJobImpls().get(0).getActionItem();
            boolean isFCPort = port.isRequestedType(FCPort.PortTypeRequested.OPEN);
            int numChildren = this.getAbstractJobImpls().size();
            ArrayList<CIMObjectPath> affectedElements = new ArrayList<CIMObjectPath>(numChildren);
            LinkedList<Object> resourceNames = new LinkedList<Object>();
            int x = 0;
            Iterator<AbstractJobImpl> iter = this.getAbstractJobImpls().iterator();
            while (iter.hasNext()) {
                AbstractJobImpl childJob = iter.next();
                if (!(childJob instanceof ModifyPortLabel)) {
                    String msg = "Expected all elements of the list to contain instances of ModifyPortLabel, however this instance was a " + childJob.getClass().getSimpleName();
                    this.markAndRemoveChildJobWithError(iter, childJob, msg);
                    continue;
                }
                ModifyPortLabel mpl = (ModifyPortLabel)childJob;
                mpl.setResultIndex(x);
                affectedElements.add(mpl.getJob().getCIMObjectPath(this.getOwningElement()));
                if (isFCPort) {
                    this.changeFCportLabel(rmiObj, mpl, affectedElements, resourceNames);
                } else {
                    SanRemote sanRemote;
                    try {
                        sanRemote = rmiObj.keyValueAPI_GetSanRemote();
                    }
                    catch (NotBoundException | RemoteException e) {
                        Throwable t = e;
                        while (null != t.getCause()) {
                            t = t.getCause();
                        }
                        throw new WBEMException(1, "Error getting SanRemote object", null, t);
                    }
                    this.changeiSCSIPortLabel(rmiObj, mpl, affectedElements, resourceNames, sanRemote);
                }
                ++x;
            }
            this.setItemQueue(resourceNames);
            return isFCPort;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred building RMI Objects: " + t, null, t);
        }
    }
}

